/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utill;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class DataStore {
    private static int getRecordId(RecordStore store) throws RecordStoreException {
        RecordEnumeration e = store.enumerateRecords(null, null, false);
        int i = e.nextRecordId();
        e.destroy();
        return i;
    }

    public static void writeData(String storeName, String data) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)storeName, (boolean)true);
            byte[] byteOutputData = data.getBytes();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byteOutputData, 0, byteOutputData.length);
            } else {
                byte[] byteData = data.getBytes();
                recordStore.setRecord(DataStore.getRecordId(recordStore), byteData, 0, byteData.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException r1) {
            System.out.println("RecordStoreFullException " + r1.toString());
        }
        catch (RecordStoreNotFoundException r2) {
            System.out.println("RecordStoreNotFoundException " + r2.toString());
        }
        catch (RecordStoreException r3) {
            System.out.println("RecordStoreNotFoundException " + r3.toString());
        }
    }

    public static String readData(String storeName, String defaultValue) {
        String data = defaultValue;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)storeName, (boolean)false);
            if (recordStore != null) {
                byte[] byteInputData = new byte[1];
                int length = 0;
                for (int x = 1; x <= recordStore.getNumRecords(); ++x) {
                    if (recordStore.getRecordSize(x) > byteInputData.length) {
                        byteInputData = new byte[recordStore.getRecordSize(x)];
                    }
                    length = recordStore.getRecord(x, byteInputData, 0);
                }
                data = new String(byteInputData, 0, length);
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }
}

