/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import com.spice.twozerofoureight.gamescreen.Config;
import com.spice.twozerofoureight.gamescreen.NumberField;
import com.spice.twozerofoureight.gamescreen.RMSData;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameBoard {
    public static final int ygap = (Config.DISPLAY_HEIGHT - 60) * 10 / 100;
    public static final int CELL_HEIGHT;
    public static final int CELL_WIDTH;
    public static final int CELL_GAP;
    public static final int SCORE_XPOS;
    public static final int SCORE_WIDTH;
    public static final int SCORE_HEIGHT;
    public NumberField[][] arr = new NumberField[4][4];
    public static Random random;
    public int score = 0;
    private static Font scorefont;
    private static int SCORE_BOX_YPOS;
    public static int SCORE_YPOS;
    int[] cellValues = new int[16];
    int i = 0;

    static {
        CELL_WIDTH = CELL_HEIGHT = (Config.DISPLAY_HEIGHT - 60 - ygap) / 5;
        CELL_GAP = (Config.DISPLAY_HEIGHT - 4 * CELL_HEIGHT - 60 - ygap) / 4;
        SCORE_XPOS = CELL_WIDTH * 4 + CELL_GAP * 6;
        SCORE_WIDTH = Config.DISPLAY_WIDTH - ygap - SCORE_XPOS;
        SCORE_HEIGHT = CELL_WIDTH * 4 + CELL_GAP * 3;
        random = new Random();
        scorefont = Font.getFont((int)0, (int)1, (int)0);
        SCORE_BOX_YPOS = 60 + ygap / 2;
        SCORE_YPOS = 60 + ygap / 2 + (SCORE_HEIGHT - 5 * scorefont.getHeight()) / 2;
    }

    public GameBoard() {
        int row = 0;
        while (row < this.arr.length) {
            int column = 0;
            while (column < this.arr[row].length) {
                this.arr[row][column] = new NumberField();
                ++column;
            }
            ++row;
        }
    }

    public void saveCurrentstate() {
        int row = 0;
        while (row < this.arr.length) {
            int column = 0;
            while (column < this.arr[row].length) {
                this.cellValues[this.i] = this.arr[row][column].getNumber();
                ++this.i;
                ++column;
            }
            ++row;
        }
        RMSData.setGridData(this.cellValues);
    }

    public boolean shiftGameBoardRight() {
        boolean isBoardShifted = false;
        int i = 0;
        while (i < this.arr.length) {
            if (this.addRowFromRightToLeft(i)) {
                isBoardShifted = true;
            }
            if (this.shiftRowRight(i)) {
                isBoardShifted = true;
            }
            ++i;
        }
        return isBoardShifted;
    }

    public boolean shiftGameBoardLeft() {
        boolean isBoardShifted = false;
        int row = 0;
        while (row < this.arr.length) {
            if (this.addRowFromLeftToRight(row)) {
                isBoardShifted = true;
            }
            if (this.shiftRowLeft(row)) {
                isBoardShifted = true;
            }
            ++row;
        }
        return isBoardShifted;
    }

    public boolean shiftGameBoardUp() {
        boolean isBoardShifted = false;
        int column = 0;
        while (column < this.arr[0].length) {
            if (this.addColumnFromTopToBottom(column)) {
                isBoardShifted = true;
            }
            if (this.shiftColUp(column)) {
                isBoardShifted = true;
            }
            ++column;
        }
        return isBoardShifted;
    }

    public boolean shiftGameBoardDown() {
        boolean isBoardShifted = false;
        int column = 0;
        while (column < this.arr[0].length) {
            if (this.addColumnFromBottomToTop(column)) {
                isBoardShifted = true;
            }
            if (this.shiftColDown(column)) {
                isBoardShifted = true;
            }
            ++column;
        }
        return isBoardShifted;
    }

    private boolean shiftColUp(int columnNum) {
        boolean isBoardShifted = false;
        int row = 0;
        while (row < this.arr.length) {
            if (this.arr[row][columnNum].isEmpty()) {
                int nextRow = row + 1;
                while (nextRow < this.arr.length) {
                    if (!this.arr[nextRow][columnNum].isEmpty()) {
                        this.arr[row][columnNum].setNumber(this.arr[nextRow][columnNum].getNumber());
                        this.arr[nextRow][columnNum].setEmpty();
                        isBoardShifted = true;
                        break;
                    }
                    ++nextRow;
                }
            }
            ++row;
        }
        return isBoardShifted;
    }

    private boolean shiftColDown(int columnNum) {
        boolean isBoardShifted = false;
        int row = this.arr.length - 1;
        while (row >= 0) {
            if (this.arr[row][columnNum].isEmpty()) {
                int nextRow = row - 1;
                while (nextRow >= 0) {
                    if (!this.arr[nextRow][columnNum].isEmpty()) {
                        this.arr[row][columnNum].setNumber(this.arr[nextRow][columnNum].getNumber());
                        this.arr[nextRow][columnNum].setEmpty();
                        isBoardShifted = true;
                        break;
                    }
                    --nextRow;
                }
            }
            --row;
        }
        return isBoardShifted;
    }

    private boolean shiftRowLeft(int rowNum) {
        boolean isBoardShifted = false;
        int col = 0;
        while (col < this.arr[0].length) {
            if (this.arr[rowNum][col].isEmpty()) {
                int nextCol = col + 1;
                while (nextCol < this.arr[0].length) {
                    if (!this.arr[rowNum][nextCol].isEmpty()) {
                        this.arr[rowNum][col].setNumber(this.arr[rowNum][nextCol].getNumber());
                        this.arr[rowNum][nextCol].setEmpty();
                        isBoardShifted = true;
                        break;
                    }
                    ++nextCol;
                }
            }
            ++col;
        }
        return isBoardShifted;
    }

    private boolean shiftRowRight(int rowNum) {
        boolean isBoardShifted = false;
        int col = this.arr[0].length - 1;
        while (col >= 0) {
            if (this.arr[rowNum][col].isEmpty()) {
                int nextCol = col - 1;
                while (nextCol >= 0) {
                    if (!this.arr[rowNum][nextCol].isEmpty()) {
                        this.arr[rowNum][col].setNumber(this.arr[rowNum][nextCol].getNumber());
                        this.arr[rowNum][nextCol].setEmpty();
                        isBoardShifted = true;
                        break;
                    }
                    --nextCol;
                }
            }
            --col;
        }
        return isBoardShifted;
    }

    private boolean addRowFromRightToLeft(int rowNum) {
        boolean isBoardShifted = false;
        int col = this.arr[rowNum].length - 1;
        while (col >= 0) {
            if (!this.arr[rowNum][col].isEmpty()) {
                int nextCol = col - 1;
                while (nextCol >= 0) {
                    if (!this.arr[rowNum][nextCol].isEmpty()) {
                        if (this.arr[rowNum][nextCol].getNumber() != this.arr[rowNum][col].getNumber()) break;
                        this.score += 2 * this.arr[rowNum][col].getNumber();
                        this.arr[rowNum][nextCol].setNumber(2 * this.arr[rowNum][col].getNumber());
                        this.arr[rowNum][col].setNumber(0);
                        System.out.println("i" + rowNum + "j" + col);
                        col = nextCol;
                        isBoardShifted = true;
                        break;
                    }
                    --nextCol;
                }
            }
            --col;
        }
        return isBoardShifted;
    }

    private boolean addRowFromLeftToRight(int rowNum) {
        boolean isBoardShifted = false;
        int i = 0;
        while (i < this.arr.length) {
            if (!this.arr[rowNum][i].isEmpty()) {
                int j = i + 1;
                while (j < this.arr.length) {
                    if (!this.arr[rowNum][j].isEmpty()) {
                        if (this.arr[rowNum][j].getNumber() != this.arr[rowNum][i].getNumber()) break;
                        this.score += 2 * this.arr[rowNum][i].getNumber();
                        this.arr[rowNum][j].setNumber(2 * this.arr[rowNum][j].getNumber());
                        this.arr[rowNum][i].setNumber(0);
                        i = j;
                        isBoardShifted = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return isBoardShifted;
    }

    private boolean addColumnFromTopToBottom(int columnNum) {
        boolean isBoardShifted = false;
        int i = 0;
        while (i < this.arr.length) {
            if (!this.arr[i][columnNum].isEmpty()) {
                int j = i + 1;
                while (j < this.arr.length) {
                    if (!this.arr[j][columnNum].isEmpty()) {
                        if (this.arr[j][columnNum].getNumber() != this.arr[i][columnNum].getNumber()) break;
                        this.score += 2 * this.arr[j][columnNum].getNumber();
                        this.arr[j][columnNum].setNumber(2 * this.arr[j][columnNum].getNumber());
                        this.arr[i][columnNum].setNumber(0);
                        i = j;
                        isBoardShifted = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return isBoardShifted;
    }

    private boolean addColumnFromBottomToTop(int columnNum) {
        boolean isBoardShifted = false;
        int row = this.arr.length - 1;
        while (row >= 0) {
            if (!this.arr[row][columnNum].isEmpty()) {
                int nextRow = row - 1;
                while (nextRow >= 0) {
                    if (!this.arr[nextRow][columnNum].isEmpty()) {
                        if (this.arr[nextRow][columnNum].getNumber() != this.arr[row][columnNum].getNumber()) break;
                        this.score += 2 * this.arr[nextRow][columnNum].getNumber();
                        this.arr[nextRow][columnNum].setNumber(2 * this.arr[nextRow][columnNum].getNumber());
                        this.arr[row][columnNum].setNumber(0);
                        row = nextRow;
                        isBoardShifted = true;
                        break;
                    }
                    --nextRow;
                }
            }
            --row;
        }
        return isBoardShifted;
    }

    public void initializeGame() {
        this.setNumberInEmptyField();
        this.setNumberInEmptyField();
    }

    public void setNumberInEmptyField() {
        Vector vec = this.getEmptyFieldVector();
        if (vec.size() > 0) {
            NumberField field = (NumberField)vec.elementAt(random.nextInt(vec.size()));
            field.setNumber(random.nextInt(10) == 0 ? 4 : 2);
        }
    }

    public boolean isGameOver() {
        boolean isEmptyField = this.checkForEmptyFields();
        if (isEmptyField) {
            return false;
        }
        return !this.checkifCombinationExists();
    }

    private boolean checkifCombinationExists() {
        int row = 0;
        while (row < this.arr.length) {
            if (this.checkCombinationInRow(row)) {
                return true;
            }
            ++row;
        }
        int col = 0;
        while (col < this.arr[0].length) {
            if (this.checkCombinationInColumn(col)) {
                return true;
            }
            ++col;
        }
        return false;
    }

    private boolean checkCombinationInRow(int rowNum) {
        int col = 0;
        while (col < this.arr[0].length - 1) {
            if (!this.arr[rowNum][col].isEmpty() && this.arr[rowNum][col].getNumber() == this.arr[rowNum][col + 1].getNumber()) {
                return true;
            }
            ++col;
        }
        return false;
    }

    private boolean checkCombinationInColumn(int column) {
        int row = 0;
        while (row < this.arr.length - 1) {
            if (!this.arr[row][column].isEmpty() && this.arr[row][column].getNumber() == this.arr[row + 1][column].getNumber()) {
                return true;
            }
            ++row;
        }
        return false;
    }

    private boolean checkForEmptyFields() {
        return this.getEmptyFieldVector().size() > 0;
    }

    private Vector getEmptyFieldVector() {
        Vector<NumberField> vec = new Vector<NumberField>();
        int row = 0;
        while (row < this.arr.length) {
            int col = 0;
            while (col < this.arr[0].length) {
                if (this.arr[row][col].isEmpty()) {
                    vec.addElement(this.arr[row][col]);
                }
                ++col;
            }
            ++row;
        }
        return vec;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isGameWon() {
        int row = 0;
        while (row < this.arr.length) {
            int col = 0;
            while (col < this.arr.length) {
                if (this.arr[row][col].isNumber2048Achieved()) {
                    return true;
                }
                ++col;
            }
            ++row;
        }
        return false;
    }

    public void drawGameBoard(Graphics graphics) {
        int row = 0;
        while (row < this.arr.length) {
            int col = 0;
            while (col < this.arr[0].length) {
                this.arr[row][col].paint(graphics, (col + 1) * CELL_GAP + col * CELL_WIDTH, row * CELL_GAP + 60 + row * CELL_HEIGHT + ygap / 2);
                ++col;
            }
            ++row;
        }
        Font font = graphics.getFont();
        graphics.setFont(scorefont);
        int color = graphics.getColor();
        graphics.setColor(0x444444);
        graphics.fillRect(SCORE_XPOS, SCORE_BOX_YPOS, SCORE_WIDTH, SCORE_HEIGHT);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(Config.SCORE, SCORE_XPOS + (SCORE_WIDTH - graphics.getFont().stringWidth(Config.SCORE)) / 2, SCORE_YPOS, 0);
        int ypos = SCORE_YPOS + graphics.getFont().getHeight();
        graphics.drawString("" + this.score, SCORE_XPOS + (SCORE_WIDTH - graphics.getFont().stringWidth("" + this.score)) / 2, ypos, 0);
        ypos = SCORE_YPOS + 3 * graphics.getFont().getHeight();
        graphics.drawString(" H.S. ", SCORE_XPOS + (SCORE_WIDTH - graphics.getFont().stringWidth(" H.S. ")) / 2, ypos, 0);
        ypos = SCORE_YPOS + 4 * graphics.getFont().getHeight();
        graphics.drawString("" + RMSData.getScore(), SCORE_XPOS + (SCORE_WIDTH - graphics.getFont().stringWidth("" + RMSData.getScore())) / 2, ypos, 0);
        graphics.setColor(color);
        graphics.setFont(font);
    }
}

