/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import com.spice.twozerofoureight.gamescreen.Config;
import com.spice.twozerofoureight.gamescreen.GameScreen;
import com.spice.twozerofoureight.gamescreen.HomeScreen;
import com.spice.twozerofoureight.gamescreen.MainMidlet;
import com.spice.twozerofoureight.gamescreen.RMSData;
import com.spice.twozerofoureight.gamescreen.ScaleImage;
import com.spice.twozerofoureight.gamescreen.YeloFocus;
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vInAppAdEngine.VservAd;
import vInAppAdEngine.VservAdListener;
import vInAppAdEngine.VservManager;

public class GameOverScreen
extends Canvas
implements VservAdListener {
    MainMidlet midlet;
    boolean isGameWon;
    boolean isHighScore;
    long score;
    private VservManager vservManager;
    private VservAd vservAd;
    Image imageAd;
    String textAd;
    public static final Image WhiteScreenBG = ScaleImage.CreateScaledImage(Config.getFolderImage("popupScreen", "pop_up_screen.png"), Config.getX(75), Config.getY(55));
    public static YeloFocus focus1 = new YeloFocus(Config.popupButtonFocus, Config.popupButtonNormal, 50, 50, "homeScreen", 25, 12);
    public static YeloFocus focus2 = new YeloFocus(Config.popupButtonFocus, Config.popupButtonNormal, 50, 50, "homeScreen", 25, 12);
    public static int x1 = (Config.DISPLAY_WIDTH - WhiteScreenBG.getWidth()) / 2;
    public static int y1 = (Config.DISPLAY_HEIGHT - WhiteScreenBG.getHeight()) / 2;

    public GameOverScreen(MainMidlet midlet, long score, boolean isGameWon) {
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.isHighScore = score > RMSData.getScore();
        this.isGameWon = isGameWon;
        this.score = score;
        if (this.isHighScore) {
            RMSData.setScore(score);
        }
        focus1.setFocus(true);
        focus2.setFocus(false);
        this.initlize();
    }

    private void initlize() {
        Hashtable<String, String> vservConfigTable = new Hashtable<String, String>();
        vservConfigTable.put("appId", "11c6d347");
        this.vservManager = new VservManager(this.midlet, vservConfigTable);
        this.vservAd = new VservAd(this);
        this.vservAd.requestAd();
    }

    public void vservAdReceived(Object obj) {
        System.out.println("received");
        if (((VservAd)obj).getAdType().equals("image")) {
            this.imageAd = (Image)((VservAd)obj).getAd();
            System.out.println("image");
            this.repaint();
        } else if (((VservAd)obj).getAdType().equals("text")) {
            this.textAd = (String)((VservAd)obj).getAd();
            System.out.println("text");
            this.repaint();
        }
    }

    public void vservAdFailed(Object arg0) {
        System.out.println("not received");
    }

    protected void paint(Graphics g) {
        g.setColor(10324859);
        g.fillRect(0, 0, Config.DISPLAY_WIDTH, Config.DISPLAY_HEIGHT);
        g.drawImage(WhiteScreenBG, x1, y1, 0);
        g.setColor(0);
        g.drawString(String.valueOf(Config.SCORE) + " : " + this.score, x1 + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(String.valueOf(Config.SCORE) + " : " + this.score)) / 2, y1 + (WhiteScreenBG.getHeight() * 70 / 100 - g.getFont().getHeight()) / 2, 0);
        g.setColor(0xFF0000);
        g.drawString("High Score: " + RMSData.getScore(), x1 + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("High Score: " + RMSData.getScore())) / 2, y1 + (WhiteScreenBG.getHeight() * 100 / 100 - g.getFont().getHeight()) / 2, 0);
        g.setColor(0);
        if (this.isHighScore) {
            if (this.isGameWon) {
                g.drawString(Config.CONGRATS_TEXT, x1 + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(Config.CONGRATS_TEXT)) / 2, y1 + (WhiteScreenBG.getHeight() * 40 / 100 - g.getFont().getHeight()) / 2, 0);
            } else {
                g.drawString(Config.GAME_OVER_TEXT, x1 + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(Config.GAME_OVER_TEXT)) / 2, y1 + (WhiteScreenBG.getHeight() * 40 / 100 - g.getFont().getHeight()) / 2, 0);
            }
        } else {
            g.drawString(Config.GAME_OVER_TEXT, x1 + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(Config.GAME_OVER_TEXT)) / 2, y1 + (WhiteScreenBG.getHeight() * 40 / 100 - g.getFont().getHeight()) / 2, 0);
        }
        focus1.draw(g, x1, y1, WhiteScreenBG.getWidth(), WhiteScreenBG.getHeight(), 20, 80, "Replay", 0, 0);
        focus2.draw(g, x1, y1, WhiteScreenBG.getWidth(), WhiteScreenBG.getHeight(), 80, 80, Config.EXIT_TEXT, 0, 0);
        if (this.imageAd != null) {
            g.drawImage(this.imageAd, (Config.DISPLAY_WIDTH - this.imageAd.getWidth()) / 2, 0, 0);
        }
        if (this.textAd != null) {
            g.drawString(this.textAd, (Config.DISPLAY_WIDTH - g.getFont().stringWidth(this.textAd)) / 2, 0, 0);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (x > focus1.getX() && x < focus1.getX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            System.out.println("hi");
            focus1.setFocus(true);
            focus2.setFocus(false);
        } else if (x > focus2.getX() && x < focus2.getX() + focus2.getImageWidth() && y > focus2.getY() && y < focus2.getY() + focus2.getImageHeight()) {
            focus1.setFocus(false);
            focus2.setFocus(true);
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (x > focus1.getX() && x < focus1.getX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            this.midlet.display.setCurrent((Displayable)new GameScreen(null, this.midlet));
        } else if (x > focus2.getX() && x < focus2.getX() + focus2.getImageWidth() && y > focus2.getY() && y < focus2.getY() + focus2.getImageHeight()) {
            this.midlet.display.setCurrent((Displayable)new HomeScreen(this.midlet));
        }
        if (x > 0 && x < Config.DISPLAY_WIDTH && y > 0 && y < 55 && this.vservAd.hasAction) {
            this.vservAd.handleAdAction();
        }
    }

    protected void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 2: {
                if (GameOverScreen.focus2.IsFocus) {
                    focus1.setFocus(true);
                    focus2.setFocus(false);
                }
                this.repaint();
                break;
            }
            case 5: {
                if (GameOverScreen.focus1.IsFocus) {
                    focus2.setFocus(true);
                    focus1.setFocus(false);
                }
                this.repaint();
                break;
            }
            case 8: {
                if (GameOverScreen.focus1.IsFocus) {
                    this.midlet.display.setCurrent((Displayable)new GameScreen(null, this.midlet));
                    break;
                }
                if (!GameOverScreen.focus2.IsFocus) break;
                this.midlet.display.setCurrent((Displayable)new HomeScreen(this.midlet));
            }
        }
    }
}

