/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.animationlistener;

import in.spice.jewelworld.animationlistener.Animation;
import in.spice.jewelworld.animationlistener.AnimationCompleteCallBack;
import in.spice.jewelworld.common.JewelConstants;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RowAnimation
extends Animation {
    private int rowNum;
    private int currentFrame;
    private int totalCols;
    private int paintCount;
    private AnimationCompleteCallBack callBack;
    private boolean isAnimationComplete;

    public RowAnimation(int rowNum, int totalCols, AnimationCompleteCallBack callback) {
        this.rowNum = rowNum;
        this.totalCols = totalCols;
        this.callBack = callback;
    }

    public void drawAnimation(Graphics graphics, int xoffset, int yoffset) {
        if (this.isAnimationComplete) {
            this.callBack.isAnimationComplete(this);
            return;
        }
        ++this.currentFrame;
        ++this.paintCount;
        if (this.currentFrame >= JewelConstants.flashRowImages.length) {
            this.currentFrame = 0;
        }
        Image bitmap = JewelConstants.flashRowImages[this.currentFrame];
        graphics.drawImage(bitmap, xoffset, this.rowNum * JewelConstants.GEM_HEIGHT + yoffset + (JewelConstants.GEM_HEIGHT - bitmap.getHeight()) / 2, 0);
        if (this.isAnimationComplete()) {
            this.callBack.isAnimationComplete(this);
            this.isAnimationComplete = true;
        }
    }

    public boolean isAnimationComplete() {
        return this.paintCount > 4 * JewelConstants.flashRowImages.length;
    }

    public int getRowNum() {
        return this.rowNum;
    }
}

