/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.objects;

import in.spice.jewelworld.animationlistener.Animation;
import in.spice.jewelworld.animationlistener.AnimationCompleteCallBack;
import in.spice.jewelworld.animationlistener.AnimationCompleteListener;
import in.spice.jewelworld.animationlistener.BlastAnimtion;
import in.spice.jewelworld.animationlistener.ColumnAnimation;
import in.spice.jewelworld.animationlistener.RandomAnimation;
import in.spice.jewelworld.animationlistener.RowAnimation;
import in.spice.jewelworld.common.Config;
import in.spice.jewelworld.common.JewelConstants;
import in.spice.jewelworld.common.ScaleImage;
import in.spice.jewelworld.objects.Coord;
import in.spice.jewelworld.objects.JewelObj;
import in.spice.jewelworld.objects.PowerObj;
import in.spice.jewelworld.objects.ScoreAnimationObj;
import in.spice.jewelworld.store.RMSData;
import in.spice.jewelworld.utils.Match;
import in.spice.jewelworld.utils.MultipleMatch;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameBoard
implements AnimationCompleteCallBack,
AnimationCompleteListener {
    private JewelObj[][] jewelArr;
    private int numRows;
    private int numCols;
    private static Random random = new Random();
    private int freq = 100;
    private int currentfreq;
    private int hintCount;
    private boolean showHint = true;
    private Coord hintAvailCoord;
    private Vector animation = new Vector();
    private static final int GAME_STATE_FALLING = 0;
    private static final int GAME_STATE_ANIMATION = 1;
    private static final int GAME_STATE_NORMAL = 2;
    private static final int GAME_STATE_SWAPPED = 3;
    private static final int GAME_STATE_REARRANGE = 4;
    private static final int GAME_STATE_OVER = 5;
    public static final int DIRECTION_NORTH = 11;
    public static final int DIRECTION_SOUTH = 12;
    public static final int DIRECTION_EAST = 13;
    public static final int DIRECTION_WEST = 14;
    private static final Font font = Font.getFont((int)0, (int)1, (int)0);
    private static final int hintPaintFreq = 4;
    private static int currentHintPaintFreq = 0;
    private long score = 0L;
    private int currentState = 2;
    private Vector powerVector = new Vector();
    public Coord currentCoord;
    public boolean isSelected;
    private Coord[] swappedCoord = new Coord[2];
    private long hintTime = System.currentTimeMillis();
    private Vector scoreAnimVec = new Vector();
    private String prevScoreText = "H.S : " + RMSData.getScore();
    private String scoreText = "";
    private static final int scoreXpos = 16;
    int scoreTextWidth;

    public GameBoard(int width, int height) {
        this.numRows = (int)Math.floor(height / JewelConstants.GEM_HEIGHT);
        this.numCols = (int)Math.floor(width / JewelConstants.GEM_WIDTH);
        System.out.println("width" + width + " " + "JewelConstants.GEM_WIDTH" + JewelConstants.GEM_WIDTH + "numCols" + this.numCols);
        System.out.println("height" + height + " " + "JewelConstants.GEM_HEIGHT" + JewelConstants.GEM_HEIGHT + "numRows" + this.numRows);
        do {
            this.jewelArr = new JewelObj[this.numRows][this.numCols];
            int row = this.numRows - 1;
            while (row > -1) {
                int col = 0;
                while (col < this.numCols) {
                    this.newBubble(col, row, random.nextInt(JewelConstants.TOTAL_COLORS) + 1, true);
                    ++col;
                }
                --row;
            }
        } while (this.getAvailHint().size() > 15);
        this.loadBitmap();
    }

    public void loadBitmap() {
        JewelConstants.flashRowImages = new Image[]{ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash05.png"), JewelConstants.GEM_WIDTH * this.numCols, JewelConstants.GEM_HEIGHT), ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash06.png"), JewelConstants.GEM_WIDTH * this.numCols, JewelConstants.GEM_HEIGHT), ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash07.png"), JewelConstants.GEM_WIDTH * this.numCols, JewelConstants.GEM_HEIGHT), ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash08.png"), JewelConstants.GEM_WIDTH * this.numCols, JewelConstants.GEM_HEIGHT)};
        JewelConstants.flashColsImages = new Image[]{ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash01.png"), JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT * this.numRows), ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash02.png"), JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT * this.numRows), ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash03.png"), JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT * this.numRows), ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", "flash04.png"), JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT * this.numRows)};
    }

    private boolean removeCombinations() {
        MultipleMatch rowMatch = new MultipleMatch();
        MultipleMatch colMatch = new MultipleMatch();
        int row = this.numRows - 1;
        while (row > -1) {
            int col = 0;
            while (col < this.numCols) {
                Coord coord = new Coord(col, row);
                if (!colMatch.contains(coord)) {
                    colMatch = this.returnCombinationForColumn(col, row, colMatch);
                }
                if (!rowMatch.contains(coord)) {
                    rowMatch = this.returnCombinationForRow(col, row, rowMatch);
                }
                ++col;
            }
            --row;
        }
        this.playSoundForMatch(colMatch.size() + rowMatch.size());
        this.setAndAssignPowers(colMatch, rowMatch);
        return colMatch.size() > 0 || rowMatch.size() > 0;
    }

    private void playSoundForMatch(int totalCombos) {
    }

    private String getSoundFile(int num) {
        switch (num) {
            case 1: {
                return Config.ONE_MATCH_SOUND;
            }
            case 2: {
                return Config.TWO_MATCH_SOUND;
            }
        }
        return Config.THREE_OR_MORE_MATCH_SOUND;
    }

    private void setAndAssignPowers(MultipleMatch colMatch, MultipleMatch rowMatch) {
        int size;
        BlastAnimtion anim;
        int powerType;
        Coord coord;
        int j;
        Match match;
        int i = 0;
        while (i < colMatch.size()) {
            match = (Match)colMatch.elementAt(i);
            j = 0;
            while (j < match.size()) {
                coord = (Coord)match.elementAt(j);
                powerType = this.jewelArr[coord.y][coord.x].getPowerType();
                if (powerType == 0) {
                    anim = new BlastAnimtion(coord.y, coord.x, this.numRows, this.numCols, this);
                    this.animation.addElement(anim);
                    this.jewelArr[coord.y][coord.x].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                    this.checkForAnotherPowerInWay(anim.getCoord());
                } else if (powerType == 2) {
                    this.animation.addElement(new RandomAnimation(this.numRows, this.numCols, this));
                    this.jewelArr[coord.y][coord.x].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                } else if (powerType == 1) {
                    this.animation.addElement(new ColumnAnimation(coord.x, this.numRows, this));
                    this.jewelArr[coord.y][coord.x].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                    this.checkForAnotherPowerInRowOrColumn(coord.x, false);
                }
                if (rowMatch.isMatched(coord)) {
                    this.powerVector.addElement(new PowerObj(coord.y, coord.x, 0));
                }
                ++j;
            }
            size = match.size();
            coord = (Coord)match.firstElement();
            if (size > 4) {
                this.removeElements(match);
                if (this.currentState == 3) {
                    if (match.contains(this.swappedCoord[0])) {
                        this.addScore(size * 300, this.swappedCoord[0].y, this.swappedCoord[0].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[0].y, this.swappedCoord[0].x, 2));
                    } else if (match.contains(this.swappedCoord[1])) {
                        this.addScore(size * 300, this.swappedCoord[1].y, this.swappedCoord[1].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[1].y, this.swappedCoord[1].x, 2));
                    } else {
                        this.addScore(size * 300, coord.y, coord.x);
                        this.powerVector.addElement(new PowerObj(coord.y, coord.x, 2));
                    }
                } else {
                    this.addScore(size * 300, coord.y, coord.x);
                    this.powerVector.addElement(new PowerObj(coord.y, coord.x, 2));
                }
            } else if (size > 3) {
                this.removeElements(match);
                if (this.currentState == 3) {
                    if (match.contains(this.swappedCoord[0])) {
                        this.addScore(size * 200, this.swappedCoord[0].y, this.swappedCoord[0].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[0].y, this.swappedCoord[0].x, 1));
                    } else if (match.contains(this.swappedCoord[1])) {
                        this.addScore(size * 200, this.swappedCoord[1].y, this.swappedCoord[1].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[1].y, this.swappedCoord[1].x, 1));
                    } else {
                        this.addScore(size * 200, coord.y, coord.x);
                        this.powerVector.addElement(new PowerObj(coord.y, coord.x, 1));
                    }
                } else {
                    this.addScore(size * 200, coord.y, coord.x);
                    this.powerVector.addElement(new PowerObj(coord.y, coord.x, 1));
                }
            } else {
                this.addScore(size * 200, coord.y, coord.x);
                this.removeElements(match);
            }
            ++i;
        }
        i = 0;
        while (i < rowMatch.size()) {
            match = (Match)rowMatch.elementAt(i);
            j = 0;
            while (j < match.size()) {
                coord = (Coord)match.elementAt(j);
                powerType = this.jewelArr[coord.y][coord.x].getPowerType();
                if (powerType == 0) {
                    anim = new BlastAnimtion(coord.y, coord.x, this.numRows, this.numCols, this);
                    this.animation.addElement(anim);
                    this.jewelArr[coord.y][coord.x].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                    this.checkForAnotherPowerInWay(anim.getCoord());
                } else if (powerType == 2) {
                    this.animation.addElement(new RandomAnimation(this.numRows, this.numCols, this));
                    this.jewelArr[coord.y][coord.x].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                } else if (powerType == 1) {
                    this.animation.addElement(new RowAnimation(coord.y, this.numCols, this));
                    this.jewelArr[coord.y][coord.x].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                    this.checkForAnotherPowerInRowOrColumn(coord.y, true);
                }
                if (colMatch.isMatched(coord)) {
                    this.powerVector.addElement(new PowerObj(coord.y, coord.x, 0));
                }
                ++j;
            }
            size = match.size();
            coord = (Coord)match.firstElement();
            if (size > 4) {
                this.removeElements(match);
                if (this.currentState == 3) {
                    if (match.contains(this.swappedCoord[0])) {
                        this.addScore(size * 300, this.swappedCoord[0].y, this.swappedCoord[0].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[0].y, this.swappedCoord[0].x, 2));
                    } else if (match.contains(this.swappedCoord[1])) {
                        this.addScore(size * 300, this.swappedCoord[1].y, this.swappedCoord[1].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[1].y, this.swappedCoord[1].x, 2));
                    } else {
                        this.addScore(size * 300, coord.y, coord.x);
                        this.powerVector.addElement(new PowerObj(coord.y, coord.x, 2));
                    }
                } else {
                    this.addScore(size * 300, coord.y, coord.x);
                    this.powerVector.addElement(new PowerObj(coord.y, coord.x, 2));
                }
            } else if (size > 3) {
                this.removeElements(match);
                if (this.currentState == 3) {
                    if (match.contains(this.swappedCoord[0])) {
                        this.addScore(size * 200, this.swappedCoord[0].y, this.swappedCoord[0].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[0].y, this.swappedCoord[0].x, 1));
                    } else if (match.contains(this.swappedCoord[1])) {
                        this.addScore(size * 200, this.swappedCoord[1].y, this.swappedCoord[1].x);
                        this.powerVector.addElement(new PowerObj(this.swappedCoord[1].y, this.swappedCoord[1].x, 1));
                    } else {
                        this.addScore(size * 200, coord.y, coord.x);
                        this.powerVector.addElement(new PowerObj(coord.y, coord.x, 1));
                    }
                } else {
                    this.addScore(size * 200, coord.y, coord.x);
                    this.powerVector.addElement(new PowerObj(coord.y, coord.x, 1));
                }
            } else {
                this.addScore(size * 200, coord.y, coord.x);
                this.removeElements(match);
            }
            ++i;
        }
    }

    private void addScore(int score, int row, int col) {
        this.scoreAnimVec.addElement(new ScoreAnimationObj(col * JewelConstants.GEM_WIDTH, row * JewelConstants.GEM_WIDTH, Config.SCREEN_HEIGHT - font.getHeight(), (this.scoreTextWidth + 5) * 95 / 100, score, this));
    }

    private void checkForAnotherPowerInRowOrColumn(int y, boolean isRow) {
        if (isRow) {
            int i = 0;
            while (i < this.numCols) {
                int powerType = this.jewelArr[y][i].getPowerType();
                this.setAnimationType(y, i, powerType, isRow);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numRows) {
                int powerType = this.jewelArr[i][y].getPowerType();
                this.setAnimationType(i, y, powerType, isRow);
                ++i;
            }
        }
    }

    private void setAnimationType(int row, int col, int powerType, boolean isRow) {
        switch (powerType) {
            case 0: {
                BlastAnimtion anim = new BlastAnimtion(row, col, this.numRows, this.numCols, this);
                this.animation.addElement(anim);
                this.jewelArr[row][col].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                break;
            }
            case 2: {
                this.animation.addElement(new RandomAnimation(this.numRows, this.numCols, this));
                this.jewelArr[row][col].setPowerType(JewelConstants.POWER_TYPE_EMPTY);
                break;
            }
            case 1: {
                if (isRow) {
                    this.animation.addElement(new ColumnAnimation(col, this.numRows, this));
                    break;
                }
                this.animation.addElement(new RowAnimation(row, this.numCols, this));
            }
        }
    }

    private void checkForAnotherPowerInWay(Coord[] coord) {
        int i = 0;
        while (i < coord.length) {
            this.setAnimationType(coord[i].y, coord[i].x, this.jewelArr[coord[i].y][coord[i].x].getPowerType(), random.nextInt(2) == 0);
            ++i;
        }
    }

    private void removeElements(Match match) {
        int j = 0;
        while (j < match.size()) {
            Coord coord = (Coord)match.elementAt(j);
            this.jewelArr[coord.y][coord.x].setAsNull();
            ++j;
        }
    }

    public MultipleMatch returnCombinationForRow(int col, int row, MultipleMatch match1) {
        Coord coord;
        Match match = new Match();
        match.addElement(new Coord(col, row));
        JewelObj obj = this.jewelArr[row][col];
        int count = 0;
        int i = col - 1;
        while (i >= 0) {
            if (!obj.equals(this.jewelArr[row][i])) break;
            coord = new Coord(i, row);
            if (!match.contains(coord)) {
                ++count;
                match.addElement(coord);
            }
            --i;
        }
        i = col + 1;
        while (i < this.numCols) {
            if (!obj.equals(this.jewelArr[row][i])) break;
            coord = new Coord(i, row);
            if (!match.contains(coord)) {
                ++count;
                match.addElement(coord);
            }
            ++i;
        }
        if (count >= 2 && !match1.isMatched(match)) {
            match1.addElement(match);
        }
        return match1;
    }

    public MultipleMatch returnCombinationForColumn(int col, int row, MultipleMatch match1) {
        Coord coord;
        Match match = new Match();
        match.addElement(new Coord(col, row));
        JewelObj obj = this.jewelArr[row][col];
        int count = 0;
        int i = row - 1;
        while (i >= 0) {
            if (!obj.equals(this.jewelArr[i][col])) break;
            coord = new Coord(col, i);
            if (!match.contains(coord)) {
                ++count;
                match.addElement(coord);
            }
            --i;
        }
        i = row + 1;
        while (i < this.numRows) {
            if (!obj.equals(this.jewelArr[i][col])) break;
            coord = new Coord(col, i);
            if (!match.contains(coord)) {
                ++count;
                match.addElement(coord);
            }
            ++i;
        }
        if (count >= 2 && !match1.isMatched(match)) {
            match1.addElement(match);
        }
        return match1;
    }

    public int getNextJewel(int col, int row) {
        int color = random.nextInt(JewelConstants.TOTAL_COLORS) + 1;
        while (this.isRowOrColumn(col, row, color = random.nextInt(JewelConstants.TOTAL_COLORS) + 1)) {
        }
        return color;
    }

    public boolean isRowOrColumn(int col, int row, int color) {
        if (col - 2 >= 0 && this.jewelArr[row][col - 1] != null && this.jewelArr[row][col - 2] != null && this.jewelArr[row][col - 1].equals(color) && this.jewelArr[row][col - 2].equals(color)) {
            return true;
        }
        return row + 2 < this.numRows && this.jewelArr[row + 1][col] != null && this.jewelArr[row + 2][col] != null && this.jewelArr[row + 1][col].equals(color) && this.jewelArr[row + 2][col].equals(color);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void showHint() {
        this.showHint = true;
    }

    public void hideHint() {
        this.showHint = false;
        this.hintAvailCoord = null;
    }

    public void newBubble(int col, int row, int pBubbleType, boolean isStartup) {
        this.jewelArr[row][col] = new JewelObj(col, random.nextInt(this.numRows) - this.numRows, col, row, this.getNextJewel(col, row), JewelConstants.POWER_TYPE_EMPTY);
    }

    public void rearrangeArray() {
        int row = this.numRows - 1;
        while (row >= 0) {
            int col = 0;
            while (col < this.numCols) {
                if (this.jewelArr[row][col].isNull()) {
                    this.shiftRowsDown(col, row);
                }
                ++col;
            }
            --row;
        }
    }

    private void shiftRowsDown(int column, int row) {
        int i = row;
        while (i >= 0) {
            if (this.jewelArr[i][column].isNull()) {
                int rowNum = this.getNextJewelRowNum(row, column);
                if (rowNum > -1) {
                    this.swapJewelObj(row, column, rowNum, column);
                } else {
                    this.fillRowWithNewJewels(column, i);
                }
            }
            --i;
        }
    }

    public void swapJewel(int col, int row, int direction) {
        Coord coord = this.getSwappedCoord(col, row, direction);
        if (coord != null && this.isValidSwap(col, row, coord.x, coord.y)) {
            this.swappedCoord[0] = new Coord(col, row);
            this.swappedCoord[1] = coord;
            this.swapJewelObj(row, col, coord.y, coord.x);
            this.currentState = 3;
            this.hintTime = System.currentTimeMillis();
            this.showHint = true;
        }
    }

    private Coord getSwappedCoord(int col, int row, int direction) {
        switch (direction) {
            case 13: {
                if (col + 1 >= this.numCols) break;
                return new Coord(col + 1, row);
            }
            case 11: {
                if (row - 1 >= 0) {
                    return new Coord(col, row - 1);
                }
                return null;
            }
            case 12: {
                if (row + 1 < this.numRows) {
                    return new Coord(col, row + 1);
                }
                return null;
            }
            case 14: {
                if (col - 1 >= 0) {
                    return new Coord(col - 1, row);
                }
                return null;
            }
        }
        return null;
    }

    private void swapJewelObj(int row, int column, int row2, int col) {
        int finalX = this.jewelArr[row][column].getFinalX();
        int finalY = this.jewelArr[row][column].getFinalY();
        this.jewelArr[row][column].setFinalXAndFinalY(this.jewelArr[row2][col].getFinalX(), this.jewelArr[row2][col].getFinalY());
        this.jewelArr[row2][col].setFinalXAndFinalY(finalX, finalY);
        JewelObj temp = this.jewelArr[row2][col];
        this.jewelArr[row2][col] = this.jewelArr[row][column];
        this.jewelArr[row][column] = temp;
    }

    private void fillRowWithNewJewels(int col, int row) {
        int i = row;
        while (row >= 0) {
            this.jewelArr[row][col] = new JewelObj(col, row - (i + 1), col, row, random.nextInt(JewelConstants.TOTAL_COLORS) + 1, JewelConstants.POWER_TYPE_EMPTY);
            --row;
        }
    }

    private int getNextJewelRowNum(int row, int column) {
        int i = row;
        while (i >= 0) {
            if (!this.jewelArr[i][column].isNull()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void drawGameBoard(Graphics graphics, int currentX, int currentY, int xoffset, int yoffset) {
        int i;
        boolean isFalling = false;
        boolean isEmptyJewel = false;
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                int count = row * this.numCols + col;
                if (row % 2 != 0 && this.numCols % 2 == 0) {
                    ++count;
                }
                if (this.jewelArr[row][col].isFalling()) {
                    isFalling = true;
                }
                if (this.jewelArr[row][col].isNull()) {
                    isEmptyJewel = true;
                }
                int color = graphics.getColor();
                if (count % 2 == 0) {
                    graphics.setColor(JewelConstants.GRID_COLOR1);
                    graphics.fillRect(col * JewelConstants.GEM_WIDTH + xoffset, row * JewelConstants.GEM_HEIGHT + yoffset, JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT);
                } else {
                    graphics.fillRect(col * JewelConstants.GEM_WIDTH + xoffset, row * JewelConstants.GEM_HEIGHT + yoffset, JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT);
                }
                graphics.setColor(color);
                this.jewelArr[row][col].drawGems(graphics, xoffset, yoffset);
                ++col;
            }
            ++row;
        }
        int color = graphics.getColor();
        if (currentX != -1 || currentY != -1) {
            int xpos = (currentX - xoffset) / JewelConstants.GEM_WIDTH;
            int ypos = (currentY - yoffset) / JewelConstants.GEM_HEIGHT;
            if (xpos < this.numCols && ypos < this.numRows) {
                graphics.setColor(Config.FOCUS_COLOR);
                graphics.fillRect(currentX, currentY, JewelConstants.GEM_WIDTH, JewelConstants.GEM_HEIGHT);
                graphics.setColor(color);
                this.jewelArr[ypos][xpos].drawGems(graphics, xoffset, yoffset);
            }
        }
        if (this.currentState == 3) {
            this.removeCombinations();
            this.currentState = 1;
        }
        if (this.animation.isEmpty() && this.currentState == 1) {
            this.currentState = 4;
        }
        if (this.currentState == 4) {
            if (isEmptyJewel) {
                this.rearrangeArray();
                this.currentState = 0;
            } else {
                this.removeCombinations();
                this.currentState = 1;
            }
        }
        if (!isFalling && this.currentState == 0 && !isEmptyJewel && this.animation.isEmpty()) {
            boolean isRemoved = this.removeCombinations();
            if (isRemoved) {
                this.currentState = this.animation.size() > 0 ? 1 : 4;
            } else {
                this.currentState = 2;
                if (this.showHint) {
                    Match match = this.getAvailHint();
                    if (match.isEmpty()) {
                        this.currentState = 5;
                    } else {
                        this.hintAvailCoord = (Coord)match.elementAt(random.nextInt(match.size()));
                    }
                    this.showHint = false;
                }
            }
        }
        if (this.currentState == 1) {
            i = 0;
            while (i < this.animation.size()) {
                Animation animation = (Animation)this.animation.elementAt(i);
                animation.drawAnimation(graphics, xoffset, yoffset);
                ++i;
            }
        }
        if (this.currentState == 2 && this.powerVector.size() > 0) {
            this.assignPowersToGrids();
        }
        if (currentX > -1 && currentY > -1) {
            this.drawFocusFrame(graphics, currentX, currentY, xoffset, yoffset);
        }
        if (System.currentTimeMillis() - this.hintTime > JewelConstants.HINT_TIME && this.currentState == 2) {
            this.showHint(graphics, xoffset, yoffset);
        }
        i = 0;
        while (i < this.scoreAnimVec.size()) {
            ScoreAnimationObj obj = (ScoreAnimationObj)this.scoreAnimVec.elementAt(i);
            obj.drawScoreObject(graphics, xoffset, yoffset);
            ++i;
        }
        graphics.setColor(Config.FOCUS_COLOR);
        graphics.setFont(font);
        graphics.setColor(Config.NONFOCUS_COLOR);
        graphics.drawString(this.scoreText, 5, Config.SCREEN_HEIGHT - JewelConstants.GEM_HEIGHT, 0);
        this.scoreTextWidth = graphics.getFont().stringWidth(this.scoreText);
        graphics.drawString(this.prevScoreText, Config.SCREEN_WIDTH - graphics.getFont().stringWidth(this.prevScoreText), Config.SCREEN_HEIGHT - JewelConstants.GEM_HEIGHT, 0);
        graphics.setColor(color);
    }

    public boolean isGameOver() {
        return this.currentState == 5;
    }

    private void assignPowersToGrids() {
        int i = this.powerVector.size() - 1;
        while (i >= 0) {
            PowerObj obj = (PowerObj)this.powerVector.elementAt(i);
            this.jewelArr[obj.getRow()][obj.getCol()].setPowerType(obj.getPowerType());
            this.powerVector.removeElementAt(i);
            --i;
        }
    }

    private void drawFocusFrame(Graphics graphics, int currentX, int currentY, int xoffset, int yoffset) {
        graphics.drawImage(JewelConstants._imgfocusFrame, currentX, currentY, 0);
        if (this.currentCoord != null) {
            graphics.drawImage(JewelConstants._imgSelectedFrame, this.currentCoord.x * JewelConstants.GEM_WIDTH + xoffset, this.currentCoord.y * JewelConstants.GEM_HEIGHT + yoffset, 0);
        }
    }

    private void showHint(Graphics graphics, int xoffset, int yoffset) {
        if (++currentHintPaintFreq >= 4) {
            ++this.hintCount;
            if (this.hintCount >= JewelConstants._imgHintFrame.length) {
                this.hintCount = 0;
            }
            currentHintPaintFreq = 0;
        }
        if (this.hintAvailCoord != null) {
            Coord cord = this.hintAvailCoord;
            graphics.drawImage(JewelConstants._imgHintFrame[this.hintCount], cord.x * JewelConstants.GEM_WIDTH + xoffset + (JewelConstants.GEM_WIDTH - JewelConstants._imgHintFrame[this.hintCount].getWidth()) / 2, cord.y * JewelConstants.GEM_HEIGHT + yoffset + (JewelConstants.GEM_HEIGHT - JewelConstants._imgHintFrame[this.hintCount].getHeight()) / 2, 0);
        }
    }

    public boolean changeFrame() {
        ++this.currentfreq;
        if (this.currentfreq == this.freq) {
            this.currentfreq = 0;
            return true;
        }
        return false;
    }

    public boolean isValidSwap(int col, int row, int swappedCol, int swappedRow) {
        if (swappedRow >= this.numRows || swappedCol >= this.numCols || col >= this.numCols || row >= this.numRows) {
            return false;
        }
        if (swappedRow < 0 || swappedCol < 0 || col < 0 || row < 0) {
            return false;
        }
        int color = this.jewelArr[swappedRow][swappedCol].getColor();
        int color1 = this.jewelArr[row][col].getColor();
        this.swapJewelObj(row, col, swappedRow, swappedCol);
        int numRowElements = this.checkForRow(col, row, color);
        if (numRowElements > 2) {
            this.swapJewelObj(row, col, swappedRow, swappedCol);
            return true;
        }
        int numColElements = this.checkForColumn(col, row, color);
        if (numColElements > 2) {
            this.swapJewelObj(row, col, swappedRow, swappedCol);
            return true;
        }
        int numSwapRowElements = this.checkForRow(swappedCol, swappedRow, color1);
        if (numSwapRowElements > 2) {
            this.swapJewelObj(row, col, swappedRow, swappedCol);
            return true;
        }
        int numSwapColElements = this.checkForColumn(swappedCol, swappedRow, color1);
        if (numSwapColElements > 2) {
            this.swapJewelObj(row, col, swappedRow, swappedCol);
            return true;
        }
        this.swapJewelObj(row, col, swappedRow, swappedCol);
        return false;
    }

    public int checkForRow(int col, int row, int color) {
        int count = 1;
        int i = col - 1;
        while (i >= 0) {
            if (!this.jewelArr[row][i].equals(color)) break;
            ++count;
            --i;
        }
        i = col + 1;
        while (i < this.numCols) {
            if (!this.jewelArr[row][i].equals(color)) break;
            ++count;
            ++i;
        }
        return count;
    }

    public int checkForColumn(int col, int row, int color) {
        int count = 1;
        int i = row - 1;
        while (i >= 0) {
            if (!this.jewelArr[i][col].equals(color)) break;
            ++count;
            --i;
        }
        i = row + 1;
        while (i < this.numRows) {
            if (!this.jewelArr[i][col].equals(color)) break;
            ++count;
            ++i;
        }
        return count;
    }

    public Match getAvailHint() {
        Match match = new Match();
        int col = 0;
        while (col < this.numCols) {
            this.getAvailableCombinationInColumn(match, col);
            ++col;
        }
        int row = 0;
        while (row < this.numRows) {
            this.getAvailableCombinationInRow(match, row);
            ++row;
        }
        return match;
    }

    private Match getAvailableCombinationInRow(Match match, int rowNum) {
        int col = 0;
        while (col < this.numCols - 2) {
            if (this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum][col + 1]) && !this.jewelArr[rowNum][col].equals(0)) {
                if (col - 2 >= 0 && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum][col - 2])) {
                    if (!match.isMatched(new Coord(col - 2, rowNum))) {
                        match.addElement(new Coord(col - 2, rowNum));
                    }
                } else if (col + 3 < this.numCols && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum][col + 3])) {
                    if (!match.isMatched(new Coord(col + 3, rowNum))) {
                        match.addElement(new Coord(col + 3, rowNum));
                    }
                } else if (rowNum + 1 < this.numRows && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum + 1][col + 2])) {
                    if (!match.isMatched(new Coord(col + 2, rowNum + 1))) {
                        match.addElement(new Coord(col + 2, rowNum + 1));
                    }
                } else if (rowNum - 1 >= 0 && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum - 1][col + 2])) {
                    if (!match.isMatched(new Coord(col + 2, rowNum - 1))) {
                        match.addElement(new Coord(col + 2, rowNum - 1));
                    }
                } else if (rowNum - 1 >= 0 && col - 1 >= 0 && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum - 1][col - 1])) {
                    if (!match.isMatched(new Coord(col - 1, rowNum - 1))) {
                        match.addElement(new Coord(col - 1, rowNum - 1));
                    }
                } else if (rowNum + 1 < this.numRows && col - 1 >= 0 && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum + 1][col - 1]) && !match.isMatched(new Coord(col - 1, rowNum + 1))) {
                    match.addElement(new Coord(col - 1, rowNum + 1));
                }
            } else if (this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum][col + 2]) && !this.jewelArr[rowNum][col].equals(0)) {
                if (rowNum + 1 < this.numRows && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum + 1][col + 1])) {
                    if (!match.isMatched(new Coord(col + 1, rowNum + 1))) {
                        match.addElement(new Coord(col + 1, rowNum + 1));
                    }
                } else if (rowNum - 1 >= 0 && this.jewelArr[rowNum][col].equals(this.jewelArr[rowNum - 1][col + 1]) && !match.isMatched(new Coord(col + 1, rowNum - 1))) {
                    match.addElement(new Coord(col + 1, rowNum - 1));
                }
            }
            ++col;
        }
        return match;
    }

    private Match getAvailableCombinationInColumn(Match match, int columNum) {
        int row = 0;
        while (row < this.numRows - 2) {
            if (this.jewelArr[row][columNum].equals(this.jewelArr[row + 1][columNum]) && !this.jewelArr[row][columNum].equals(0)) {
                if (row - 2 >= 0 && this.jewelArr[row][columNum].equals(this.jewelArr[row - 2][columNum])) {
                    if (!match.isMatched(new Coord(columNum, row - 2))) {
                        match.addElement(new Coord(columNum, row - 2));
                    }
                } else if (row + 3 < this.numRows && this.jewelArr[row][columNum].equals(this.jewelArr[row + 3][columNum])) {
                    if (!match.isMatched(new Coord(columNum, row + 3))) {
                        match.addElement(new Coord(columNum, row + 3));
                    }
                } else if (columNum + 1 < this.numCols && this.jewelArr[row][columNum].equals(this.jewelArr[row + 2][columNum + 1])) {
                    if (!match.isMatched(new Coord(columNum + 1, row + 2))) {
                        match.addElement(new Coord(columNum + 1, row + 2));
                    }
                } else if (columNum - 1 >= 0 && this.jewelArr[row][columNum].equals(this.jewelArr[row + 2][columNum - 1])) {
                    if (!match.isMatched(new Coord(columNum - 1, row + 2))) {
                        match.addElement(new Coord(columNum - 1, row + 2));
                    }
                } else if (columNum - 1 >= 0 && row - 1 >= 0 && this.jewelArr[row][columNum].equals(this.jewelArr[row - 1][columNum - 1])) {
                    if (!match.isMatched(new Coord(columNum - 1, row - 1))) {
                        match.addElement(new Coord(columNum - 1, row - 1));
                    }
                } else if (columNum + 1 < this.numCols && row - 1 >= 0 && this.jewelArr[row][columNum].equals(this.jewelArr[row - 1][columNum + 1]) && !match.isMatched(new Coord(columNum + 1, row - 1))) {
                    match.addElement(new Coord(columNum + 1, row - 1));
                }
            } else if (this.jewelArr[row][columNum].equals(this.jewelArr[row + 2][columNum]) && !this.jewelArr[row][columNum].equals(0)) {
                if (columNum + 1 < this.numCols && this.jewelArr[row][columNum].equals(this.jewelArr[row + 1][columNum + 1])) {
                    if (!match.isMatched(new Coord(columNum + 1, row + 1))) {
                        match.addElement(new Coord(columNum + 1, row + 1));
                    }
                } else if (columNum - 1 >= 0 && this.jewelArr[row][columNum].equals(this.jewelArr[row + 1][columNum - 1]) && !match.isMatched(new Coord(columNum - 1, row + 1))) {
                    match.addElement(new Coord(columNum - 1, row + 1));
                }
            }
            ++row;
        }
        return match;
    }

    public void isAnimationComplete(Animation animation) {
        boolean isPresent = this.animation.removeElement(animation);
        if (isPresent) {
            if (animation instanceof RandomAnimation) {
                RandomAnimation rndmAnimation = (RandomAnimation)animation;
                Coord[] arr = rndmAnimation.getRandomCoord();
                this.assignRandomPowersToArr(arr);
            } else if (animation instanceof ColumnAnimation) {
                ColumnAnimation anim = (ColumnAnimation)animation;
                int colNum = anim.getColumnNum();
                this.removeColumn(colNum);
                this.score += (long)(100 * this.numCols);
                this.addScore(100 * this.numRows, this.numRows / 2, colNum);
            } else if (animation instanceof RowAnimation) {
                RowAnimation anim = (RowAnimation)animation;
                int rowNum = anim.getRowNum();
                this.removeRow(rowNum);
                this.addScore(100 * this.numRows, rowNum, this.numCols / 2);
            } else if (animation instanceof BlastAnimtion) {
                BlastAnimtion anim = (BlastAnimtion)animation;
                Coord[] arr = anim.getCoord();
                int i = 0;
                while (i < arr.length) {
                    this.removeElement(arr[i]);
                    ++i;
                }
                Coord coord = anim.getAnimStartCoord();
                this.addScore(100 * arr.length, coord.y, coord.x);
            }
        }
    }

    private void removeElement(Coord coord) {
        this.jewelArr[coord.y][coord.x].setAsNull();
    }

    private void assignRandomPowersToArr(Coord[] arr) {
        int i = 0;
        while (i < arr.length) {
            Coord coord = arr[i];
            this.powerVector.addElement(new PowerObj(coord.y, coord.x, random.nextInt(2)));
            ++i;
        }
    }

    public void removeRow(int rowNum) {
        int i = 0;
        while (i < this.numCols) {
            this.jewelArr[rowNum][i].setAsNull();
            ++i;
        }
    }

    public void removeColumn(int colNum) {
        int i = 0;
        while (i < this.numRows) {
            this.jewelArr[i][colNum].setAsNull();
            ++i;
        }
    }

    public boolean isStateNormal() {
        return this.currentState == 2;
    }

    public long getScore() {
        int i = this.scoreAnimVec.size() - 1;
        while (i >= 0) {
            ScoreAnimationObj obj = (ScoreAnimationObj)this.scoreAnimVec.elementAt(i);
            this.score += (long)obj.getScore();
            --i;
        }
        return this.score;
    }

    public void animationComplete(ScoreAnimationObj obj) {
        if (this.scoreAnimVec.removeElement(obj)) {
            this.score += (long)obj.getScore();
        }
        this.scoreText = String.valueOf(Config.SCORE) + this.score;
    }

    private Image createTransparentBackgroundImage() {
        Image image = Image.createImage((int)312, (int)100);
        Graphics g = image.getGraphics();
        g.setColor(225, 225, 0);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        int[] rgb = new int[image.getWidth() * image.getHeight()];
        image.getRGB(rgb, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int i = 0;
        while (i < rgb.length) {
            if (rgb[i] == -1) {
                int n = i;
                rgb[n] = rgb[n] & 0xFFFFFF;
            }
            ++i;
        }
        return Image.createRGBImage((int[])rgb, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }
}

