/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.objects;

import in.spice.jewelworld.animationlistener.AnimationCompleteListener;
import in.spice.jewelworld.common.Config;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ScoreAnimationObj {
    private int xpos;
    private int ypos;
    private AnimationCompleteListener listener;
    private String score;
    private int numScore;
    private float xdecrement;
    private float ydecrement;
    private static final int paintcycle = 20;
    private int currentPaintCount = 0;
    private int initialXpos;
    private int initialYpos;
    private static Font font = Font.getFont((int)0, (int)1, (int)16);

    public ScoreAnimationObj(int xpos, int ypos, int ymax, int xmax, int score, AnimationCompleteListener listener) {
        this.xpos = xpos;
        this.ypos = ypos;
        this.initialXpos = xpos;
        this.initialYpos = ypos;
        this.numScore = score;
        this.score = "+" + score;
        this.listener = listener;
        this.xdecrement = (float)(xpos - xmax) * 1.0f / 20.0f;
        this.ydecrement = (float)(ypos - ymax) * 1.0f / 20.0f;
    }

    public int getXpos() {
        return this.xpos;
    }

    public int getScore() {
        return this.numScore;
    }

    public int getYpos() {
        return this.ypos;
    }

    private void decrXYPos(int paintCount) {
        if (this.currentPaintCount >= 20) {
            this.listener.animationComplete(this);
            return;
        }
        this.xpos = this.initialXpos - (int)((float)this.currentPaintCount * this.xdecrement);
        this.ypos = this.initialYpos - (int)((float)this.currentPaintCount * this.ydecrement);
    }

    public void drawScoreObject(Graphics graphics, int xoffset, int yoffset) {
        ++this.currentPaintCount;
        this.decrXYPos(this.currentPaintCount);
        Font gcFont = graphics.getFont();
        graphics.setFont(font);
        int color = graphics.getColor();
        graphics.setColor(Config.NONFOCUS_COLOR);
        graphics.drawString(this.score, this.xpos + xoffset, this.ypos, 0);
        graphics.setColor(color);
        graphics.setFont(gcFont);
    }
}

