/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.screen;

import in.spice.jewelworld.common.Config;
import in.spice.jewelworld.common.ScaleImage;
import in.spice.jewelworld.common.YeloFocus;
import in.spice.jewelworld.midlet.MainMidlet;
import in.spice.jewelworld.screen.GameScreen;
import in.spice.jewelworld.screen.HomeScreen;
import in.spice.jewelworld.store.RMSData;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameOverScreen
extends Canvas {
    public static final Image WhiteScreenBG = ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", Config.POPUP_BG), Config.getX(80), Config.getY(70));
    public static YeloFocus focus1 = new YeloFocus(Config.focusButton, Config.unFocusButton, 88, 25, "gamescreen", 30, 14, Config.PLAY_TEXT, Config.FOCUS_COLOR);
    public static final Image blankScreen = ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", Config.blacktransparent), Config.SCREEN_WIDTH, Config.SCREEN_HEIGHT);
    long score;
    boolean isHighScore;
    int gameOverType;
    public static int x = (Config.SCREEN_WIDTH - WhiteScreenBG.getWidth()) / 2;
    public static int y = (Config.SCREEN_HEIGHT - WhiteScreenBG.getHeight()) / 2;
    public boolean isVisible = true;

    public GameOverScreen(long score, int gameOverType, boolean isHighScore) {
        this.setFullScreenMode(true);
        this.score = score;
        this.isHighScore = isHighScore;
        if (isHighScore) {
            RMSData.setScore(score);
        }
        this.gameOverType = gameOverType;
        focus1.setFocusLeft(true);
    }

    protected void paint(Graphics g) {
        if (this.isVisible) {
            g.drawImage(blankScreen, 0, 0, 0);
        }
        this.isVisible = false;
        g.setColor(Config.NONFOCUS_COLOR);
        focus1.drawBaseImage(g, WhiteScreenBG, x, y);
        int x1 = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(Config.CONGRATS_TEXT)) / 2;
        int y1 = y + g.getFont().getHeight() / 2;
        if (this.isHighScore) {
            g.drawString(Config.CONGRATS_TEXT, x1, y1, 0);
        } else {
            g.drawString(Config.GAME_OVER_TEXT, x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(Config.GAME_OVER_TEXT)) / 2, y1, 0);
        }
        int x2 = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth(String.valueOf(Config.SCORE) + this.score)) / 2;
        int y2 = y1 + g.getFont().getHeight();
        g.drawString(String.valueOf(Config.SCORE) + this.score, x2, y2, 0);
        int highScoreX = x + (WhiteScreenBG.getWidth() - g.getFont().stringWidth("High Score:" + RMSData.getScore())) / 2;
        int highScoreY = y2 + g.getFont().getHeight();
        g.drawString("High Score:" + RMSData.getScore(), highScoreX, highScoreY, 0);
        focus1.draw(g, Config.REPLAY_TEXT, Config.EXIT_TEXT, "", Config.NONFOCUS_COLOR, 0);
    }

    protected void pointerPressed(int x, int y) {
        if (x > focus1.getLeftX() && x < focus1.getLeftX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            System.out.println("hi");
            focus1.setFocusLeft(true);
            focus1.setFocusRight(false);
        } else if (x > focus1.getRightX() && x < focus1.getRightX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            focus1.setFocusLeft(false);
            focus1.setFocusRight(true);
        } else {
            return;
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (x > focus1.getLeftX() && x < focus1.getLeftX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            GameScreen.screen = null;
            MainMidlet.display.setCurrent((Displayable)GameScreen.getInstance());
        } else if (x > focus1.getRightX() && x < focus1.getRightX() + focus1.getImageWidth() && y > focus1.getY() && y < focus1.getY() + focus1.getImageHeight()) {
            GameScreen.screen = null;
            MainMidlet.display.setCurrent((Displayable)new HomeScreen());
        }
    }

    protected void keyPressed(int keyCode) {
        int key;
        String key1 = this.getKeyName(keyCode);
        System.out.println("key" + key1);
        if (key1.equals("g")) {
            if (GameOverScreen.focus1.IsFocusLeft) {
                GameScreen.screen = null;
                MainMidlet.display.setCurrent((Displayable)GameScreen.getInstance());
            } else {
                MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                GameScreen.screen = null;
            }
        }
        if ((key = this.getGameAction(keyCode)) == 5) {
            if (GameOverScreen.focus1.IsFocusLeft) {
                focus1.setFocusRight(true);
                focus1.setFocusLeft(false);
            }
        } else if (key == 2 && GameOverScreen.focus1.IsFocusRight) {
            focus1.setFocusLeft(true);
            focus1.setFocusRight(false);
        }
        this.repaint();
    }

    protected void showNotify() {
        this.isVisible = true;
    }
}

