/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.screen;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import in.spice.jewelworld.common.Config;
import in.spice.jewelworld.common.JewelConstants;
import in.spice.jewelworld.common.ScaleImage;
import in.spice.jewelworld.midlet.MainMidlet;
import in.spice.jewelworld.objects.Coord;
import in.spice.jewelworld.objects.GameBoard;
import in.spice.jewelworld.screen.GameOverScreen;
import in.spice.jewelworld.screen.HomeScreen;
import in.spice.jewelworld.store.RMSData;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import vInAppAdEngine.VservAd;
import vInAppAdEngine.VservAdListener;
import vInAppAdEngine.VservManager;

public class GameScreen
extends GameCanvas
implements CommandListener,
VservAdListener {
    public static GameScreen screen;
    private GameBoard board;
    private Timer timer = new Timer();
    private int currentXpos;
    private int mXOffset;
    private int currentYpos;
    private int mYOffset;
    private int prevXpos;
    private int prevYpos;
    Image bgImage;
    private VservManager vservManager;
    private VservAd vservAd;
    Image imageAd;
    String textAd;
    private Command backCommand;
    int startxpoint;
    int startyPoint;
    int direction;
    Alert alert;

    public GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        ++Config.gameCount;
        this.mXOffset = 0;
        this.mYOffset = Config.AD_MANAGER_HEIGHT;
        this.currentXpos = this.mXOffset;
        this.currentYpos = this.mYOffset;
        this.prevXpos = this.mXOffset;
        this.prevYpos = this.mYOffset;
        this.board = new GameBoard(Config.SCREEN_WIDTH, Config.SCREEN_HEIGHT - this.mYOffset - JewelConstants.GEM_HEIGHT);
        this.currentXpos = this.mXOffset = (Config.SCREEN_WIDTH - this.board.getNumCols() * JewelConstants.GEM_WIDTH) / 2;
        this.currentYpos = this.mYOffset;
        this.prevXpos = this.mXOffset;
        this.prevYpos = this.mYOffset;
        this.bgImage = ScaleImage.CreateScaledImage(Config.getFolderImage("gamescreen", Config.GAME_BG), Config.SCREEN_WIDTH, Config.SCREEN_HEIGHT);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.initlize();
        this.startTimer();
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-16");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    private void initlize() {
        Hashtable<String, String> vservConfigTable = new Hashtable<String, String>();
        vservConfigTable.put("appId", "7aabd0dd");
        this.vservManager = new VservManager(Config.midlet, vservConfigTable);
        this.vservAd = new VservAd(this);
        this.vservAd.requestAd();
    }

    public static GameScreen getInstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    private void startTimer() {
        this.stopTimer();
        if (this.board.isGameOver()) {
            return;
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (GameScreen.this.board.isGameOver()) {
                    GameScreen.this.stopTimer();
                    new Timer().schedule(new TimerTask(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Hashtable<String, String> vservConfigTableAd = new Hashtable<String, String>();
                            vservConfigTableAd.put("zoneId", "1a6c5938");
                            vservConfigTableAd.put("showAt", "end");
                            new VservManager(Config.midlet, vservConfigTableAd);
                            if (GameScreen.access$0(1.access$0(this.this$1)).getScore() > RMSData.getScore()) {
                                MainMidlet.display.setCurrent((Displayable)new GameOverScreen(GameScreen.access$0(1.access$0(this.this$1)).getScore(), 1, true));
                            } else {
                                MainMidlet.display.setCurrent((Displayable)new GameOverScreen(GameScreen.access$0(1.access$0(this.this$1)).getScore(), 1, false));
                            }
                        }
                    }, 2000L);
                } else {
                    GameScreen.this.repaint();
                }
            }

            static /* synthetic */ GameScreen access$0(1 var0) {
                return var0.GameScreen.this;
            }
        }, 1000L, 40L);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.bgImage, 0, 0, 0);
        this.board.drawGameBoard(g, this.currentXpos, this.currentYpos, this.mXOffset, this.mYOffset);
        if (this.imageAd != null) {
            g.drawImage(this.imageAd, (Config.SCREEN_WIDTH - this.imageAd.getWidth()) / 2, 0, 0);
        }
        if (this.textAd != null) {
            g.drawString(this.textAd, (Config.SCREEN_WIDTH - g.getFont().stringWidth(this.textAd)) / 2, 0, 0);
        }
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-16");
        tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer((int)this.board.getScore())));
    }

    protected void pointerDragged(int x, int y) {
        int xdiff = x - this.startxpoint;
        int ydiff = y - this.startyPoint;
        this.direction = Math.abs(xdiff) > Math.abs(ydiff) ? (xdiff > 0 ? 13 : 14) : (ydiff > 0 ? 12 : 11);
        this.board.swapJewel((this.currentXpos - this.mXOffset) / JewelConstants.GEM_WIDTH, (this.currentYpos - this.mYOffset) / JewelConstants.GEM_HEIGHT, this.direction);
        this.board.isSelected = false;
    }

    protected void pointerPressed(int x, int y) {
        this.startxpoint = x;
        this.startyPoint = y;
        int curX = Config.floor(this.startxpoint);
        int curY = Config.floor(this.startyPoint);
        int bubbleX = (curX - this.mXOffset) / JewelConstants.GEM_WIDTH;
        int bubbleY = (curY - this.mYOffset) / JewelConstants.GEM_HEIGHT;
        if (bubbleX < this.board.getNumCols() && bubbleY < this.board.getNumRows() && bubbleX >= 0 && bubbleY >= 0) {
            this.currentXpos = bubbleX * JewelConstants.GEM_WIDTH + this.mXOffset;
            this.currentYpos = bubbleY * JewelConstants.GEM_HEIGHT + this.mYOffset;
            this.board.isSelected = true;
        }
        if (x > 0 && x < Config.SCREEN_WIDTH && y > 0 && y < Config.AD_MANAGER_HEIGHT && this.vservAd.hasAction) {
            this.vservAd.handleAdAction();
        }
    }

    public void vservAdReceived(Object obj) {
        if (((VservAd)obj).getAdType().equals("image")) {
            this.imageAd = (Image)((VservAd)obj).getAd();
            System.out.println("image");
        } else if (((VservAd)obj).getAdType().equals("text")) {
            this.textAd = (String)((VservAd)obj).getAd();
            System.out.println("text");
        }
    }

    public void vservAdFailed(Object arg0) {
        System.out.println("not received");
    }

    public void commandAction(Command c, Displayable arg1) {
        if (c == this.backCommand) {
            this.showConfirmationYesOrNo(" ", Config.EXIT_MSG);
        }
    }

    protected void showConfirmationYesOrNo(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    GameScreen.this.stopTimer();
                    screen = null;
                    GameScreen.this.alert = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getInstance());
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        String key = this.getKeyName(keyCode);
        System.out.println("key" + key);
        if (key.equals("g")) {
            if (!this.board.isStateNormal()) {
                return;
            }
            if (!this.board.isSelected) {
                this.board.currentCoord = new Coord((this.currentXpos - this.mXOffset) / JewelConstants.GEM_WIDTH, (this.currentYpos - this.mYOffset) / JewelConstants.GEM_HEIGHT);
                this.board.isSelected = true;
            } else {
                this.board.isSelected = false;
                this.board.currentCoord = null;
            }
        }
        switch (gameAction) {
            case 1: {
                System.out.println("UP1");
                if (this.board.isSelected) {
                    this.board.swapJewel((this.currentXpos - this.mXOffset) / JewelConstants.GEM_WIDTH, (this.currentYpos - this.mYOffset) / JewelConstants.GEM_HEIGHT, 11);
                    this.board.isSelected = false;
                    this.board.currentCoord = null;
                }
                if (this.currentYpos == this.mYOffset || this.currentYpos == -1) break;
                this.currentYpos -= JewelConstants.GEM_HEIGHT;
                break;
            }
            case 6: {
                System.out.println("DOWN6");
                if (this.board.isSelected) {
                    this.board.swapJewel((this.currentXpos - this.mXOffset) / JewelConstants.GEM_WIDTH, (this.currentYpos - this.mYOffset) / JewelConstants.GEM_HEIGHT, 12);
                    this.board.currentCoord = null;
                    this.board.isSelected = false;
                }
                if (this.currentYpos == this.mYOffset + (this.board.getNumRows() - 1) * JewelConstants.GEM_HEIGHT || this.currentYpos == -1) break;
                this.currentYpos += JewelConstants.GEM_HEIGHT;
                break;
            }
            case 2: {
                if (this.board.isSelected) {
                    this.board.swapJewel((this.currentXpos - this.mXOffset) / JewelConstants.GEM_WIDTH, (this.currentYpos - this.mYOffset) / JewelConstants.GEM_HEIGHT, 14);
                    this.board.isSelected = false;
                    this.board.currentCoord = null;
                }
                if (this.currentXpos != this.mXOffset) {
                    this.currentXpos -= JewelConstants.GEM_WIDTH;
                }
                System.out.println("LEFT2");
                break;
            }
            case 5: {
                if (this.board.isSelected) {
                    this.board.swapJewel((this.currentXpos - this.mXOffset) / JewelConstants.GEM_WIDTH, (this.currentYpos - this.mYOffset) / JewelConstants.GEM_HEIGHT, 13);
                    this.board.isSelected = false;
                    this.board.currentCoord = null;
                }
                if (this.currentXpos != this.mXOffset + (this.board.getNumCols() - 1) * JewelConstants.GEM_WIDTH) {
                    this.currentXpos += JewelConstants.GEM_WIDTH;
                }
                System.out.println("RIGHT5");
            }
        }
        switch (keyCode) {
            case 52: {
                System.out.println(52);
                break;
            }
            case 50: {
                System.out.println(50);
                break;
            }
            case 54: {
                System.out.println(54);
                break;
            }
            case 56: {
                System.out.println(56);
                break;
            }
            case 53: {
                System.out.println(53);
            }
        }
    }
}

