/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.animationlistener;

import in.spice.jewelworld.animationlistener.Animation;
import in.spice.jewelworld.animationlistener.AnimationCompleteCallBack;
import in.spice.jewelworld.common.JewelConstants;
import in.spice.jewelworld.objects.Coord;
import in.spice.jewelworld.utils.Match;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RandomAnimation
extends Animation {
    private int totalRow;
    private int totalCol;
    private Coord[] coordinates = new Coord[JewelConstants.RANDOM_BOLCKS];
    private int currentFrame;
    private int paintCount;
    private AnimationCompleteCallBack callBack;
    private boolean isAnimationComplete;
    public static final Random random = new Random();

    public RandomAnimation(int totalRow, int totalCol, AnimationCompleteCallBack callBack) {
        this.totalRow = totalRow;
        this.totalCol = totalCol;
        this.callBack = callBack;
        this.assignRandomElements();
    }

    private void assignRandomElements() {
        Match match = new Match();
        int i = 0;
        while (i < JewelConstants.RANDOM_BOLCKS) {
            this.coordinates[i] = this.getRandomCoord(match);
            ++i;
        }
    }

    private Coord getRandomCoord(Match match) {
        int row;
        int col = random.nextInt(this.totalCol);
        Coord coord = new Coord(col, row = random.nextInt(this.totalRow));
        if (!match.contains(coord)) {
            match.addElement(coord);
            return coord;
        }
        return this.getRandomCoord(match);
    }

    public void drawAnimation(Graphics graphics, int xoffset, int yoffset) {
        if (this.isAnimationComplete) {
            this.callBack.isAnimationComplete(this);
            return;
        }
        ++this.currentFrame;
        ++this.paintCount;
        int i = 0;
        while (i < this.coordinates.length) {
            Coord coord = this.coordinates[i];
            int colNum = coord.x;
            int row = coord.y;
            float incrementFactor = (float)(row * JewelConstants.GEM_HEIGHT) * 1.0f / 18.0f;
            if (this.currentFrame >= JewelConstants.flashRandomImages.length) {
                this.currentFrame = 0;
            }
            Image bitmap = JewelConstants.flashRandomImages[this.currentFrame];
            graphics.drawImage(bitmap, xoffset + colNum * JewelConstants.GEM_WIDTH + (JewelConstants.GEM_WIDTH - bitmap.getWidth()) / 2, yoffset + (int)(incrementFactor * (float)this.paintCount) - bitmap.getHeight(), 0);
            if (this.isAnimationComplete()) {
                this.callBack.isAnimationComplete(this);
                this.isAnimationComplete = true;
            }
            ++i;
        }
    }

    public boolean isAnimationComplete() {
        return this.paintCount > 4 * JewelConstants.flashColsImages.length;
    }

    public Coord[] getRandomCoord() {
        return this.coordinates;
    }
}

