/*
 * Decompiled with CFR 0.152.
 */
package animation;

import animation.Animation;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Actor {
    public static final int ALLOCATE_ACTOR_MAX_PARA_NUM = 15;
    public static final int FLAG_SPEED_X = 1;
    public static final int FLAG_SPEED_Y = 2;
    public static final int FLAG_SPEED_AX = 4;
    public static final int FLAG_SPEED_AY = 8;
    static final int ID_CLASS_BAT = 0;
    int m_posX;
    int m_posY_Display;
    int m_posY_Ground;
    int m_vX;
    int m_vY;
    int m_vZ;
    int m_aZ;
    public Animation m_anim;
    int m_animType;
    int m_currentActionID;
    int m_tickAction;
    boolean m_actionOver;
    int m_frameIndex;
    int m_pageIDNow;
    byte m_durNow;
    boolean[] m_flag;
    byte[] m_parameters = new byte[15];
    int m_tarX;
    int m_tarY;
    int m_actorID;
    int m_roomID;
    boolean m_isValid;
    byte m_Direction;
    byte m_preDirection;
    short[] m_frameInfo;
    public static final byte ACTOR_LOOP = -1;
    int m_loopTick = -1;

    public Actor(String animFile, Image ima) {
        this.m_flag = new boolean[4];
        try {
            this.m_anim = new Animation();
            DataInputStream is = new DataInputStream(animFile.getClass().getResourceAsStream(animFile));
            this.m_anim.loadAnimation(is);
            is.close();
            this.m_anim.s_images = ima;
            this.m_anim.simaWidth = this.m_anim.s_images.getWidth();
            this.m_anim.simaHeight = this.m_anim.s_images.getHeight();
            this.loadActor(0);
            this.initFrameInfo();
        }
        catch (Exception ex) {
            System.out.println(animFile);
            ex.printStackTrace();
        }
    }

    public Actor(String animFile, String imgFile) {
        this.m_flag = new boolean[4];
        try {
            this.m_anim = new Animation();
            DataInputStream is = new DataInputStream(animFile.getClass().getResourceAsStream(animFile));
            this.m_anim.loadAnimation(is);
            is.close();
            this.m_anim.s_images = Image.createImage((String)imgFile);
            this.m_anim.simaWidth = this.m_anim.s_images.getWidth();
            this.m_anim.simaHeight = this.m_anim.s_images.getHeight();
            this.loadActor(0);
            this.initFrameInfo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void resetImage(Image ima) {
        this.m_anim.s_images = ima;
        this.m_anim.simaWidth = this.m_anim.s_images.getWidth();
        this.m_anim.simaHeight = this.m_anim.s_images.getHeight();
    }

    public void initFrameInfo() {
        int t = 0;
        int frameIndex = 0;
        this.m_frameInfo = new short[this.m_anim.m_nFrames.length * 3];
        int minX = 0;
        int maxX = 0;
        for (int j = 0; j < this.m_anim.m_nFrames.length; ++j) {
            for (int i = 0; i < this.m_anim.m_nFrames[this.m_currentActionID]; ++i) {
                frameIndex = this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
                int[] iTemp = this.m_anim.getFrameX(frameIndex);
                if (i == 0) {
                    minX = iTemp[0];
                    maxX = iTemp[1];
                    continue;
                }
                if (minX > iTemp[0]) {
                    minX = iTemp[0];
                }
                if (maxX >= iTemp[0]) continue;
                maxX = iTemp[0];
            }
            this.m_frameInfo[t + 0] = (short)minX;
            this.m_frameInfo[t + 1] = (short)(maxX - minX);
            this.m_frameInfo[t + 2] = (short)(this.m_frameInfo[t + 1] >> 1);
            t += 3;
        }
    }

    public void destory() {
        this.m_anim.s_images = null;
    }

    public void loadActor(int classID) {
        this.m_animType = classID;
        this.m_posY_Display = 0;
        this.m_posX = 0;
    }

    public void changeAction(int actionID, int loop) {
        if (actionID == this.m_currentActionID) {
            return;
        }
        this.m_loopTick = loop;
        this.m_tickAction = 0;
        this.m_actionOver = false;
        this.m_currentActionID = actionID;
        this.m_pageIDNow = 0;
        this.m_durNow = 0;
        this.m_frameIndex = this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
    }

    public void changeAction(int actionID, int loop, boolean isreset) {
        if (!isreset && actionID == this.m_currentActionID) {
            return;
        }
        this.m_loopTick = loop;
        this.m_tickAction = 0;
        this.m_actionOver = false;
        this.m_currentActionID = actionID;
        this.m_pageIDNow = 0;
        this.m_durNow = 0;
        this.m_frameIndex = this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
    }

    public short getFrameIndex() {
        return (short)this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
    }

    public int getCurAction() {
        return this.m_currentActionID;
    }

    public boolean isActionOver() {
        return this.m_actionOver;
    }

    public void setLoop(int loop) {
        this.m_loopTick = loop;
    }

    public void drawFrame(Graphics g, int camX, int camY, int frame) {
        int temp = this.m_anim.getFrame(this.m_currentActionID, frame);
        this.m_anim.draw(g, camX, camY, this.m_flag[0], false, temp);
    }

    public void drawFrameIndex(Graphics g, int camX, int camY, int frame) {
        this.m_anim.draw(g, camX, camY, this.m_flag[0], false, frame);
    }

    public boolean draw(Graphics g, int camX, int camY) {
        if (this.isActionOver()) {
            return true;
        }
        boolean return_value = false;
        if (this.m_pageIDNow == 0 && this.m_durNow == 0 && this.m_loopTick > 0) {
            --this.m_loopTick;
        }
        this.m_anim.draw(g, camX, camY, this.m_flag[0], false, this.m_frameIndex);
        this.m_durNow = (byte)(this.m_durNow + 1);
        if (this.m_durNow < this.m_anim.m_actions[this.m_currentActionID][(this.m_pageIDNow << 1) + 1]) {
            return false;
        }
        ++this.m_pageIDNow;
        if (this.m_pageIDNow > this.m_anim.m_nFrames[this.m_currentActionID] - 1) {
            return_value = true;
            if (this.m_loopTick == 0) {
                this.m_actionOver = true;
                --this.m_pageIDNow;
            } else {
                this.m_pageIDNow = 0;
            }
        }
        this.m_frameIndex = this.m_anim.getFrame(this.m_currentActionID, this.m_pageIDNow);
        this.m_durNow = 0;
        return return_value;
    }

    public void cleanRoom() {
    }
}

