/*
 * Decompiled with CFR 0.152.
 */
package animation;

import animation.DirectGraphics;
import animation.DirectUtils;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimationPngByte {
    static final int MASK = 65535;
    static final int EXTEND_PER_ACTION = 2;
    public static final int EXTEND_PER_MODULE = 4;
    public static final int EXTEND_PER_SPRITE = 4;
    public static final int EXTEND_PER_MECHMODULE = 4;
    public static final int EXTEND_PER_COLBOX = 4;
    public static final int EXTEND_PER_ATTBOX = 4;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT180 = 1;
    int m_imageID;
    short[][] m_actions;
    short[] m_nFrames;
    short[] m_mechModels;
    byte[] m_mechModelFlag;
    public short[][] m_frames;
    byte[] m_colBox;
    byte[] m_attBox;
    short[] m_modules;
    public Image s_images;
    public String m_imagepath;
    public int simaWidth;
    public int simaHeight;
    short m_clipx = 0;
    short m_clipy = 0;
    short m_clipw = (short)400;
    short m_cliph = (short)400;
    short m_curclipx = this.m_clipx;
    short m_curclipy = this.m_clipy;

    public void setclip(int x, int y, int w, int h) {
        this.m_clipx = (short)x;
        this.m_clipy = (short)y;
        this.m_clipw = (short)w;
        this.m_cliph = (short)h;
    }

    public void loadAnimation(DataInputStream is) throws Exception {
        int num;
        int i;
        is.readShort();
        this.m_imageID = is.readShort();
        is.readInt();
        this.m_imagepath = is.readUTF();
        int count = is.readShort();
        this.m_modules = new short[count * 4];
        AnimationPngByte.readDataShort(is, this.m_modules, 0, this.m_modules.length);
        count = is.readShort();
        this.m_frames = new short[count][];
        for (i = 0; i < count; ++i) {
            num = is.readUnsignedShort();
            this.m_frames[i] = new short[num * 4];
            AnimationPngByte.readDataShort(is, this.m_frames[i], 0, this.m_frames[i].length);
        }
        this.m_colBox = AnimationPngByte.readDataByte(is, count * 4);
        this.m_attBox = AnimationPngByte.readDataByte(is, count * 4);
        count = is.readUnsignedShort();
        this.m_nFrames = new short[count];
        this.m_actions = new short[count][];
        this.m_mechModels = new short[count * 4];
        for (i = 0; i < count; ++i) {
            num = is.readUnsignedShort();
            this.m_nFrames[i] = (short)num;
            this.m_actions[i] = new short[num * 2];
            AnimationPngByte.readDataShort(is, this.m_actions[i], 0, this.m_actions[i].length);
        }
        this.m_mechModelFlag = AnimationPngByte.readDataByte(is, count);
        AnimationPngByte.readDataShort(is, this.m_mechModels, 0, this.m_mechModels.length);
    }

    public int getFrame(int actionID, int frameID) {
        if (actionID < 0 || actionID >= this.m_nFrames.length) {
            return -1;
        }
        if (frameID < 0 || frameID >= this.m_nFrames[actionID]) {
            return -1;
        }
        return this.m_actions[actionID][frameID << 1] & 0xFFFF;
    }

    public int[] getFrameX(int frameIndex) {
        int[] temp = new int[2];
        short[] s = this.m_frames[frameIndex];
        int minX = 0;
        int maxX = 0;
        for (int i = 0; i < s.length; i += 4) {
            int modID = (s[i] & 0xFFFF) << 2;
            short modW = this.m_modules[modID + 2];
            int posX = Math.abs(s[i + 2]);
            if (i == 0) {
                minX = posX;
                maxX = posX + modW;
                continue;
            }
            if (minX > posX) {
                minX = posX;
            }
            if (maxX >= posX + modW) continue;
            maxX = posX + modW;
        }
        temp[0] = minX;
        temp[1] = maxX;
        return temp;
    }

    public void draw(Graphics g, int screenX, int screenY, boolean flipX, boolean flipY, int frameIndex) {
        short[] s = this.m_frames[frameIndex];
        int dgflag = 0;
        this.m_curclipx = this.m_clipx;
        this.m_curclipy = this.m_clipy;
        for (int i = 0; i < s.length; i += 4) {
            int modID = (s[i] & 0xFFFF) << 2;
            int flag = s[i + 1] & 0xFFFF;
            short modX = this.m_modules[modID];
            short modY = this.m_modules[modID + 1];
            short modW = this.m_modules[modID + 2];
            short modH = this.m_modules[modID + 3];
            boolean flipXs = flipX ^ (flag & 1) != 0;
            boolean flipYs = flipY ^ (flag & 2) != 0;
            int posX = screenX;
            int posY = screenY;
            posX = flipX ? (posX -= s[i + 2]) : (posX += s[i + 2]);
            posY = flipY ? (posY -= s[i + 3]) : (posY += s[i + 3]);
            short s2 = flipYs ? modH : (short)0;
            dgflag = AnimationPngByte.trans(flipXs, flipYs);
            this.drawRegion_Nokia(g, this.m_imageID, 0, modX, modY, modW, modH, dgflag, posX -= flipXs ? modW : (short)0, posY -= s2);
        }
    }

    static int trans(boolean flipX, boolean flipY) {
        if (!flipX && !flipY) {
            return 0;
        }
        if (flipX && !flipY) {
            return 2;
        }
        if (!flipX && flipY) {
            return 1;
        }
        return 3;
    }

    public void drawRegion_Nokia(Graphics g, int imageID, int palID, int sx, int sy, int sw, int sh, int flag, int dx, int dy) {
        if (g == null) {
            return;
        }
        int a2 = g.getClipX();
        int b = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        DirectGraphics dg = DirectUtils.getDirectGraphics(g);
        switch (flag) {
            case 0: {
                int clipx = Math.max(dx, this.m_curclipx);
                int clipy = Math.max(dy, this.m_curclipy);
                int clipw = Math.min(dx + sw, this.m_curclipx + this.m_clipw) - clipx;
                int cliph = Math.min(dy + sh, this.m_curclipx + this.m_cliph) - clipy;
                g.setClip(clipx, clipy, clipw, cliph);
                g.drawImage(this.s_images, dx - sx, dy - sy, 0);
                break;
            }
            case 2: {
                g.setClip((int)this.m_curclipx, (int)this.m_curclipy, (int)this.m_clipw, (int)this.m_cliph);
                dg.drawImage(this.s_images, dx, dy, 0, 8192);
                break;
            }
            case 1: {
                g.setClip((int)this.m_curclipx, (int)this.m_curclipy, (int)this.m_clipw, (int)this.m_cliph);
                dg.setClip(sx, sy, sw, sh);
                dg.drawImage(this.s_images, dx, dy, 0, 16384);
                break;
            }
            case 3: {
                g.setClip((int)this.m_curclipx, (int)this.m_curclipy, (int)this.m_clipw, (int)this.m_cliph);
                dg.setClip(sx, sy, sw, sh);
                dg.drawImage(this.s_images, dx, dy, 0, 180);
            }
        }
        g.setClip(a2, b, w, h);
    }

    public static final byte[] readDataByte(DataInputStream dis, int length) throws Exception {
        byte[] data = new byte[length];
        dis.read(data, 0, length);
        return data;
    }

    public static final void readDataShort(DataInputStream dis, short[] data, int off, int length) throws Exception {
        for (int i = 0; i < length; ++i) {
            data[i + off] = dis.readShort();
        }
    }

    int durframe(int actionID, int frameID) {
        return this.m_actions[actionID][(frameID << 1) + 1] & 0xFFFF;
    }
}

