/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

final class BitUtils {
    private BitUtils() {
    }

    static int countLeadingZeros(int x) {
        if (x <= 0) {
            if (x == 0) {
                return 32;
            }
            return 0;
        }
        int count = 0;
        if ((x & 0xFFFF0000) == 0) {
            x <<= 16;
            count = 16;
        }
        if ((x & 0xFF000000) == 0) {
            x <<= 8;
            count += 8;
        }
        while (x > 0) {
            ++count;
            x <<= 1;
        }
        return count;
    }

    static int countLeadingZeros(long x) {
        int c = BitUtils.countLeadingZeros((int)(x >> 32));
        if (c == 32) {
            return BitUtils.countLeadingZeros((int)x) + 32;
        }
        return c;
    }

    static int stickyRightShift(int x, int count) {
        if (count >= 32) {
            return x == 0 ? 0 : 1;
        }
        if (x << 32 - count == 0) {
            return x >>> count;
        }
        return x >>> count | 1;
    }

    static long stickyRightShift(long x, int count) {
        if (count >= 64) {
            return x == 0L ? 0 : 1;
        }
        if (x << 64 - count == 0L) {
            return x >>> count;
        }
        return x >>> count | 1L;
    }

    static int roundingRightShift(int x, int count) {
        int remainder;
        if (count > 32) {
            return 0;
        }
        if (count == 32) {
            remainder = x;
            x = 0;
        } else {
            remainder = x << 32 - count;
            x >>>= count;
        }
        if (remainder < 0 && (remainder != Integer.MIN_VALUE || (x & 1) == 1)) {
            return x + 1;
        }
        return x;
    }

    static long roundingRightShift(long x, int count) {
        long remainder;
        if (count > 64) {
            return 0L;
        }
        if (count == 64) {
            remainder = x;
            x = 0L;
        } else {
            remainder = x << 64 - count;
            x >>>= count;
        }
        if (remainder < 0L && (remainder != Long.MIN_VALUE || (x & 1L) == 1L)) {
            return x + 1L;
        }
        return x;
    }
}

