/*
 * Decompiled with CFR 0.152.
 */
package com.lq.net;

import com.lq.util.LQDebug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public class LQOnlineClient
implements Runnable {
    public static final byte MAX_PACKAGE_PARAMS = 100;
    public static final byte MAX_RESPONSE_PARAMS = 100;
    public static final boolean PRINTING_HEADERS = false;
    protected static final short GAME_CODE = 108;
    public static final byte REQUEST_BY_GET = 0;
    public static final byte REQUEST_BY_POST = 1;
    public static final byte REQUEST_IMAGE = 2;
    public static final byte PARAM_ERROR_MSG = 0;
    public static final byte PARAM_INFO_MSG = 1;
    public static final byte PARAM_SESSION_ID = 2;
    public static final byte PARAM_USER_ID = 3;
    public static final byte PARAM_CLOSE_CONNECTION = 4;
    public static final byte PARAM_OK = 5;
    public static final byte PARAM_IMG = 6;
    public static final byte PARAM_CRC32 = 7;
    public static final byte PARAM_GAME_CODE = 8;
    public static final byte PARAM_GAME_TABLE = 9;
    protected static final String URL_BASE = "http://lemonlive.com/status/";
    protected static final String URL_MANAGER = "http://lemonlive.com/status/session.php";
    protected static final String URL_LOGIN = "http://lemonlive.com/status/login.php";
    protected static final String URL_IMAGES = "http://lemonlive.com/";
    public static final byte STATE_ERROR = -1;
    public static final byte STATE_IDDLE = 0;
    public static final byte STATE_WAITING = 1;
    public static final byte STATE_RECEIVED = 2;
    public static final byte STATE_SEND_BY_GET = 3;
    public static final byte STATE_SEND_BY_POST = 4;
    public static final byte STATE_REQUEST_IMAGE = 5;
    public static final short TIME_REFRESH_STATE = 20;
    public static final short MAX_NUM_RETRYS = 5;
    public static boolean running = true;
    public static byte state = 0;
    public static byte oldState = 0;
    public static Calendar auxCalendar;
    public static long timeLastTrans;
    public static int sessionId;
    public static int userId;
    public static byte numRetrys;
    public static long crcCode;
    protected static String gameTable;
    protected static int[] sendDataI;
    protected static int[] sendNamesI;
    protected static int[] sendNamesS;
    protected static String[] sendDataS;
    protected static int[] responseDataI;
    protected static int[] responseNamesI;
    protected static int[] responseNamesS;
    protected static String[] responseDataS;
    protected static int numSendInt;
    protected static int numSendString;
    protected static int numRespInt;
    protected static int numRespString;
    protected static String error;
    protected static String infomsg;
    protected static String imgroute;
    protected static Image tempImg;
    public static HttpConnection connection;
    public static InputStream input;
    public static OutputStream output;
    public static String url;

    public LQOnlineClient() {
        sendDataI = new int[100];
        sendDataS = new String[100];
        sendNamesI = new int[100];
        sendNamesS = new int[100];
        responseDataI = new int[100];
        responseDataS = new String[100];
        responseNamesI = new int[100];
        responseNamesS = new int[100];
    }

    public void run() {
        try {
            switch (state) {
                case 1: {
                    break;
                }
                case 3: {
                    LQOnlineClient.changeStateTo((byte)1);
                    LQOnlineClient.request((byte)0);
                    break;
                }
                case 4: {
                    LQOnlineClient.changeStateTo((byte)1);
                    LQOnlineClient.request((byte)1);
                    break;
                }
                case 5: {
                    LQOnlineClient.changeStateTo((byte)1);
                    LQOnlineClient.request((byte)2);
                    break;
                }
            }
        }
        catch (Exception e) {
            LQDebug.log("ERROR: There was an uncatched exception in the client!");
            LQDebug.log("" + e.getMessage());
            LQDebug.log("" + e.toString());
        }
    }

    private static void getImgResponse() throws IOException {
        int ch;
        ByteArrayOutputStream bStrm = new ByteArrayOutputStream();
        int rc = connection.getResponseCode();
        if (rc != 200) {
            throw new IOException("HTTP response code: " + rc);
        }
        input = connection.openInputStream();
        String type = connection.getType();
        LQOnlineClient.printHeader();
        String cad = "";
        int len = (int)connection.getLength();
        byte[] data = null;
        while ((ch = input.read()) != -1) {
            bStrm.write(ch);
        }
        data = bStrm.toByteArray();
        try {
            tempImg = Image.createImage((byte[])data, (int)0, (int)(data.length - 1));
        }
        catch (IllegalArgumentException er) {
            tempImg = null;
            LQDebug.log("- Warning! Image downloaded is not a valid PNG.");
        }
        if (state != -1) {
            LQOnlineClient.changeStateTo((byte)2);
        }
    }

    private static void getResponse() throws IOException {
        int rc = connection.getResponseCode();
        if (rc != 200) {
            throw new IOException("HTTP response code: " + rc);
        }
        input = connection.openInputStream();
        String type = connection.getType();
        LQOnlineClient.printHeader();
        String cad = "";
        int len = (int)connection.getLength();
        if (len > 0) {
            int actual = 0;
            byte[] data = new byte[len];
            actual = input.read(data, 0, len);
            LQDebug.log(new String(data));
            cad = new String(data);
        } else {
            int ch;
            while ((ch = input.read()) != -1) {
                cad = cad + ch;
            }
            LQDebug.log(cad);
        }
        LQOnlineClient.parseResponse(cad);
        if (state != -1) {
            LQOnlineClient.changeStateTo((byte)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void request(byte mode) {
        try {
            switch (mode) {
                case 0: {
                    LQOnlineClient.sendGET();
                    return;
                }
                case 1: {
                    LQOnlineClient.sendPOST();
                    return;
                }
                case 2: {
                    LQOnlineClient.getImage();
                    return;
                }
            }
            return;
        }
        catch (IllegalArgumentException e) {
            LQOnlineClient.setError("Illegal argument (could be an illegal URL): " + url);
            e.printStackTrace();
            return;
        }
        catch (ClassCastException e) {
            LQOnlineClient.setError("Not an HTTP URL: " + url);
            return;
        }
        catch (SecurityException e) {
            LQOnlineClient.setError("Security exception, access to this protocol prohibited.");
            return;
        }
        catch (ConnectionNotFoundException e) {
            LQOnlineClient.setError("URL not found or protocol type not supported.");
            return;
        }
        catch (IOException e) {
            LQDebug.log(e.getMessage());
            numRetrys = (byte)(numRetrys + 1);
            if (numRetrys >= 5) {
                LQOnlineClient.setError("(IOException) ERROR connecting to server (probably is a CONEXION PROBLEM): \n" + e.getMessage());
                return;
            }
            try {
                if (input != null) {
                    input.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LQOnlineClient.request(mode);
            return;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                LQDebug.log("-WARNING!! IOEXCEPTION closing HTTP Connection: \n" + e.getMessage());
            }
            timeLastTrans = System.currentTimeMillis() - timeLastTrans;
            LQDebug.log("Transaction time: " + timeLastTrans + "ms.");
        }
    }

    private static void sendGET() throws IOException {
        String completeUrl = null;
        timeLastTrans = System.currentTimeMillis();
        completeUrl = LQOnlineClient.buildCompleteUrl();
        connection = (HttpConnection)UnAds.open(completeUrl, 3, true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "Profile/MIDP-2.0 Configuration/CLDC-1.0");
        LQOnlineClient.getResponse();
    }

    private static void sendPOST() throws IOException {
        String postPackage = null;
        boolean error = true;
        timeLastTrans = System.currentTimeMillis();
        connection = (HttpConnection)UnAds.open(url, 3, true);
        postPackage = LQOnlineClient.buildPostPackage();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", "Profile/MIDP-2.0 Configuration/CLDC-1.0");
        output = connection.openOutputStream();
        byte[] data = postPackage.getBytes();
        for (int i = 0; i < data.length; ++i) {
            output.write(data[i]);
        }
        output.flush();
        data = null;
        LQOnlineClient.getResponse();
    }

    private static void getImage() throws IOException {
        timeLastTrans = System.currentTimeMillis();
        connection = (HttpConnection)UnAds.open(URL_IMAGES + url, 3, true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "Profile/MIDP-2.0 Configuration/CLDC-1.0");
        LQOnlineClient.getImgResponse();
    }

    public static boolean thereIsResponse() {
        return numRespInt + numRespString > 0;
    }

    public static int responseNumInts() {
        return numRespInt;
    }

    public static int responsenumStrings() {
        return numRespString;
    }

    public static String getResponseParam(int name) {
        int i;
        String result = null;
        for (i = 0; i < numRespString && result == null; ++i) {
            if (responseNamesS[i] != name) continue;
            result = responseDataS[i];
        }
        if (result == null) {
            for (i = 0; i < numRespInt && result == null; ++i) {
                if (responseNamesI[i] != name) continue;
                result = "" + responseDataI[i];
            }
        }
        return result;
    }

    public static int[] responseIntData() {
        int[] result = new int[numRespInt];
        for (int i = 0; i < numRespInt; ++i) {
            result[i] = responseDataI[i];
        }
        return result;
    }

    public static int responseIntData(int i) {
        if (i < numRespInt) {
            return responseDataI[i];
        }
        return -1;
    }

    public static int[] responseIntNames() {
        int[] result = new int[numRespInt];
        for (int i = 0; i < numRespInt; ++i) {
            result[i] = responseNamesI[i];
        }
        return result;
    }

    public static int responseIntName(int i) {
        if (i < numRespInt) {
            return responseNamesI[i];
        }
        return -1;
    }

    public static String[] responseStringData() {
        String[] result = new String[numRespString];
        for (int i = 0; i < numRespString; ++i) {
            result[i] = responseDataS[i];
        }
        return result;
    }

    public static String responseStringData(int i) {
        if (i < numRespString) {
            return responseDataS[i];
        }
        return null;
    }

    public static int responseStringName(int i) {
        if (i < numRespString) {
            return responseNamesS[i];
        }
        return -1;
    }

    public static int[] responseStringNames() {
        int[] result = new int[numRespString];
        for (int i = 0; i < numRespString; ++i) {
            result[i] = responseNamesS[i];
        }
        return result;
    }

    public static Image responseImage() {
        return tempImg;
    }

    public static void createNewPackage() {
        numSendInt = 0;
        numSendString = 0;
    }

    public static boolean addValue(int variable, int value) {
        boolean added = false;
        if (numSendInt < 100) {
            LQOnlineClient.sendNamesI[LQOnlineClient.numSendInt] = variable;
            LQOnlineClient.sendDataI[LQOnlineClient.numSendInt] = value;
            ++numSendInt;
            added = true;
        }
        return added;
    }

    public static boolean addValue(int variable, String value) {
        boolean added = false;
        if (numSendString < 100) {
            LQOnlineClient.sendNamesS[LQOnlineClient.numSendString] = variable;
            LQOnlineClient.sendDataS[LQOnlineClient.numSendString] = value;
            ++numSendString;
            added = true;
        }
        return added;
    }

    private static String buildPostPackage() {
        StringBuffer cad = new StringBuffer("");
        int i = 0;
        boolean j = false;
        if (gameTable != null) {
            cad.append("#");
            cad.append(9);
            cad.append("#");
            cad.append(gameTable);
        }
        if (sessionId != 0) {
            cad.append("#");
            cad.append(2);
            cad.append("#");
            cad.append(sessionId);
        }
        if (userId != 0) {
            cad.append("#");
            cad.append(3);
            cad.append("#");
            cad.append(userId);
        }
        for (i = 0; i < numSendInt; ++i) {
            cad.append("#");
            cad.append(sendNamesI[i]);
            cad.append("#");
            cad.append(sendDataI[i]);
        }
        for (i = 0; i < numSendString; ++i) {
            cad.append("#");
            cad.append(sendNamesS[i]);
            cad.append("#");
            cad.append(sendDataS[i]);
        }
        LQDebug.log("Sending: " + cad);
        return cad.toString();
    }

    private static String buildCompleteUrl() {
        StringBuffer cad = new StringBuffer("?");
        int i = 0;
        int j = 0;
        i = 0;
        if (gameTable != null) {
            if (i > 0) {
                cad.append("&");
            }
            cad.append(9);
            cad.append("=");
            cad.append(gameTable);
            ++i;
        }
        if (sessionId != 0) {
            if (i > 0) {
                cad.append("&");
            }
            cad.append(2);
            cad.append("=");
            cad.append(sessionId);
            ++i;
        }
        if (userId != 0) {
            if (i > 0) {
                cad.append("&");
            }
            cad.append(3);
            cad.append("=");
            cad.append(userId);
            ++i;
        }
        while (i < numSendInt) {
            if (i > 0) {
                cad.append("&");
            }
            cad.append(sendNamesI[i]);
            cad.append("=");
            cad.append(sendDataI[i]);
            ++i;
        }
        j = 0;
        while (i < numSendString) {
            if (i > 0) {
                cad.append("&");
            }
            cad.append(sendNamesS[j]);
            cad.append("=");
            cad.append(sendDataS[j]);
            ++i;
            ++j;
        }
        if (cad.length() >= 256) {
            LQDebug.log("WARNING!! -> URL size over 255 chars");
        }
        LQDebug.log("Sending: " + cad);
        return url + cad;
    }

    public static boolean sendbyGET() {
        boolean accepted = false;
        if (state != 1) {
            LQOnlineClient.changeStateTo((byte)3);
            accepted = true;
        }
        return accepted;
    }

    public static boolean sendbyPOST() {
        boolean accepted = false;
        if (state != 1) {
            LQOnlineClient.changeStateTo((byte)4);
            accepted = true;
        }
        return accepted;
    }

    public static boolean downloadImage() {
        boolean accepted = false;
        if (state != 1) {
            LQOnlineClient.changeStateTo((byte)5);
            accepted = true;
        }
        return accepted;
    }

    public static String getError() {
        return error;
    }

    public void open() {
    }

    public static void cancel() {
        try {
            if (input != null) {
                input.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (output != null) {
                output.close();
            }
            LQOnlineClient.changeStateTo((byte)0);
        }
        catch (IOException e) {
            LQOnlineClient.setError(" closing HTTP Connection. \n");
        }
    }

    public void close() {
        try {
            if (input != null) {
                input.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (output != null) {
                output.close();
            }
            if (userId != 0 && sessionId != 0) {
                LQOnlineClient.setURL(URL_MANAGER);
                LQOnlineClient.createNewPackage();
                LQOnlineClient.addValue(4, 0);
                LQOnlineClient.sendbyPOST();
            } else {
                LQOnlineClient.changeStateTo((byte)2);
            }
        }
        catch (IOException e) {
            LQOnlineClient.setError("closing HTTP Connection. \n");
        }
    }

    public static boolean isLogged() {
        return sessionId != 0 && userId != 0;
    }

    public static void setURL(String newUrl) {
        url = newUrl;
    }

    public static byte getState() {
        return state;
    }

    public static boolean thereIsImg() {
        return imgroute != null && !imgroute.equals("EMPTY");
    }

    public static boolean thereIsInfoMsg() {
        return infomsg != null;
    }

    public static void changeStateTo(byte newState) {
        oldState = state;
        state = newState;
    }

    private static void setError(String cad) {
        oldState = state;
        state = (byte)-1;
        numRespInt = 0;
        numRespString = 0;
        error = "+ ERROR: " + cad;
        LQDebug.log(error);
    }

    private static void parseResponse(String cad) throws IOException {
        boolean isName = true;
        boolean errorb = false;
        numRespInt = 0;
        numRespString = 0;
        crcCode = 0L;
        infomsg = null;
        imgroute = null;
        error = null;
        int i = 0;
        int paramName = 0;
        while (i < cad.length() && !errorb) {
            if (cad.charAt(i) == '#') {
                String param = "";
                ++i;
                while (i < cad.length() && cad.charAt(i) != '#') {
                    param = param + cad.charAt(i);
                    ++i;
                }
                if (param.length() > 0) {
                    if (isName) {
                        paramName = Integer.parseInt(param);
                        isName = !isName;
                        continue;
                    }
                    LQOnlineClient.processParam(paramName, param, cad.substring(i, cad.length()));
                    boolean bl = isName = !isName;
                    if (state != -1) continue;
                    errorb = true;
                    continue;
                }
                LQOnlineClient.setError("Wrong package format");
                errorb = true;
                continue;
            }
            LQOnlineClient.setError("Wrong package format.");
            errorb = true;
        }
    }

    private static void processParam(int name, String data, String pack) throws IOException {
        char auxChar = data.charAt(0);
        if (name == 9) {
            gameTable = data;
        }
        if (name == 7) {
            crcCode = Long.parseLong(data);
            if (crcCode != LQOnlineClient.getCRC32(pack)) {
                throw new IOException("Package received corrupted.");
            }
        } else if (name == 2) {
            sessionId = Integer.parseInt(data);
        } else if (name == 3) {
            userId = Integer.parseInt(data);
        } else if (name == 0) {
            LQOnlineClient.setError(data);
        } else if (name == 6) {
            imgroute = data;
        } else if (name == 1) {
            infomsg = data;
        } else if (auxChar >= '0' && auxChar <= '9') {
            LQOnlineClient.responseDataI[LQOnlineClient.numRespInt] = Integer.parseInt(data);
            LQOnlineClient.responseNamesI[LQOnlineClient.numRespInt] = name;
            ++numRespInt;
        } else {
            LQOnlineClient.responseDataS[LQOnlineClient.numRespString] = data;
            LQOnlineClient.responseNamesS[LQOnlineClient.numRespString] = name;
            ++numRespString;
        }
    }

    private static void printHeader() {
    }

    public static long getCRC32(byte[] buf) {
        int c;
        int off = 0;
        int len = buf.length;
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public static long getCRC32(String text) {
        return LQOnlineClient.getCRC32(text.getBytes());
    }

    static {
        timeLastTrans = 0L;
        sessionId = 0;
        userId = 0;
        numRetrys = 0;
        crcCode = 0L;
        gameTable = "";
        connection = null;
        input = null;
        output = null;
        url = null;
    }
}

