/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import com.lq.util.LQFunctions;
import game.Menu;
import game.Mycavans;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import piple.Piple;

public class LQFont {
    public int fontHeight;
    public int charSpacing;
    public int lineSpacing;
    public int spaceSize;
    public int numSymbols;
    public int numLetters;
    public int currentPalette;
    public int previousPalette;
    public short[][] symbols;
    public char[] letterChars;
    public short[][] letterSymbols;
    public Image[] image;
    protected boolean m_isEnableArea;
    protected int m_areaX;
    protected int m_areaY;
    protected int m_areaW;
    protected int m_areaH;
    public static int MAX_LINE_SLOT = 20;
    protected static short[] strMoveTick = new short[MAX_LINE_SLOT];
    protected static boolean[] isShow = new boolean[MAX_LINE_SLOT];
    protected Font m_font;
    protected int[] m_textColor;

    public LQFont(String filepath) {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(filepath));
        this.load(dis, null);
    }

    public LQFont(DataInputStream dis, int[][] palettes) {
        this.load(dis, palettes);
    }

    public void load(DataInputStream dis, int[][] palettes) {
        try {
            int j;
            byte version = dis.readByte();
            this.numSymbols = dis.readUnsignedByte();
            this.symbols = new short[this.numSymbols][6];
            for (j = 0; j < this.numSymbols; ++j) {
                this.symbols[j][0] = (short)dis.readUnsignedByte();
                this.symbols[j][1] = (short)dis.readUnsignedByte();
                this.symbols[j][2] = (short)dis.readUnsignedByte();
                this.symbols[j][3] = (short)dis.readUnsignedByte();
                this.symbols[j][4] = dis.readByte();
                this.symbols[j][5] = dis.readByte();
            }
            this.fontHeight = dis.readUnsignedByte();
            this.charSpacing = dis.readByte();
            this.lineSpacing = dis.readUnsignedByte();
            this.spaceSize = dis.readUnsignedByte();
            this.numLetters = dis.readUnsignedByte();
            this.letterChars = new char[this.numLetters];
            this.letterSymbols = new short[this.numLetters][];
            for (j = 0; j < this.numLetters; ++j) {
                this.letterChars[j] = dis.readChar();
                int numSymbolsLetter = dis.readUnsignedByte();
                this.letterSymbols[j] = new short[numSymbolsLetter];
                for (int k = 0; k < numSymbolsLetter; ++k) {
                    this.letterSymbols[j][k] = (short)dis.readUnsignedByte();
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[128];
            int readed = dis.read(buffer);
            while (readed != -1) {
                baos.write(buffer, 0, readed);
                readed = dis.read(buffer);
            }
            buffer = baos.toByteArray();
            this.image = new Image[palettes == null ? 1 : palettes.length + 1];
            this.image[0] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
            if (palettes != null) {
                int i = 1;
                while (0 < palettes.length) {
                    LQFunctions.changePNGPalette(buffer, palettes[i - 1]);
                    this.image[i] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                    ++i;
                }
            }
            this.currentPalette = 0;
            baos.close();
            dis.close();
            baos = null;
            dis = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setArea(boolean isEnableArea, int x, int y, int w, int h) {
        this.m_isEnableArea = isEnableArea;
        this.m_areaX = x;
        this.m_areaY = y;
        this.m_areaW = w;
        this.m_areaH = h;
    }

    public void setCurrentPalette(int numPalette) {
        if (this.m_font == null) {
            if (numPalette < this.image.length) {
                this.currentPalette = numPalette;
            }
        } else if (numPalette < this.m_textColor.length) {
            this.currentPalette = numPalette;
        }
    }

    public Object[] getLineData(char[] text, int width) {
        if (this.m_font != null) {
            return LQFont.getStrings(text, width, this.m_font);
        }
        Vector<short[]> lines = new Vector<short[]>();
        int lineStart = 0;
        int lineEnd = 0;
        int lineWidth = 0;
        boolean noData = true;
        int nextWordStart = 0;
        int processWidth = 0;
        int lastCharType = 48;
        for (int index = 0; index < text.length; ++index) {
            char actualCharacter = text[index];
            switch (actualCharacter) {
                case ' ': {
                    if (lastCharType == 67) {
                        lineEnd = index - 1;
                        lineWidth = processWidth - this.getCharSpacing();
                    }
                    processWidth += this.getSpaceSize() + this.getCharSpacing();
                    lastCharType = 83;
                    break;
                }
                case '\n': {
                    lineEnd = index - 1;
                    lineWidth = processWidth - this.getCharSpacing();
                    lastCharType = 78;
                    break;
                }
                default: {
                    if (noData) {
                        lineStart = index;
                        noData = false;
                    }
                    if (lastCharType == 83) {
                        nextWordStart = index;
                    } else if (lastCharType == 78) {
                        nextWordStart = index;
                    }
                    processWidth += this.getCharacterWidth(actualCharacter) + this.getCharSpacing();
                    lastCharType = 67;
                }
            }
            if (index == text.length - 1) {
                lineEnd = index;
                lineWidth = processWidth - this.getCharSpacing();
                lastCharType = 78;
            } else if (processWidth >= width) {
                switch (text[index + 1]) {
                    case '\n': 
                    case ' ': {
                        lineEnd = index;
                        lineWidth = processWidth;
                        break;
                    }
                    default: {
                        if (lineEnd > lineStart) break;
                        lineWidth = processWidth - this.getCharSpacing();
                        lineEnd = index;
                    }
                }
                lastCharType = 78;
            }
            if (lastCharType != 78) continue;
            short[] lineData = new short[3];
            if (!noData) {
                lineData[0] = (short)lineStart;
                lineData[1] = (short)lineEnd;
                lineData[2] = (short)lineWidth;
            }
            lines.addElement(lineData);
            if (nextWordStart <= lineEnd) {
                noData = true;
            } else {
                lineStart = nextWordStart;
                processWidth -= (nextWordStart - lineEnd) * this.getSpaceSize() - 2;
            }
            processWidth -= lineWidth + this.getCharSpacing();
        }
        short[][] result = new short[lines.size()][];
        Enumeration e = lines.elements();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short[])e.nextElement();
        }
        return result;
    }

    public Object[] getLineData(String text, int width) {
        return this.getLineData(text.toCharArray(), width);
    }

    private int getCharacterWidth(char character) {
        if (this.m_font != null) {
            return this.m_font.charWidth(character);
        }
        short[] charSymbol = this.getSymbolByCharacter_ImageFont(character, 0);
        if (charSymbol == null) {
            if (character == ' ') {
                return this.getSpaceSize();
            }
            System.out.println("Character " + character + " not found");
            return 0;
        }
        return charSymbol[2];
    }

    private short[] getSymbolByCharacter_ImageFont(char character, int numSymbol) {
        int charIndex = this.binarySearchOnChars_ImageFont(character, 0, this.letterChars.length - 1);
        if (charIndex == -1) {
            return null;
        }
        return this.symbols[this.letterSymbols[charIndex][numSymbol]];
    }

    private int binarySearchOnChars_ImageFont(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.letterChars[mid] == character) {
            return mid;
        }
        if (character < this.letterChars[mid]) {
            return this.binarySearchOnChars_ImageFont(character, left, mid - 1);
        }
        return this.binarySearchOnChars_ImageFont(character, mid + 1, right);
    }

    public int drawChar(Graphics graphics, char character, int x, int y) {
        if (character == ' ') {
            return this.getSpaceSize();
        }
        if (this.m_font != null) {
            graphics.drawChar(character, x, y, 0);
            return this.m_font.charWidth(character);
        }
        int charIndex = this.binarySearchOnChars_ImageFont(character, 0, this.letterChars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        short[] f = this.letterSymbols[charIndex];
        int result = this.drawSymbol_ImageFont(graphics, this.symbols[f[0]], x, y);
        for (int i = 1; i < f.length; ++i) {
            result = Math.max(result, this.drawSymbol_ImageFont(graphics, this.symbols[f[i]], x, y));
        }
        return result;
    }

    public int getLineWidth(String str) {
        if (this.m_font == null) {
            return this.getLineWidth(str.toCharArray());
        }
        return this.m_font.stringWidth(str);
    }

    public int getLineWidth(char[] text) {
        int totalWidth = 0;
        if (text.length < 1) {
            return 0;
        }
        totalWidth += this.getCharacterWidth(text[0]);
        for (int i = 1; i < text.length; ++i) {
            char auxChar = text[i];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.getCharSpacing();
        }
        return totalWidth;
    }

    private int drawSymbol_ImageFont(Graphics g, short[] symbol, int x, int y) {
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        x -= symbol[4];
        y -= symbol[5];
        if (this.m_isEnableArea) {
            if (x + symbol[2] < this.m_areaX) {
                return symbol[2];
            }
            if (x > this.m_areaX + this.m_areaW) {
                return symbol[2];
            }
            if (y + symbol[3] < this.m_areaY) {
                return symbol[2];
            }
            if (y > this.m_areaY + this.m_areaH) {
                return symbol[2];
            }
        }
        g.setClip(x, y, (int)symbol[2], (int)symbol[3]);
        g.drawImage(this.image[this.currentPalette], x - symbol[0], y - symbol[1], 20);
        g.setClip(cx, cy, cw, ch);
        return symbol[2];
    }

    public int drawString(Graphics g, char[] text, int x, int y, int anchor, int maxPixelsWidth) {
        if (this.getLineWidth(text) > maxPixelsWidth) {
            StringBuffer newText = new StringBuffer(text.length);
            for (int i = 0; i < text.length; ++i) {
                if (maxPixelsWidth - this.getCharacterWidth(text[i]) > 3 * this.getCharacterWidth('.')) {
                    maxPixelsWidth -= this.getCharacterWidth(text[i]);
                } else {
                    newText.append('.');
                    break;
                }
                newText.append(text[i]);
            }
            return this.drawString(g, newText.toString().toCharArray(), x, y, anchor);
        }
        return this.drawString(g, text, x, y, anchor);
    }

    public int drawString(Graphics g, String str, int x, int y, int anchor) {
        return this.drawString(g, str.toCharArray(), x, y, anchor);
    }

    public int drawString(Graphics g, char[] text, int x, int y, int anchor) {
        if (this.m_font != null) {
            if ((anchor & 2) != 0) {
                anchor &= 0xFFFFFFFD;
                y -= this.fontHeight >> 1;
                anchor |= 0x10;
            }
            if (this.m_isEnableArea) {
                g.setClip(this.m_areaX, this.m_areaY, this.m_areaW, this.m_areaH);
            }
            int oldc = g.getColor();
            Font oldf = g.getFont();
            g.setColor(this.m_textColor[this.currentPalette]);
            g.setFont(this.m_font);
            g.drawChars(text, 0, text.length, x, y, anchor);
            g.setColor(oldc);
            g.setFont(oldf);
            return this.m_font.charsWidth(text, 0, text.length);
        }
        if ((anchor & 0x10) != 0) {
            y += this.getFontHeight();
        } else if ((anchor & 0x20) != 0) {
            y -= this.getLineSpacing();
        } else if ((anchor & 2) != 0) {
            y += this.getFontHeight() / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i = 0; i < text.length; ++i) {
                textWidth = textWidth + this.drawChar(g, text[i], x + textWidth, y) + this.getCharSpacing();
            }
        } else {
            for (int i = 0; i < text.length; ++i) {
                x = x + this.drawChar(g, text[i], x, y) + this.getCharSpacing();
            }
        }
        return textWidth;
    }

    public int drawString(Graphics g, int palette, char[] text, int x, int y, int anchor) {
        this.previousPalette = this.currentPalette;
        this.setCurrentPalette(palette);
        int output = this.drawString(g, text, x, y, anchor);
        this.currentPalette = this.previousPalette;
        return output;
    }

    public int drawString(Graphics g, char[] text, int x, int y, int width, int height, int anchor, int firstLine, int scrollbarWidth, int color) {
        int frameWidth = width - scrollbarWidth - 4;
        int maxLinesToWrite = 0;
        Object[] mLineData = this.getLineData(text, frameWidth);
        maxLinesToWrite = Math.min(height / (this.getFontHeight() + this.getLineSpacing()), mLineData.length);
        firstLine = Math.min(firstLine, mLineData.length - maxLinesToWrite);
        this.drawFastString(g, text, x, y, frameWidth, height, anchor, firstLine, maxLinesToWrite);
        if (mLineData.length > maxLinesToWrite) {
            int gapHeight = maxLinesToWrite * height / mLineData.length;
            int gapPosY = y + firstLine * height / mLineData.length;
            g.setClip(x + frameWidth, y, scrollbarWidth + 4, height);
            g.setColor(color);
            g.setStrokeStyle(0);
            g.fillRect(x + frameWidth + 5, gapPosY, scrollbarWidth - 4, gapHeight);
            g.drawRect(x + frameWidth + 3, y, scrollbarWidth - 1, height - 1);
        }
        return firstLine;
    }

    public int drawStringWave(Graphics g, char[] text, int x, int y, int startDegree, int lengthWaveInLetters, int maxY, int anchor) {
        int degree = startDegree % 360;
        int incDegree = 360 / lengthWaveInLetters;
        if ((anchor & 0x10) != 0) {
            y += this.getFontHeight();
        } else if ((anchor & 0x20) != 0) {
            y -= this.getLineSpacing();
        } else if ((anchor & 2) != 0) {
            y += this.getFontHeight() / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth / 2;
        }
        if (this.m_font != null) {
            if ((anchor & 2) != 0) {
                anchor &= 0xFFFFFFFD;
                y -= this.fontHeight >> 1;
                anchor |= 0x10;
            }
            if (this.m_isEnableArea) {
                g.setClip(this.m_areaX, this.m_areaY, this.m_areaW, this.m_areaH);
            }
            int oldc = g.getColor();
            Font oldf = g.getFont();
            g.setColor(this.m_textColor[this.currentPalette]);
            g.setFont(this.m_font);
            if (textWidth == 0) {
                for (int i = 0; i < text.length; ++i) {
                    int diffY = LQFunctions.seno(degree) * maxY / 10000;
                    g.drawChar(text[i], x + textWidth, y + diffY, anchor);
                    textWidth += this.m_font.charWidth(text[i]);
                    degree += incDegree;
                }
            } else {
                for (int i = 0; i < text.length; ++i) {
                    int diffY = LQFunctions.seno(degree) * maxY / 10000;
                    g.drawChar(text[i], x, y + diffY, anchor);
                    x += this.m_font.charWidth(text[i]);
                    degree += incDegree;
                }
            }
            g.setColor(oldc);
            g.setFont(oldf);
            return textWidth;
        }
        if (textWidth == 0) {
            for (int i = 0; i < text.length; ++i) {
                int diffY = LQFunctions.seno(degree) * maxY / 10000;
                textWidth = textWidth + this.drawChar(g, text[i], x + textWidth, y + diffY) + this.getCharSpacing();
                degree += incDegree;
            }
        } else {
            for (int i = 0; i < text.length; ++i) {
                int diffY = LQFunctions.seno(degree) * maxY / 10000;
                x = x + this.drawChar(g, text[i], x, y + diffY) + this.getCharSpacing();
                degree += incDegree;
            }
        }
        return textWidth;
    }

    public Object[] drawString(Graphics g, String data, int x, int y, int width, int height, int anchor) {
        Object[] mLineData = this.getLineData(data, width);
        this.drawFastString(g, data.toCharArray(), x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public Object[] drawString(Graphics g, char[] data, int x, int y, int width, int height, int anchor) {
        Object[] mLineData = this.getLineData(data, width);
        this.drawFastString(g, data, x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public Object[] drawFastString(Graphics g, char[] data, int x, int y, int width, int height, int anchor, Object[] mLines) {
        int textHeight;
        int maxLines = height / (this.getFontHeight() + this.getLineSpacing());
        if (maxLines < 1) {
            maxLines = 1;
        }
        if (mLines.length < maxLines) {
            maxLines = mLines.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        if (this.m_font != null) {
            Object[] strings = (String[])mLines;
            if ((anchor & 8) != 0) {
                x += width;
            } else if ((anchor & 1) != 0) {
                x += width / 2;
            }
            if ((anchor & 0x20) != 0) {
                y -= textHeight;
                anchor &= 0xFFFFFFDF;
            } else if ((anchor & 2) != 0) {
                y += height - textHeight >> 1;
                anchor &= 0xFFFFFFFD;
            }
            anchor |= 0x10;
            if (this.m_isEnableArea) {
                g.setClip(this.m_areaX, this.m_areaY, this.m_areaW, this.m_areaH);
            }
            int oldc = g.getColor();
            Font oldf = g.getFont();
            g.setColor(this.m_textColor[this.currentPalette]);
            g.setFont(this.m_font);
            for (int i = 0; i < maxLines; ++i) {
                g.drawString(strings[i], x, y, anchor);
                y += this.fontHeight;
            }
            g.setColor(oldc);
            g.setFont(oldf);
            return strings;
        }
        short[][] mLineData = (short[][])mLines;
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.getFontHeight() + (height - textHeight >> 1) : (y += this.getFontHeight()));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i = 0; i < maxLines; ++i) {
            this.drawFastString_ImageFont(g, data, x, y, anchor, mLineData[i]);
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
        return mLineData;
    }

    public int getMaxNumLines(Object[] mLineData, int height) {
        return height / (this.getFontHeight() + this.lineSpacing);
    }

    public Object[] drawFastString(Graphics g, char[] data, int x, int y, int width, int height, int anchor, int firstLine, int linesToDraw) {
        int textHeight;
        int maxLines = height / (this.getFontHeight() + this.getLineSpacing());
        if (linesToDraw < maxLines) {
            maxLines = linesToDraw;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        if (this.m_font != null) {
            Object[] strings = LQFont.getStrings(data, width, this.m_font);
            if ((anchor & 8) != 0) {
                x += width;
            } else if ((anchor & 1) != 0) {
                x += width / 2;
            }
            if ((anchor & 0x20) != 0) {
                y -= textHeight;
                anchor &= 0xFFFFFFDF;
            } else if ((anchor & 2) != 0) {
                y += height - textHeight >> 1;
                anchor &= 0xFFFFFFFD;
            }
            anchor |= 0x10;
            if (this.m_isEnableArea) {
                g.setClip(this.m_areaX, this.m_areaY, this.m_areaW, this.m_areaH);
            }
            int oldc = g.getColor();
            Font oldf = g.getFont();
            g.setColor(this.m_textColor[this.currentPalette]);
            g.setFont(this.m_font);
            for (int i = firstLine; i < firstLine + maxLines && i < strings.length; ++i) {
                g.drawString(strings[i], x, y, anchor);
                y += this.fontHeight;
            }
            g.setColor(oldc);
            g.setFont(oldf);
            return strings;
        }
        short[][] mLineData = (short[][])this.getLineData(data, width);
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? (y += height - textHeight >> 1) : (y += this.getFontHeight()));
        this.drawFastString(g, data, (Object[])mLineData, x, y, width, anchor, firstLine, linesToDraw);
        return mLineData;
    }

    public void drawFastString(Graphics g, char[] data, Object[] lines, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > lines.length) {
            maxLines = lines.length;
        }
        if (this.m_font != null) {
            if ((anchor & 2) != 0) {
                anchor &= 0xFFFFFFFD;
                y -= this.fontHeight >> 1;
                anchor |= 0x10;
            }
            if (this.m_isEnableArea) {
                g.setClip(this.m_areaX, this.m_areaY, this.m_areaW, this.m_areaH);
            }
            int oldc = g.getColor();
            Font oldf = g.getFont();
            g.setColor(this.m_textColor[this.currentPalette]);
            g.setFont(this.m_font);
            String[] strings = (String[])lines;
            for (int i = firstLine; i < maxLines; ++i) {
                g.drawString(strings[i], x, y, anchor);
                y = y + this.getLineSpacing() + this.getFontHeight();
            }
            g.setColor(oldc);
            g.setFont(oldf);
        } else {
            if ((anchor & 8) != 0) {
                x += width;
            } else if ((anchor & 1) != 0) {
                x += width / 2;
            }
            short[][] mLineData = (short[][])lines;
            for (int i = firstLine; i < maxLines; ++i) {
                this.drawFastString_ImageFont(g, data, x, y, anchor, mLineData[i]);
                y = y + this.getLineSpacing() + this.getFontHeight();
            }
        }
    }

    private void drawFastString_ImageFont(Graphics g, char[] text, int x, int y, int anchor, short[] lineData) {
        int i;
        if (lineData[2] == 0) {
            return;
        }
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        if (this.m_isEnableArea) {
            for (i = lineData[0]; i < lineData[1] + 1; ++i) {
                int charIndex;
                if (text[i] == ' ' || (charIndex = this.binarySearchOnChars_ImageFont(text[i], 0, this.letterChars.length - 1)) == -1) continue;
                short[] f = this.letterSymbols[charIndex];
                for (int j = 0; j < f.length; ++j) {
                    short[] symbol = this.symbols[f[j]];
                    if (y - symbol[5] >= this.m_areaY && y - symbol[5] + symbol[3] <= this.m_areaY + this.m_areaH) continue;
                    return;
                }
            }
        }
        for (i = lineData[0]; i < lineData[1] + 1; ++i) {
            x = x + this.drawChar(g, text[i], x, y) + this.getCharSpacing();
        }
    }

    public static void clearLineTick() {
        strMoveTick = null;
        isShow = null;
        strMoveTick = new short[MAX_LINE_SLOT];
        isShow = new boolean[MAX_LINE_SLOT];
    }

    public boolean drawLineString(int slot, Graphics g, String data, int maxLineWidth, int x, int y, int anchor) {
        if (slot < 0 || slot >= MAX_LINE_SLOT) {
            return false;
        }
        char[] str = data.toCharArray();
        int lineWidth = this.getLineWidth(str);
        if (lineWidth > maxLineWidth) {
            if ((anchor & 1) != 0) {
                x -= maxLineWidth / 2;
            }
            this.setArea(true, x + 4, y - 100, maxLineWidth - 8, 200);
            int n = slot;
            strMoveTick[n] = (short)(strMoveTick[n] - 1);
            if (strMoveTick[slot] < -lineWidth) {
                LQFont.strMoveTick[slot] = (short)this.fontHeight;
                LQFont.isShow[slot] = true;
            }
            if (slot < 12) {
                this.drawString(g, str, x + strMoveTick[slot], y, anchor);
                this.drawString(g, str, x + strMoveTick[slot] + lineWidth + this.fontHeight, y, anchor);
            } else {
                this.drawString(g, str, x + strMoveTick[slot], y, anchor);
                this.drawString(g, str, x + strMoveTick[slot] + lineWidth + this.fontHeight, y, anchor);
            }
            this.setArea(false, 0, 0, 0, 0);
            return true;
        }
        this.drawString(g, str, x, y, anchor);
        return false;
    }

    public int getFontHeight() {
        if (Menu.isLargeLine4) {
            return this.fontHeight + 5;
        }
        if (Piple.isTeach && !Mycavans.isPause || Menu.isLargeLine) {
            return this.fontHeight + 3;
        }
        if (Menu.isLargeLine) {
            return this.fontHeight + 3;
        }
        return this.fontHeight + 1;
    }

    public int getCharSpacing() {
        return this.charSpacing;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getSpaceSize() {
        return this.spaceSize;
    }

    public LQFont(Font font, int[] textColor) {
        this.m_font = font;
        this.m_textColor = textColor;
        this.fontHeight = this.m_font.getHeight();
        this.spaceSize = this.m_font.charWidth(' ');
    }

    protected static String[] getStrings(char[] text, int drawWidth, Font fnt) {
        int sl = text.length;
        int beginID = 0;
        int endID = 0;
        int lineWidth = 0;
        int spaceID = 0;
        Vector<String> vS = new Vector<String>();
        for (int i = 0; i < sl; ++i) {
            boolean bLineEnd = false;
            boolean bLink = false;
            char ch = text[i];
            if (i == sl - 1) {
                endID = i + 1;
                bLineEnd = true;
            } else {
                if (ch == ' ' || ch == '.') {
                    spaceID = i;
                }
                if ((lineWidth = fnt.charsWidth(text, beginID, i - beginID + 1)) >= drawWidth) {
                    if (ch != ' ' && ch != '.') {
                        if (spaceID <= beginID) {
                            endID = i;
                            bLink = true;
                        } else {
                            endID = spaceID + 1;
                        }
                    } else {
                        endID = i + 1;
                    }
                    bLineEnd = true;
                }
                if (ch == '\n') {
                    endID = i + 1;
                    bLineEnd = true;
                }
            }
            if (!bLineEnd) continue;
            String tstr = new String(text, beginID, endID - beginID);
            tstr = tstr.replace('\n', ' ');
            if (bLink) {
                tstr = tstr + "-";
            }
            vS.addElement(tstr);
            beginID = endID;
        }
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }
}

