/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import com.lq.net.LQLemonLive;
import com.lq.net.UILive;
import com.lq.util.LQFont;
import javax.microedition.lcdui.Graphics;

public class LQScrollList {
    public static final int SPEED = 3;
    public static final int MIN_STEP = 2;
    public static final int BASIC_SCROLL_WIDTH = 9;
    public static final int TYPE_BASIC = 0;
    public int type = 0;
    public int uiIndexHor = 0;
    public int uiIndexVer = 0;
    public boolean uiShowSelector = false;
    public boolean uiShowScroll = false;
    public int listFrames = 0;
    public int windowX = 0;
    public int windowY = 0;
    public int windowWidth = 0;
    public int windowHeight = 0;
    public int listX = 0;
    public int listY = 0;
    public int listXfinal = 0;
    public int listYfinal = 0;
    public int listHeight = 0;
    public int[] listColsWidth = null;
    public int listRowHeight = 0;
    public String[] eTextPrimary = new String[1];
    public String[] eTextSecondary = new String[1];
    public String[] eTextTertiary = new String[1];
    public int step = 1;
    public int diffX = 0;
    public int diffY = 0;
    public int paintX = 0;
    public int paintY = 0;
    public int gapHeight = 0;
    public int gapPosY = 0;
    LQFont lFont;

    public LQScrollList(int x, int y, int width, int height, LQFont lFont) {
        this.lFont = lFont;
        this.type = 0;
        this.windowX = x;
        this.windowY = y;
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public String[] getLine(int index) {
        index = this.uiIndexVer;
        String[] result = new String[]{this.eTextPrimary[index], this.eTextSecondary[index], this.eTextTertiary[index]};
        return result;
    }

    public int getIndex(String value, int col) {
        for (int i = 0; i < this.eTextSecondary.length; ++i) {
            if (!this.eTextSecondary[i].trim().equals(value.trim())) continue;
            return i;
        }
        return -1;
    }

    public void setPosition(int x, int y) {
        this.windowX = x;
        this.windowY = y;
    }

    public void setSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public void setIndex(int index) {
        int position = 0;
        for (int i = 0; i < this.eTextPrimary.length; ++i) {
            if (!this.eTextPrimary[i].trim().equals("" + index)) continue;
            position = i;
            break;
        }
        if (this.uiIndexVer == this.eTextPrimary.length - 1) {
            // empty if block
        }
        this.uiIndexVer = position;
        this.listYfinal -= this.listRowHeight;
    }

    public void setList(String[] textsPrimary, String[] textsSecondary, String[] textsTertiary, int[] colsWidth, int rowHeight) {
        if (textsPrimary.length != this.eTextPrimary.length) {
            this.eTextPrimary = null;
            this.eTextSecondary = null;
            this.eTextTertiary = null;
            System.gc();
            this.eTextPrimary = new String[textsPrimary.length];
            this.eTextSecondary = new String[textsSecondary.length];
            this.eTextTertiary = new String[textsTertiary.length];
        }
        this.eTextPrimary = textsPrimary;
        this.eTextSecondary = textsSecondary;
        this.eTextTertiary = textsTertiary;
        this.listX = this.windowX;
        this.listY = this.windowY;
        this.listXfinal = this.listX;
        this.listYfinal = this.listY;
        this.listHeight = (rowHeight + 1) * this.eTextPrimary.length;
        colsWidth[0] = this.lFont.getLineWidth("9") * 3;
        colsWidth[1] = (240 - colsWidth[0]) / 5 * 2;
        colsWidth[2] = (240 - colsWidth[0]) / 5 * 3;
        this.listColsWidth = colsWidth;
        this.listRowHeight = rowHeight;
        if (this.listHeight > this.windowHeight) {
            this.uiShowScroll = true;
        }
    }

    public boolean pressUp() {
        if (this.uiIndexVer == 0) {
            return true;
        }
        this.uiIndexVer = Math.max(0, this.uiIndexVer - 1);
        if (this.uiIndexVer != 0) {
            this.listYfinal += this.listRowHeight;
        }
        return false;
    }

    public boolean pressDown() {
        if (this.uiIndexVer == this.eTextPrimary.length - 1) {
            return true;
        }
        this.uiIndexVer = Math.min(this.uiIndexVer + 1, this.eTextPrimary.length - 1);
        this.listYfinal -= this.listRowHeight;
        return false;
    }

    private void update() {
        if (this.listHeight > this.windowHeight) {
            if (this.listYfinal + this.uiIndexVer * this.listRowHeight + this.listRowHeight / 2 < this.windowY + (this.windowHeight - this.listRowHeight) / 2) {
                this.listYfinal += this.windowY + (this.windowHeight - this.listRowHeight) / 2 - (this.listYfinal + this.uiIndexVer * this.listRowHeight + this.listRowHeight / 2);
            } else if (this.listYfinal + this.uiIndexVer * this.listRowHeight + this.listRowHeight / 2 > this.windowY + (this.windowHeight - this.listRowHeight) / 2) {
                this.listYfinal -= this.listYfinal + this.uiIndexVer * this.listRowHeight + this.listRowHeight / 2 - this.windowY + (this.windowHeight - this.listRowHeight) / 2;
            }
        }
        if (this.listHeight <= this.windowHeight) {
            this.listY = this.listYfinal = this.windowY;
        } else if (this.listYfinal > this.windowY) {
            this.listYfinal = this.windowY;
        } else if (this.listYfinal + this.listHeight < this.windowY + this.windowHeight) {
            this.listYfinal = this.windowY + this.windowHeight - this.listHeight;
        }
        this.diffY = this.listYfinal - this.listY;
        if (this.diffY != 0) {
            this.step = Math.max(2, Math.abs(this.diffY / 3));
            if (Math.abs(this.diffY) < this.step) {
                this.listY = this.listYfinal;
            } else if (this.diffY > 0) {
                this.listY += this.step;
            } else if (this.diffY < 0) {
                this.listY -= this.step;
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.type) {
            case 0: {
                this.update();
                this.paintBasic(g);
            }
        }
        ++this.listFrames;
    }

    private void paintBasic(Graphics g) {
        this.paintX = this.listX;
        this.paintY = this.listY;
        for (int e = 0; e < this.eTextPrimary.length; ++e) {
            if (this.windowY - this.listRowHeight <= this.paintY && this.paintY <= this.windowY + this.windowHeight) {
                this.paintBasicRow(g, e, this.paintX, this.paintY);
            }
            this.paintY += this.listRowHeight + 1;
        }
        UILive.paintRectBorder(g, this.windowX, this.windowY, this.windowWidth, this.windowHeight, 20, LQLemonLive.COLOR[0], 1);
        this.paintScrollBar(g);
    }

    private void paintBasicRow(Graphics g, int position, int x, int y) {
        UILive.paintRectFill(g, 1, y, this.listColsWidth[0], this.listRowHeight, 20, this.uiShowSelector && position == this.uiIndexVer ? LQLemonLive.COLOR_PULSE[LQLemonLive.menuFrames % LQLemonLive.COLOR_PULSE.length] : LQLemonLive.COLOR[3], false);
        this.lFont.drawString(g, this.uiShowSelector && position == this.uiIndexVer ? 0 : 1, this.eTextPrimary[position].toCharArray(), 1 + (this.listColsWidth[0] >> 1), y + (this.listRowHeight >> 1), 3);
        UILive.paintRectFill(g, 2 + this.listColsWidth[0], y, this.listColsWidth[1], this.listRowHeight, 20, this.uiShowSelector && position == this.uiIndexVer ? LQLemonLive.COLOR_PULSE[LQLemonLive.menuFrames % LQLemonLive.COLOR_PULSE.length] : LQLemonLive.COLOR[2], false);
        this.lFont.drawLineString(position, g, this.eTextSecondary[position], this.listColsWidth[1] - 4, this.listColsWidth[0] + 5, y + (this.listRowHeight >> 1), 6);
        UILive.paintRectFill(g, 3 + this.listColsWidth[0] + this.listColsWidth[1], y, this.listColsWidth[2], this.listRowHeight, 20, this.uiShowSelector && position == this.uiIndexVer ? LQLemonLive.COLOR_PULSE[LQLemonLive.menuFrames % LQLemonLive.COLOR_PULSE.length] : LQLemonLive.COLOR[3], false);
        this.lFont.drawString(g, this.uiShowSelector && position == this.uiIndexVer ? 0 : 1, this.eTextTertiary[position].toCharArray(), 235 - (this.uiShowScroll ? 9 : 0), y + (this.listRowHeight >> 1), 10);
    }

    private void paintScrollBar(Graphics g) {
        UILive.paintRectFill(g, this.windowX + this.windowWidth, this.windowY, 11, this.windowHeight, 24, LQLemonLive.COLOR[2], false);
        UILive.paintRectBorder(g, this.windowX + this.windowWidth - 1, this.windowY + 1, 9, this.windowHeight - 2, 24, this.uiShowSelector ? LQLemonLive.COLOR_PULSE[LQLemonLive.menuFrames % LQLemonLive.COLOR_PULSE.length] : LQLemonLive.COLOR[6], 1);
        this.gapHeight = this.windowHeight * (this.windowHeight - 6) / this.listHeight;
        this.gapPosY = this.uiIndexVer * (this.windowHeight - 6 - this.gapHeight) / (this.eTextPrimary.length - 1);
        UILive.paintRectFill(g, this.windowX + this.windowWidth - 3, this.windowY + 3 + this.gapPosY, 5, this.gapHeight, 24, this.uiShowSelector ? LQLemonLive.COLOR_PULSE[LQLemonLive.menuFrames % LQLemonLive.COLOR_PULSE.length] : LQLemonLive.COLOR[6], false);
    }
}

