/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import com.lq.util.LQFont;
import com.lq.util.LQKey;
import com.lq.util.LQPage;
import com.lq.util.LQRms;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LQDebug {
    public static boolean ishide = true;
    public static LQPage page;
    public static final Font smallFont;
    public static final LQFont font;
    public static final int heightFont;
    public static long memoryTotal;
    public static long memoryFree;
    public static long memoryUsed;
    public static long memoryPrevious;
    public static long fps;
    public static long fps_integer;
    public static long fps_decimal;
    public static long frameLastTime;
    public static long frameNowTime;
    public static long frameCounter;
    public static final long LOG_SHOWTIME = 3000L;
    public static long logInit;
    public static StringBuffer logBuffer;
    public static String logMessage;
    public static StringBuffer auxStringBuffer;

    public static void output(String str) {
        logBuffer.append(str);
        logBuffer.append('\n');
        LQRms.saveRmsByte("log", "debug", logBuffer.toString().getBytes());
    }

    public static void output(Exception e, String sFlag) {
        String str = e.getMessage();
        if (str == null) {
            str = e.toString();
        }
        LQDebug.output(sFlag + " : " + str);
    }

    public static void draw(Graphics g) {
        if (ishide) {
            return;
        }
        if (LQKey.isKeyPressed(32768)) {
            byte[] b = LQRms.getRmsByte("log", "debug");
            logBuffer.setLength(0);
            if (b != null) {
                logBuffer.append(new String(b));
            }
            String str = logBuffer.toString();
            logBuffer.setLength(0);
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '.' || c == '/') {
                    c = ' ';
                }
                logBuffer.append(c);
            }
            page = new LQPage(font, "log", str);
            page.mov2End();
        }
    }

    public static void log(String msg) {
        logInit = System.currentTimeMillis();
        logMessage = msg;
        logBuffer.append(msg);
        logBuffer.append("\n");
        System.out.println(msg);
    }

    public static void log(Exception e, String sFlag) {
        String str = e.getMessage();
        if (str == null) {
            str = e.toString();
        }
        LQDebug.log(sFlag + " : " + str);
    }

    public static void paintDebug(Graphics g) {
        memoryTotal = Runtime.getRuntime().totalMemory();
        if (memoryTotal - (memoryFree = Runtime.getRuntime().freeMemory()) < memoryPrevious && memoryTotal - memoryFree > memoryUsed) {
            memoryUsed = memoryTotal - memoryFree;
        }
        memoryPrevious = memoryTotal - memoryFree;
        frameNowTime = System.currentTimeMillis();
        if (frameNowTime - frameLastTime > 0L) {
            fps += 10000L / (frameNowTime - frameLastTime);
        }
        frameLastTime = frameNowTime;
        ++frameCounter;
        g.setFont(smallFont);
        g.setColor(0);
        g.setColor(0xFFFFFF);
        auxStringBuffer.setLength(0);
        auxStringBuffer.append(memoryUsed >> 10);
        auxStringBuffer.append("/");
        auxStringBuffer.append(memoryTotal - memoryFree >> 10);
        auxStringBuffer.append("/");
        auxStringBuffer.append(memoryTotal >> 10);
        auxStringBuffer.append("KB.");
        g.drawString(auxStringBuffer.toString(), 0, 0, 20);
        if (frameCounter == 10L) {
            fps_integer = (fps /= frameCounter) / 10L;
            fps_decimal = fps % 10L;
            fps = 0L;
            frameCounter = 0L;
        }
        auxStringBuffer.setLength(0);
        auxStringBuffer.append(fps_integer);
        auxStringBuffer.append(".");
        auxStringBuffer.append(fps_decimal);
        auxStringBuffer.append("fps");
    }

    static {
        smallFont = Font.getFont((int)0, (int)0, (int)8);
        font = new LQFont(smallFont, new int[]{0xFFFFFF, 0});
        heightFont = smallFont.getHeight();
        memoryTotal = 0L;
        memoryFree = 0L;
        memoryUsed = 0L;
        memoryPrevious = 0L;
        fps = 0L;
        fps_integer = 0L;
        fps_decimal = 0L;
        frameLastTime = 0L;
        frameNowTime = System.currentTimeMillis();
        frameCounter = 0L;
        logInit = 0L;
        logBuffer = new StringBuffer();
        logMessage = new String();
        auxStringBuffer = new StringBuffer();
    }
}

