/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

public class LQKey {
    public static final int DK_PAD_UP = 1;
    public static final int DK_PAD_DOWN = 2;
    public static final int DK_PAD_LEFT = 4;
    public static final int DK_PAD_RIGHT = 8;
    public static final int DK_NUM0 = 16;
    public static final int DK_NUM1 = 32;
    public static final int DK_NUM2 = 64;
    public static final int DK_NUM3 = 128;
    public static final int DK_NUM4 = 256;
    public static final int DK_NUM5 = 512;
    public static final int DK_NUM6 = 1024;
    public static final int DK_NUM7 = 2048;
    public static final int DK_NUM8 = 4096;
    public static final int DK_NUM9 = 8192;
    public static final int DK_STAR = 16384;
    public static final int DK_POUND = 32768;
    public static final int DK_SOFT_LEFT = 65536;
    public static final int DK_SOFT_RIGHT = 131072;
    public static final int DK_PAD_MIDDLE = 262144;
    public static int m_numPressed;
    public static boolean m_isDebugEnabled;
    public static final byte GAMEKEY_QUEUE_SIZE = 6;
    public static final int KEY_DOUBLE_PRESSED_FRAME = 6;
    public static int s_keyCurrent;
    public static int s_keyPressed;
    public static int m_keyPressedInStore;
    public static int s_keyReleased;
    static int s_keyDblPressed;
    public static int s_lastPressed;
    static int s_keyTick;
    public static int s_fastCurrentKey;
    public static int[] s_gkQueue;
    public static int s_queueStart;
    public static int s_queueEnd;
    public static final int comboLastingTime = 10;
    public static final int maxComboKey = 4;
    public static int[] keyComboQueue;
    public static int keyComboTick;
    public static int keyCode;
    public static boolean isUp;
    public static boolean isDown;
    public static boolean isLeft;
    public static boolean isRight;
    public static boolean isLS;
    public static boolean isRS;
    public static boolean isFire;
    public static final int KEY_SOFTL = -6;
    public static final int KEY_SOFTR = -7;
    public static final int KEY_OK = -5;
    public static final int KEY_UP = -1;
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_CLEAR = -8;

    private static int getKeyAction(int keyCode) {
        switch (keyCode) {
            case 48: {
                return 16;
            }
            case 49: {
                return 32;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 128;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 262144;
            }
            case 54: {
                return 8;
            }
            case 55: {
                return 2048;
            }
            case 56: {
                return 2;
            }
            case 57: {
                return 8192;
            }
            case 42: {
                return 16384;
            }
            case 35: {
                return 32768;
            }
            case -1: {
                return 1;
            }
            case -2: {
                return 2;
            }
            case -3: {
                return 4;
            }
            case -4: {
                return 8;
            }
            case -5: {
                return 262144;
            }
            case -6: {
                return 65536;
            }
            case -7: {
                return 131072;
            }
        }
        return 0;
    }

    private static int getNumericKeyForKeycode(int keyCode) {
        switch (keyCode) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
            case -1: {
                return 12;
            }
            case -2: {
                return 13;
            }
            case -3: {
                return 14;
            }
            case -4: {
                return 15;
            }
            case -5: {
                return 16;
            }
            case -6: {
                return 17;
            }
            case -7: {
                return 18;
            }
        }
        return -1;
    }

    public static void clearKey() {
        s_keyCurrent = 0;
        s_keyPressed = 0;
        s_keyReleased = 0;
        s_keyDblPressed = 0;
        s_lastPressed = 0;
        s_keyTick = 0;
        s_fastCurrentKey = 0;
        m_keyPressedInStore = 0;
        for (int i = 0; i < 6; ++i) {
            LQKey.s_gkQueue[i] = 0;
        }
        s_queueEnd = 0;
        s_queueStart = 0;
    }

    private static boolean pushQueue(int key) {
        if ((s_queueStart + 1) % 6 == s_queueEnd) {
            return false;
        }
        LQKey.s_gkQueue[LQKey.s_queueStart] = key;
        if (m_isDebugEnabled) {
            // empty if block
        }
        s_queueStart = (s_queueStart + 1) % 6;
        return true;
    }

    private static int popQueue() {
        if (s_queueStart == s_queueEnd) {
            return s_fastCurrentKey;
        }
        int key = s_gkQueue[s_queueEnd];
        s_queueEnd = (s_queueEnd + 1) % 6;
        if (m_isDebugEnabled) {
            System.out.println("pop key " + Integer.toHexString(key));
        }
        return key;
    }

    public static void updateKey() {
        int currentKey = LQKey.popQueue();
        s_keyPressed = ~s_keyCurrent & currentKey;
        s_keyReleased = s_keyCurrent & ~currentKey;
        s_keyCurrent = currentKey;
        ++s_keyTick;
        if (s_keyPressed != 0) {
            if (s_lastPressed != 0 && s_keyTick < 6 && s_lastPressed == s_keyPressed) {
                s_keyDblPressed = s_keyPressed;
                s_lastPressed = 0;
            } else {
                s_keyTick = 0;
                s_keyDblPressed = 0;
                s_lastPressed = s_keyPressed;
            }
        } else if (s_keyDblPressed != 0) {
            s_keyDblPressed = 0;
        }
        if (keyComboTick > 0) {
            --keyComboTick;
        } else {
            LQKey.pushComboQueue(0);
        }
    }

    public static boolean isKeyCombo(int[] combo) {
        int comboIndex = 0;
        for (int i = 0; i < keyComboQueue.length; ++i) {
            if (combo[comboIndex] != keyComboQueue[i]) {
                if (comboIndex <= 0) continue;
                return false;
            }
            ++comboIndex;
        }
        if (comboIndex <= combo.length - 1) {
            return false;
        }
        LQKey.clearKeyCombo();
        return true;
    }

    public static void clearKeyCombo() {
        for (int i = 0; i < 4; ++i) {
            LQKey.keyComboQueue[i] = 0;
        }
    }

    public static boolean isKeyHold(int gameKey) {
        return (s_keyCurrent & gameKey) != 0;
    }

    public static boolean isAnyKeyPressed() {
        return s_keyPressed != 0;
    }

    public static boolean isAnyKeyHold() {
        return s_keyCurrent != 0;
    }

    public static boolean isKeyDblPressed(int gameKey) {
        return (s_keyDblPressed & gameKey) != 0;
    }

    public static boolean isKeyPressed(int gKey) {
        return (s_keyPressed & gKey) != 0;
    }

    public static boolean isKeyReleased(int gKey) {
        return (s_keyReleased & gKey) != 0;
    }

    public static boolean isKeyPressedFast(int gKey) {
        return gKey == keyCode;
    }

    public static void clearKeyHold(int gKey) {
        s_fastCurrentKey &= ~gKey;
        if (m_isDebugEnabled) {
            System.out.print("manual release <----- ");
        }
        LQKey.pushQueue(s_fastCurrentKey);
    }

    public static void keyPressed(int keyCode) {
        m_numPressed = LQKey.getNumericKeyForKeycode(keyCode);
        int key = LQKey.getKeyAction(keyCode);
        s_fastCurrentKey |= key;
        LQKey.keyCode = keyCode;
        if (m_isDebugEnabled) {
            System.out.print("press -----> ");
        }
        LQKey.pushQueue(s_fastCurrentKey);
        LQKey.pushComboQueue(key);
    }

    public static void keyReleased(int keyCode) {
        s_fastCurrentKey &= ~LQKey.getKeyAction(keyCode);
        if (m_isDebugEnabled) {
            System.out.print("release <----- ");
        }
        LQKey.pushQueue(s_fastCurrentKey);
    }

    private static void pushComboQueue(int key) {
        for (int i = 0; i < 3; ++i) {
            LQKey.keyComboQueue[i] = keyComboQueue[i + 1];
        }
        LQKey.keyComboQueue[3] = key;
        keyComboTick = 10;
    }

    public static void StoreAnyKeyPressed() {
        if (s_keyPressed != 0) {
            m_keyPressedInStore = s_keyPressed;
        }
    }

    public static boolean isKeyPressedInStore(int gameKey) {
        return (m_keyPressedInStore & gameKey) != 0;
    }

    public static void clearKeyPressedInStore() {
        m_keyPressedInStore = 0;
    }

    public static void clearCavansKey() {
        isUp = false;
        isDown = false;
        isLeft = false;
        isRight = false;
        isLS = false;
        isRS = false;
        isFire = false;
    }

    public static void updataCavansKey(int k) {
        if (k == -1) {
            isUp = true;
        }
        if (k == -2) {
            isDown = true;
        }
        if (k == -3) {
            isLeft = true;
        }
        if (k == -4) {
            isRight = true;
        }
        if (k == -6) {
            isLS = true;
            System.out.println("11111111111111111");
        }
        if (k == -7) {
            isRS = true;
            System.out.println("2222222222222222222");
        }
        if (k == -5 || k == 53) {
            isFire = true;
        }
    }

    static {
        m_isDebugEnabled = false;
        s_gkQueue = new int[6];
        keyComboQueue = new int[4];
    }
}

