/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.inode.utils.mMath;
import com.lq.util.LQKey;
import game.Mycavans;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import piple.Piple;

public class Joystick {
    int cx;
    int cy;
    Image joyBack;
    Image joyPaddle;
    Image buttonPress;
    boolean isPressed;
    double vx;
    double vy;
    int px;
    int py;
    int pressedkey;
    long tapTime;
    final int JOYSTICK_RADIUS;
    final int THUMB_RADIUS;
    public Mycavans mc;

    Joystick() {
        this.JOYSTICK_RADIUS = 47;
        this.THUMB_RADIUS = 21;
        try {
            this.joyBack = Image.createImage((String)"/pad_back.png");
            this.joyPaddle = Image.createImage((String)"/pad_front.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updateVelocity(int tvx, int tvy) {
        if (tvy > 275) {
            return;
        }
        double dx = tvx - this.cx;
        double dy = tvy - this.cy;
        double dist = Math.sqrt(dx * dx + dy * dy);
        double ang = mMath.atan2(dy, dx);
        if (dist > 47.0) {
            dx = Math.cos(ang) * 47.0;
            dy = Math.sin(ang) * 47.0;
        }
        this.vx = dx / 47.0;
        this.vy = dy / 47.0;
        if (dist > 21.0) {
            tvx = (int)Math.floor((double)this.cx + Math.cos(ang) * 21.0);
            tvy = (int)Math.floor((double)this.cy + Math.sin(ang) * 21.0);
        }
        this.px = tvx;
        this.py = tvy;
        if (Math.abs(this.vx) > 0.2 || Math.abs(this.vy) > 0.2) {
            this.tapTime = 0L;
        }
        int presskey = 0;
        if (this.vx < -0.5) {
            if (this.vy < -0.5) {
                presskey = 49;
            } else if (this.vy > -0.5 && this.vy < 0.5) {
                presskey = -3;
            } else if (this.vy > 0.5) {
                presskey = 55;
            }
        } else if (this.vx > -0.5 && this.vx < 0.5) {
            if (this.vy < -0.5) {
                presskey = -1;
            } else if (!(this.vy > -0.5 && this.vy < 0.5 || !(this.vy > 0.5))) {
                presskey = -2;
            }
        } else if (this.vx > 0.5) {
            if (this.vy < -0.5) {
                presskey = 51;
            } else if (this.vy > -0.5 && this.vy < 0.5) {
                presskey = -4;
            } else if (this.vy > 0.5) {
                presskey = 57;
            }
        }
        if (presskey != this.pressedkey) {
            this.releaseKey(this.pressedkey);
            this.pressKey(presskey);
        } else if (presskey == 0) {
            this.releaseKey(this.pressedkey);
        }
    }

    private void pressKey(int key) {
        System.out.println("pressing key " + key);
        this.pressedkey = key;
        if (this.pressedkey != 0) {
            LQKey.keyPressed(this.pressedkey);
        }
    }

    private void releaseKey(int key) {
        System.out.println("releasing key " + key);
        if (this.pressedkey != 0) {
            LQKey.keyReleased(this.pressedkey);
        }
        this.pressedkey = 0;
    }

    void resetJoystick() {
        this.updateVelocity(this.cx, this.cy);
    }

    boolean handleLastTouch() {
        boolean wasPressed = this.isPressed;
        if (wasPressed) {
            this.resetJoystick();
            this.releaseKey(this.pressedkey);
            this.isPressed = false;
        }
        return wasPressed;
    }

    void pointerPressed(int x, int y) {
        this.isPressed = true;
        this.cx = x;
        this.cy = y;
        this.px = x;
        this.py = y;
        this.tapTime = System.currentTimeMillis();
        if (y > 275 && this.mc != null) {
            if (Mycavans.game_state == 3 && this.mc.pip != null) {
                Piple cfr_ignored_0 = this.mc.pip;
                if (this.mc.pip.pipState == 0 && !this.mc.menu.isShowMakeSure && x < 45) {
                    this.pressKey(48);
                }
            }
        }
    }

    void pointerDragged(int x, int y) {
        if (this.isPressed) {
            this.updateVelocity(x, y);
        }
    }

    /*
     * Unable to fully structure code
     */
    void pointerReleased(int x, int y) {
        block5: {
            block6: {
                block7: {
                    block8: {
                        if (Math.abs(this.vx) > 0.2 || Math.abs(this.vy) > 0.2) {
                            this.tapTime = 0L;
                        }
                        if (System.currentTimeMillis() - this.tapTime >= 400L) break block5;
                        if (y <= 275) break block6;
                        if (x >= 120) break block7;
                        if (this.mc == null) break block8;
                        if (Mycavans.game_state != 3 || this.mc.pip == null) break block8;
                        this.mc.pip;
                        if (this.mc.pip.pipState == 0 && !this.mc.menu.isShowMakeSure) break block5;
                    }
                    this.pressKey(-6);
                    break block5;
                }
                if (this.mc == null) ** GOTO lbl-1000
                if (Mycavans.game_state != 3 || this.mc.pip == null) ** GOTO lbl-1000
                this.mc.pip;
                if (this.mc.pip.pipState != 0) ** GOTO lbl-1000
                this.mc.pip;
                if (!Piple.isTeach && !this.mc.menu.isShowMakeSure) {
                    this.pressKey(-6);
                } else lbl-1000:
                // 4 sources

                {
                    this.pressKey(-7);
                }
                break block5;
            }
            this.pressKey(53);
        }
        this.handleLastTouch();
    }

    static boolean isPointInCircle(int x, int y, int cx, int cy, int radius) {
        int dx = x - cx;
        int dy = y - cy;
        return (double)radius >= Math.sqrt(dx * dx + dy * dy);
    }

    void paint(Graphics g) {
        if (this.isPressed) {
            g.drawImage(this.joyBack, this.cx, this.cy, 3);
            g.drawImage(this.joyPaddle, this.px, this.py, 3);
        }
    }
}

