/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import InneractiveSDK.IADView;
import com.inode.pictorama.BoardManager;
import com.inode.pictorama.Clock;
import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameMIDlet;
import com.inode.pictorama.MenuBonus;
import com.inode.pictorama.MenuClassic;
import com.inode.pictorama.MenuInfo;
import com.inode.pictorama.MenuManager;
import com.inode.pictorama.MenuProgress;
import com.inode.pictorama.MenuQuest;
import com.inode.pictorama.Robot;
import com.inode.utils.SSDebug;
import com.inode.utils.SSFunctions;
import com.inode.utils.SSKeyboard;
import com.inode.utils.SSMath;
import com.inode.utils.SSMusic;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameEngine
extends Canvas {
    public boolean running;
    public static final int TIME_SCROLL_TEXT = 200;
    public static final String GOD_CODE = "19771106";
    public int godCounter = 0;
    public boolean godMode = false;
    public boolean debug = false;
    public int gameFrames = 0;
    public int gameFramesAux = 0;
    public long gameTimestamp = 0L;
    public long timeScrollText = 0L;
    public boolean pressedDown = false;
    public boolean pressedUp = false;
    public boolean pressedLeft = false;
    public boolean pressedRight = false;
    public boolean pressedAnyKey = false;
    public long lastProcessTime;
    public long pauseTime;
    public static final int MAX_PROCESS = 40;
    public static final int TRANSITION_FRAMES = 20;
    public static final int SQUARE_BLOCKS_SIZE = 16;
    public static final int SHINE_NUMBER = 6;
    public static final int STATE_NONE = 0;
    public static final int STATE_TRANSITION_IN = 1;
    public static final int STATE_TRANSITION_OUT = 2;
    public static final int STATE_LOADING = 3;
    public static final int STATE_SPLASH = 4;
    public static final int STATE_SOUND_QUESTION = 5;
    public static final int STATE_COVER = 6;
    public static final int STATE_MENU = 7;
    public static final int STATE_GAME = 8;
    public static final int STATE_BYE = 9;
    public static final int STATE_LANDSCAPE = 10;
    public int statePrevLandscape = 0;
    public int state = 0;
    public int[] stateList = null;
    public int stateIndexCurrent = 0;
    public int stateIndexAdd = 0;
    public static final int GAME_TYPE_CLASSIC = 0;
    public static final int GAME_TYPE_QUEST = 1;
    public static final int GAME_TYPE_DAILY = 2;
    public static final int GAME_TYPE_BONUS = 3;
    public static final int GAME_WAITING = 0;
    public static final int GAME_PLAYING = 1;
    public static final int GAME_COMPLETED_A = 2;
    public static final int GAME_COMPLETED_B = 3;
    public static final int GAME_SOLVED = 4;
    public static final int GAME_MENU_IN_GAME = 5;
    public static final int GAME_PAUSE = 6;
    public static final int GAME_FAILED = 7;
    public static final int GAME_USE_ITEM = 8;
    public static final int GAME_PRESS_ANY_KEY = 9;
    public static final int GAME_BLOCK_RESUME = 10;
    public static final int GAME_HELP_IN_GAME = 11;
    public int gameState = 9;
    public int gameType = 0;
    public String gameLevelToLoad = null;
    public static final int MENU_MAIN = 0;
    public static final int MENU_PLAY_MODES = 1;
    public static final int MENU_SETTINGS = 2;
    public static final int MENU_EXIT = 3;
    public static final int MENU_DAILY = 4;
    public static final int MENU_HELP = 5;
    public static final int MENU_PROGRESS = 6;
    public static final int MENU_CREDITS = 7;
    public static final int MENU_CLASSIC = 8;
    public static final int MENU_QUEST = 9;
    public static final int MENU_BONUS = 10;
    public static final int MENU_TUTORIAL = 11;
    public int menuActive = 0;
    public int menuNext = 0;
    public int menuItemSelected = 0;
    public SSKeyboard keyboard;
    public char key;
    public GameCanvas gc;
    public GameMIDlet gm;
    public int iconLeft = -1;
    public int iconRight = -1;
    public static final int TIME_SPLASH = 3000;
    public static final int TIME_COVER = 3000;
    public static long waitingTime = 0L;
    public SSMusic sound;
    public int soundMusic;
    public int soundWin;
    public int soundLose;
    public int soundStart;
    public int sfxError;
    public int sfxMark;
    public int sfxBlank;
    public int[][] palettes = new int[][]{{10814464, 4082315, 6196172, 13715712, 15519488, 0xFFFF66, 6397992, 10274408}, {16444548, 10814464, 13715712, 14851328, 15519488, 0xFFFF66, 10274408, 6397992}, {13660254, 0, 6965806, 14589538, 0xC88000, 15255552, 16444548, 6397992}, {10459525, 5846040, 11033113, 15830537, 0xFFCC33, 3037238, 3571775, 10274408}, {16498441, 3875633, 8923451, 12469295, 14121842, 16035526, 3037238, 8827753}, {0xF0F0F0, 0x300000, 8923451, 11424574, 14192145, 0xFFCC33, 0xFFFF66, 8827753}, {0xFAFFFF, 0x2F2F2F, 0x484848, 0x676767, 0x898989, 0xA9A9A9, 0xC6C6C6, 0xE6E6E6}, {0xFFFF66, 4211842, 5268882, 7311787, 10599632, 13360103, 14182944, 6920757}};
    public int[][] squares = null;
    public boolean[][] squaresNew = null;
    public String[] lang;
    public String moreGamesURL = null;
    public boolean moreGameEnabled = false;
    public int configPictocubes = 0;
    public int configTotalPoints = 0;
    public int configLevelsClassic = 0;
    public int configLevelsQuest = 0;
    public boolean configIsLowPerformance = false;
    public boolean configIsPaused = false;
    public boolean configSound = false;
    public boolean configVibrate = true;
    public int configSkin = 0;
    public static final String GC_RMS_NAME = "Game_Classic";
    public static final int GC_TOTAL_LEVELS = 90;
    public long[] gcHighScoresTime = new long[90];
    public int[] gcHighScoresPoints = new int[90];
    public int gcHighLevelCompleted = 0;
    public int gcLastLevelPlayed = 0;
    public int gcPenalties = 0;
    public int gcPoints = 0;
    public long gcTime = 0L;
    public int[] gcTimeLimits = new int[]{60, 200, 1500, 2500};
    public static final String GQ_RMS_NAME = "Game_Quest";
    public static final int GQ_TOTAL_LEVELS = 60;
    public static final int GQ_LEVEL_LOCKED = 0;
    public static final int GQ_LEVEL_QUESTION = 1;
    public static final int GQ_LEVEL_SOLVED = 2;
    public long[] gqHighScoresTime = new long[15];
    public int[] gqHighScoresPoints = new int[15];
    public int gqLevelCol = 2;
    public int gqLevelRow = 5;
    public int gqLevelColReturnLast = -1;
    public int gqLevelRowReturnLast = -1;
    public int[] gqLevelState = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
    public String[] gqLevelDescription = null;
    public String[] gqItemDescription = null;
    public int gqPenalties = 0;
    public int gqPoints = 0;
    public long gqTime = 0L;
    public boolean gqJoker = false;
    public int gqLevelNumber = 0;
    public int[] gqTimeLimits = new int[]{60, 200, 1200, 2000};
    public int[] gqOrder = new int[]{0, 1, 2, 3};
    public byte[][] gqDataColor = new byte[4][];
    public int[] gqDataPalette = new int[4];
    public int[] gqItemUsed = new int[4];
    public long[] gqTimeLeft = new long[4];
    public int[] gqPointsLevel = new int[4];
    public String[] gbMenuOptions = null;
    public int gbMenuUnBlocked = 0;
    public int[] gbPictocubesCost = new int[]{20, 50, 90, 140, 200};
    public MenuManager menu = null;
    public MenuInfo menuInfo = null;
    public MenuProgress menuProgress = null;
    public MenuClassic menuClassic = null;
    public MenuQuest menuQuest = null;
    public MenuBonus menuBonus = null;
    public Robot robot = null;
    public BoardManager board = null;
    public Clock clock = null;
    public int[] arrayInt = null;
    public int auxInt = 0;
    public long auxLong = 0L;
    public String auxString = "";
    public Vector m_ad;
    public Image m_adImage = null;
    public static final String INNERAD_KEY = "InodeTechnology_PictoCross_Nokia";
    int loadIndex;

    private void displayFullAd() {
        Hashtable<String, String> interAd = new Hashtable<String, String>();
        interAd.put("Key_interstitial_GO_btn", "GO");
        interAd.put("Key_interstitial_SKIP_btn", "Skip");
        IADView.displayInterstitialAd((MIDlet)this.gm, INNERAD_KEY, interAd);
    }

    private void getAd() {
        this.m_adImage = null;
        this.m_ad = null;
        System.gc();
        new Thread(){

            public void run() {
                GameEngine.this.m_ad = IADView.getBannerAdData(GameEngine.this.gm, GameEngine.INNERAD_KEY);
                if (GameEngine.this.m_ad != null) {
                    GameEngine.this.m_adImage = (Image)GameEngine.this.m_ad.elementAt(0);
                }
            }
        }.start();
    }

    public GameEngine(GameMIDlet _gm) {
        this.setFullScreenMode(true);
        this.gameTimestamp = System.currentTimeMillis();
        this.gm = _gm;
        this.sound = new SSMusic();
        this.gc = new GameCanvas(this);
        this.keyboard = new SSKeyboard();
        this.stateClear();
        this.gc.resLoad(0, 1);
        this.stateAdd(4);
        this.stateAdd(2);
        this.stateAdd(3);
        this.stateAdd(1);
        this.stateAdd(5);
        this.stateNext();
        this.keyboard.removeAllEvents();
        this.getAd();
    }

    public void loadLanguage() {
        this.lang = null;
        GameEngine.garbageCollector();
        this.lang = SSFunctions.loadLang(this.gc.resManager.getResourceAsStream("texts.dat"), 107);
        this.lang[45] = SSFunctions.replace(this.lang[45], "%%SRL%%", "LQNS43001");
        this.lang[45] = SSFunctions.replace(this.lang[45], "%%VERSION%%", this.gm.getAppProperty("MIDlet-Version"));
        String[] stringArray = new String[6];
        stringArray[0] = this.lang[60];
        stringArray[1] = this.lang[61];
        stringArray[2] = this.lang[62];
        stringArray[3] = this.lang[63];
        stringArray[4] = this.lang[64];
        stringArray[5] = this.lang[65];
        this.gqItemDescription = stringArray;
        String[] stringArray2 = new String[15];
        stringArray2[0] = this.lang[66];
        stringArray2[1] = this.lang[67];
        stringArray2[2] = this.lang[68];
        stringArray2[3] = this.lang[69];
        stringArray2[4] = this.lang[70];
        stringArray2[5] = this.lang[71];
        stringArray2[6] = this.lang[72];
        stringArray2[7] = this.lang[73];
        stringArray2[8] = this.lang[74];
        stringArray2[9] = this.lang[75];
        stringArray2[10] = this.lang[76];
        stringArray2[11] = this.lang[77];
        stringArray2[12] = this.lang[78];
        stringArray2[13] = this.lang[79];
        stringArray2[14] = this.lang[80];
        this.gqLevelDescription = stringArray2;
        this.gbMenuOptions = new String[]{this.lang[37] + " 1", this.lang[36] + " 1", this.lang[37] + " 2", this.lang[36] + " 2", this.lang[37] + " 3"};
    }

    private void stateClear() {
        this.stateList = new int[16];
        this.stateIndexCurrent = 0;
        this.stateIndexAdd = 0;
    }

    private void stateRecover() {
    }

    private void stateAdd(int _state) {
        if (!this.configIsLowPerformance || _state != 1 && _state != 2) {
            this.stateIndexAdd = (this.stateIndexAdd + 1) % this.stateList.length;
            this.stateList[this.stateIndexAdd] = _state;
            this.stateList[(this.stateIndexAdd + 1) % this.stateList.length] = 0;
        }
    }

    private void stateNext() {
        this.stateIndexCurrent = (this.stateIndexCurrent + 1) % this.stateList.length;
        this.state = this.getState();
        System.out.println("##### state -> " + this.state + " #####");
        waitingTime = System.currentTimeMillis();
        this.gameFramesAux = 0;
        this.gc.loading_step = 0;
        this.gc.loading_steps_total = 1000;
        this.arrayInt = new int[15];
        this.arrayInt = new int[15];
        for (int i = 0; i < this.arrayInt.length; ++i) {
            this.arrayInt[i] = i;
        }
        this.arrayInt = SSMath.shuffle(this.arrayInt);
        if (this.state == 2) {
            this.initTransitionOut();
        }
        if (this.state == 1) {
            this.initTransitionIn();
        }
        this.keyboard.removeAllEvents();
    }

    private int getState() {
        return this.stateList[this.stateIndexCurrent];
    }

    public int getStateNext() {
        int searchStateNext = 0;
        for (int i = 0; i < this.stateList.length && (searchStateNext = this.stateList[(this.stateIndexCurrent + i) % this.stateList.length]) <= 3; ++i) {
        }
        return searchStateNext;
    }

    private int getStatePrevious() {
        int searchStatePrevious = 0;
        for (int i = 0; i < this.stateList.length && (searchStatePrevious = this.stateList[(this.stateIndexCurrent + this.stateList.length - i) % this.stateList.length]) <= 3; ++i) {
        }
        return searchStatePrevious;
    }

    public void changeStateTo(int toState, int toSubState) {
        this.stateAdd(2);
        this.stateAdd(3);
        this.stateAdd(1);
        this.stateAdd(toState);
        switch (toState) {
            case 7: {
                this.menuActive = this.menuNext = toSubState;
                break;
            }
            case 8: {
                this.gameState = toSubState;
            }
        }
        this.stateNext();
    }

    public void initTransitionOut() {
        int col;
        int row;
        int squareHorizontal = 15;
        int squareVertical = 20;
        if (240 % squareHorizontal != 0) {
            ++squareHorizontal;
        }
        if (320 % squareVertical != 0) {
            ++squareVertical;
        }
        this.squaresNew = new boolean[squareVertical][squareHorizontal];
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                this.squaresNew[row][col] = false;
            }
        }
        this.squares = new int[squareVertical][squareHorizontal];
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                this.squares[row][col] = 0;
            }
        }
        if (squareVertical % 2 == 0 && squareHorizontal % 2 == 0) {
            this.squares[squareVertical / 2 - 1][squareHorizontal / 2 - 1] = 2;
            this.squares[squareVertical / 2 - 1][squareHorizontal / 2] = 2;
            this.squares[squareVertical / 2][squareHorizontal / 2 - 1] = 2;
            this.squares[squareVertical / 2][squareHorizontal / 2] = 2;
        } else if (squareVertical % 2 == 0) {
            this.squares[squareVertical / 2 - 1][squareHorizontal / 2] = 2;
            this.squares[squareVertical / 2][squareHorizontal / 2] = 2;
        } else if (squareHorizontal % 2 == 0) {
            this.squares[squareVertical / 2][squareHorizontal / 2 - 1] = 2;
            this.squares[squareVertical / 2][squareHorizontal / 2] = 2;
        } else {
            this.squares[squareVertical / 2][squareHorizontal / 2] = 2;
        }
    }

    public void initTransitionIn() {
        int col;
        int row;
        int squareHorizontal = 15;
        int squareVertical = 20;
        if (240 % squareHorizontal != 0) {
            ++squareHorizontal;
        }
        if (320 % squareVertical != 0) {
            ++squareVertical;
        }
        this.squaresNew = new boolean[squareVertical][squareHorizontal];
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                this.squaresNew[row][col] = false;
            }
        }
        this.squares = new int[squareVertical][squareHorizontal];
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                this.squares[row][col] = 16;
            }
        }
        if (squareVertical % 2 == 0 && squareHorizontal % 2 == 0) {
            int[] nArray = this.squares[squareVertical / 2 - 1];
            int n = squareHorizontal / 2 - 1;
            nArray[n] = nArray[n] - 2;
            int[] nArray2 = this.squares[squareVertical / 2 - 1];
            int n2 = squareHorizontal / 2;
            nArray2[n2] = nArray2[n2] - 2;
            int[] nArray3 = this.squares[squareVertical / 2];
            int n3 = squareHorizontal / 2 - 1;
            nArray3[n3] = nArray3[n3] - 2;
            int[] nArray4 = this.squares[squareVertical / 2];
            int n4 = squareHorizontal / 2;
            nArray4[n4] = nArray4[n4] - 2;
        } else if (squareVertical % 2 == 0) {
            int[] nArray = this.squares[squareVertical / 2 - 1];
            int n = squareHorizontal / 2;
            nArray[n] = nArray[n] - 2;
            int[] nArray5 = this.squares[squareVertical / 2];
            int n5 = squareHorizontal / 2;
            nArray5[n5] = nArray5[n5] - 2;
        } else if (squareHorizontal % 2 == 0) {
            int[] nArray = this.squares[squareVertical / 2];
            int n = squareHorizontal / 2 - 1;
            nArray[n] = nArray[n] - 2;
            int[] nArray6 = this.squares[squareVertical / 2];
            int n6 = squareHorizontal / 2;
            nArray6[n6] = nArray6[n6] - 2;
        } else {
            int[] nArray = this.squares[squareVertical / 2];
            int n = squareHorizontal / 2;
            nArray[n] = nArray[n] - 2;
        }
    }

    private void process() {
        block0 : switch (this.state) {
            case 10: {
                if (this.getWidth() != 240) break;
                this.state = this.statePrevLandscape;
                this.keyboard.removeAllEvents();
                break;
            }
            case 1: 
            case 2: {
                this.processTransition();
                this.keyboard.removeAllEvents();
                break;
            }
            case 3: {
                this.processLoading();
                this.keyboard.removeAllEvents();
                break;
            }
            case 4: {
                if (System.currentTimeMillis() > waitingTime + 3000L) {
                    this.loadLanguage();
                    this.stateNext();
                }
                this.keyboard.removeAllEvents();
                break;
            }
            case 5: {
                this.processKeysSoundQuestion();
                this.keyboard.removeAllEvents();
                break;
            }
            case 6: {
                if (!this.sound.isSound(this.soundMusic) && this.configSound && !this.configIsPaused) {
                    this.sound.playSound(this.soundMusic, false);
                } else if (this.sound.isSound(this.soundMusic) && !this.configSound) {
                    this.sound.stopSound(this.soundMusic);
                }
                if (System.currentTimeMillis() > waitingTime + 3000L) {
                    this.stateNext();
                    this.displayFullAd();
                }
                this.keyboard.removeAllEvents();
                break;
            }
            case 7: {
                if (!this.sound.isSound(this.soundMusic) && this.configSound && !this.configIsPaused) {
                    this.sound.playSound(this.soundMusic, false);
                } else if (this.sound.isSound(this.soundMusic) && !this.configSound) {
                    this.sound.stopSound(this.soundMusic);
                }
                switch (this.menuActive) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.processKeysMenuMain();
                        break;
                    }
                    case 8: {
                        if (this.timeScrollText >= this.lastProcessTime) {
                            if (this.pressedLeft) {
                                this.menuClassic.speedX = 2;
                                this.auxInt = this.menuClassic.setLevelSelected(this.menuClassic.levelSelected - 1);
                            } else if (this.pressedRight) {
                                this.menuClassic.speedX = 2;
                                this.auxInt = this.menuClassic.setLevelSelected(this.menuClassic.levelSelected + 1);
                            }
                            this.timeScrollText = this.lastProcessTime + 200L;
                        }
                        this.processKeysMenuClassic();
                        break;
                    }
                    case 9: {
                        this.processKeysMenuQuest();
                        break;
                    }
                    case 10: {
                        this.processKeysMenuBonus();
                        break;
                    }
                    case 6: {
                        this.processKeysMenuProgress();
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 11: {
                        if (this.timeScrollText >= this.lastProcessTime) {
                            if (this.pressedUp) {
                                this.menuInfo.textLine = Math.max(0, this.menuInfo.textLine - 1);
                            } else if (this.pressedDown) {
                                this.menuInfo.textLine = Math.max(0, this.menuInfo.textLine + 1);
                            }
                            this.timeScrollText = this.lastProcessTime + 200L;
                        }
                        this.processKeysMenuInfo();
                    }
                }
                break;
            }
            case 8: {
                if (this.gameState == 11 && this.timeScrollText >= this.lastProcessTime) {
                    if (this.pressedUp) {
                        this.board.auxInt = Math.max(0, this.board.auxInt - 1);
                    } else if (this.pressedDown) {
                        this.board.auxInt = Math.max(0, this.board.auxInt + 1);
                    }
                    this.timeScrollText = this.lastProcessTime + 200L;
                }
                switch (this.gameType) {
                    case 0: {
                        this.processKeysGameClassic();
                        break block0;
                    }
                    case 1: {
                        this.processKeysGameQuest();
                        break block0;
                    }
                    case 2: {
                        this.processKeysGameDaily();
                        break block0;
                    }
                    case 3: {
                        this.processKeysGameBonus();
                    }
                }
            }
        }
        if (this.state == 7 && !this.configIsLowPerformance && this.gameFrames % 5 == 0) {
            this.auxInt = this.gameFrames % 6;
            this.gc.shineTime[this.auxInt] = System.currentTimeMillis();
            this.gc.shineX[this.auxInt] = 16 * SSMath.rand(0, 15);
            this.gc.shineY[this.auxInt] = 16 * SSMath.rand(0, 20);
        }
    }

    private void processLoading() {
        int unloadResourcesFor = this.getStatePrevious();
        System.out.println("Unloading resources for state number " + unloadResourcesFor);
        switch (unloadResourcesFor) {
            case 4: {
                this.gc.resUnload(0, 1);
                break;
            }
            case 6: {
                this.gc.resUnload(1, 1);
                break;
            }
            case 7: {
                this.gc.resUnload(11, 1);
                this.gc.resUnload(12, 1);
                this.gc.resUnload(8, 1);
                this.gc.resUnload(9, 1);
                this.gc.resUnload(10, 1);
                this.gc.resUnload(15, 1);
                this.gc.resUnload(16, 1);
                this.gc.resUnload(17, 1);
                this.gc.resUnload(18, 1);
                this.gc.resUnload(19, 1);
                this.gc.resUnload(20, 1);
                this.gc.resUnload(21, 1);
                this.gc.resUnload(22, 1);
                this.gc.resUnload(23, 1);
                this.gc.resUnload(24, 1);
                this.gc.resUnload(27, 1);
                this.gc.resUnload(28, 1);
                this.gc.resUnload(29, 1);
                this.gc.resUnload(30, 1);
                this.gc.resUnload(0, 0);
                this.gc.resUnload(2, 0);
                this.gc.resUnload(9, 0);
                this.menu.unload();
                this.menuInfo.unload();
                this.menuClassic.unload();
                this.menuQuest.unload();
                this.menu = null;
                this.menuInfo = null;
                this.menuClassic = null;
                this.menuQuest = null;
                break;
            }
            case 8: {
                this.gc.resUnload(20, 1);
                this.gc.resUnload(23, 1);
                this.gc.resUnload(24, 1);
                this.gc.resUnload(26, 1);
                this.gc.resUnload(27, 1);
                this.gc.resUnload(1, 0);
                this.gc.resUnload(5, 0);
                this.gc.resUnload(6, 0);
                this.gc.resUnload(7, 0);
                this.board.unload();
                this.board = null;
            }
        }
        GameEngine.garbageCollector();
        this.repaint();
        this.serviceRepaints();
        int loadResourcesFor = this.getStateNext();
        System.out.println("Loading resources for state number " + loadResourcesFor);
        switch (loadResourcesFor) {
            case 4: {
                this.gc.loading_steps_total = 1;
                break;
            }
            case 6: {
                this.gc.loading_steps_total = 2;
                this.repaint();
                this.serviceRepaints();
                this.gc.resLoad(1, 1);
                break;
            }
            case 7: {
                this.gc.loading_steps_total = this.gcHighLevelCompleted == 0 ? 50 : 12 + Math.min(this.gcHighLevelCompleted, 89);
                this.gc.resLoad(27, 1);
                this.gc.resLoad(0, 0);
                this.gc.resLoad(2, 0);
                this.gc.resLoad(9, 0);
                this.repaint();
                this.serviceRepaints();
                this.gc.resLoad(11, 1);
                this.gc.resLoad(12, 1);
                this.gc.resLoad(8, 1);
                this.gc.resLoad(9, 1);
                this.gc.resLoad(10, 1);
                this.repaint();
                this.serviceRepaints();
                this.gc.resLoad(15, 1);
                this.gc.resLoad(16, 1);
                this.gc.resLoad(17, 1);
                this.gc.resLoad(18, 1);
                this.gc.resLoad(19, 1);
                this.repaint();
                this.serviceRepaints();
                this.gc.resLoad(20, 1);
                this.gc.resLoad(21, 1);
                this.gc.resLoad(22, 1);
                this.gc.resLoad(23, 1);
                this.gc.resLoad(24, 1);
                this.repaint();
                this.serviceRepaints();
                if (this.menu == null) {
                    this.menu = new MenuManager(this, 4);
                }
                if (this.configIsLowPerformance) {
                    this.menu.setConfig(2, 6);
                    this.menu.setConfig(0, 2);
                    this.menu.setConfig(1, 2);
                    this.menu.setConfig(4, false);
                }
                if (this.moreGameEnabled) {
                    this.menu.setMenu(0, new String[]{this.lang[8], this.lang[101], this.lang[12], this.lang[14], this.lang[16], this.lang[18]});
                    this.menu.setMenu(1, new String[]{this.lang[20], this.lang[22], this.lang[24], this.lang[26], this.lang[10]});
                } else {
                    this.menu.setMenu(0, new String[]{this.lang[8], this.lang[10], this.lang[12], this.lang[14], this.lang[16], this.lang[18]});
                    this.menu.setMenu(1, new String[]{this.lang[20], this.lang[22], this.lang[24], this.lang[26], this.lang[28]});
                }
                this.menu.setMenu(2, new String[]{this.lang[38] + " " + this.lang[43], this.lang[40] + " " + this.lang[43], this.lang[28]});
                if (this.configSound) {
                    this.menu.setItemString(2, 0, this.lang[38] + " " + this.lang[42]);
                }
                if (this.configVibrate) {
                    this.menu.setItemString(2, 1, this.lang[40] + " " + this.lang[42]);
                }
                this.menu.setMenu(3, new String[]{this.lang[99], this.lang[100]});
                this.auxString = "BEFORE->item_animations.lqa";
                this.repaint();
                this.serviceRepaints();
                this.auxString = "AFTER->item_animations.lqa";
                this.repaint();
                this.serviceRepaints();
                this.menu.setFont(GameCanvas.resFonts[1], 10, 6);
                this.menu.setItemPos(0, 60, 2);
                this.menu.setItemPos(1, 85, 2);
                this.menu.setItemPos(2, 110, 2);
                this.menu.setItemPos(3, 110, 2);
                this.auxString = "AFTER->MenuManager()";
                this.repaint();
                this.serviceRepaints();
                if (this.menuInfo == null) {
                    this.menuInfo = new MenuInfo(this);
                }
                this.menuInfo.setText(this.lang[44]);
                this.repaint();
                this.serviceRepaints();
                if (this.menuClassic == null) {
                    this.menuClassic = new MenuClassic(this);
                } else {
                    this.menuClassic.initLevels();
                }
                this.repaint();
                this.serviceRepaints();
                if (this.menuQuest == null) {
                    this.menuQuest = new MenuQuest(this);
                }
                this.repaint();
                this.serviceRepaints();
                if (this.menuBonus == null) {
                    this.menuBonus = new MenuBonus(this);
                }
                this.repaint();
                this.serviceRepaints();
                if (this.menuProgress == null) {
                    this.menuProgress = new MenuProgress(this);
                }
                this.repaint();
                this.serviceRepaints();
                if (this.robot == null) {
                    this.robot = new Robot(this);
                }
                switch (this.menuActive) {
                    case 0: {
                        this.menu.makeTransition(0, 100);
                        this.menu.makeTransition(0, 0);
                        this.menu.runTransition();
                        break;
                    }
                    case 8: {
                        this.auxInt = this.menuClassic.levelSelected = Math.min(this.gcHighLevelCompleted, 89);
                        this.menuClassic.runTransitionIn();
                        if (this.menuClassic.levelSelected == 89 && this.gcHighLevelCompleted >= 90) {
                            this.robot.speak(this.lang[103]);
                            break;
                        }
                        this.robot.speak(this.lang[82]);
                        break;
                    }
                    case 9: {
                        if (this.gqLevelRowReturnLast != -1 && this.gqLevelColReturnLast != -1) {
                            this.gqLevelCol = this.gqLevelColReturnLast;
                            this.gqLevelRow = this.gqLevelRowReturnLast;
                        }
                        this.menuQuest.setItemSelected(this.gqLevelRow, this.gqLevelCol);
                        this.menuQuest.runTransitionIn();
                        break;
                    }
                    case 10: {
                        this.menuBonus.runTransitionIn();
                    }
                }
                break;
            }
            case 8: {
                this.gc.loading_steps_total = 2;
                this.gc.resLoad(20, 1);
                this.gc.resLoad(23, 1);
                this.gc.resLoad(24, 1);
                this.gc.resLoad(26, 1);
                this.gc.resLoad(27, 1);
                this.repaint();
                this.serviceRepaints();
                this.gc.resLoad(1, 0);
                this.gc.resLoad(5, 0);
                this.gc.resLoad(6, 0);
                this.gc.resLoad(7, 0);
            }
        }
        this.repaint();
        this.serviceRepaints();
        this.stateNext();
    }

    private void processTransition() {
        if (this.gameFramesAux > 20) {
            this.stateNext();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processKeysMenuMain() {
        if (this.menu.getMenuState() == 1) {
            this.menuActive = this.menuNext;
        }
lbl3:
        // 12 sources

        block16: while (this.keyboard.getHasMoreKeys()) {
            this.key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.keyboard.removeAllEvents();
                continue;
            }
            if (this.menu.getMenuState() != 1) continue;
            this.cheat(this.key);
            switch (this.key) {
                case '*': {
                    if (!this.godMode) break;
                    this.debug = this.debug == false;
                    break;
                }
                case '\u0001': {
                    if (this.menuActive == 0 || this.menuActive != 1) break;
                    this.menuNext = 0;
                    this.robot.speak(this.lang[9]);
                    this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 0);
                    this.menu.makeTransition(this.menu.getMenuActive(), 600);
                    this.menu.makeTransition(this.menuNext, 900);
                    this.menu.runTransition();
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    switch (this.menuActive) {
                        case 0: {
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[8])) {
                                this.menuNext = 1;
                                this.robot.speak(this.lang[21]);
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, this.menuItemSelected);
                                this.menu.makeTransition(this.menu.getMenuActive(), 1000);
                                this.menu.makeTransition(this.menuNext, 200);
                                this.menu.runTransition();
                                break;
                            }
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[10])) {
                                this.countProgress();
                                this.menuNext = 6;
                                this.robot.speak(this.lang[11]);
                                this.robot.robotDown();
                                this.menu.makeTransition(this.menu.getMenuActive(), 700);
                                this.menu.runTransition();
                                this.menuProgress.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[101])) {
                                this.running = false;
                                this.gm.running = false;
                                try {
                                    this.sound.stopSound(this.soundMusic);
                                    this.configSound = false;
                                    this.menu.setItemString(2, 0, this.lang[38] + " " + this.lang[43]);
                                    this.gm.platformRequest(this.moreGamesURL);
                                }
                                catch (Exception var1_1) {}
                                break;
                            }
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[12])) {
                                this.menuNext = 2;
                                this.robot.speak(this.lang[39]);
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 0);
                                this.menu.makeTransition(this.menu.getMenuActive(), 600);
                                if (this.menu.menuOptions[2].length == 3) {
                                    this.menu.makeTransition(this.menuNext, 400);
                                } else {
                                    this.menu.makeTransition(this.menuNext, 100);
                                }
                                this.menu.runTransition();
                                break;
                            }
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[14])) {
                                this.menuNext = 5;
                                this.menuInfo.setText(this.lang[44]);
                                this.menu.makeTransition(this.menu.getMenuActive(), 700);
                                this.menu.runTransition();
                                this.menuInfo.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[16])) {
                                this.menuNext = 7;
                                this.menuInfo.setText(this.lang[45]);
                                this.menu.makeTransition(this.menu.getMenuActive(), 800);
                                this.menu.runTransition();
                                this.menuInfo.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[0][this.menuItemSelected].equals(this.lang[18])) {
                                this.robot.speak(this.lang[99]);
                                this.menuNext = 3;
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, this.menuItemSelected);
                                this.menu.makeTransition(this.menu.getMenuActive(), 600);
                                this.menu.makeTransition(this.menuNext, 100);
                                this.menu.runTransition();
                                break;
                            }
                            ** GOTO lbl3
                        }
                        case 1: {
                            if (this.menu.menuOptions[1][this.menuItemSelected].equals(this.lang[20])) {
                                System.out.println("*** MENU CLASSIC ***");
                                this.menuNext = 8;
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, this.menuItemSelected);
                                this.menuClassic.levelSelected = Math.min(this.gcHighLevelCompleted, 89);
                                if (this.menuClassic.levelSelected == 89 && this.gcHighLevelCompleted >= 90) {
                                    this.robot.speak(this.lang[103]);
                                } else {
                                    this.robot.speak(this.lang[82]);
                                }
                                this.menu.titleOut();
                                this.menu.makeTransition(this.menu.getMenuActive(), 600);
                                this.menu.runTransition();
                                this.menuClassic.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[1][this.menuItemSelected].equals(this.lang[22])) {
                                System.out.println("*** MENU QUEST ***");
                                this.menuNext = 9;
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, this.menuItemSelected);
                                this.robot.robotOut();
                                this.menu.titleOut();
                                this.menu.makeTransition(this.menu.getMenuActive(), 600);
                                this.menu.runTransition();
                                this.menuQuest.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[1][this.menuItemSelected].equals(this.lang[24])) {
                                System.out.println("*** MENU BONUS ***");
                                this.countProgress();
                                this.menuNext = 10;
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, this.menuItemSelected);
                                this.menu.titleOut();
                                this.menu.makeTransition(this.menu.getMenuActive(), 600);
                                this.menu.runTransition();
                                this.menuBonus.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[1][this.menuItemSelected].equals(this.lang[26])) {
                                System.out.println("*** MENU TUTORIAL ***");
                                this.menuNext = 11;
                                this.menuInfo.setText(this.lang[95]);
                                this.menu.makeTransition(this.menu.getMenuActive(), 700);
                                this.menu.runTransition();
                                this.menuInfo.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[1][this.menuItemSelected].equals(this.lang[10])) {
                                this.menuNext = 6;
                                this.robot.speak(this.lang[11]);
                                this.robot.robotDown();
                                this.menu.makeTransition(this.menu.getMenuActive(), 700);
                                this.menu.runTransition();
                                this.menuProgress.runTransitionIn();
                                break;
                            }
                            if (this.menu.menuOptions[1][this.menuItemSelected].equals(this.lang[28])) {
                                this.menuNext = 0;
                                this.robot.speak(this.lang[9]);
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 0);
                                this.menu.makeTransition(this.menu.getMenuActive(), 600);
                                this.menu.makeTransition(this.menuNext, 900);
                                this.menu.runTransition();
                                break;
                            }
                            ** GOTO lbl3
                        }
                        case 2: {
                            if (this.menu.menuOptions[2][this.menuItemSelected].startsWith(this.lang[38])) {
                                v0 = this.configSound = this.configSound == false;
                                if (this.configSound) {
                                    this.menu.setItemString(2, this.menuItemSelected, this.lang[38] + " " + this.lang[42]);
                                    break;
                                }
                                this.menu.setItemString(2, this.menuItemSelected, this.lang[38] + " " + this.lang[43]);
                                break;
                            }
                            if (this.menu.menuOptions[2][this.menuItemSelected].startsWith(this.lang[40])) {
                                v1 = this.configVibrate = this.configVibrate == false;
                                if (this.configVibrate) {
                                    if (this.configVibrate) {
                                        Display.getDisplay((MIDlet)this.gm).vibrate(200);
                                    }
                                    this.menu.setItemString(2, this.menuItemSelected, this.lang[40] + " " + this.lang[42]);
                                    break;
                                }
                                this.menu.setItemString(2, this.menuItemSelected, this.lang[40] + " " + this.lang[43]);
                                break;
                            }
                            if (this.menu.menuOptions[2][this.menuItemSelected].equals(this.lang[28])) {
                                this.menuNext = 0;
                                this.robot.speak(this.lang[13]);
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 2);
                                this.menu.makeTransition(this.menu.getMenuActive(), 700);
                                this.menu.makeTransition(this.menuNext, 200);
                                this.menu.runTransition();
                                break;
                            }
                            ** GOTO lbl3
                        }
                        case 3: {
                            if (this.menuItemSelected == 0) {
                                this.robot.speak(this.lang[19]);
                                this.menuNext = 0;
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 5);
                                this.menu.makeTransition(this.menu.getMenuActive(), 500);
                                this.menu.makeTransition(this.menuNext, 200);
                                this.menu.runTransition();
                                break;
                            }
                            if (this.menuItemSelected == 1) {
                                this.gm.running = false;
                                this.running = false;
                                break;
                            }
                            ** GOTO lbl3
                        }
                        case 4: {
                            if (this.menuItemSelected == 0 || this.menuItemSelected == 1 || this.menuItemSelected == 2) break;
                            if (this.menuItemSelected == 3) {
                                this.menuNext = 1;
                                this.menuItemSelected = this.menu.setItemSelected(this.menuNext, this.menuItemSelected);
                                this.menu.makeTransition(this.menu.getMenuActive(), 800);
                                this.menu.makeTransition(this.menuNext, 300);
                                this.menu.runTransition();
                            } else {
                                break;
                            }
                        }
                    }
                    continue block16;
                }
                case '\u0005': 
                case '2': {
                    this.menuItemSelected = this.menu.setItemSelected(this.menuActive, this.menuItemSelected - 1);
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[8])) {
                        this.robot.speak(this.lang[9]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[20])) {
                        this.robot.speak(this.lang[21]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].startsWith(this.lang[38])) {
                        this.robot.speak(this.lang[39]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[10])) {
                        this.robot.speak(this.lang[11]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[101])) {
                        this.robot.speak(this.lang[102]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[22])) {
                        this.robot.speak(this.lang[23]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].startsWith(this.lang[40])) {
                        this.robot.speak(this.lang[41]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[12])) {
                        this.robot.speak(this.lang[13]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[24])) {
                        this.robot.speak(this.lang[25]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[28])) {
                        this.robot.speak(this.lang[29]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[14])) {
                        this.robot.speak(this.lang[15]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[26])) {
                        this.robot.speak(this.lang[27]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[16])) {
                        this.robot.speak(this.lang[17]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[18])) {
                        this.robot.speak(this.lang[19]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[6])) {
                        this.robot.speak(this.lang[99]);
                        break;
                    }
                    if (!this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[100])) break;
                    this.robot.speak(this.lang[100]);
                    break;
                }
                case '\u0006': 
                case '8': {
                    this.menuItemSelected = this.menu.setItemSelected(this.menuActive, this.menuItemSelected + 1);
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[8])) {
                        this.robot.speak(this.lang[9]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[20])) {
                        this.robot.speak(this.lang[21]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].startsWith(this.lang[38])) {
                        this.robot.speak(this.lang[39]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[10])) {
                        this.robot.speak(this.lang[11]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[101])) {
                        this.robot.speak(this.lang[102]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[22])) {
                        this.robot.speak(this.lang[23]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].startsWith(this.lang[40])) {
                        this.robot.speak(this.lang[41]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[12])) {
                        this.robot.speak(this.lang[13]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[24])) {
                        this.robot.speak(this.lang[25]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[28])) {
                        this.robot.speak(this.lang[29]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[14])) {
                        this.robot.speak(this.lang[15]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[26])) {
                        this.robot.speak(this.lang[27]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[16])) {
                        this.robot.speak(this.lang[17]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[18])) {
                        this.robot.speak(this.lang[19]);
                        break;
                    }
                    if (this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[6])) {
                        this.robot.speak(this.lang[99]);
                        break;
                    }
                    if (!this.menu.menuOptions[this.menuActive][this.menuItemSelected].equals(this.lang[100])) break;
                    this.robot.speak(this.lang[100]);
                }
            }
        }
    }

    private void processKeysMenuClassic() {
        if (this.menuClassic.menuState == 0) {
            this.menuActive = this.menuNext;
        }
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0 && (key == '\u0003' || key == '\u0004' || key == '4' || key == '6')) {
                this.pressedLeft = false;
                this.pressedRight = false;
                if (this.auxInt > this.gcHighLevelCompleted) {
                    this.robot.speak(this.lang[81]);
                } else if (this.auxInt == this.gcHighLevelCompleted) {
                    this.robot.speak(this.lang[82]);
                } else if (this.auxInt < this.gcHighLevelCompleted && this.auxInt == this.menuClassic.levelSelectedNext) {
                    this.auxString = SSFunctions.replace(this.lang[83] + " " + (this.auxInt + 1) + "\n" + this.lang[31] + ": %%TIME%%\n" + this.lang[84] + ": %%POINTS%%", "%%TIME%%", SSFunctions.getTimeText(this.gcHighScoresTime[this.auxInt]));
                    this.auxString = SSFunctions.replace(this.auxString, "%%POINTS%%", Long.toString(this.gcHighScoresPoints[this.auxInt]));
                    this.robot.speak(this.auxString);
                }
                this.keyboard.removeAllEvents();
                continue;
            }
            if (this.menuClassic.menuState != 0) continue;
            if (key == '\u0003' || key == '\u0004' || key == '4' || key == '6') {
                if (this.menuClassic.levelSelected > this.gcHighLevelCompleted) {
                    this.robot.speak(this.lang[81]);
                } else if (this.menuClassic.levelSelected == this.gcHighLevelCompleted) {
                    this.robot.speak(this.lang[82]);
                } else if (this.menuClassic.levelSelectedNext < this.gcHighLevelCompleted) {
                    this.auxString = SSFunctions.replace(this.lang[83] + " " + (this.auxInt + 1) + "\n" + this.lang[31] + ": %%TIME%%\n" + this.lang[84] + ": %%POINTS%%", "%%TIME%%", SSFunctions.getTimeText(this.gcHighScoresTime[this.auxInt]));
                    this.auxString = SSFunctions.replace(this.auxString, "%%POINTS%%", Long.toString(this.gcHighScoresPoints[this.auxInt]));
                    this.robot.speak(this.auxString);
                }
            }
            if (!this.configIsLowPerformance) {
                this.menuClassic.speedX = 3;
            }
            switch (key) {
                case '*': {
                    if (!this.godMode) break;
                    this.debug = !this.debug;
                    break;
                }
                case '\u0001': {
                    this.menuNext = 1;
                    this.menuClassic.runTransitionOut();
                    this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 0);
                    this.robot.speak(this.lang[21]);
                    this.menu.titleIn();
                    this.menu.makeTransition(1, 200);
                    this.menu.runTransition();
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    if (this.menuClassic.levelSelected > this.gcHighLevelCompleted) break;
                    this.gameType = 0;
                    this.gameState = 1;
                    this.clock = new Clock(1);
                    this.gameLevelToLoad = "c" + this.menuClassic.levelSelected + ".pcs";
                    this.board = new BoardManager(this, this.gameLevelToLoad);
                    this.board.skin = 0;
                    if (this.menuClassic.levelSelected == this.gcLastLevelPlayed) {
                        // empty if block
                    }
                    this.gcPoints = 0;
                    this.gcPenalties = 0;
                    this.gcLastLevelPlayed = this.menuClassic.levelSelected;
                    this.board.setBoardState(9);
                    this.changeStateTo(8, 9);
                    break;
                }
                case '\u0003': 
                case '4': {
                    this.pressedLeft = true;
                    this.timeScrollText = this.lastProcessTime + 200L;
                    this.auxInt = this.menuClassic.setLevelSelected(this.menuClassic.levelSelected - 1);
                    break;
                }
                case '\u0004': 
                case '6': {
                    this.pressedRight = true;
                    this.timeScrollText = this.lastProcessTime + 200L;
                    this.auxInt = this.menuClassic.setLevelSelected(this.menuClassic.levelSelected + 1);
                }
            }
        }
    }

    private void processKeysMenuQuest() {
        if (this.menuQuest.menuState == 0) {
            this.menuActive = this.menuNext;
        }
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.keyboard.removeAllEvents();
                continue;
            }
            if (this.menuQuest.menuState != 0) continue;
            switch (key) {
                case '*': {
                    if (!this.godMode) break;
                    this.debug = !this.debug;
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.gqLevelRowReturnLast = this.gqLevelRow;
                    this.gqLevelColReturnLast = this.gqLevelCol;
                    this.gameType = 1;
                    this.gameState = 8;
                    this.clock = null;
                    this.clock = new Clock(2);
                    this.gqOrder = SSMath.shuffle(this.gqOrder);
                    this.gqLevelNumber = 0;
                    this.gameLevelToLoad = "q" + this.gqLevelRow + this.gqLevelCol + this.gqOrder[this.gqLevelNumber] + ".pcs";
                    this.board = null;
                    GameEngine.garbageCollector();
                    this.board = new BoardManager(this, this.gameLevelToLoad);
                    if (this.gqLevelState[MenuQuest.getIndex(this.gqLevelRow, this.gqLevelCol)] == 1) {
                        this.board.loadState("Game_Quest_Continue");
                    }
                    this.gqDataColor[this.gqLevelNumber] = this.board.getDataColor();
                    this.gqDataPalette[this.gqLevelNumber] = BoardManager.boardPalette;
                    this.board.skin = 1;
                    this.board.setBoardState(10);
                    this.changeStateTo(8, 10);
                    break;
                }
                case '\u0001': {
                    this.menuNext = 1;
                    this.menuQuest.runTransitionOut();
                    this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 1);
                    this.robot.hello(this.lang[23]);
                    this.menu.titleIn();
                    this.menu.makeTransition(1, 200);
                    this.menu.runTransition();
                    break;
                }
                case '\u0005': 
                case '2': {
                    this.menuQuest.setItemSelected(this.menuQuest.levelSelectedRow - 1, this.menuQuest.levelSelectedCol);
                    break;
                }
                case '\u0006': 
                case '8': {
                    this.menuQuest.setItemSelected(this.menuQuest.levelSelectedRow + 1, this.menuQuest.levelSelectedCol);
                    break;
                }
                case '\u0003': 
                case '4': {
                    this.menuQuest.setItemSelected(this.menuQuest.levelSelectedRow, this.menuQuest.levelSelectedCol - 1);
                    break;
                }
                case '\u0004': 
                case '6': {
                    this.menuQuest.setItemSelected(this.menuQuest.levelSelectedRow, this.menuQuest.levelSelectedCol + 1);
                }
            }
        }
    }

    private void processKeysMenuBonus() {
        if (this.menuBonus.menuState == 1) {
            this.menuActive = this.menuNext;
        }
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.keyboard.removeAllEvents();
                continue;
            }
            if (this.menuBonus.menuState == 1) {
                switch (key) {
                    case '*': {
                        if (!this.godMode) break;
                        this.debug = !this.debug;
                        break;
                    }
                    case '\u0001': {
                        this.menuNext = 1;
                        this.menuBonus.runTransitionOut();
                        this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 2);
                        this.robot.speak(this.lang[25]);
                        this.menu.titleIn();
                        this.menu.makeTransition(1, 200);
                        this.menu.runTransition();
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (this.menuBonus.itemSelected == 0 && this.configPictocubes >= this.gbPictocubesCost[0]) {
                            this.menuBonus.menuState = 4;
                            break;
                        }
                        if (this.menuBonus.itemSelected == 1 && this.configPictocubes >= this.gbPictocubesCost[1]) {
                            this.gameType = 3;
                            this.gameState = 1;
                            this.clock = new Clock(1);
                            this.gameLevelToLoad = "b0.pcs";
                            this.board = new BoardManager(this, this.gameLevelToLoad);
                            this.board.skin = 2;
                            this.gcPenalties = 0;
                            this.board.setBoardState(9);
                            this.changeStateTo(8, 9);
                            break;
                        }
                        if (this.menuBonus.itemSelected == 2 && this.configPictocubes >= this.gbPictocubesCost[2]) {
                            this.menuBonus.menuState = 5;
                            break;
                        }
                        if (this.menuBonus.itemSelected == 3 && this.configPictocubes >= this.gbPictocubesCost[3]) {
                            this.gameType = 3;
                            this.gameState = 1;
                            this.clock = new Clock(1);
                            this.gameLevelToLoad = "b1.pcs";
                            this.board = new BoardManager(this, this.gameLevelToLoad);
                            this.board.skin = 2;
                            this.gcPenalties = 0;
                            this.board.setBoardState(9);
                            this.changeStateTo(8, 9);
                            break;
                        }
                        if (this.menuBonus.itemSelected != 4 || this.configPictocubes < this.gbPictocubesCost[4]) break;
                        this.menuBonus.menuState = 6;
                        break;
                    }
                    case '\u0005': 
                    case '2': {
                        this.menuBonus.setItemSelected(this.menuBonus.itemSelected - 1);
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        this.menuBonus.setItemSelected(this.menuBonus.itemSelected + 1);
                    }
                }
                continue;
            }
            if (this.menuBonus.menuState != 4 && this.menuBonus.menuState != 5 && this.menuBonus.menuState != 6) continue;
            if (this.menuBonus.menuState == 4) {
                this.gc.resUnload(28, 1);
            } else if (this.menuBonus.menuState == 5) {
                this.gc.resUnload(29, 1);
            } else if (this.menuBonus.menuState == 6) {
                this.gc.resUnload(30, 1);
            }
            GameEngine.garbageCollector();
            this.menuBonus.runTransitionIn();
        }
    }

    private void processKeysMenuProgress() {
        if (this.menuProgress.menuState == 0) {
            this.menuActive = this.menuNext;
        }
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.keyboard.removeAllEvents();
                continue;
            }
            if (this.menuProgress.menuState != 0) continue;
            switch (key) {
                case '*': {
                    if (!this.godMode) break;
                    this.debug = !this.debug;
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    if (this.moreGameEnabled) {
                        this.menuNext = 1;
                        this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 4);
                        this.menuProgress.runTransitionOut();
                        this.robot.robotUp();
                        this.menu.makeTransition(1, 200);
                        this.menu.runTransition();
                        break;
                    }
                    this.menuNext = 0;
                    this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 1);
                    this.menuProgress.runTransitionOut();
                    this.robot.robotUp();
                    this.menu.makeTransition(0, 200);
                    this.menu.runTransition();
                }
            }
        }
    }

    private void processKeysMenuInfo() {
        if (this.menuInfo.menuState == 0) {
            this.menuActive = this.menuNext;
        }
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.pressedUp = false;
                this.pressedDown = false;
                this.keyboard.removeAllEvents();
                continue;
            }
            if (this.menuInfo.menuState != 0) continue;
            switch (key) {
                case '*': {
                    if (!this.godMode) break;
                    this.debug = !this.debug;
                    break;
                }
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    if (this.menuActive == 5) {
                        this.menuNext = 0;
                        this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 3);
                        this.menuInfo.runTransitionOut();
                        this.menu.makeTransition(0, 200);
                        this.menu.runTransition();
                        break;
                    }
                    if (this.menuActive == 7) {
                        this.menuNext = 0;
                        this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 4);
                        this.menuInfo.runTransitionOut();
                        this.menu.makeTransition(0, 200);
                        this.menu.runTransition();
                        break;
                    }
                    if (this.menuActive != 11) break;
                    this.menuNext = 1;
                    this.menuItemSelected = this.menu.setItemSelected(this.menuNext, 3);
                    this.menuInfo.runTransitionOut();
                    this.menu.makeTransition(1, 200);
                    this.menu.runTransition();
                    break;
                }
                case '\u0005': 
                case '2': {
                    this.menuInfo.textLine = Math.max(0, this.menuInfo.textLine - 1);
                    this.pressedDown = false;
                    this.pressedUp = true;
                    this.timeScrollText = this.lastProcessTime + 200L;
                    break;
                }
                case '\u0006': 
                case '8': {
                    ++this.menuInfo.textLine;
                    this.pressedDown = true;
                    this.pressedUp = false;
                    this.timeScrollText = this.lastProcessTime + 200L;
                }
            }
        }
    }

    private void processKeysSoundQuestion() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) continue;
            switch (key) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.configSound = true;
                    this.stateAdd(2);
                    this.stateAdd(3);
                    this.stateAdd(1);
                    this.stateAdd(6);
                    this.stateAdd(2);
                    this.stateAdd(3);
                    this.stateAdd(1);
                    this.stateAdd(7);
                    this.stateNext();
                    this.menuActive = 0;
                    break;
                }
                case '\u0001': {
                    this.configSound = false;
                    this.stateAdd(2);
                    this.stateAdd(3);
                    this.stateAdd(1);
                    this.stateAdd(6);
                    this.stateAdd(2);
                    this.stateAdd(3);
                    this.stateAdd(1);
                    this.stateAdd(7);
                    this.stateNext();
                    this.menuActive = 0;
                }
            }
        }
    }

    public void processKeysGameClassic() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.pressedUp = false;
                this.pressedDown = false;
                continue;
            }
            if (this.gameState == 1) {
                switch (key) {
                    case '*': {
                        if (!this.godMode) break;
                        this.debug = !this.debug;
                        break;
                    }
                    case '#': {
                        if (!this.godMode) break;
                        if (this.configSound) {
                            this.sound.playSound(this.soundWin, true);
                        }
                        this.auxString = this.clock.getTimeString(3);
                        this.gcTime = this.clock.getMilliseconds();
                        this.auxInt = (int)((long)this.gcTimeLimits[BoardManager.boardSize / 5 - 1] - this.gcTime / 1000L);
                        this.gcPoints = Math.max(0, this.auxInt) * (10 - Math.min(5, this.gcPenalties));
                        this.board.setBoardState(2);
                        this.gameState = 2;
                        break;
                    }
                    case '\u0000': {
                        if (!BoardManager.zoomEnabled) break;
                        if (BoardManager.zoomState == 1) {
                            BoardManager.cellSizeFinal = BoardManager.minCellSize;
                        }
                        if (BoardManager.zoomState == 0) {
                            BoardManager.cellSizeFinal = BoardManager.maxCellSize;
                        }
                        BoardManager.zooming = true;
                        break;
                    }
                    case '\u0001': {
                        this.auxString = this.clock.getTimeString(3);
                        this.clock.stop();
                        this.board.setBoardState(5);
                        this.gameState = 5;
                        return;
                    }
                    case '\u0005': 
                    case '2': {
                        this.board.movePointer(0);
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        this.board.movePointer(1);
                        break;
                    }
                    case '\u0003': 
                    case '4': {
                        this.board.movePointer(2);
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        this.board.movePointer(3);
                        break;
                    }
                    case '\u0002': 
                    case '5': {
                        if (this.board.getCellDataInput() != 0 && this.board.getCellDataInput() != 2) break;
                        if (this.board.getCellDataBW() == 1) {
                            if (this.configSound && !this.sound.isSound()) {
                                this.sound.playSound(this.sfxMark, false);
                            }
                            this.board.markCell((byte)1, false);
                            this.board.drawAnimation(-2, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                            if (!this.board.checkLevelCompleted()) break;
                            if (this.configSound) {
                                this.sound.playSound(this.soundWin, true);
                            }
                            this.auxString = this.clock.getTimeString(3);
                            this.gcTime = this.clock.getMilliseconds();
                            this.auxInt = (int)((long)this.gcTimeLimits[BoardManager.boardSize / 5 - 1] - this.gcTime / 1000L);
                            this.gcPoints = Math.max(0, this.auxInt) * (10 - Math.min(5, this.gcPenalties));
                            this.board.setBoardState(2);
                            this.gameState = 2;
                            break;
                        }
                        if (this.configSound) {
                            this.sound.playSound(this.sfxError, false);
                        }
                        if (this.configVibrate) {
                            Display.getDisplay((MIDlet)this.gm).vibrate(200);
                        }
                        this.board.markCell((byte)2, true);
                        this.board.drawAnimation(-1, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        ++this.gcPenalties;
                        this.board.drawAnimation(Math.min(this.gcPenalties - 1, 8), this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        this.clock.addTime(this.gcPenalties * 60 * 1000);
                        break;
                    }
                    case '0': {
                        if (this.board.getCellDataInput() == 0) {
                            if (this.configSound) {
                                this.sound.playSound(this.sfxBlank, false);
                            }
                            this.board.markCell((byte)2, false);
                            this.board.drawAnimation(-1, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                            break;
                        }
                        if (this.board.getCellDataInput() != 2) break;
                        this.board.markCell((byte)0, false);
                    }
                }
                continue;
            }
            if (this.gameState == 9) {
                if (this.configSound) {
                    if (this.sound.isSound(this.soundMusic)) {
                        this.sound.stopSound(this.soundMusic);
                    }
                    this.sound.playSound(this.soundStart, true);
                }
                this.board.setBoardState(1);
                this.gameState = 1;
                this.clock.start();
                continue;
            }
            if (this.gameState == 2) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        this.pressedAnyKey = false;
                        this.board.setBoardState(3);
                        this.gameState = 3;
                    }
                }
                continue;
            }
            if (this.gameState == 3) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        if (this.pressedAnyKey) {
                            this.pressedAnyKey = false;
                            if (this.gcTime < this.gcHighScoresTime[this.gcLastLevelPlayed] || this.gcHighScoresTime[this.gcLastLevelPlayed] == 0L) {
                                this.gcHighScoresTime[this.gcLastLevelPlayed] = this.gcTime;
                            }
                            if (this.gcPoints > this.gcHighScoresPoints[this.gcLastLevelPlayed]) {
                                this.gcHighScoresPoints[this.gcLastLevelPlayed] = this.gcPoints;
                            }
                            if (this.gcLastLevelPlayed == 89) {
                                this.gcHighLevelCompleted = 90;
                            } else {
                                this.gcLastLevelPlayed = Math.min(this.gcLastLevelPlayed + 1, 89);
                                if (this.gcHighLevelCompleted < this.gcLastLevelPlayed) {
                                    this.gcHighLevelCompleted = this.gcLastLevelPlayed;
                                }
                            }
                            this.saveGame(GC_RMS_NAME);
                            this.displayFullAd();
                            this.changeStateTo(7, 8);
                            break;
                        }
                        this.board.boardFramesAux = 100;
                        this.pressedAnyKey = true;
                    }
                }
                continue;
            }
            if (this.gameState == 7) {
                if (!this.pressedAnyKey) continue;
                this.pressedAnyKey = false;
                this.displayFullAd();
                this.changeStateTo(7, 8);
                continue;
            }
            if (this.gameState == 11) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        this.board.setBoardState(5);
                        this.gameState = 5;
                        break;
                    }
                    case '\u0005': 
                    case '2': {
                        this.board.auxInt = Math.max(0, this.board.auxInt - 1);
                        this.pressedDown = false;
                        this.pressedUp = true;
                        this.timeScrollText = this.lastProcessTime + 200L;
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        ++this.board.auxInt;
                        this.pressedDown = true;
                        this.pressedUp = false;
                        this.timeScrollText = this.lastProcessTime + 200L;
                    }
                }
                continue;
            }
            if (this.gameState != 5) continue;
            switch (key) {
                case '\u0001': 
                case '\u0002': 
                case '5': {
                    if (this.board.itemSelected == 0) {
                        this.clock.start();
                        this.board.setBoardState(1);
                        this.gameState = 1;
                        break;
                    }
                    if (this.board.itemSelected == 1) {
                        this.board.setBoardState(11);
                        this.gameState = 11;
                        break;
                    }
                    if (this.board.itemSelected == 2) {
                        this.configSound = !this.configSound;
                        break;
                    }
                    if (this.board.itemSelected == 3) {
                        boolean bl = this.configVibrate = !this.configVibrate;
                        if (!this.configVibrate) break;
                        Display.getDisplay((MIDlet)this.gm).vibrate(200);
                        break;
                    }
                    if (this.board.itemSelected != 4) break;
                    this.changeStateTo(7, 8);
                    break;
                }
                case '\u0006': 
                case '8': {
                    this.board.setItemSelected(this.board.itemSelected + 1);
                    break;
                }
                case '\u0005': 
                case '2': {
                    this.board.setItemSelected(this.board.itemSelected - 1);
                }
            }
        }
        if (this.gameState == 1) {
            if (this.clock.getMilliseconds() >= 3600000L) {
                if (this.configSound) {
                    this.sound.playSound(this.soundLose, true);
                }
                this.board.setBoardState(7);
                this.gameState = 7;
            }
            if (BoardManager.zooming) {
                this.board.zoomChange();
            } else if (BoardManager.scroll) {
                this.board.scroll(160, 213, 1);
            } else {
                this.board.scroll(BoardManager.boardXfixed, BoardManager.boardYfixed, 0);
            }
        }
    }

    public void processKeysGameQuest() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.pressedUp = false;
                this.pressedDown = false;
                continue;
            }
            if (this.gameState == 1) {
                switch (key) {
                    case '*': {
                        if (!this.godMode) break;
                        this.debug = !this.debug;
                        break;
                    }
                    case '#': {
                        if (!this.godMode) break;
                        if (this.configSound) {
                            this.sound.playSound(this.soundWin, true);
                        }
                        this.auxString = this.clock.getTimeString(3);
                        this.gqTimeLeft[this.gqLevelNumber] = Math.max(0L, this.clock.getMilliseconds());
                        this.gqPointsLevel[this.gqLevelNumber] = (int)Math.max(0L, this.gqTimeLeft[this.gqLevelNumber] / 1000L) * (10 - Math.min(5, this.gqPenalties));
                        this.gqTime += Math.max(0L, this.clock.getMilliseconds());
                        this.gqPoints = SSMath.sum(this.gqPointsLevel);
                        this.board.setBoardState(2);
                        this.gameState = 2;
                        break;
                    }
                    case '\u0000': {
                        if (!BoardManager.zoomEnabled) break;
                        if (BoardManager.zoomState == 1) {
                            BoardManager.cellSizeFinal = BoardManager.minCellSize;
                        }
                        if (BoardManager.zoomState == 0) {
                            BoardManager.cellSizeFinal = BoardManager.maxCellSize;
                        }
                        BoardManager.zooming = true;
                        break;
                    }
                    case '\u0001': {
                        this.auxString = this.clock.getTimeString(3);
                        this.clock.stop();
                        this.board.setBoardState(5);
                        this.gameState = 5;
                        return;
                    }
                    case '\u0005': 
                    case '2': {
                        this.board.movePointer(0);
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        this.board.movePointer(1);
                        break;
                    }
                    case '\u0003': 
                    case '4': {
                        this.board.movePointer(2);
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        this.board.movePointer(3);
                        break;
                    }
                    case '\u0002': 
                    case '5': {
                        if (this.board.getCellDataInput() != 0 && this.board.getCellDataInput() != 2) break;
                        if (this.board.getCellDataBW() == 1) {
                            if (this.configSound) {
                                this.sound.playSound(this.sfxMark, false);
                            }
                            this.board.markCell((byte)1, false);
                            this.board.drawAnimation(-2, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                            if (!this.board.checkLevelCompleted()) break;
                            if (this.configSound) {
                                this.sound.playSound(this.soundWin, true);
                            }
                            this.auxString = this.clock.getTimeString(3);
                            this.gqTimeLeft[this.gqLevelNumber] = Math.max(0L, this.clock.getMilliseconds());
                            this.gqPointsLevel[this.gqLevelNumber] = (int)Math.max(0L, this.gqTimeLeft[this.gqLevelNumber] / 1000L) * (10 - Math.min(5, this.gqPenalties));
                            this.gqTime += Math.max(0L, this.clock.getMilliseconds());
                            this.gqPoints = SSMath.sum(this.gqPointsLevel);
                            this.board.setBoardState(2);
                            this.gameState = 2;
                            break;
                        }
                        if (this.configSound) {
                            this.sound.playSound(this.sfxError, false);
                        }
                        if (this.configVibrate) {
                            Display.getDisplay((MIDlet)this.gm).vibrate(200);
                        }
                        this.board.markCell((byte)2, true);
                        this.board.drawAnimation(-1, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        if (this.gqJoker) {
                            this.gqJoker = false;
                            break;
                        }
                        if (this.gqPenalties == 0) {
                            this.clock.addTime(-20000L);
                            this.board.drawAnimation(18, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        } else {
                            this.clock.addTime(-Math.min(this.gqPenalties, 9) * 60 * 1000);
                            this.board.drawAnimation(Math.min(this.gqPenalties, 8) + 8, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        }
                        ++this.gqPenalties;
                        break;
                    }
                    case '0': {
                        if (this.board.getCellDataInput() == 0) {
                            if (this.configSound) {
                                this.sound.playSound(this.sfxBlank, false);
                            }
                            this.board.markCell((byte)2, false);
                            this.board.drawAnimation(-1, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                            break;
                        }
                        if (this.board.getCellDataInput() != 2) break;
                        this.board.markCell((byte)0, false);
                    }
                }
                continue;
            }
            if (this.gameState == 10) {
                switch (key) {
                    case '\u0000': {
                        if (this.gqLevelNumber != 0) break;
                        this.changeStateTo(7, 9);
                        break;
                    }
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        if (this.gqLevelNumber == 0) {
                            if (this.configSound) {
                                if (this.sound.isSound(this.soundWin)) {
                                    this.sound.stopSound(this.soundWin);
                                }
                                this.sound.playSound(this.soundStart, true);
                            }
                            this.gqJoker = false;
                            this.gqPoints = 0;
                            this.gqTime = 0L;
                            this.gqPenalties = 0;
                            this.board.setBoardState(8);
                            this.gameState = 8;
                            break;
                        }
                        if (this.gqLevelNumber < 4) {
                            this.clock = null;
                            this.gqJoker = false;
                            this.gqPenalties = 0;
                            this.gameLevelToLoad = "q" + this.gqLevelRow + this.gqLevelCol + this.gqOrder[this.gqLevelNumber] + ".pcs";
                            this.board = null;
                            GameEngine.garbageCollector();
                            this.board = new BoardManager(this, this.gameLevelToLoad);
                            this.board.skin = 1;
                            this.clock = new Clock(2);
                            this.gqDataColor[this.gqLevelNumber] = this.board.getDataColor();
                            this.gqDataPalette[this.gqLevelNumber] = BoardManager.boardPalette;
                            this.board.setBoardState(8);
                            this.gameState = 8;
                            if (!this.configSound) break;
                            this.sound.playSound(this.soundStart, true);
                            break;
                        }
                        this.pressedAnyKey = false;
                        this.board.setBoardState(3);
                        this.gameState = 3;
                    }
                }
                continue;
            }
            if (this.gameState == 8) {
                switch (key) {
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        this.gqItemUsed[this.gqLevelNumber] = this.board.itemSelected;
                        this.clock.setTime(1000 * this.gqTimeLimits[BoardManager.boardSize / 5 - 1]);
                        if (this.board.itemSelected != 0) {
                            if (this.board.itemSelected == 1) {
                                this.board.useItemShowCol();
                            } else if (this.board.itemSelected == 2) {
                                this.board.useItemShowRow();
                            } else if (this.board.itemSelected == 3) {
                                this.clock.addTime(300 * this.gqTimeLimits[BoardManager.boardSize / 5 - 1]);
                            } else if (this.board.itemSelected == 4) {
                                this.gqJoker = true;
                            } else if (this.board.itemSelected == 5) {
                                this.board.useItemBomd();
                            }
                        }
                        this.clock.start();
                        this.board.setBoardState(1);
                        this.gameState = 1;
                        this.board.itemSelected = 0;
                        break;
                    }
                    case '\u0003': 
                    case '4': {
                        this.board.setUseItemSelected(this.board.itemSelected - 1);
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        this.board.setUseItemSelected(this.board.itemSelected + 1);
                    }
                }
                continue;
            }
            if (this.gameState == 2) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        ++this.gqLevelNumber;
                        this.board.saveState(1);
                        this.board.setBoardState(10);
                        this.gameState = 10;
                        this.displayFullAd();
                    }
                }
                continue;
            }
            if (this.gameState == 3) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        if (this.pressedAnyKey) {
                            this.pressedAnyKey = false;
                            this.gqLevelState[MenuQuest.getIndex((int)this.gqLevelRow, (int)this.gqLevelCol)] = 2;
                            if (this.gqLevelRow > 1) {
                                for (int col = 0; col < this.gqLevelRow - 1; ++col) {
                                    if (this.gqLevelState[MenuQuest.getIndex(this.gqLevelRow - 1, col)] != 0 || this.gqLevelState[MenuQuest.getIndex(this.gqLevelRow, col)] != 2 || this.gqLevelState[MenuQuest.getIndex(this.gqLevelRow, col + 1)] != 2) continue;
                                    this.gqLevelState[MenuQuest.getIndex((int)(this.gqLevelRow - 1), (int)col)] = 1;
                                }
                            }
                            if (this.gqTime > this.gqHighScoresTime[MenuQuest.getIndex(this.gqLevelRow, this.gqLevelCol)] || this.gqHighScoresTime[MenuQuest.getIndex(this.gqLevelRow, this.gqLevelCol)] == 0L) {
                                this.gqHighScoresTime[MenuQuest.getIndex((int)this.gqLevelRow, (int)this.gqLevelCol)] = this.gqTime;
                            }
                            if (this.gqPoints > this.gqHighScoresPoints[MenuQuest.getIndex(this.gqLevelRow, this.gqLevelCol)]) {
                                this.gqHighScoresPoints[MenuQuest.getIndex((int)this.gqLevelRow, (int)this.gqLevelCol)] = this.gqPoints;
                            }
                            this.saveGame(GQ_RMS_NAME);
                            this.displayFullAd();
                            this.changeStateTo(7, 9);
                            break;
                        }
                        this.board.boardFramesAux = 100;
                        this.pressedAnyKey = true;
                    }
                }
                continue;
            }
            if (this.gameState == 7) {
                if (!this.pressedAnyKey) continue;
                this.pressedAnyKey = false;
                this.displayFullAd();
                this.changeStateTo(7, 9);
                continue;
            }
            if (this.gameState == 11) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        this.board.setBoardState(5);
                        this.gameState = 5;
                        break;
                    }
                    case '\u0005': 
                    case '2': {
                        this.board.auxInt = Math.max(0, this.board.auxInt - 1);
                        this.pressedDown = false;
                        this.pressedUp = true;
                        this.timeScrollText = this.lastProcessTime + 200L;
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        ++this.board.auxInt;
                        this.pressedDown = true;
                        this.pressedUp = false;
                        this.timeScrollText = this.lastProcessTime + 200L;
                    }
                }
                continue;
            }
            if (this.gameState != 5) continue;
            switch (key) {
                case '\u0001': 
                case '\u0002': 
                case '5': {
                    if (this.board.itemSelected == 0) {
                        this.clock.start();
                        this.board.setBoardState(1);
                        this.gameState = 1;
                        break;
                    }
                    if (this.board.itemSelected == 1) {
                        this.board.setBoardState(11);
                        this.gameState = 11;
                        break;
                    }
                    if (this.board.itemSelected == 2) {
                        this.configSound = !this.configSound;
                        break;
                    }
                    if (this.board.itemSelected == 3) {
                        boolean bl = this.configVibrate = !this.configVibrate;
                        if (!this.configVibrate) break;
                        Display.getDisplay((MIDlet)this.gm).vibrate(200);
                        break;
                    }
                    if (this.board.itemSelected != 4) break;
                    this.changeStateTo(7, 9);
                    break;
                }
                case '\u0006': 
                case '8': {
                    this.board.setItemSelected(this.board.itemSelected + 1);
                    break;
                }
                case '\u0005': 
                case '2': {
                    this.board.setItemSelected(this.board.itemSelected - 1);
                }
            }
        }
        if (this.gameState == 1) {
            if (this.clock.getMilliseconds() <= 0L) {
                if (this.configSound) {
                    this.sound.playSound(this.soundLose, true);
                }
                this.pressedAnyKey = false;
                this.board.setBoardState(7);
                this.gameState = 7;
            }
            if (BoardManager.zooming) {
                this.board.zoomChange();
            } else if (BoardManager.scroll) {
                this.board.scroll(160, 213, 1);
            } else {
                this.board.scroll(BoardManager.boardXfixed, BoardManager.boardYfixed, 0);
            }
        }
    }

    public void processKeysGameDaily() {
    }

    public void processKeysGameBonus() {
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) {
                this.pressedUp = false;
                this.pressedDown = false;
                continue;
            }
            if (this.gameState == 1) {
                switch (key) {
                    case '*': {
                        if (!this.godMode) break;
                        this.debug = !this.debug;
                        break;
                    }
                    case '#': {
                        if (!this.godMode) break;
                        if (this.configSound) {
                            this.sound.playSound(this.soundWin, true);
                        }
                        this.board.setBoardState(2);
                        this.gameState = 2;
                        break;
                    }
                    case '\u0000': {
                        if (!BoardManager.zoomEnabled) break;
                        if (BoardManager.zoomState == 1) {
                            BoardManager.cellSizeFinal = BoardManager.minCellSize;
                        }
                        if (BoardManager.zoomState == 0) {
                            BoardManager.cellSizeFinal = BoardManager.maxCellSize;
                        }
                        BoardManager.zooming = true;
                        break;
                    }
                    case '\u0001': {
                        this.auxString = this.clock.getTimeString(3);
                        this.clock.stop();
                        this.board.setBoardState(5);
                        this.gameState = 5;
                        return;
                    }
                    case '\u0005': 
                    case '2': {
                        this.board.movePointer(0);
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        this.board.movePointer(1);
                        break;
                    }
                    case '\u0003': 
                    case '4': {
                        this.board.movePointer(2);
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        this.board.movePointer(3);
                        break;
                    }
                    case '\u0002': 
                    case '5': {
                        if (this.board.getCellDataInput() != 0 && this.board.getCellDataInput() != 2) break;
                        if (this.board.getCellDataBW() == 1) {
                            if (this.configSound) {
                                this.sound.playSound(this.sfxMark, false);
                            }
                            this.board.markCell((byte)1, false);
                            this.board.drawAnimation(-2, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                            if (!this.board.checkLevelCompleted()) break;
                            if (this.configSound) {
                                this.sound.playSound(this.soundWin, true);
                            }
                            this.board.setBoardState(2);
                            this.gameState = 2;
                            break;
                        }
                        if (this.configVibrate) {
                            Display.getDisplay((MIDlet)this.gm).vibrate(200);
                        }
                        if (this.configSound) {
                            this.sound.playSound(this.sfxError, false);
                        }
                        this.board.markCell((byte)2, true);
                        this.board.drawAnimation(-1, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        ++this.gcPenalties;
                        this.board.drawAnimation(Math.min(this.gcPenalties - 1, 8), this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                        this.clock.addTime(this.gcPenalties * 60 * 1000);
                        break;
                    }
                    case '0': {
                        if (this.board.getCellDataInput() != 0) break;
                        if (this.configSound) {
                            this.sound.playSound(this.sfxBlank, false);
                        }
                        this.board.markCell((byte)2, false);
                        this.board.drawAnimation(-1, this.board.getPointerXcenter(), this.board.getPointerYcenter(), System.currentTimeMillis());
                    }
                }
                continue;
            }
            if (this.gameState == 9) {
                if (this.configSound) {
                    if (this.sound.isSound(this.soundMusic)) {
                        this.sound.stopSound(this.soundMusic);
                    }
                    this.sound.playSound(this.soundStart, true);
                }
                this.board.setBoardState(1);
                this.gameState = 1;
                this.clock.start();
                continue;
            }
            if (this.gameState == 2) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        this.displayFullAd();
                        this.changeStateTo(7, 10);
                    }
                }
                continue;
            }
            if (this.gameState == 7) {
                if (!this.pressedAnyKey) continue;
                this.pressedAnyKey = false;
                this.displayFullAd();
                this.changeStateTo(7, 10);
                continue;
            }
            if (this.gameState == 11) {
                switch (key) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        this.board.setBoardState(5);
                        this.gameState = 5;
                        break;
                    }
                    case '\u0005': 
                    case '2': {
                        this.board.auxInt = Math.max(0, this.board.auxInt - 1);
                        this.pressedDown = false;
                        this.pressedUp = true;
                        this.timeScrollText = this.lastProcessTime + 200L;
                        break;
                    }
                    case '\u0006': 
                    case '8': {
                        ++this.board.auxInt;
                        this.pressedDown = true;
                        this.pressedUp = false;
                        this.timeScrollText = this.lastProcessTime + 200L;
                    }
                }
                continue;
            }
            if (this.gameState != 5) continue;
            switch (key) {
                case '\u0001': 
                case '\u0002': 
                case '5': {
                    if (this.board.itemSelected == 0) {
                        this.clock.start();
                        this.board.setBoardState(1);
                        this.gameState = 1;
                        break;
                    }
                    if (this.board.itemSelected == 1) {
                        this.board.setBoardState(11);
                        this.gameState = 11;
                        break;
                    }
                    if (this.board.itemSelected == 2) {
                        this.configSound = !this.configSound;
                        break;
                    }
                    if (this.board.itemSelected == 3) {
                        boolean bl = this.configVibrate = !this.configVibrate;
                        if (!this.configVibrate) break;
                        Display.getDisplay((MIDlet)this.gm).vibrate(200);
                        break;
                    }
                    if (this.board.itemSelected != 4) break;
                    this.changeStateTo(7, 10);
                    break;
                }
                case '\u0006': 
                case '8': {
                    this.board.setItemSelected(this.board.itemSelected + 1);
                    break;
                }
                case '\u0005': 
                case '2': {
                    this.board.setItemSelected(this.board.itemSelected - 1);
                }
            }
        }
        if (this.gameState == 1) {
            if (this.clock.getMilliseconds() >= 3600000L) {
                if (this.configSound) {
                    this.sound.playSound(this.soundLose, true);
                }
                this.board.setBoardState(7);
                this.gameState = 7;
            }
            if (BoardManager.zooming) {
                this.board.zoomChange();
            } else if (BoardManager.scroll) {
                this.board.scroll(160, 213, 1);
            } else {
                this.board.scroll(BoardManager.boardXfixed, BoardManager.boardYfixed, 0);
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.state) {
            case 10: {
                this.gc.paintLandscape(g);
                break;
            }
            case 4: {
                this.gc.paintSplash(g);
                break;
            }
            case 5: {
                this.gc.paintSoundQuestion(g);
                break;
            }
            case 6: {
                this.gc.paintCover(g);
                break;
            }
            case 7: {
                switch (this.menuActive) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.gc.paintMenuMain(g);
                        break;
                    }
                    case 6: {
                        this.gc.paintMenuProgress(g);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 11: {
                        this.gc.paintMenuInfo(g);
                        break;
                    }
                    case 8: {
                        this.gc.paintMenuClassic(g);
                        break;
                    }
                    case 9: {
                        this.gc.paintMenuQuest(g);
                        break;
                    }
                    case 10: {
                        this.gc.paintMenuBonus(g);
                    }
                }
                break;
            }
            case 8: {
                this.gc.paintBoard(g);
                break;
            }
            case 3: {
                this.gc.paintLoading(g);
                break;
            }
            case 1: 
            case 2: {
                this.gc.paintTransition(g);
                break;
            }
        }
        if (this.state != 10) {
            ++this.gameFramesAux;
            ++this.gameFrames;
        }
        if (this.debug) {
            SSDebug.paintDebug(g, SSKeyboard.getLastKeyCode(), this);
        }
    }

    public void saveGame(String recordStoreName) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            StringBuffer sb = new StringBuffer();
            if (recordStoreName.startsWith(GC_RMS_NAME)) {
                System.out.println("** saveGame(Game_Classic) **");
                sb.append(this.gcHighLevelCompleted);
                sb.append("#");
                sb.append(this.gcLastLevelPlayed);
                sb.append("#");
                for (int i = 0; i < 90; ++i) {
                    sb.append(this.gcHighScoresTime[i]);
                    sb.append("#");
                    sb.append(this.gcHighScoresPoints[i]);
                    sb.append("#");
                }
            } else if (recordStoreName.startsWith(GQ_RMS_NAME)) {
                System.out.println("** saveGame(Game_Quest) **");
                sb.append(this.gqLevelRow);
                sb.append("#");
                sb.append(this.gqLevelCol);
                sb.append("#");
                for (int i = 0; i < this.gqLevelState.length; ++i) {
                    sb.append(this.gqLevelState[i]);
                    sb.append("#");
                    sb.append(this.gqHighScoresPoints[i]);
                    sb.append("#");
                    sb.append(this.gqHighScoresTime[i]);
                    sb.append("#");
                }
            } else if (!recordStoreName.startsWith("Game_Daily")) {
                return;
            }
            dos.writeUTF(sb.toString());
            SSFunctions.store(recordStoreName, baos);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String parseRecord(String s) {
        if (s == null) {
            return "0";
        }
        String sParser = "";
        while (s.charAt(this.loadIndex) != '#') {
            sParser = sParser + s.charAt(this.loadIndex);
            ++this.loadIndex;
        }
        ++this.loadIndex;
        return sParser;
    }

    public void loadGame(String recordStoreName) {
        try {
            DataInputStream dis = SSFunctions.load(recordStoreName);
            if (dis == null) {
                this.saveGame(recordStoreName);
                return;
            }
            String s = dis.readUTF();
            dis.close();
            this.loadIndex = 0;
            if (recordStoreName.startsWith(GC_RMS_NAME)) {
                System.out.println("** loadGame(Game_Classic) **");
                this.gcHighLevelCompleted = Integer.parseInt(this.parseRecord(s));
                this.gcLastLevelPlayed = Integer.parseInt(this.parseRecord(s));
                for (int i = 0; i < 90; ++i) {
                    this.gcHighScoresTime[i] = Long.parseLong(this.parseRecord(s));
                    this.gcHighScoresPoints[i] = Integer.parseInt(this.parseRecord(s));
                }
            } else if (recordStoreName.startsWith(GQ_RMS_NAME)) {
                System.out.println("** loadGame(Game_Quest) **");
                this.gqLevelRow = Integer.parseInt(this.parseRecord(s));
                this.gqLevelCol = Integer.parseInt(this.parseRecord(s));
                for (int i = 0; i < this.gqLevelState.length; ++i) {
                    this.gqLevelState[i] = Integer.parseInt(this.parseRecord(s));
                    this.gqHighScoresPoints[i] = Integer.parseInt(this.parseRecord(s));
                    this.gqHighScoresTime[i] = Long.parseLong(this.parseRecord(s));
                }
            } else if (!recordStoreName.startsWith("Game_Daily")) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void garbageCollector() {
        System.gc();
    }

    private void cheat(char key) {
        this.godCounter = key == GOD_CODE.charAt(this.godCounter) ? ++this.godCounter : 0;
        if (this.godCounter == GOD_CODE.length()) {
            this.godMode = true;
            this.godCounter = 0;
            this.menuClassic.levelSelected = 88;
            this.menuClassic.levelHighest = 88;
            this.gcLastLevelPlayed = 88;
            this.gcHighLevelCompleted = 88;
        }
    }

    public void countProgress() {
        int i;
        this.configPictocubes = 0;
        this.configTotalPoints = 0;
        this.configLevelsClassic = 0;
        this.configLevelsQuest = 0;
        this.configPictocubes += this.gcHighLevelCompleted;
        if (this.gcHighLevelCompleted >= 90) {
            this.configPictocubes += 10;
        }
        this.configTotalPoints = SSMath.sum(this.gcHighScoresPoints) + SSMath.sum(this.gqHighScoresPoints);
        this.configLevelsClassic = Math.min(this.gcHighLevelCompleted, 90);
        for (i = 0; i < this.gqLevelState.length; ++i) {
            if (this.gqLevelState[i] != 2) continue;
            this.configPictocubes += 6;
            ++this.configLevelsQuest;
        }
        if (this.configLevelsQuest == 15) {
            this.configPictocubes += 10;
        }
        this.configTotalPoints += SSMath.sum(this.gqHighScoresPoints);
        this.gbMenuUnBlocked = 0;
        for (i = 0; i < this.gbPictocubesCost.length; ++i) {
            if (this.configPictocubes < this.gbPictocubesCost[i]) continue;
            ++this.gbMenuUnBlocked;
        }
    }

    public void showNotify() {
        this.gm.startApp();
    }

    public void hideNotify() {
        this.gm.pauseApp();
    }

    public void keyPressed(int keyCode) {
        this.keyboard.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.keyboard.keyReleased(keyCode);
    }

    public void run() {
        this.running = true;
        while (this.running) {
            this.lastProcessTime = System.currentTimeMillis() - this.pauseTime;
            this.process();
            this.repaint();
            this.serviceRepaints();
            long time = System.currentTimeMillis() - this.pauseTime;
            if (time - this.lastProcessTime < 40L) {
                this.sleep(40 - (int)(time - this.lastProcessTime));
                continue;
            }
            this.sleep(5);
        }
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

