/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

import com.inode.pictorama.GameEngine;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SSDebug {
    public static Font smallFont = Font.getFont((int)0, (int)0, (int)8);
    public static int heightFont = smallFont.getHeight();
    public static long memoryTotal = 0L;
    public static long memoryFree = 0L;
    public static long memoryUsed = 0L;
    public static long memoryPrevious = 0L;
    public static long fps = 0L;
    public static long fps_integer = 0L;
    public static long fps_decimal = 0L;
    public static long frameTime = System.currentTimeMillis();
    public static long frameTimeTotal = 0L;
    public static long frameCount = 0L;

    public static void paintDebug(Graphics g, int lastKeyCode, int width, int height, long frames, long time) {
        memoryTotal = Runtime.getRuntime().totalMemory();
        if (memoryTotal - (memoryFree = Runtime.getRuntime().freeMemory()) < memoryPrevious && memoryTotal - memoryFree > memoryUsed) {
            memoryUsed = memoryTotal - memoryFree;
        }
        memoryPrevious = memoryTotal - memoryFree;
        g.setFont(smallFont);
        g.setColor(0);
        g.setClip(0, 0, width, heightFont);
        g.fillRect(0, 0, width, heightFont);
        g.setColor(0xFFFFFF);
        g.drawString((memoryUsed >> 10) + "/" + (memoryTotal - memoryFree >> 10) + "/" + (memoryTotal >> 10) + "KB.", 0, 0, 20);
        if (time > 1024L) {
            fps = 10L * frames / (time >> 10);
            fps_integer = fps / 10L;
            fps_decimal = fps % 10L;
            g.drawString(fps_integer + "." + fps_decimal + "fps", width, 0, 24);
        }
        g.setColor(0);
        g.setClip(0, height - heightFont, width, heightFont);
        g.fillRect(0, height - heightFont, width, heightFont);
        g.setColor(0xFFFFFF);
        if (lastKeyCode != 0) {
            g.drawString("keyCode: " + lastKeyCode, 0, height, 36);
        }
        g.drawString(width + "x" + height + "px", width, height, 40);
    }

    public static void paintDebug(Graphics g, int lastKeyCode, GameEngine ge) {
        frameTimeTotal += System.currentTimeMillis() - frameTime;
        frameTime = System.currentTimeMillis();
        SSDebug.paintDebug(g, lastKeyCode, ge.getWidth(), ge.getHeight(), ++frameCount, frameTimeTotal);
        if (ge.sound.isSound()) {
            g.drawString(">", ge.getWidth() / 2, ge.getHeight(), 33);
        } else {
            g.drawString("|", ge.getWidth() / 2, ge.getHeight(), 33);
        }
    }
}

