/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

import java.io.IOException;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class SSSMS {
    public static boolean sendText(String toAddress, int smsPort, String smsText) {
        toAddress = "sms://" + toAddress;
        if (smsPort != 0) {
            toAddress = toAddress + ":" + smsPort;
        }
        MessageConnection smsConnection = null;
        try {
            if (smsConnection == null) {
                smsConnection = (MessageConnection)UnAds.open(toAddress);
            }
            TextMessage txtMessage = (TextMessage)smsConnection.newMessage("text");
            txtMessage.setAddress(toAddress);
            txtMessage.setPayloadText(smsText);
            smsConnection.send((Message)txtMessage);
        }
        catch (IOException ioe) {
            System.out.println("Send text SMS message caught: ");
            ioe.printStackTrace();
            return false;
        }
        if (smsConnection != null) {
            try {
                smsConnection.close();
            }
            catch (IOException ioe) {
                System.out.println("Closing text SMS connection caught: ");
                ioe.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean sendBinary(String toAddress, int smsPort, byte[] smsData) {
        toAddress = "sms://" + toAddress;
        if (smsPort != 0) {
            toAddress = toAddress + ":" + smsPort;
        }
        MessageConnection smsConnection = null;
        try {
            if (smsConnection == null) {
                smsConnection = (MessageConnection)UnAds.open(toAddress);
            }
            BinaryMessage binMessage = (BinaryMessage)smsConnection.newMessage("binary");
            binMessage.setAddress(toAddress);
            binMessage.setPayloadData(smsData);
            smsConnection.send((Message)binMessage);
        }
        catch (Throwable t) {
            System.out.println("Send binary SMS message caught: ");
            t.printStackTrace();
            return false;
        }
        if (smsConnection != null) {
            try {
                smsConnection.close();
            }
            catch (IOException ioe) {
                System.out.println("Closing binary SMS connection caught: ");
                ioe.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static long getCRC32(byte[] buf) {
        int c;
        int off = 0;
        int len = buf.length;
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public static long getCRC32(String text) {
        return SSSMS.getCRC32(text.getBytes());
    }
}

