/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;

public class XMLElement {
    private XMLElement next;
    private XMLElement prev;
    private String name;
    private Hashtable items;
    private Hashtable attributes;
    private Vector itemsList;
    private Vector attributesList;
    private String value;
    private int counter;
    public static String upperStr = "ABWGDEVZIJKLMNOPRSTUFHCQYX\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";
    public static String lowerStr = "abwgdevzijklmnoprstufhcqyx\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044a\u044c\u044d\u044e\u044f";

    XMLElement(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    final void addItem(XMLElement xMLElement) {
        XMLElement xMLElement2;
        if (this.items == null) {
            this.items = new Hashtable();
            this.itemsList = new Vector();
        }
        if ((xMLElement2 = (XMLElement)this.items.get(xMLElement.name)) != null) {
            xMLElement.next = null;
            xMLElement.prev = xMLElement2.prev;
            xMLElement.prev.next = xMLElement;
            xMLElement2.prev = xMLElement;
            ++xMLElement2.counter;
        } else {
            this.items.put(xMLElement.name, xMLElement);
            xMLElement.prev = xMLElement;
            xMLElement.counter = 1;
        }
        this.itemsList.addElement(xMLElement);
    }

    final void addAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = new XMLAttribute(string, string2);
        if (this.attributes == null) {
            this.attributes = new Hashtable();
            this.attributesList = new Vector();
        }
        this.attributesList.addElement(xMLAttribute);
        this.attributes.put(string, xMLAttribute);
    }

    final Vector getItems() {
        return this.itemsList;
    }

    final Vector getAttributes() {
        return this.attributesList;
    }

    final XMLElement getItem(String string) {
        XMLElement xMLElement;
        if (this.items != null && (xMLElement = (XMLElement)this.items.get(string)) != null) {
            return xMLElement;
        }
        return null;
    }

    final XMLElement getNextItem() {
        return this.next;
    }

    final int getCounter() {
        return this.counter;
    }

    final XMLAttribute getAttribute(String string) {
        return this.attributes != null ? (XMLAttribute)this.attributes.get(string) : null;
    }

    final void setValue(String string) {
        this.value = string;
    }

    final String getValue() {
        return this.value;
    }

    final int getIntValue() {
        if (this.value == null) {
            throw new XMLException("Value not set");
        }
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLException("Element value '" + this.value + "' is not an integer constant");
        }
    }

    public String toUpperCase(String string) {
        String string2 = "";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = lowerStr.indexOf(c);
            string2 = n2 > -1 ? string2 + upperStr.charAt(n2) : string2 + c;
        }
        return string2;
    }

    public Vector search(String string) {
        Vector<XMLElement> vector = new Vector<XMLElement>();
        string = this.toUpperCase(string.trim());
        if (this.itemsList != null) {
            int n;
            int n2 = n = this.itemsList.size();
            while (--n2 >= 0) {
                XMLElement xMLElement = (XMLElement)this.itemsList.elementAt(n2);
                if (xMLElement.searchItems(string)) {
                    vector.addElement(xMLElement);
                }
                if (n2 % 10 != 0) continue;
                SearchBox.box.setTitle(SearchBox.boxHdr + ": " + (n - n2) * 100 / n + "%");
            }
            SearchBox.box.setTitle(SearchBox.boxHdr);
        }
        return vector;
    }

    private boolean searchItems(String string) {
        Object object;
        int n;
        if (this.toUpperCase(this.name).equals(string)) {
            return true;
        }
        if (this.value != null && this.toUpperCase(this.value).indexOf(string) >= 0) {
            return true;
        }
        if (this.attributesList != null) {
            n = this.attributesList.size();
            while (--n >= 0) {
                object = (XMLAttribute)this.attributesList.elementAt(n);
                if ((((XMLAttribute)object).getName() == null || !this.toUpperCase(((XMLAttribute)object).getName()).equals(string)) && (((XMLAttribute)object).getValue() == null || this.toUpperCase(((XMLAttribute)object).getValue()).indexOf(string) < 0)) continue;
                return true;
            }
        }
        if (this.itemsList != null) {
            n = this.itemsList.size();
            while (--n >= 0) {
                object = (XMLElement)this.itemsList.elementAt(n);
                if (!super.searchItems(string)) continue;
                return true;
            }
        }
        return false;
    }
}

