/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;

public class RGBImage
extends Image {
    public int width;
    public int height;
    public int[] rgb;
    public boolean opaque;

    public RGBImage(Image img) {
        super(null);
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.rgb = img.getRGBCached();
    }

    public RGBImage(int[] rgb, int width, int height) {
        super(null);
        this.width = width;
        this.height = height;
        this.rgb = rgb;
    }

    public Image subImage(int x, int y, int width, int height, boolean processAlpha) {
        int[] arr = new int[width * height];
        for (int iter = 0; iter < arr.length; ++iter) {
            int destY = iter / width;
            int destX = iter % width;
            int offset = x + destX + (y + destY) * this.width;
            arr[iter] = this.rgb[offset];
        }
        return new RGBImage(arr, width, height);
    }

    public Image scaled(int width, int height) {
        int srcWidth = this.getWidth();
        int srcHeight = this.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return this;
        }
        int[] currentArray = new int[srcWidth];
        int[] destinationArray = new int[width * height];
        this.scaleArray(srcWidth, srcHeight, height, width, currentArray, destinationArray);
        return new RGBImage(destinationArray, width, height);
    }

    public void scale(int width, int height) {
        int srcWidth = this.getWidth();
        int srcHeight = this.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return;
        }
        int[] currentArray = new int[srcWidth];
        int[] destinationArray = new int[width * height];
        this.scaleArray(srcWidth, srcHeight, height, width, currentArray, destinationArray);
        this.width = width;
        this.height = height;
        this.rgb = destinationArray;
    }

    public Image rotate(int degrees) {
        throw new RuntimeException("The rotate method is not supported by RGB images at the moment");
    }

    public Image modifyAlpha(byte alpha) {
        int[] arr = new int[this.rgb.length];
        System.arraycopy(this.rgb, 0, arr, 0, this.rgb.length);
        int alphaInt = alpha << 24 & 0xFF000000;
        for (int iter = 0; iter < this.rgb.length; ++iter) {
            if ((arr[iter] & 0xFF000000) == 0) continue;
            arr[iter] = arr[iter] & 0xFFFFFF | alphaInt;
        }
        return new RGBImage(arr, this.width, this.height);
    }

    public Graphics getGraphics() {
        throw new RuntimeException("RGBImage objects can't be modified via graphics");
    }

    public int[] getRGB() {
        return this.rgb;
    }

    void getRGB(int[] rgbData, int offset, int x, int y, int width, int height) {
        int startPoint = y * this.width + x;
        for (int rows = 0; rows < height; ++rows) {
            int currentRow = rows * width;
            for (int columns = 0; columns < width; ++columns) {
                rgbData[offset + currentRow + columns] = this.rgb[startPoint + columns];
            }
            startPoint += this.width;
        }
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        g.drawRGB(this.rgb, 0, x, y, this.width, this.height, !this.opaque);
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

