/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.CellRenderer;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class ContainerList
extends Container {
    public CellRenderer renderer = new DefaultListCellRenderer();
    public ListModel model;
    public Listeners listener;
    public EventDispatcher dispatcher = new EventDispatcher();
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$com$sun$lwuit$list$CellRenderer;

    public ContainerList() {
        this(new DefaultListModel());
    }

    public ContainerList(ListModel m) {
        this.init(m);
    }

    private void init(ListModel m) {
        this.setModel(m);
        this.setUIID("ContainerList");
        this.setScrollableY(true);
    }

    public ContainerList(Layout l, ListModel m) {
        super(l);
        this.init(m);
    }

    public void setRenderer(CellRenderer r) {
        this.renderer = r;
        this.repaint();
    }

    public CellRenderer getRenderer() {
        return this.renderer;
    }

    private void updateComponentCount() {
        block4: {
            int modelCount;
            int cc = this.getComponentCount();
            if (cc == (modelCount = this.model.getSize())) break block4;
            if (cc < modelCount) {
                for (int iter = cc; iter < modelCount; ++iter) {
                    this.addComponent(new Entry(iter));
                }
            } else {
                while (this.getComponentCount() > modelCount) {
                    this.removeComponent(this.getComponentAt(this.getComponentCount() - 1));
                }
            }
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    protected void initComponent() {
        int i;
        if (this.model != null && (i = this.model.getSelectedIndex()) > 0) {
            this.getComponentAt(i).requestFocus();
        }
    }

    public void setModel(ListModel model) {
        if (this.model != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
        this.model = model;
        this.updateComponentCount();
        if (model.getSelectedIndex() > 0) {
            this.getComponentAt(model.getSelectedIndex()).requestFocus();
        }
        if (this.isInitialized()) {
            this.bindListeners();
        }
        this.repaint();
    }

    private void bindListeners() {
        if (this.listener == null) {
            this.listener = new Listeners();
            this.model.addDataChangedListener(this.listener);
            this.model.addSelectionListener(this.listener);
        }
    }

    public Object getSelectedItem() {
        int i = this.model.getSelectedIndex();
        if (i > -1) {
            return this.model.getItemAt(i);
        }
        return null;
    }

    public String[] getPropertyNames() {
        return new String[]{"ListItems", "Renderer"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ContainerList.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$com$sun$lwuit$list$CellRenderer == null ? (class$com$sun$lwuit$list$CellRenderer = ContainerList.class$("com.sun.lwuit.list.CellRenderer")) : class$com$sun$lwuit$list$CellRenderer};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("ListItems")) {
            Object[] obj = new Object[this.model.getSize()];
            for (int iter = 0; iter < obj.length; ++iter) {
                obj[iter] = this.model.getItemAt(iter);
            }
            return obj;
        }
        if (name.equals("Renderer")) {
            return this.getRenderer();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("ListItems")) {
            this.setModel(new DefaultListModel((Object[])value));
            return null;
        }
        if (name.equals("Renderer")) {
            this.setRenderer((CellRenderer)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listeners
    implements DataChangedListener,
    SelectionListener {
        private Listeners() {
        }

        public void dataChanged(int status, int index) {
            ContainerList.this.updateComponentCount();
        }

        public void selectionChanged(int oldSelected, int newSelected) {
            ContainerList.this.getComponentAt(newSelected).requestFocus();
        }
    }

    class Entry
    extends Component {
        public int offset;

        Entry(int off) {
            this.setFocusable(true);
            this.offset = off;
        }

        public void initComponent() {
            this.offset = this.getParent().getComponentIndex(this);
        }

        protected void focusGained() {
            ContainerList.this.model.setSelectedIndex(this.offset);
        }

        public void paintBackground(Graphics g) {
        }

        public void paintBorder(Graphics g) {
        }

        public void paint(Graphics g) {
            Component cmp = ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus());
            cmp.setX(this.getX());
            cmp.setY(this.getY());
            cmp.setWidth(this.getWidth());
            cmp.setHeight(this.getHeight());
            cmp.paintComponent(g);
        }

        public void pointerReleased(int x, int y) {
            super.pointerReleased(x, y);
            if (!this.isDragActivated()) {
                ContainerList.this.dispatcher.fireActionEvent(new ActionEvent(ContainerList.this, x, y));
            }
        }

        public void keyReleased(int keyCode) {
            super.keyReleased(keyCode);
            if (Display.getInstance().getGameAction(keyCode) == 8) {
                ContainerList.this.dispatcher.fireActionEvent(new ActionEvent(ContainerList.this, keyCode));
            }
        }

        public Dimension calcPreferredSize() {
            return ContainerList.this.renderer.getCellRendererComponent(ContainerList.this, ContainerList.this.model, ContainerList.this.model.getItemAt(this.offset), this.offset, this.hasFocus()).getPreferredSize();
        }
    }
}

