/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.payment.NPayException;
import com.nokia.payment.NPayListener;
import com.nokia.payment.NPayManager;
import com.nokia.payment.ProductData;
import com.nokia.payment.PurchaseData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotOpenException;
import race.FTCMIDlet;
import trybuylocalization.L10nResources;
import trybuylocalization.StringTools;

public class TryAndBuyWrapper
extends FTCMIDlet
implements NPayListener {
    private static final String VERSION = "1.0.1";
    private String midlet_name = null;
    private String PRODUCT_ID = null;
    private Display display = null;
    private TryAndBuyButtonHandler commandHandler = null;
    public static int TRY_AND_BUY_STATUS = 1;
    public static int TRY_AND_BUY_PRICE_BEFORE_PURCHASE = 2;
    public static int TRY_AND_BUY_FIRST_RUN = 3;
    public static int TRY_AND_BUY_EXEC_COUNT = 4;
    public static int TRY_AND_BUY_TIME_LEFT = 5;
    public static int TRY_AND_BUY_STATUS_VALUE_TRIAL = 0;
    public static int TRY_AND_BUY_STATUS_VALUE_IN_PURCHASE = 1;
    public static int TRY_AND_BUY_STATUS_VALUE_FULL = 2;
    private RecordStore recordStore = null;
    private static final String TRYANDBUY_RECORDSTORE_NAME = "TryAndBuy";
    private long firstRunTime = -1L;
    private int tryAndBuyStatus = TRY_AND_BUY_STATUS_VALUE_TRIAL;
    private long execCount = 0L;
    private long lastKnownTimeLeft = -1L;
    private boolean lastKnownTimeLeftSet = false;
    private long limit_time = -1L;
    private long limit_exec = -1L;
    private Timer trialTimer = null;
    public static final String TRY_AND_BUY_LIMIT_TIME = "TryAndBuy-Limit-Time-Seconds";
    public static final String TRY_AND_BUY_LIMIT_EXEC = "TryAndBuy-Limit-Exec-Count";
    public static final String TRY_AND_BUY_PRODUCT_ID = "TryAndBuy-Product-id";
    public static final String TRY_AND_BUY_PRICE_POINT = "TryAndBuy-Price-Point";
    public static final String MIDLET_NAME = "MIDlet-Name";
    private String priceToShow = null;
    private NPayManager npayManager = null;
    L10nResources l10n = L10nResources.getL10nResources(null);
    Form trialForm = null;
    Alert installConfirm;
    boolean startupComplete = false;
    Object startupMonitor = new Object();

    public TryAndBuyWrapper() {
        this.display = Display.getDisplay((MIDlet)this);
        String midletNameProperty = this.getAppProperty(MIDLET_NAME);
        String timeLimitProperty = this.getAppProperty(TRY_AND_BUY_LIMIT_TIME);
        String execLimitProperty = this.getAppProperty(TRY_AND_BUY_LIMIT_EXEC);
        String productIdProperty = this.getAppProperty(TRY_AND_BUY_PRODUCT_ID);
        this.midlet_name = midletNameProperty != null ? midletNameProperty : "Trial";
        if (timeLimitProperty != null) {
            try {
                this.limit_time = Long.parseLong(timeLimitProperty);
                this.limit_time *= 1000L;
            }
            catch (NumberFormatException e2) {
                this.limit_time = -1L;
            }
        }
        if (execLimitProperty != null) {
            try {
                this.limit_exec = Long.parseLong(execLimitProperty);
            }
            catch (NumberFormatException e3) {
                this.limit_exec = -1L;
            }
        }
        if (productIdProperty != null) {
            this.PRODUCT_ID = productIdProperty;
        }
        UnDemo.out.println("midlet name: " + this.midlet_name);
        UnDemo.out.println("limit_time: " + this.limit_time);
        UnDemo.out.println("limit_exec: " + this.limit_exec);
        UnDemo.out.println("Product ID: " + this.PRODUCT_ID);
        try {
            this.recordStore = RecordStore.openRecordStore((String)TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
        }
        catch (Exception e4) {
            // empty catch block
        }
        if (this.recordStore != null) {
            byte[] tryAndBuyStatusRecord = null;
            try {
                tryAndBuyStatusRecord = this.recordStore.getRecord(TRY_AND_BUY_STATUS);
            }
            catch (RecordStoreNotOpenException e1) {
            }
            catch (InvalidRecordIDException e1) {
            }
            catch (RecordStoreException e1) {
                // empty catch block
            }
            if (tryAndBuyStatusRecord != null) {
                try {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tryAndBuyStatusRecord));
                    this.tryAndBuyStatus = dis.readInt();
                    dis.close();
                }
                catch (IOException e5) {}
            } else {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeInt(this.tryAndBuyStatus);
                    dos.close();
                    tryAndBuyStatusRecord = baos.toByteArray();
                    if (this.recordStore.getNextRecordID() == TRY_AND_BUY_STATUS) {
                        this.recordStore.addRecord(tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                    } else {
                        this.recordStore.setRecord(TRY_AND_BUY_STATUS, tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                    }
                }
                catch (RecordStoreNotOpenException e6) {
                }
                catch (InvalidRecordIDException e7) {
                }
                catch (RecordStoreException e8) {
                }
                catch (IOException e9) {
                    // empty catch block
                }
            }
            byte[] firstRunRecord = null;
            try {
                firstRunRecord = this.recordStore.getRecord(TRY_AND_BUY_FIRST_RUN);
            }
            catch (RecordStoreNotOpenException e10) {
            }
            catch (InvalidRecordIDException e11) {
            }
            catch (RecordStoreException e12) {
                // empty catch block
            }
            try {
                if (firstRunRecord != null) {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(firstRunRecord));
                    this.firstRunTime = dis.readLong();
                    dis.close();
                }
            }
            catch (IOException e13) {
                // empty catch block
            }
            byte[] execCountRecord = null;
            try {
                execCountRecord = this.recordStore.getRecord(TRY_AND_BUY_EXEC_COUNT);
            }
            catch (RecordStoreNotOpenException e1) {
            }
            catch (InvalidRecordIDException e1) {
            }
            catch (RecordStoreException e1) {
                // empty catch block
            }
            try {
                if (execCountRecord != null) {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(execCountRecord));
                    this.execCount = dis.readLong();
                    dis.close();
                }
            }
            catch (IOException e14) {
                // empty catch block
            }
            byte[] lastKnownTimeLeftRecord = null;
            try {
                lastKnownTimeLeftRecord = this.recordStore.getRecord(TRY_AND_BUY_TIME_LEFT);
            }
            catch (RecordStoreNotOpenException e15) {
            }
            catch (InvalidRecordIDException e16) {
            }
            catch (RecordStoreException e17) {
                // empty catch block
            }
            try {
                if (lastKnownTimeLeftRecord != null) {
                    this.lastKnownTimeLeftSet = true;
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(lastKnownTimeLeftRecord));
                    this.lastKnownTimeLeft = dis.readLong();
                    dis.close();
                }
            }
            catch (IOException e18) {
                // empty catch block
            }
            try {
                this.recordStore.closeRecordStore();
                this.recordStore = null;
            }
            catch (RecordStoreNotOpenException e19) {
            }
            catch (RecordStoreException e20) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApp() {
        if (!this.isTryAndBuyEnabled() || !this.isTrialMode()) {
            super.startApp();
            return;
        }
        try {
            this.npayManager = new NPayManager(this);
            this.npayManager.setNPayListener(this);
        }
        catch (NPayException e2) {
            // empty catch block
        }
        this.commandHandler = new TryAndBuyButtonHandler(this);
        this.installConfirm = new Alert("Missing MIDlet", "You have to install IAPMidlet", null, AlertType.CONFIRMATION);
        this.installConfirm.addCommand(this.commandHandler.installConfirmOk);
        this.installConfirm.addCommand(this.commandHandler.installConfirmCancel);
        this.installConfirm.setCommandListener((CommandListener)this.commandHandler);
        this.installConfirm.setTimeout(-2);
        if (this.tryAndBuyStatus == TRY_AND_BUY_STATUS_VALUE_IN_PURCHASE) {
            Object e2 = this.startupMonitor;
            synchronized (e2) {
                this.startupComplete = true;
                this.startupMonitor.notifyAll();
            }
            return;
        }
        try {
            this.npayManager.getProductData(new String[]{this.PRODUCT_ID});
        }
        catch (NPayException e3) {
            this.priceToShow = "";
            this.displayTrialScreen();
        }
        Object object = this.startupMonitor;
        synchronized (object) {
            this.startupComplete = true;
            this.startupMonitor.notifyAll();
        }
    }

    public void pauseApp() {
        super.pauseApp();
    }

    public void destroyApp(boolean arg0) {
        super.destroyApp(arg0);
    }

    private boolean isTryAndBuyEnabled() {
        boolean result = true;
        result = this.limit_time > -1L || this.limit_exec > -1L;
        return result;
    }

    private boolean isTrialMode() {
        boolean trialMode = true;
        trialMode = this.tryAndBuyStatus != TRY_AND_BUY_STATUS_VALUE_FULL;
        return trialMode;
    }

    private boolean isTrialExpired() {
        boolean isExpired = false;
        boolean timer_expired = false;
        if (this.limit_time > -1L) {
            UnDemo.out.println("We have time limit as " + this.limit_time);
            UnDemo.out.println("Last known time left as " + this.lastKnownTimeLeft);
            if (this.lastKnownTimeLeftSet) {
                UnDemo.out.println("time left was set");
                timer_expired = this.lastKnownTimeLeft <= 0L;
            } else {
                UnDemo.out.println("We have no information abouit last known time left");
                timer_expired = this.limit_time > -1L && this.firstRunTime > -1L && UnDemo.currentTimeMillis() - this.firstRunTime >= this.limit_time;
            }
            UnDemo.out.println("timer expired: " + timer_expired);
        }
        boolean exec_exceeded = this.limit_exec > -1L && this.execCount >= this.limit_exec;
        isExpired = timer_expired || exec_exceeded;
        return isExpired;
    }

    private void displayTrialScreen() {
        String trialText;
        this.trialForm = new Form(this.l10n.getString("TEXT_FORM_TITLE"));
        String buyButtonText = StringTools.replace("${price}", this.priceToShow, this.l10n.getString("BUTTON_BUY"));
        StringItem buyButton = new StringItem(null, buyButtonText, 2);
        buyButton.setDefaultCommand(this.commandHandler.buyCommand);
        buyButton.setItemCommandListener((ItemCommandListener)this.commandHandler);
        StringItem useButton = new StringItem(null, this.l10n.getString("BUTTON_GO_TO_TRIAL"), 2);
        useButton.setDefaultCommand(this.commandHandler.useCommand);
        useButton.setItemCommandListener((ItemCommandListener)this.commandHandler);
        StringItem cancelButton = new StringItem(null, this.l10n.getString("BUTTON_QUIT"), 2);
        cancelButton.setDefaultCommand(this.commandHandler.cancelCommand);
        cancelButton.setItemCommandListener((ItemCommandListener)this.commandHandler);
        if (this.isTrialExpired()) {
            trialText = this.l10n.getString("TEXT_TRIAL_EXPIRED");
            this.trialForm.append((Item)new StringItem(null, trialText));
            this.trialForm.append((Item)buyButton);
            this.trialForm.append((Item)cancelButton);
        } else {
            String timeLimit = null;
            String tryLimit = null;
            if (this.limit_time > -1L) {
                long timeValue = -1L;
                String timeUnit = "";
                if (!this.lastKnownTimeLeftSet) {
                    this.lastKnownTimeLeft = this.limit_time;
                }
                if (this.lastKnownTimeLeft < 60000L) {
                    timeValue = this.lastKnownTimeLeft / 1000L;
                    timeUnit = this.l10n.getString("TEXT_TIME_UNIT_SECOND_SINGLE");
                    if (timeValue > 1L) {
                        timeUnit = this.l10n.getString("TEXT_TIME_UNIT_SECOND_MULTI");
                    }
                } else {
                    timeValue = this.lastKnownTimeLeft / 60000L;
                    timeUnit = this.l10n.getString("TEXT_TIME_UNIT_MINUTE_SINGLE");
                    if (timeValue > 1L) {
                        timeUnit = this.l10n.getString("TEXT_TIME_UNIT_MINUTE_MULTI");
                    }
                }
                timeLimit = timeValue + " " + timeUnit;
            }
            if (this.limit_exec > -1L) {
                long triesLeft = this.limit_exec - this.execCount;
                tryLimit = triesLeft + " ";
                tryLimit = triesLeft > 1L ? tryLimit + this.l10n.getString("TEXT_MULTIPLE_TRIES_LEFT") : tryLimit + this.l10n.getString("TEXT_SINGLE_TRY_LEFT");
            }
            trialText = this.l10n.getString("TEXT_TRIAL_BEGINNING") + " ";
            if (timeLimit != null) {
                trialText = trialText + timeLimit;
                if (tryLimit != null) {
                    trialText = trialText + " " + this.l10n.getString("SEPARATOR_TIME_OR_TRY") + " ";
                }
            }
            if (tryLimit != null) {
                trialText = trialText + tryLimit;
            }
            this.trialForm.append((Item)new StringItem(this.midlet_name, trialText));
            this.trialForm.append((Item)buyButton);
            this.trialForm.append((Item)useButton);
            this.trialForm.append((Item)cancelButton);
        }
        StringItem versionStringItem = new StringItem(null, VERSION);
        versionStringItem.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.trialForm.append((Item)versionStringItem);
        this.display.setCurrent((Displayable)this.trialForm);
    }

    public void purchaseApp() {
        block18: {
            if (!this.npayManager.isNPayAvailable()) {
                this.display.setCurrent(this.installConfirm, (Displayable)this.trialForm);
            } else {
                try {
                    if (this.PRODUCT_ID == null) break block18;
                    this.tryAndBuyStatus = TRY_AND_BUY_STATUS_VALUE_IN_PURCHASE;
                    try {
                        this.recordStore = RecordStore.openRecordStore((String)TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    byte[] tryAndBuyStatusRecord = null;
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        DataOutputStream dos = new DataOutputStream(baos);
                        dos.writeInt(this.tryAndBuyStatus);
                        dos.close();
                        tryAndBuyStatusRecord = baos.toByteArray();
                        if (this.recordStore.getNextRecordID() == TRY_AND_BUY_STATUS) {
                            this.recordStore.addRecord(tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                        } else {
                            this.recordStore.setRecord(TRY_AND_BUY_STATUS, tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                        }
                    }
                    catch (RecordStoreNotOpenException e3) {
                    }
                    catch (InvalidRecordIDException e4) {
                    }
                    catch (RecordStoreException e5) {
                    }
                    catch (IOException e6) {
                        // empty catch block
                    }
                    try {
                        this.recordStore.closeRecordStore();
                        this.recordStore = null;
                    }
                    catch (RecordStoreNotOpenException e7) {
                    }
                    catch (RecordStoreException recordStoreException) {
                        // empty catch block
                    }
                    this.npayManager.purchaseProduct(this.PRODUCT_ID);
                }
                catch (SecurityException e8) {
                }
                catch (IllegalStateException e9) {
                }
                catch (NPayException nPayException) {
                    // empty catch block
                }
            }
        }
    }

    public void launchApp() {
        long timeLeft = 0L;
        long lastRecordedTimeLeft = 0L;
        try {
            this.recordStore = RecordStore.openRecordStore((String)TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (this.recordStore != null) {
            byte[] firstRunRecord = null;
            try {
                firstRunRecord = this.recordStore.getRecord(TRY_AND_BUY_FIRST_RUN);
            }
            catch (RecordStoreNotOpenException e3) {
            }
            catch (InvalidRecordIDException e4) {
            }
            catch (RecordStoreException e5) {
                // empty catch block
            }
            try {
                if (firstRunRecord == null) {
                    this.firstRunTime = UnDemo.currentTimeMillis();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeLong(this.firstRunTime);
                    dos.close();
                    firstRunRecord = baos.toByteArray();
                    if (this.recordStore.getNextRecordID() == TRY_AND_BUY_FIRST_RUN) {
                        this.recordStore.addRecord(firstRunRecord, 0, firstRunRecord.length);
                    } else {
                        this.recordStore.setRecord(TRY_AND_BUY_FIRST_RUN, firstRunRecord, 0, firstRunRecord.length);
                    }
                }
            }
            catch (RecordStoreNotOpenException e6) {
            }
            catch (InvalidRecordIDException e7) {
            }
            catch (RecordStoreException e8) {
            }
            catch (IOException e9) {
                // empty catch block
            }
            this.execCount = 0L;
            byte[] execCountRecord = null;
            try {
                execCountRecord = this.recordStore.getRecord(TRY_AND_BUY_EXEC_COUNT);
            }
            catch (RecordStoreNotOpenException e1) {
            }
            catch (InvalidRecordIDException e1) {
            }
            catch (RecordStoreException e1) {
                // empty catch block
            }
            try {
                if (execCountRecord != null) {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(execCountRecord));
                    this.execCount = dis.readLong();
                    dis.close();
                }
                UnDemo.out.println("Have been executed times: " + this.execCount);
                ++this.execCount;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeLong(this.execCount);
                dos.close();
                execCountRecord = baos.toByteArray();
            }
            catch (IOException e10) {
                // empty catch block
            }
            try {
                if (this.recordStore.getNextRecordID() == TRY_AND_BUY_EXEC_COUNT) {
                    this.recordStore.addRecord(execCountRecord, 0, execCountRecord.length);
                } else {
                    this.recordStore.setRecord(TRY_AND_BUY_EXEC_COUNT, execCountRecord, 0, execCountRecord.length);
                }
            }
            catch (RecordStoreNotOpenException e11) {
            }
            catch (InvalidRecordIDException e12) {
            }
            catch (RecordStoreException e13) {
                // empty catch block
            }
            byte[] lastRecordedTimeLeftRecord = null;
            if (this.limit_time > -1L) {
                try {
                    lastRecordedTimeLeftRecord = this.recordStore.getRecord(TRY_AND_BUY_TIME_LEFT);
                }
                catch (RecordStoreNotOpenException e14) {
                }
                catch (InvalidRecordIDException e15) {
                }
                catch (RecordStoreException e16) {
                    // empty catch block
                }
                if (lastRecordedTimeLeftRecord != null) {
                    try {
                        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(lastRecordedTimeLeftRecord));
                        lastRecordedTimeLeft = dis.readLong();
                        dis.close();
                    }
                    catch (IOException e17) {}
                } else {
                    lastRecordedTimeLeft = this.limit_time - (UnDemo.currentTimeMillis() - this.firstRunTime);
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        DataOutputStream dos = new DataOutputStream(baos);
                        dos.writeLong(lastRecordedTimeLeft);
                        dos.close();
                        lastRecordedTimeLeftRecord = baos.toByteArray();
                        this.recordStore.addRecord(lastRecordedTimeLeftRecord, 0, lastRecordedTimeLeftRecord.length);
                    }
                    catch (RecordStoreNotOpenException e18) {
                    }
                    catch (RecordStoreFullException e19) {
                    }
                    catch (RecordStoreException e20) {
                    }
                    catch (IOException e21) {
                        // empty catch block
                    }
                }
                UnDemo.out.println("Time left: " + timeLeft);
            }
            try {
                this.recordStore.closeRecordStore();
                this.recordStore = null;
            }
            catch (RecordStoreNotOpenException e22) {
            }
            catch (RecordStoreException e23) {
                // empty catch block
            }
        }
        TimerTask task = new TimerTask(){

            public void run() {
                long tmpTimeLeft = 0L;
                try {
                    TryAndBuyWrapper.this.recordStore = RecordStore.openRecordStore((String)TryAndBuyWrapper.TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                byte[] tmpLastRecordedTimeLeftRecord = null;
                try {
                    tmpLastRecordedTimeLeftRecord = TryAndBuyWrapper.this.recordStore.getRecord(TRY_AND_BUY_TIME_LEFT);
                }
                catch (RecordStoreNotOpenException e3) {
                }
                catch (InvalidRecordIDException e4) {
                }
                catch (RecordStoreException e5) {
                    // empty catch block
                }
                if (tmpLastRecordedTimeLeftRecord != null) {
                    try {
                        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tmpLastRecordedTimeLeftRecord));
                        tmpTimeLeft = dis.readLong();
                        dis.close();
                    }
                    catch (IOException e6) {
                        // empty catch block
                    }
                }
                tmpTimeLeft -= 1000L;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeLong(tmpTimeLeft);
                    dos.close();
                    tmpLastRecordedTimeLeftRecord = baos.toByteArray();
                    TryAndBuyWrapper.this.recordStore.setRecord(TRY_AND_BUY_TIME_LEFT, tmpLastRecordedTimeLeftRecord, 0, tmpLastRecordedTimeLeftRecord.length);
                }
                catch (RecordStoreNotOpenException e7) {
                }
                catch (RecordStoreFullException e8) {
                }
                catch (RecordStoreException e9) {
                }
                catch (IOException e10) {
                    // empty catch block
                }
                TryAndBuyWrapper.this.lastKnownTimeLeftSet = true;
                TryAndBuyWrapper.this.lastKnownTimeLeft = tmpTimeLeft;
                try {
                    TryAndBuyWrapper.this.recordStore.closeRecordStore();
                    TryAndBuyWrapper.this.recordStore = null;
                }
                catch (RecordStoreNotOpenException e11) {
                }
                catch (RecordStoreException e12) {
                    // empty catch block
                }
                UnDemo.out.println("Time left: " + TryAndBuyWrapper.this.lastKnownTimeLeft);
                if (TryAndBuyWrapper.this.lastKnownTimeLeft <= 0L) {
                    TryAndBuyWrapper.this.trialOver();
                }
            }
        };
        if (this.lastKnownTimeLeft > 0L) {
            this.trialTimer = new Timer();
            this.trialTimer.scheduleAtFixedRate(task, 1000L, 1000L);
        }
        super.startApp();
    }

    public void trialOver() {
        super.pauseApp();
        if (this.trialTimer != null) {
            try {
                this.trialTimer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.displayTrialScreen();
    }

    public void quitApp() {
        this.notifyDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purchaseCompleted(PurchaseData response) {
        Object object = this.startupMonitor;
        synchronized (object) {
            while (!this.startupComplete) {
                try {
                    this.startupMonitor.wait(2000L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        int status = response.getStatus();
        if (status == 0 || status == 2) {
            this.tryAndBuyStatus = TRY_AND_BUY_STATUS_VALUE_FULL;
            try {
                this.recordStore = RecordStore.openRecordStore((String)TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
            }
            catch (Exception e2) {
                // empty catch block
            }
            byte[] tryAndBuyStatusRecord = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeInt(this.tryAndBuyStatus);
                dos.close();
                tryAndBuyStatusRecord = baos.toByteArray();
                if (this.recordStore.getNextRecordID() == TRY_AND_BUY_STATUS) {
                    this.recordStore.addRecord(tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                } else {
                    this.recordStore.setRecord(TRY_AND_BUY_STATUS, tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                }
            }
            catch (RecordStoreNotOpenException e3) {
            }
            catch (InvalidRecordIDException e4) {
            }
            catch (RecordStoreException e5) {
            }
            catch (IOException e6) {
                // empty catch block
            }
            try {
                this.recordStore.closeRecordStore();
                this.recordStore = null;
            }
            catch (RecordStoreNotOpenException e7) {
            }
            catch (RecordStoreException e8) {
                // empty catch block
            }
            super.startApp();
        } else {
            this.tryAndBuyStatus = TRY_AND_BUY_STATUS_VALUE_TRIAL;
            try {
                this.recordStore = RecordStore.openRecordStore((String)TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
            }
            catch (Exception e9) {
                // empty catch block
            }
            byte[] tryAndBuyStatusRecord = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeInt(this.tryAndBuyStatus);
                dos.close();
                tryAndBuyStatusRecord = baos.toByteArray();
                if (this.recordStore.getNextRecordID() == TRY_AND_BUY_STATUS) {
                    this.recordStore.addRecord(tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                } else {
                    this.recordStore.setRecord(TRY_AND_BUY_STATUS, tryAndBuyStatusRecord, 0, tryAndBuyStatusRecord.length);
                }
            }
            catch (RecordStoreNotOpenException e10) {
            }
            catch (InvalidRecordIDException e11) {
            }
            catch (RecordStoreException e12) {
            }
            catch (IOException e13) {
                // empty catch block
            }
            byte[] tryAndBuyPriceRecord = null;
            try {
                tryAndBuyPriceRecord = this.recordStore.getRecord(TRY_AND_BUY_PRICE_BEFORE_PURCHASE);
            }
            catch (RecordStoreNotOpenException e14) {
            }
            catch (InvalidRecordIDException e15) {
            }
            catch (RecordStoreException e16) {
                // empty catch block
            }
            try {
                if (tryAndBuyPriceRecord != null) {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tryAndBuyPriceRecord));
                    this.priceToShow = dis.readUTF();
                    dis.close();
                }
            }
            catch (IOException e17) {
                // empty catch block
            }
            try {
                this.recordStore.closeRecordStore();
                this.recordStore = null;
            }
            catch (RecordStoreNotOpenException e18) {
            }
            catch (RecordStoreException e19) {
                // empty catch block
            }
            this.displayTrialScreen();
        }
    }

    public void productDataReceived(ProductData[] productData) {
        this.priceToShow = "";
        if (productData != null && productData.length >= 1) {
            String lPrice = productData[0].getLocalizedPrice();
            String lCurrency = productData[0].getCurrency();
            if (lPrice != null && lCurrency != null) {
                this.priceToShow = lPrice + " " + lCurrency;
            }
        }
        try {
            this.recordStore = RecordStore.openRecordStore((String)TRYANDBUY_RECORDSTORE_NAME, (boolean)true);
        }
        catch (Exception e2) {
            // empty catch block
        }
        byte[] tryAndBuyPriceRecord = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(this.priceToShow);
            dos.close();
            tryAndBuyPriceRecord = baos.toByteArray();
            if (this.recordStore.getNextRecordID() == TRY_AND_BUY_PRICE_BEFORE_PURCHASE) {
                this.recordStore.addRecord(tryAndBuyPriceRecord, 0, tryAndBuyPriceRecord.length);
            } else {
                this.recordStore.setRecord(TRY_AND_BUY_PRICE_BEFORE_PURCHASE, tryAndBuyPriceRecord, 0, tryAndBuyPriceRecord.length);
            }
        }
        catch (RecordStoreNotOpenException e3) {
        }
        catch (InvalidRecordIDException e4) {
        }
        catch (RecordStoreException e5) {
        }
        catch (IOException e6) {
            // empty catch block
        }
        try {
            this.recordStore.closeRecordStore();
            this.recordStore = null;
        }
        catch (RecordStoreNotOpenException e7) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.displayTrialScreen();
    }

    public void launchNpaySetup() {
        this.displayTrialScreen();
        try {
            this.npayManager.launchNPaySetup();
        }
        catch (IllegalStateException e2) {
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    public void backToTrialScreen() {
        this.displayTrialScreen();
    }
}

