/*
 * Decompiled with CFR 0.152.
 */
package trybuylocalization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import trybuylocalization.StringTools;

public class L10nResources {
    private static final String PROPERTIES_PCKG = "trybuylocalization";
    private static final String PROPERTIES_PRFX = "messages";
    private static final String DEFAULT_LOCALE = "en";
    private static final String LOCALE_SEPARATOR = "-";
    private static final String UNSET_LOCALE_MESSAGE = "Set locale before retrieving resources.";
    private static final String INVALID_STRING_FORMAT = "The String format is invalid.";
    private static final String LOCALE_NOT_FOUND = "No resource found for locale";
    private static final String INVALID_RESOURCE_FORMAT = "The resource file format is invalid.";
    private static final String ERROR_LOADING_RESOURCES = "Error loading resources.";
    private static final String UNABLE_TO_FIND_BINARY_RESOURCE = "Unable to find binary resource.";
    private Hashtable values = new Hashtable();
    private String locale;

    public static L10nResources getL10nResources(String locale) {
        return new L10nResources(locale);
    }

    private L10nResources(String locale) {
        this.setLocale(locale);
    }

    public void setLocale(String locale) {
        if (locale == null || locale.length() == 0) {
            this.locale = UnDemo.getProperty("microedition.locale");
            if (this.locale == null) {
                this.locale = DEFAULT_LOCALE;
            }
        } else {
            this.locale = locale;
        }
        try {
            this.loadResources(this.locale);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public String getString(String key, String[] params) {
        String result = null;
        if (this.values == null) {
            throw new IllegalStateException(UNSET_LOCALE_MESSAGE);
        }
        result = (String)this.values.get(key);
        if (result == null) {
            result = "!!".concat(key).concat("!!");
        } else {
            StringBuffer buffer = new StringBuffer(result);
            for (int i2 = 0; i2 < params.length; ++i2) {
                int index = result.indexOf("{".concat(String.valueOf(i2)).concat("}"));
                if (index == -1) {
                    throw new IllegalArgumentException(INVALID_STRING_FORMAT);
                }
                buffer.delete(index, index + String.valueOf(i2).length() + 2);
                buffer.insert(index, params[i2]);
                result = buffer.toString();
                buffer.delete(0, buffer.length());
                buffer.append(result);
            }
        }
        return result;
    }

    public String getString(String key) {
        if (this.values == null) {
            throw new IllegalStateException(UNSET_LOCALE_MESSAGE);
        }
        String result = (String)this.values.get(key);
        if (result == null) {
            result = "!!".concat(key).concat("!!");
        }
        try {
            result = new String(result.getBytes(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        result = StringTools.replace("\\u200B", "\u200b", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String key) throws IOException {
        byte[] result = null;
        String value = this.getString(key);
        if (value != null) {
            InputStream stream = this.getClass().getResourceAsStream(value);
            if (stream == null) {
                throw new IOException(UNABLE_TO_FIND_BINARY_RESOURCE);
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                byte[] chunk = new byte[100];
                int read = -1;
                do {
                    if ((read = stream.read(chunk)) <= 0) continue;
                    buffer.write(chunk, 0, read);
                } while (read != -1);
            }
            finally {
                stream.close();
            }
            result = buffer.toByteArray();
        }
        return result;
    }

    private void loadResources(String locale) throws IOException {
        Reader reader = null;
        this.values.clear();
        try {
            reader = this.getResourceReader(locale);
            if (reader != null) {
                this.values = this.readResources(reader);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Reader getResourceReader(String locale) throws IOException {
        InputStreamReader reader = null;
        String resourePath = this.getResourcePath(locale);
        InputStream stream = this.getClass().getResourceAsStream(resourePath);
        if (stream == null) {
            if (locale.indexOf(LOCALE_SEPARATOR) == -1) {
                resourePath = this.getResourcePath(DEFAULT_LOCALE);
                reader = new InputStreamReader(this.getClass().getResourceAsStream(resourePath));
            } else {
                String shortLocale = locale.substring(0, locale.indexOf(LOCALE_SEPARATOR));
                resourePath = this.getResourcePath(shortLocale);
                stream = this.getClass().getResourceAsStream(resourePath);
                if (stream == null) {
                    resourePath = this.getResourcePath(DEFAULT_LOCALE);
                    reader = new InputStreamReader(this.getClass().getResourceAsStream(resourePath));
                } else {
                    reader = new InputStreamReader(this.getClass().getResourceAsStream(resourePath));
                }
            }
        } else {
            reader = new InputStreamReader(stream);
        }
        return reader;
    }

    private Hashtable readResources(Reader reader) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer buffer = new StringBuffer();
        try {
            int letter = -1;
            while ((letter = reader.read()) != -1) {
                switch (letter) {
                    case 10: 
                    case 13: {
                        break;
                    }
                    default: {
                        buffer.append((char)letter);
                    }
                }
                if (letter != 10) continue;
                String line = buffer.toString();
                int separator = line.indexOf("=");
                if (separator < 0) {
                    throw new IOException(INVALID_RESOURCE_FORMAT);
                }
                String key = line.substring(0, separator);
                String value = line.substring(++separator, line.length());
                values.put(key, value);
                buffer.delete(0, buffer.length());
            }
        }
        catch (Exception e2) {
            throw new IOException(ERROR_LOADING_RESOURCES);
        }
        return values;
    }

    private String getResourcePath(String locale) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/");
        if (PROPERTIES_PCKG.length() > 0) {
            buffer.append(PROPERTIES_PCKG);
            buffer.append("/");
        }
        buffer.append(PROPERTIES_PRFX);
        if (locale.length() > 0) {
            buffer.append("_");
        }
        buffer.append(locale.toString());
        buffer.append(".properties");
        return buffer.toString();
    }

    public boolean isRightToLeftLocale() {
        boolean result = false;
        String lang = null;
        if (this.locale.length() >= 2 && ("AR".equalsIgnoreCase(lang = this.locale.substring(0, 2)) || "HE".equalsIgnoreCase(lang) || "IW".equalsIgnoreCase(lang) || "FA".equalsIgnoreCase(lang) || "UR".equalsIgnoreCase(lang))) {
            result = true;
        }
        return result;
    }
}

