/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.views;

import com.rocktasticgames.diamonds.animated.AnimatedElement;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.parameters.C2MValues;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.MotionEvent;
import com.rocktasticgames.diamonds.utils.XMath;
import com.rocktasticgames.diamonds.views.View;
import javax.microedition.lcdui.Image;

public class MapView
extends View {
    private static final int MAX_TOUCHES = 2;
    private static float[] xloc = new float[]{583.0f, 932.0f, 678.0f, 310.0f, 512.0f, 717.0f, 1010.0f, 1375.0f, 2024.0f, 1725.0f, 1509.0f, 1976.0f};
    private static float[] yloc = new float[]{1141.0f, 923.0f, 675.0f, 650.0f, 407.0f, 191.0f, 384.0f, 386.0f, 471.0f, 722.0f, 948.0f, 1128.0f};
    private MainActivity activity;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement background;
    private AnimatedElement menu;
    private AnimatedElement flip;
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private long start_time;
    private boolean destroyed = false;
    private boolean showleft;
    private Image blurred;
    private long start_anim = 0L;
    private boolean menuselect = false;
    private boolean flipselect = false;
    private boolean introselect = false;
    private boolean glassselect = false;
    private int delays = 0;
    private AnimatedElement[] levels;
    private int levelselect = -1;
    private int maxsection;
    private AnimatedElement intro;
    private AnimatedElement glass;
    private boolean dialog_tapped = false;
    private boolean on_dialog_pre = false;
    private boolean on_dialog_post = false;
    private boolean show_glass = true;
    private boolean wasanimating = false;

    public MapView(MainActivity mainActivity, int n) {
        super(mainActivity);
        this.activity = mainActivity;
        this.start_time = System.currentTimeMillis();
        this.maxsection = this.activity.getSharedPref().getInt("maxlevel", 0) / 10;
        if (this.activity.getSharedPref().getInt("maxlevel", 0) == 0) {
            this.show_glass = false;
        }
        this.showleft = n == 0;
        this.activity.getAssetLoader().load("mapcheckmark", 1);
        this.activity.getMusic().playMusic("pizza_openingscreen_music_j2me");
        this.on_dialog_pre = this.activity.checkMessage(this.maxsection * 10 + 1, 6);
        if (!this.on_dialog_pre) {
            this.on_dialog_post = this.activity.checkMessage(this.maxsection * 10 + 1, 7);
        }
    }

    public boolean needsTranslate(AnimatedElement animatedElement) {
        if (this.levels == null) {
            return false;
        }
        for (int i = 7; i < this.levels.length; ++i) {
            if (this.levels[i] != animatedElement) continue;
            return true;
        }
        return false;
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (animatedElement == null) {
            return this.menu;
        }
        if (n == 1) {
            if (animatedElement == this.menu || animatedElement == this.flip) {
                if (this.showleft) {
                    return this.levels[0];
                }
                if (this.maxsection == 12) {
                    return this.levels[11];
                }
                if (this.maxsection >= 7) {
                    return this.levels[this.maxsection];
                }
                return this.intro;
            }
            for (int i = 0; i <= this.maxsection; ++i) {
                if (animatedElement != this.levels[i]) continue;
                if (i < 7) {
                    if (i < this.maxsection && i < 6) {
                        return this.levels[i + 1];
                    }
                } else if (i > 7) {
                    return this.levels[i - 1];
                }
                return this.intro;
            }
            return animatedElement;
        }
        if (animatedElement == this.menu) {
            if (n == 5 && this.showleft || n == 2 && !this.showleft) {
                return this.flip;
            }
            return animatedElement;
        }
        if (animatedElement == this.flip) {
            if (n == 5 && !this.showleft || n == 2 && this.showleft) {
                return this.menu;
            }
            return animatedElement;
        }
        if (n == 6) {
            if (animatedElement == this.intro || animatedElement == this.glass) {
                if (this.showleft) {
                    return this.levels[Math.min(6, this.maxsection)];
                }
                if (this.maxsection >= 7) {
                    return this.levels[7];
                }
                return this.menu;
            }
            for (int i = 0; i <= this.maxsection; ++i) {
                if (animatedElement != this.levels[i]) continue;
                if (i < 7) {
                    if (i > 0) {
                        return this.levels[i - 1];
                    }
                } else if (i < Math.min(this.maxsection, 11)) {
                    return this.levels[i + 1];
                }
                return this.menu;
            }
            return animatedElement;
        }
        if (animatedElement == this.intro) {
            if (n == 5 && !this.glass.isAnimatingOut()) {
                return this.glass;
            }
            return animatedElement;
        }
        if (animatedElement == this.glass && n == 2) {
            return this.intro;
        }
        return animatedElement;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activity.getAssetLoader().unload("mapcheckmark");
        if (this.background != null) {
            this.background.unload();
            this.menu.unload();
            this.intro.unload();
            this.glass.unload();
            this.flip.unload();
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i].unload();
                if (i <= 0) continue;
                this.activity.getAssetLoader().unload(Params.PATH_PIECES[i - 1]);
            }
        }
    }

    public boolean onBack() {
        if (this.on_dialog_pre) {
            this.on_dialog_pre = this.activity.progressDialog();
            if (!this.on_dialog_pre) {
                this.on_dialog_post = this.activity.checkMessage(this.maxsection * 10 + 1, 5);
            }
            return true;
        }
        if (this.on_dialog_post) {
            this.on_dialog_post = this.activity.progressDialog();
            return true;
        }
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        if (this.showleft) {
            try {
                this.blurred = Image.createImage((String)"/gamemap_with_parchment_v4_right.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.background = new AnimatedElement(this.activity.getAssetLoader(), "gamemap_with_parchment_v4_left", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.flip = new AnimatedElement(this.activity.getAssetLoader(), "button_279_nextpage", 0.9f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        } else {
            try {
                this.blurred = Image.createImage((String)"/gamemap_with_parchment_v4_left.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.background = new AnimatedElement(this.activity.getAssetLoader(), "gamemap_with_parchment_v4_right", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.flip = new AnimatedElement(this.activity.getAssetLoader(), "button_279_prevpage", 0.1f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        }
        this.menu = new AnimatedElement(this.activity.getAssetLoader(), "button_279_home", 0.5f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.intro = new AnimatedElement(this.activity.getAssetLoader(), "button_579_intro", 0.2170139f, 0.13020833f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 0L);
        this.glass = new AnimatedElement(this.activity.getAssetLoader(), "opening_button_painting", 0.8697917f, 0.13020833f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 4, 0L);
        this.levels = new AnimatedElement[Math.min(xloc.length, this.maxsection + 1)];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new AnimatedElement(this.activity.getAssetLoader(), Params.MAPMARKERS[i / 4], xloc[i] / 1152.0f, yloc[i] / 1152.0f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            if (i <= 0) continue;
            this.activity.getAssetLoader().load(Params.PATH_PIECES[i - 1], 1);
        }
        this.activity.getCanvas().setFocus(this.menu);
    }

    public void showRight() {
        if (!this.showleft) {
            return;
        }
        this.activity.getCanvas().setFocus(this.menu);
        this.background.setPNG("gamemap_with_parchment_v4_right");
        this.flip.setPNG("button_279_prevpage");
        this.flip.setX(0.1f);
        this.flip.animate(3, 0L);
        this.loaded = false;
        this.showleft = false;
        this.start_anim = System.currentTimeMillis();
        this.intro.animateOut(0L);
        this.glass.animateOut(0L);
        this.callInvalidate();
    }

    public void showLeft() {
        if (this.showleft) {
            return;
        }
        this.activity.getCanvas().setFocus(this.menu);
        this.background.setPNG("gamemap_with_parchment_v4_left");
        this.flip.setPNG("button_279_nextpage");
        this.flip.setX(0.9f);
        this.flip.animate(4, 0L);
        this.loaded = false;
        this.showleft = true;
        this.start_anim = System.currentTimeMillis();
        this.intro.animateOut(0L);
        this.glass.animateOut(0L);
        this.callInvalidate();
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        Image image;
        int n;
        graphicsContainer.setColor(-1);
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n2 = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 240;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded) {
            this.loaded = this.activity.getAssetLoader().isCurrent();
            this.start_time = System.currentTimeMillis();
            bl = true;
        }
        this.time = System.currentTimeMillis() - this.start_time;
        long l = System.currentTimeMillis() - this.start_anim;
        graphicsContainer.setColor(-13722999);
        graphicsContainer.drawPaint(n2);
        if (!this.loaded || this.start_anim > 0L && (float)l < 500.0f) {
            Image image2 = this.activity.getPlaceholder();
            if (image2 != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                if (this.start_anim > 0L) {
                    this.loaded = false;
                    if (this.showleft) {
                        graphicsContainer.translate(XMath.min(0.0f, (float)((long)(-image2.getWidth()) * (500L - l)) / 0.5f / 1000.0f), 0.0f);
                        graphicsContainer.drawImage(this.blurred, 0, 0, n2);
                        graphicsContainer.translate(image2.getWidth(), 0);
                    } else {
                        graphicsContainer.translate(XMath.max(0.0f, (float)((long)image2.getWidth() * (500L - l)) / 0.5f / 1000.0f), 0.0f);
                        graphicsContainer.drawImage(this.blurred, 0, 0, n2);
                        graphicsContainer.translate(-image2.getWidth(), 0);
                    }
                    this.callInvalidate();
                } else {
                    this.postInvalidateDelayed(50L);
                }
                graphicsContainer.drawImage(image2, 0, 0, n2);
                if (this.showleft) {
                    graphicsContainer.translate(-image2.getWidth(), 0);
                }
                graphicsContainer.scale(1.0f / (float)MainActivity.PLACEHOLDER_BLUR, 1.0f / (float)MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.translate(0.0f, -((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                if (this.start_anim > 0L) {
                    this.activity.getTitan().setSize(this.levels[0].getHeight() / 5);
                    for (int i = 0; i < this.levels.length; ++i) {
                        if (this.on_dialog_pre && i == this.levels.length - 1) continue;
                        if (this.levelselect == i) {
                            this.levels[i].setColorFilter(Params.filter_dark);
                        } else if (this.maxsection < i) {
                            this.levels[i].setColorFilter(Params.filter_gray);
                        }
                        this.levels[i].render(graphicsContainer, n2, this.time);
                        this.levels[i].setColorFilter(null);
                        graphicsContainer.setColor(-1);
                        String string = i % 4 * 10 + 1 + "-" + (i % 4 + 1) * 10;
                        graphicsContainer.save();
                        graphicsContainer.translate(this.levels[i].getX(this.time) - (float)(this.activity.getBrady().measure(string) / 2), this.levels[i].getY(this.time) - this.activity.getBrady().getSize(graphicsContainer) / 2.0f);
                        this.activity.getBrady().renderString(graphicsContainer, n2, string);
                        graphicsContainer.restore();
                    }
                }
                graphicsContainer.restore();
                if (this.start_anim > 0L) {
                    if (this.menuselect) {
                        this.menu.setColorFilter(Params.filter_dark);
                    }
                    if (!this.menu.render(graphicsContainer, n2, this.time)) {
                        bl = true;
                    }
                    if (this.menuselect) {
                        this.menu.setColorFilter(null);
                    }
                    if (this.introselect) {
                        this.intro.setColorFilter(Params.filter_dark);
                    }
                    if (!this.intro.render(graphicsContainer, n2, l)) {
                        bl = true;
                    }
                    graphicsContainer.save();
                    graphicsContainer.setColor(-1);
                    this.activity.getCartoon().setSize(this.intro.getHeight() / 2);
                    graphicsContainer.translate(this.intro.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_INTRO[this.activity.getLanguage()]) / 2), this.intro.getY(l) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
                    this.activity.getCartoon().renderString(graphicsContainer, n2, C2MValues.TEXT_INTRO[this.activity.getLanguage()]);
                    graphicsContainer.restore();
                    if (this.introselect) {
                        this.intro.setColorFilter(null);
                    }
                    if (this.glassselect) {
                        this.glass.setColorFilter(Params.filter_dark);
                    }
                    if (this.show_glass && !this.glass.render(graphicsContainer, n2, l)) {
                        bl = true;
                    }
                    if (this.glassselect) {
                        this.glass.setColorFilter(null);
                    }
                }
            } else {
                graphicsContainer.setColor(-13722999);
                graphicsContainer.drawPaint(n2);
                this.postInvalidateDelayed(50L);
            }
            graphicsContainer.restore();
            return;
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        this.background.render(graphicsContainer, n2, this.time);
        graphicsContainer.setColor(-1);
        if (this.menuselect) {
            this.menu.setColorFilter(Params.filter_dark);
        }
        if (!this.menu.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        if (this.menuselect) {
            this.menu.setColorFilter(null);
        }
        if (this.intro.isAnimatingOut()) {
            this.intro.animate(3, this.time);
        }
        if (this.introselect) {
            this.intro.setColorFilter(Params.filter_dark);
        }
        if (!this.intro.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        graphicsContainer.save();
        graphicsContainer.setColor(-1);
        this.activity.getCartoon().setSize(this.intro.getHeight() / 2);
        graphicsContainer.translate(this.intro.getX(this.time) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_INTRO[this.activity.getLanguage()]) / 2), this.intro.getY(this.time) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
        this.activity.getCartoon().renderString(graphicsContainer, n2, C2MValues.TEXT_INTRO[this.activity.getLanguage()]);
        graphicsContainer.restore();
        if (this.introselect) {
            this.intro.setColorFilter(null);
        }
        if (this.glass.isAnimatingOut()) {
            this.glass.animate(4, this.time);
        }
        if (this.glassselect) {
            this.glass.setColorFilter(Params.filter_dark);
        }
        if (this.show_glass && !this.glass.render(graphicsContainer, n2, l)) {
            bl = true;
        }
        if (this.glassselect) {
            this.glass.setColorFilter(null);
        }
        if (this.flipselect) {
            this.flip.setColorFilter(Params.filter_dark);
        }
        if (!this.flip.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        if (this.flipselect) {
            this.flip.setColorFilter(null);
        }
        if (!this.showleft) {
            graphicsContainer.translate(-240, 0);
        }
        this.activity.getTitan().setSize(this.levels[0].getHeight() / 5);
        for (n = 0; n < this.levels.length - 1; ++n) {
            if (this.on_dialog_pre && n == this.levels.length - 2) continue;
            graphicsContainer.save();
            graphicsContainer.translate((this.levels[n].getX(this.time) + this.levels[n + 1].getX(this.time)) / 2.0f, (this.levels[n].getY(this.time) + this.levels[n + 1].getY(this.time)) / 2.0f);
            image = this.activity.getAssetLoader().get(Params.PATH_PIECES[n]);
            graphicsContainer.scale(1.0f, 1.0f);
            if (image != null) {
                graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() / 2, n2);
            }
            graphicsContainer.restore();
        }
        for (n = 0; n < this.levels.length; ++n) {
            if (this.on_dialog_pre && n == this.levels.length - 1) continue;
            if (this.levelselect == n) {
                this.levels[n].setColorFilter(Params.filter_dark);
            }
            this.levels[n].render(graphicsContainer, n2, this.time);
            image = this.activity.getAssetLoader().get("mapcheckmark");
            if (n < this.maxsection && n < this.levels.length && image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(this.levels[n].getX(this.time), this.levels[n].getY(this.time));
                graphicsContainer.scale(1.0f, 1.0f);
                graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() / 2, n2);
                graphicsContainer.restore();
            }
            if (this.levelselect == n) {
                this.levels[n].setColorFilter(null);
            }
            graphicsContainer.setColor(-1);
            String string = n % 4 * 10 + 1 + "-" + (n % 4 + 1) * 10;
            graphicsContainer.save();
            graphicsContainer.translate(this.levels[n].getX(this.time) - (float)(this.activity.getBrady().measure(string) / 2), this.levels[n].getY(this.time) - this.activity.getBrady().getSize(graphicsContainer) / 2.0f);
            this.activity.getBrady().renderString(graphicsContainer, n2, string);
            graphicsContainer.restore();
        }
        if ((float)this.time < 500.0f && this.start_anim == 0L) {
            Image image3;
            if (!this.showleft) {
                graphicsContainer.translate(240, 0);
            }
            if ((image3 = this.activity.getPlaceholder()) != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image3, 0, 0, n2);
                graphicsContainer.restore();
            } else {
                graphicsContainer.drawPaint(n2);
            }
            bl = true;
        } else if (!this.wasanimating) {
            try {
                if (this.showleft && this.activity.setPlaceholder("gamemap_with_parchment_v4_left")) {
                    this.blurred = Image.createImage((String)"/gamemap_with_parchment_v4_right.png");
                } else if (!this.showleft && this.activity.setPlaceholder("gamemap_with_parchment_v4_right")) {
                    this.blurred = Image.createImage((String)"/gamemap_with_parchment_v4_left.png");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.on_dialog_pre || this.on_dialog_post && this.time > 2500L) {
            this.activity.renderDialog(graphicsContainer, n2, this.scale, this.dialog_tapped);
        }
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = System.currentTimeMillis() - this.start_time;
        this.wasanimating = bl;
        if (bl) {
            this.callInvalidate();
        } else if (this.delays == 0) {
            this.postInvalidateDelayed(100L);
        }
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
    }

    public void postInvalidateDelayed(long l) {
        ++this.delays;
        super.postInvalidateDelayed(l);
    }

    public void callInvalidate() {
        ++this.delays;
        this.invalidate();
    }

    public void invalidate() {
        this.delays = Math.max(0, this.delays - 1);
        super.invalidate();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        if (this.on_dialog_pre) {
                            this.on_dialog_pre = false;
                            this.on_dialog_post = this.activity.checkMessage(this.maxsection * 10 + 1, 5);
                        } else {
                            this.on_dialog_post = false;
                        }
                    }
                    this.dialog_tapped = false;
                } else if (this.menuselect) {
                    this.menuselect = false;
                    this.activity.openMainMenu();
                } else if (this.introselect) {
                    this.introselect = false;
                    this.activity.startIntro();
                } else if (this.glassselect) {
                    this.glassselect = false;
                    this.activity.startStainedGlass(false);
                } else if (this.flipselect) {
                    this.flipselect = false;
                    if (this.showleft) {
                        this.showRight();
                    } else {
                        this.showLeft();
                    }
                } else if (this.levelselect >= 0) {
                    this.activity.startSelection(this.levelselect);
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.on_dialog_pre || this.on_dialog_post) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.menu.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.activity.playSound("standard_click");
                    this.menuselect = true;
                } else if (this.intro.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.activity.playSound("standard_click");
                    this.introselect = true;
                } else if (this.glass.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.activity.playSound("standard_click");
                    this.glassselect = true;
                } else if (this.flip.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale) && !this.wasanimating) {
                    this.activity.playSound("standard_click");
                    this.flipselect = true;
                } else if (!this.wasanimating) {
                    for (int i = 0; i < this.levels.length && i <= this.maxsection; ++i) {
                        if (!this.showleft) {
                            // empty if block
                        }
                        if (!this.levels[i].inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) continue;
                        this.levelselect = i;
                        return true;
                    }
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.menuselect && !this.menu.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.menuselect = false;
                } else if (this.introselect && !this.intro.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.introselect = false;
                } else if (this.glassselect && !this.glass.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.glassselect = false;
                } else if (this.flipselect && !this.flip.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.flipselect = false;
                } else if (!(!this.showleft && this.showleft || this.levelselect < 0 || this.levels[this.levelselect].inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale))) {
                    this.levelselect = -1;
                } else if (!this.showleft && this.levelselect >= 0 && !this.levels[this.levelselect].inRange((float)(motionEvent.getX() + this.activity.getCanvas().getWidth()) / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.levelselect = -1;
                } else if (this.swipe_active[n] && XMath.abs(f - this.mousex[n]) + XMath.abs(f2 - this.mousey[n]) > (float)(this.activity.getCanvas().getWidth() / 50) && XMath.abs(f - this.mousex[n]) > XMath.abs(f2 - this.mousey[n])) {
                    if (f - this.mousex[n] > 0.0f) {
                        this.showLeft();
                    } else {
                        this.showRight();
                    }
                    this.swipe_active[n] = false;
                }
                return true;
            }
        }
        return true;
    }
}

