/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.utils;

import com.rocktasticgames.diamonds.utils.List;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsContainer {
    private Graphics g;
    private int w;
    private int h;
    private float vscale;
    private float hscale;
    private int hoff;
    private List saved;
    private int color;

    public GraphicsContainer(int n, int n2) {
        this.setSize(n, n2);
        this.color = -16777216;
        this.saved = new List();
        this.saved.add(new int[]{0, 0});
    }

    public void resetStack() {
        if (this.g != null) {
            this.g.translate(-this.g.getTranslateX(), -this.g.getTranslateY());
        }
        this.saved = new List();
        this.saved.add(new int[]{0, 0});
    }

    public void setSize(int n, int n2) {
        this.w = n;
        this.h = n2;
        if (this.h >= this.w * 4 / 3) {
            this.vscale = 1.0f;
            this.hscale = 1.0f;
            this.hoff = 0;
        } else if (this.h > this.w) {
            this.vscale = (float)this.h / (float)this.w / 1.3333334f + 1.0E-8f;
            this.hscale = 1.0f;
            this.hoff = 0;
        } else {
            this.vscale = 0.7500001f;
            this.hscale = (float)this.h / (float)this.w;
            this.hoff = (this.w - this.h) / 2;
        }
        this.w = Math.min(this.w, this.h);
        this.h = (int)((float)this.h / this.vscale + 0.5f);
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public float getVScale() {
        return this.vscale;
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void fillRect(float f, float f2, float f3, float f4) {
        this.fillRect((int)f, (int)f2, (int)f3, (int)f4);
    }

    public void drawPaint(int n) {
        this.g.fillRect(0, 0, 320, 240);
    }

    public int getColor() {
        return this.color;
    }

    public void save() {
        this.saved.add(new int[]{0, 0});
    }

    public void restore() {
        int[] nArray = (int[])this.saved.remove(this.saved.size - 1);
        this.g.translate(-nArray[0], -nArray[1]);
    }

    public void rotate(float f) {
    }

    public void scale(float f, float f2) {
    }

    public void translate(int n, int n2) {
        int n3 = (int)((float)Math.abs(n2) * this.vscale);
        if (n2 < 0) {
            n3 *= -1;
        }
        int[] nArray = (int[])this.saved.get(this.saved.size - 1);
        nArray[0] = nArray[0] + n;
        int[] nArray2 = (int[])this.saved.get(this.saved.size - 1);
        nArray2[1] = nArray2[1] + n3;
        if (n2 > 0) {
            this.g.translate(n, n3);
        } else {
            this.g.translate(n, n3);
        }
    }

    public int getTranslateX() {
        return this.g.getTranslateX();
    }

    public int getTranslateY() {
        return (int)((float)this.g.getTranslateY() / this.vscale);
    }

    public void drawImage(Image image, float f, float f2, int n) {
        this.drawImage(image, (int)(f + 0.5f), (int)(f2 + 0.5f), n);
    }

    public void translate(float f, float f2) {
        this.translate((int)f, (int)f2);
    }

    public void drawImage(Image image, int n, int n2, int n3) {
        if (n2 > 0) {
            this.g.drawImage(image, n + this.hoff, (int)((float)n2 * this.vscale), n3);
        } else {
            this.g.drawImage(image, n + this.hoff, (int)((float)n2 * this.vscale + 0.5f), n3);
        }
    }

    public void setColor(int n) {
        this.color = n;
        this.g.setColor(n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (n2 > 0) {
            this.g.fillRect(n + this.hoff, (int)((float)n2 * this.vscale), n3, (int)((float)n4 * this.vscale));
        } else {
            this.g.fillRect(n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3, (int)((float)n4 * this.vscale));
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (n2 > 0) {
            if (n4 > 0) {
                this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale), n3 + this.hoff, (int)((float)n4 * this.vscale));
            } else {
                this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale), n3 + this.hoff, (int)((float)n4 * this.vscale + 0.999f));
            }
        } else if (n4 > 0) {
            this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3 + this.hoff, (int)((float)n4 * this.vscale));
        } else {
            this.g.drawLine(n + this.hoff, (int)((float)n2 * this.vscale + 0.999f), n3 + this.hoff, (int)((float)n4 * this.vscale + 0.999f));
        }
    }
}

