/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.views;

import com.rocktasticgames.diamonds.animated.AnimatedElement;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.models.GameModel;
import com.rocktasticgames.diamonds.parameters.C2MValues;
import com.rocktasticgames.diamonds.parameters.Levels;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.GraphicsContainer;
import com.rocktasticgames.diamonds.utils.MotionEvent;
import com.rocktasticgames.diamonds.utils.XMath;
import com.rocktasticgames.diamonds.views.View;
import javax.microedition.lcdui.Image;

public class PregameView
extends View {
    private static final int MAX_TOUCHES = 2;
    private MainActivity activity;
    private GameModel model;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement scroll;
    private AnimatedElement play;
    private AnimatedElement background;
    private boolean[] pause_tapped = new boolean[2];
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private boolean play_tapped = false;
    private int level;
    private long start_time;
    private boolean destroyed = false;
    private String bg_image = "bg12";
    private boolean close_page = false;
    private boolean on_dialog = false;
    private boolean dialog_tapped = false;

    public PregameView(MainActivity mainActivity, GameModel gameModel, int n) {
        super(mainActivity);
        this.activity = mainActivity;
        this.model = gameModel;
        this.level = n;
        this.start_time = System.currentTimeMillis();
        switch (this.model.getLevel() / 40) {
            case 0: {
                this.activity.getMusic().playMusic("egypt");
                break;
            }
            case 1: {
                this.activity.getMusic().playMusic("mayan");
                break;
            }
            case 2: {
                this.activity.getMusic().playMusic("atlantis");
            }
        }
        this.bg_image = Params.BACKGROUNDS[this.model.getLevel() / 10];
        this.activity.getAssetLoader().load("parchmentmid_nogrid", 1);
        this.activity.getAssetLoader().load("gridboundary_bot", 1);
        this.activity.getAssetLoader().load("gridboundary_top", 1);
        switch (this.model.winCondition()) {
            case 4: {
                this.activity.getAssetLoader().load(Params.CRATE_INGAME[this.model.getLevel() / 40], 1);
                break;
            }
            case 3: {
                this.activity.getAssetLoader().load(Params.GEM_IMG[this.model.victoryGem1()], 1);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.activity.getAssetLoader().load("basetile", 1);
            }
        }
        if (this.model.isDoubleMatchWin()) {
            this.activity.getAssetLoader().load(Params.GEM_IMG[this.model.victoryGem2()], 1);
        }
        this.on_dialog = this.activity.checkMessage(n + 1, 1);
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (this.play != null) {
            return this.play;
        }
        return null;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activity.getAssetLoader().unload("parchmentmid_nogrid");
        this.activity.getAssetLoader().unload("gridboundary_bot");
        this.activity.getAssetLoader().unload("gridboundary_top");
        if (this.scroll != null) {
            this.scroll.unload();
            this.play.unload();
            this.background.unload();
        }
        switch (this.model.winCondition()) {
            case 4: {
                this.activity.getAssetLoader().unload(Params.CRATE_INGAME[this.model.getLevel() / 40]);
                break;
            }
            case 3: {
                this.activity.getAssetLoader().unload(Params.GEM_IMG[this.model.victoryGem1()]);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.activity.getAssetLoader().unload("basetile");
            }
        }
        if (this.model.isDoubleMatchWin()) {
            this.activity.getAssetLoader().unload(Params.GEM_IMG[this.model.victoryGem2()]);
        }
    }

    public boolean onBack() {
        this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.model.getLevel() / 10]);
        if (this.on_dialog) {
            this.on_dialog = this.activity.progressDialog();
            return true;
        }
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.scroll = new AnimatedElement(this.activity.getAssetLoader(), "parchmentmid_nogrid", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.play = new AnimatedElement(this.activity.getAssetLoader(), "button_272_play", 0.5f, 0.5f + 0.3f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 2L);
        this.activity.getCanvas().setFocus(this.play);
    }

    public int getLevel() {
        return this.level;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        Object object;
        graphicsContainer.setColor(-1);
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 240;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded && this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
            this.start_time = System.currentTimeMillis();
        }
        if (this.on_dialog) {
            this.start_time = System.currentTimeMillis();
            this.time = 0L;
        } else {
            this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        }
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (this.time < 302L) {
            bl = true;
        }
        float f = -108.333336f * XMath.min(1.0f, (float)this.time / 2.0f);
        float f2 = 108.333336f * XMath.min(1.0f, (float)this.time / 2.0f);
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        graphicsContainer.save();
        graphicsContainer.scale(1.6666666f, 1.6666666f);
        this.background.render(graphicsContainer, n, this.time);
        graphicsContainer.restore();
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        Image image = this.activity.getAssetLoader().get("parchmentmid_nogrid");
        if (image != null && this.loaded && f != f2) {
            float f3 = 1.12f;
            graphicsContainer.drawImage(image, (float)(120 - image.getWidth() / 2), (float)(240 * graphicsContainer.getHeight() / graphicsContainer.getWidth() / 2) + (this.model.getTopBound() + this.model.getBotBound()) * f3 / 2.0f - (float)image.getHeight() / graphicsContainer.getVScale() / 2.0f, n);
        }
        if (this.play_tapped) {
            this.play.setColorFilter(Params.filter_dark);
        }
        this.play.render(graphicsContainer, n, this.time);
        if (this.play_tapped) {
            this.play.setColorFilter(null);
        }
        if (this.scroll.isLoaded()) {
            String string = C2MValues.TEXT_OBJECTIVE[this.activity.getLanguage()][Levels.WIN_CONDITION[this.model.getLevel()]];
            if (Levels.WIN_CONDITION[this.model.getLevel()] == 1) {
                string = string + Levels.WIN_SCORE[this.model.getLevel()];
            }
            object = this.model.isMoveLimited() ? this.model.movesRemaining() + C2MValues.TEXT_MOVE_LIMITER[this.activity.getLanguage()] : C2MValues.TEXT_TIME_LIMITER[this.activity.getLanguage()];
            this.activity.getCartoon().setSize((float)this.scroll.getWidth() * 0.055f);
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure(string) / 2), this.scroll.getY(this.time) - (float)this.scroll.getWidth() * 0.22f);
            if ((double)(-this.scroll.getWidth()) * 0.22 + (double)this.activity.getCartoon().getSize(graphicsContainer) > (double)f) {
                this.activity.getCartoon().renderString(graphicsContainer, n, string);
            }
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure((String)object) / 2), this.scroll.getY(this.time) - (float)this.scroll.getWidth() * 0.13f);
            if ((double)(-this.scroll.getWidth()) * 0.13 + (double)this.activity.getCartoon().getSize(graphicsContainer) > (double)f) {
                this.activity.getCartoon().renderString(graphicsContainer, n, (String)object);
            }
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time), this.scroll.getY(this.time) + (float)this.scroll.getWidth() * 0.0f);
            if (this.model.isDoubleMatchWin()) {
                graphicsContainer.translate((float)(-this.scroll.getWidth()) * 0.2f, 0.0f);
            }
            graphicsContainer.save();
            Image image2 = null;
            switch (this.model.winCondition()) {
                case 4: {
                    image2 = this.activity.getAssetLoader().get(Params.CRATE_INGAME[this.model.getLevel() / 40]);
                    break;
                }
                case 3: {
                    image2 = this.activity.getAssetLoader().get(Params.GEM_IMG[this.model.victoryGem1()]);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    image2 = this.activity.getAssetLoader().get("basetile");
                }
            }
            if (image2 != null) {
                graphicsContainer.save();
                graphicsContainer.scale(1.0f, 1.0f);
                if ((double)this.scroll.getWidth() * 0.0 - (double)((float)image2.getHeight() / graphicsContainer.getVScale() / 2.0f) < (double)f2) {
                    graphicsContainer.drawImage(image2, (float)(-image2.getWidth() / 2), (float)(-image2.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
                }
                graphicsContainer.restore();
            }
            graphicsContainer.translate((float)(-this.activity.getCartoon().measure(this.model.gemTarget1()) / 2), (float)this.scroll.getWidth() * 0.08f);
            if ((double)this.scroll.getWidth() * 0.08 < (double)f2) {
                this.activity.getCartoon().renderString(graphicsContainer, n, this.model.gemTarget1());
            }
            graphicsContainer.restore();
            if (this.model.isDoubleMatchWin()) {
                graphicsContainer.translate((float)this.scroll.getWidth() * 0.4f, 0.0f);
                Image image3 = this.activity.getAssetLoader().get(Params.GEM_IMG[this.model.victoryGem2()]);
                if (image3 != null) {
                    graphicsContainer.save();
                    graphicsContainer.scale(1.0f, 1.0f);
                    if ((double)this.scroll.getWidth() * 0.0 - (double)((float)image3.getHeight() / graphicsContainer.getVScale() / 2.0f) < (double)f2) {
                        graphicsContainer.drawImage(image3, (float)(-image3.getWidth() / 2), (float)(-image3.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
                    }
                    graphicsContainer.restore();
                }
                graphicsContainer.translate((float)(-this.activity.getCartoon().measure(this.model.gemTarget2()) / 2), (float)this.scroll.getWidth() * 0.08f);
                if ((double)this.scroll.getWidth() * 0.08 < (double)f2) {
                    this.activity.getCartoon().renderString(graphicsContainer, n, this.model.gemTarget2());
                }
            }
            graphicsContainer.restore();
        }
        Image image4 = this.activity.getAssetLoader().get("gridboundary_top");
        object = this.activity.getAssetLoader().get("gridboundary_bot");
        if (image4 != null && object != null && this.loaded) {
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time), this.scroll.getY(this.time) + f - (float)image4.getHeight() / graphicsContainer.getVScale() * 0.3f);
            graphicsContainer.scale(1.0f, 1.0f);
            graphicsContainer.drawImage(image4, (float)(-image4.getWidth() / 2), (float)(-image4.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time), this.scroll.getY(this.time) + f2 + (float)object.getHeight() / graphicsContainer.getVScale() * 0.25f);
            graphicsContainer.scale(1.0f, 1.0f);
            graphicsContainer.drawImage((Image)object, (float)(-object.getWidth() / 2), (float)(-object.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
            graphicsContainer.restore();
        }
        if (this.on_dialog) {
            this.activity.renderDialog(graphicsContainer, n, this.scale, this.dialog_tapped);
        }
        this.last_time = this.time;
        this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time < 0L) {
            this.activity.startGame(this.level);
            this.destroy();
        } else if (bl) {
            this.invalidate();
        } else {
            this.postInvalidateDelayed(50L);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.close_page) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.model.getLevel() / 10]);
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        this.on_dialog = false;
                    }
                    this.dialog_tapped = false;
                } else if (this.play_tapped) {
                    this.play.animate(4, 2L);
                    this.close_page = true;
                    this.start_time = System.currentTimeMillis() + 2L + 300L;
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.on_dialog) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.play.isLoaded() && this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = true;
                    this.activity.playSound("standard_click");
                } else if (!this.model.isPaused()) {
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.play_tapped && !this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = false;
                } else if (this.swipe_active[n]) {
                    // empty if block
                }
                return true;
            }
        }
        return true;
    }
}

