/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.ui.Button;

public class OptionButton
extends Button {
    private String[] values;
    private String[] valuesKeys;
    private int selectedValueIndex;
    private String plainText;
    private String plainTextKey;
    private EFLiteSprite[] selectedValues;

    public OptionButton(String id, String plainText, String[] values) {
        super(id);
        this.plainText = plainText;
        this.values = values;
        this.setText(plainText);
    }

    public OptionButton(String id) {
        super(id);
    }

    public int getSelectedValueIndex() {
        return this.selectedValueIndex;
    }

    public void setSelectedValueIndex(int selectedValueIndex) {
        this.selectedValueIndex = selectedValueIndex;
        this.setText(this.plainText);
    }

    public String getPlainTextKey() {
        return this.plainTextKey;
    }

    public void setText(String text) {
        this.plainText = text;
        super.setText(this.plainText + " " + this.values[this.selectedValueIndex]);
    }

    public void setText(String fgText, boolean localizationSupport) {
        if (localizationSupport) {
            this.plainTextKey = fgText;
            this.setText(LocalizationSupport.getMessage(this.plainTextKey));
        } else {
            this.setText(fgText);
        }
    }

    public String[] getValues() {
        return this.values;
    }

    private void setValues(String[] values) {
        this.values = values;
        this.setText(this.plainText);
    }

    public void setValues(String[] values, boolean localizationsupport) {
        if (localizationsupport) {
            this.valuesKeys = values;
            String[] newValues = new String[this.valuesKeys.length];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = LocalizationSupport.getMessage(this.valuesKeys[i]);
            }
            this.setValues(newValues);
        } else {
            this.setValues(values);
        }
    }

    public EFLiteSprite[] getEFLiteSpriteValues() {
        return this.selectedValues;
    }

    public void setEFLiteSpriteValues(EFLiteSprite[] selectedValues) {
        this.selectedValues = selectedValues;
    }

    public String[] getValuesKeys() {
        return this.valuesKeys;
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.actionPerformed();
    }

    private void actionPerformed() {
        if (this.getEFLiteSpriteValues() == null) {
            ++this.selectedValueIndex;
            this.selectedValueIndex %= this.values.length;
            this.setText(this.plainText);
            if (this.actionListener != null) {
                this.actionListener.onValueChange(this.values[this.selectedValueIndex]);
            }
        } else {
            ++this.selectedValueIndex;
            this.selectedValueIndex %= this.selectedValues.length;
            this.setSelectedBg(this.getEFLiteSpriteValues()[this.selectedValueIndex]);
            if (this.actionListener != null) {
                this.actionListener.onValueChange(this.values[this.selectedValueIndex]);
            }
        }
    }
}

