/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.manager.IActionListener;
import javax.microedition.lcdui.Graphics;

public abstract class Component {
    String id;
    int x;
    int y;
    int height;
    int width;
    boolean enabled;
    boolean visible;
    boolean autoResize;
    boolean autoPos;
    int bgColor;
    int fgColor;
    int borderColor;
    int borderSize;
    EFLiteSprite bg;
    EFLiteSprite fg;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    protected int compClipX;
    protected int compClipY;
    protected int compClipW;
    protected int compClipH;
    protected boolean clipRegionActivated;
    private int color;
    private int stroke;
    IActionListener actionListener;

    public Component(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.equals("")) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.visible = true;
        this.enabled = true;
        this.autoPos = true;
        this.autoResize = true;
        this.borderSize = 1;
        this.borderColor = -1;
        this.bgColor = -1;
        this.fgColor = -1;
        this.width = 100;
        this.height = 20;
    }

    public IActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(IActionListener actionListener) {
        this.actionListener = actionListener;
    }

    boolean isInside(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getY() && y < this.getY() + this.getHeight();
    }

    public boolean isAutoPos() {
        return this.autoPos;
    }

    public void setAutoPos(boolean autoPos) {
        this.autoPos = autoPos;
    }

    public EFLiteSprite getBg() {
        return this.bg;
    }

    public void setBg(EFLiteSprite bg) {
        this.bg = bg;
        if (this.autoResize) {
            this.width = this.fg == null ? bg.getWidth() : Math.max(this.fg.getWidth(), bg.getWidth());
            this.height = this.fg == null ? bg.getHeight() : Math.max(this.fg.getHeight(), bg.getHeight());
        }
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EFLiteSprite getFg() {
        return this.fg;
    }

    public void setFg(EFLiteSprite fg) {
        this.fg = fg;
        if (this.autoResize) {
            this.width = this.bg == null ? fg.getWidth() : Math.max(fg.getWidth(), this.bg.getWidth());
            this.height = this.bg == null ? fg.getHeight() : Math.max(fg.getHeight(), this.bg.getHeight());
        }
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(int fgColor) {
        this.fgColor = fgColor;
    }

    public String getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    void saveClip(Graphics g) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipW = g.getClipWidth();
        this.clipH = g.getClipHeight();
        this.color = g.getColor();
        this.stroke = g.getStrokeStyle();
    }

    void restoreClip(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
        g.setColor(this.color);
        g.setStrokeStyle(this.stroke);
    }

    public void setClipRegion(int x, int y, int w, int h) {
        this.compClipX = x;
        this.compClipY = y;
        this.compClipW = w;
        this.compClipH = h;
        this.clipRegionActivated = true;
    }

    public abstract void paint(Graphics var1);
}

