/*
 * Decompiled with CFR 0.152.
 */
package cucumber;

import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    protected InputStream in;
    protected int bits;
    protected int pos;

    public BitInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.pos = 8;
    }

    public int readBit() throws IOException {
        if (this.pos == 8) {
            int n = this.in.read();
            if (n == -1) {
                return -1;
            }
            this.bits = n;
            this.pos = 0;
        }
        if ((this.bits & 128 >> this.pos) != 0) {
            ++this.pos;
            return 1;
        }
        ++this.pos;
        return 0;
    }

    public boolean readBoolean() throws IOException {
        int n = this.readBit();
        if (n != -1) {
            return n == 1;
        }
        throw new IOException();
    }

    public void skipToByte(boolean bl) throws IOException {
        if (bl && this.pos == 8) {
            this.in.read();
        }
        this.pos = 8;
    }

    public void skipToByte() throws IOException {
        this.pos = 8;
    }

    public int skipBits(int n) throws IOException {
        int n2 = 0;
        for (int i = 1; i <= n && this.readBit() != -1; ++i) {
            ++n2;
        }
        return n2;
    }

    public int availableBits() throws IOException {
        return 8 - this.pos + this.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        this.skipToByte();
        return this.in.read();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read(byte[] byArray) throws IOException {
        this.skipToByte();
        return this.in.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.skipToByte();
        return this.in.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }
}

