/*
 * Decompiled with CFR 0.152.
 */
package cucumber;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    protected OutputStream out;
    protected byte bits;
    protected byte pos;

    public BitOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.pos = 0;
        this.bits = 0;
    }

    public void writeBit(int n) throws IOException {
        this.bits = n == 1 ? (byte)(this.bits | 128 >> this.pos) : (byte)(this.bits & ~(128 >> this.pos));
        this.pos = (byte)(this.pos + 1);
        if (this.pos == 8) {
            this.pos = 0;
            this.out.write(this.bits);
            this.bits = 0;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.bits = bl ? (byte)(this.bits | 128 >> this.pos) : (byte)(this.bits & ~(128 >> this.pos));
        this.pos = (byte)(this.pos + 1);
        if (this.pos == 8) {
            this.pos = 0;
            this.out.write(this.bits);
            this.bits = 0;
        }
    }

    public void flushToByte() throws IOException {
        if (this.pos > 0) {
            this.pos = 0;
            this.out.write(this.bits);
        }
    }

    public void write(int n) throws IOException {
        this.flushToByte();
        this.out.write(n);
    }

    public void flush() throws IOException {
        this.flushToByte();
        this.out.flush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushToByte();
        this.out.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.flushToByte();
        this.out.write(byArray);
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

