/*
 * Decompiled with CFR 0.152.
 */
package skb;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import skb.Entry;
import skb.GameNotifier;
import skb.Replayer;

public class Level {
    public static final byte SPACE = 0;
    public static final byte PLAYER = 1;
    public static final byte BOX = 2;
    public static final byte TARGET = 4;
    public static final byte WALL = 8;
    public static final byte SOUTH = 16;
    public static final byte NORTH = 32;
    public static final byte EAST = 64;
    public static final byte WEST = -128;
    public Replayer replay = null;
    public byte[][] lv;
    public byte[] rw;
    public byte width = 0;
    public byte height = 0;
    public int num;
    public int numSolved = 0;
    public int bestMoves = 0;
    public int bestPushes = 0;
    public int moves = 0;
    public int pushes = 0;
    public int posi;
    public int posj;
    public int collection = -1;
    public String title = "";
    public String author = "";
    public GameNotifier gn = null;

    public void setNotifier(GameNotifier gameNotifier) {
        this.gn = gameNotifier;
    }

    public void setTitle(String string) {
        if (string.length() == 0) {
            this.title = "";
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.charAt(0) == ' ' || stringBuffer.charAt(0) == ';') {
            stringBuffer.deleteCharAt(0);
        }
        if (stringBuffer.charAt(0) == '\'' && stringBuffer.charAt(stringBuffer.length() - 1) == '\'') {
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        this.title = stringBuffer.toString();
    }

    public void addReplayer(int n) {
        this.replay = new Replayer(this, n);
    }

    public void delReplayer() {
        this.replay = null;
    }

    public boolean complete() {
        if (this.moves == 0) {
            return false;
        }
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if ((this.lv[i][j] & 2) == 0 || (this.lv[i][j] & 4) != 0) continue;
                return false;
            }
        }
        return true;
    }

    public int nxt(int n, int n2) {
        int n3 = this.posi + n;
        int n4 = this.posj + n2;
        if (n3 < 0 || n4 < 0 || n3 >= this.height || n4 >= this.width) {
            return -1;
        }
        if ((this.lv[n3][n4] & 8) != 0) {
            return 8;
        }
        if ((this.lv[n3][n4] & 2) != 0) {
            return 2;
        }
        return 0;
    }

    public int mv(int n, int n2) {
        int n3 = 0;
        int n4 = this.posi + n;
        int n5 = this.posj + n2;
        if (n4 < 0 || n5 < 0 || n4 >= this.height || n5 >= this.width) {
            return 0;
        }
        if ((this.lv[n4][n5] & 8) != 0) {
            return 0;
        }
        if ((this.lv[n4][n5] & 2) != 0) {
            int n6 = n4 + n;
            int n7 = n5 + n2;
            if (n6 < 0 || n7 < 0 || n6 >= this.height || n7 >= this.width) {
                return 0;
            }
            if ((this.lv[n6][n7] & 8) != 0 || (this.lv[n6][n7] & 2) != 0) {
                return 0;
            }
            byte[] byArray = this.lv[n4];
            int n8 = n5;
            byArray[n8] = (byte)(byArray[n8] & 0xFFFFFFFD);
            byte[] byArray2 = this.lv[n6];
            int n9 = n7;
            byArray2[n9] = (byte)(byArray2[n9] | 2);
            this.gn.cellUpdated(n6, n7);
            ++this.pushes;
            n3 = 1;
        }
        byte[] byArray = this.lv[this.posi];
        int n10 = this.posj;
        byArray[n10] = (byte)(byArray[n10] & 0xFFFFFFFE);
        byte[] byArray3 = this.lv[n4];
        int n11 = n5;
        byArray3[n11] = (byte)(byArray3[n11] | 1);
        this.gn.cellUpdated(this.posi, this.posj);
        this.gn.cellUpdated(n4, n5);
        this.posi = n4;
        this.posj = n5;
        ++this.moves;
        this.gn.statusUpdated();
        return 1 + n3;
    }

    public int move(int n, int n2) {
        int n3 = this.mv(n, n2);
        if (n3 != 0) {
            if (this.replay != null) {
                this.replay.put(new Entry(n, n2, n3 == 2));
            }
            if (this.complete()) {
                this.gn.levelComplete();
            }
            return 1;
        }
        return 0;
    }

    public void undo() {
        if (this.replay == null) {
            return;
        }
        this.replay.undo();
    }

    public void redo() {
        if (this.replay == null) {
            return;
        }
        this.replay.redo();
    }

    public boolean save(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.collection);
            dataOutputStream.writeInt(this.num);
            dataOutputStream.writeInt(this.moves);
            dataOutputStream.writeInt(this.pushes);
            dataOutputStream.writeInt(this.posi);
            dataOutputStream.writeInt(this.posj);
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    dataOutputStream.writeByte(this.lv[i][j]);
                }
            }
            dataOutputStream.writeBoolean(this.replay != null);
            if (this.replay != null) {
                this.replay.save(outputStream);
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static int loadGetCollection(DataInputStream dataInputStream) {
        try {
            return dataInputStream.readInt();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int loadGetNum(DataInputStream dataInputStream) {
        try {
            return dataInputStream.readInt();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean load(DataInputStream dataInputStream) {
        try {
            this.moves = dataInputStream.readInt();
            this.pushes = dataInputStream.readInt();
            this.posi = dataInputStream.readInt();
            this.posj = dataInputStream.readInt();
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.lv[i][j] = dataInputStream.readByte();
                }
            }
            if (dataInputStream.readBoolean()) {
                this.replay.load(dataInputStream);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Level copyOf() {
        int n;
        Level level = new Level();
        level.rw = new byte[this.height];
        level.lv = new byte[this.height][this.width];
        level.width = this.width;
        level.height = this.height;
        level.bestMoves = this.bestMoves;
        level.bestPushes = this.bestPushes;
        level.moves = this.moves;
        level.pushes = this.pushes;
        level.author = new String(this.author);
        level.title = new String(this.title);
        level.num = this.num;
        level.posi = this.posi;
        level.posj = this.posj;
        level.gn = this.gn;
        level.numSolved = this.numSolved;
        level.collection = this.collection;
        for (n = 0; n < this.height; ++n) {
            level.rw[n] = this.rw[n];
        }
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                level.lv[n][i] = this.lv[n][i];
            }
        }
        return level;
    }
}

