/*
 * Decompiled with CFR 0.152.
 */
package skb;

import cucumber.IniFile;
import cucumber.Q;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import skb.About;
import skb.Board;
import skb.MainMenu;
import skb.OptionsDlg;
import skb.SkbSelTarget;
import skb.SkbSelector;
import skb.SkbSettings;
import skb.SkinLoader;
import skb.SkinSelector;
import skb.Splash;
import skb.Xsb;
import skb.XsbSelector;

public class Skb
extends MIDlet
implements CommandListener,
SkbSelTarget {
    private Display display;
    private Board board;
    private SkinLoader skn;
    private Xsb xsb;
    private IniFile ini;
    private XsbSelector xsbsel;
    private SkinSelector skinsel;
    private OptionsDlg optbox;
    private SkbSettings skbset;
    private MainMenu mm;
    private About about;
    private Splash splash;
    private boolean first = true;

    public void startApp() {
        if (this.first) {
            this.display = Display.getDisplay((MIDlet)this);
            this.splash = new Splash();
            this.display.setCurrent((Displayable)this.splash);
            Q.wt(1000);
            this.ini = new IniFile("/config.ini");
            this.skbset = new SkbSettings();
            this.skn = new SkinLoader(this.ini);
            this.skn.loadSkin(this.skbset.skin);
            this.about = null;
            this.xsb = new Xsb(this.ini);
            this.xsb.load(this.skbset.collection);
            this.mm = new MainMenu(this);
            this.xsbsel = new XsbSelector(this.ini, this.display, (Displayable)this.mm, this.skbset, this);
            this.skinsel = new SkinSelector(this.ini, this.display, (Displayable)this.mm, this.skbset, this);
            this.optbox = new OptionsDlg(this.skbset, this);
            this.board = new Board(this.skbset, this.skn, this.xsb, (Displayable)this.mm, this.display, this);
            this.first = false;
        }
        this.display.setCurrent((Displayable)this.board);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void processMenuEntry(String string) {
        if (string.equals("Return to game")) {
            this.display.setCurrent((Displayable)this.board);
            return;
        }
        if (string.equals("Collections")) {
            this.xsbsel.show();
            return;
        }
        if (string.equals("Skins")) {
            this.skinsel.show();
            return;
        }
        if (string.equals("Exit")) {
            this.exitGame();
            return;
        }
        if (string.equals("Options")) {
            this.optbox.reset();
            this.display.setCurrent((Displayable)this.optbox);
            return;
        }
        if (string.equals("Info")) {
            if (this.about == null) {
                this.about = new About(this.display, (Displayable)this.mm);
            }
            this.display.setCurrent((Displayable)this.about);
            return;
        }
    }

    public void exitGame() {
        this.display.setCurrent(null);
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == OptionsDlg.cmdOk) {
            this.board.setFullScreenMode(this.skbset.fullScreen);
            this.board.createScreenImage();
            this.board.createScreen();
            this.display.setCurrent((Displayable)this.mm);
        } else if (command == OptionsDlg.cmdCancel) {
            this.display.setCurrent((Displayable)this.mm);
        } else if (command == MainMenu.cmdExit) {
            this.display.setCurrent((Displayable)this.board);
        } else if (command == MainMenu.cmdOk) {
            this.processMenuEntry(this.mm.getString(this.mm.getSelectedIndex()));
        } else if (command == Board.cmdMenu) {
            this.display.setCurrent((Displayable)this.mm);
        }
    }

    public void itemSelected(SkbSelector skbSelector) {
        if (skbSelector instanceof SkinSelector) {
            this.skn.loadSkin(this.skbset.skin);
            this.board.createScreen();
            this.display.setCurrent((Displayable)this.board);
            return;
        }
        if (skbSelector instanceof XsbSelector) {
            this.xsb.load(this.skbset.collection);
            this.board.loadLevel(this.xsb.getFirstUnsolved());
            this.display.setCurrent((Displayable)this.board);
            return;
        }
    }
}

