/*
 * Decompiled with CFR 0.152.
 */
package skb;

import cucumber.IniFile;
import javax.microedition.lcdui.Image;

public class SkinLoader {
    private IniFile ini;
    private int crtsz;
    private int minsz;
    private int maxsz;
    private int type;
    private int numi;
    private Image skin = null;
    private Image[] images;

    public SkinLoader(IniFile iniFile) {
        this.ini = iniFile;
        this.crtsz = -1;
    }

    public void loadSkin(int n) {
        this.skin = null;
        this.crtsz = -1;
        try {
            this.skin = Image.createImage((String)this.ini.rdStringN("Skins.File", n, ""));
        }
        catch (Exception exception) {
            System.out.println("?");
            return;
        }
        this.minsz = this.ini.rdIntN("Skins.Min", n, 0);
        this.maxsz = this.ini.rdIntN("Skins.Max", n, 0);
        this.type = this.ini.rdIntN("Skins.Type", n, 1);
        switch (this.type) {
            case 1: {
                this.numi = 7;
                this.images = new Image[7];
                break;
            }
            case 2: {
                this.numi = 22;
                this.images = new Image[22];
            }
        }
        if (this.crtsz > 0) {
            this.loadImages(this.crtsz);
        }
    }

    public void loadImages(int n) {
        if (n == this.crtsz) {
            return;
        }
        this.crtsz = n;
        if (n < this.minsz) {
            n = this.minsz;
        }
        if (n > this.maxsz) {
            n = this.maxsz;
        }
        int n2 = -this.minsz * (this.minsz + 1) / 2 + n * (n + 1) / 2;
        for (int i = 0; i < this.numi; ++i) {
            this.images[i] = Image.createImage((Image)this.skin, (int)(1 + (n + 1) * i), (int)(1 + n2), (int)n, (int)n, (int)0);
        }
    }

    public int getMinSize() {
        return this.minsz;
    }

    public int getMaxSize() {
        return this.maxsz;
    }

    public int getSize() {
        return this.crtsz;
    }

    public void setSize(int n) {
        this.loadImages(n);
    }

    public Image getImage(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.numi) {
            n = this.numi - 1;
        }
        return this.images[n];
    }

    public Image getCellImage(int n) {
        int n2 = n >= 0 ? n : n + 256;
        switch (n2) {
            case 4: {
                return this.getImage(0);
            }
            case 1: {
                return this.getImage(1);
            }
            case 5: {
                return this.getImage(2);
            }
            case 2: {
                return this.getImage(3);
            }
            case 6: {
                return this.getImage(4);
            }
            case 0: {
                return this.getImage(5);
            }
        }
        if ((n2 & 8) != 0) {
            if (this.type == 1) {
                return this.getImage(6);
            }
            return this.getImage(((n2 & 0xFFFFFFF7) >> 4) + 6);
        }
        return null;
    }
}

