/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.ColorBackground;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Label;
import de.softgames.pl.mylittlefarm.StaticImage;
import javax.microedition.lcdui.game.Sprite;

public class ScaleBar
extends GameLayer {
    static final byte HORIZONTAL = 0;
    static final byte VERTICAL = 1;
    static final byte LEFT = 0;
    static final byte RIGHT = 1;
    static final byte UP = 2;
    static final byte DOWN = 3;
    StaticImage[][] bar;
    ColorBackground clipper;
    byte layout;
    int max;
    int value;
    byte dir;
    Label label;

    public ScaleBar(int n, int n2, Sprite sprite, int n3, int n4, int n5, int n6, int n7, int n8, byte by, int n9, int n10, int n11, byte by2) {
        block3: {
            block2: {
                this.x = n;
                this.y = n2;
                this.layout = by;
                this.max = n11;
                this.value = n10;
                this.dir = by2;
                this.bar = new StaticImage[2][3];
                if (by != 0) break block2;
                this.width = n9;
                this.height = sprite.getHeight();
                n9 -= sprite.getWidth();
                this.bar[0][0] = new StaticImage(sprite, n6, 0);
                this.bar[0][1] = new StaticImage(sprite, n7, 0, n9 -= sprite.getWidth(), sprite.getHeight());
                this.bar[0][2] = new StaticImage(sprite, n8, 0);
                this.bar[1][0] = new StaticImage(sprite, n3, 0);
                this.bar[1][1] = new StaticImage(sprite, n4, 0, n9, sprite.getHeight());
                this.bar[1][2] = new StaticImage(sprite, n5, 0);
                this.clipper = new ColorBackground(this.x, this.y, this.width, this.height, -1, -1);
                for (int i = 0; i < 3; ++i) {
                    this.bar[1][i].setPosition(n, n2);
                    n += this.bar[1][i].getWidth();
                    this.bar[1][i].setClipLayer(this.clipper);
                    this.bar[0][i].setPosition(this.bar[1][i].getX(), this.bar[1][i].getY());
                }
                break block3;
            }
            if (by != 1) break block3;
            this.width = sprite.getHeight();
            this.height = n9;
            n9 -= sprite.getHeight();
            this.bar[0][0] = new StaticImage(sprite, n6, 5);
            this.bar[0][1] = new StaticImage(sprite, n7, 5, this.width, n9 -= sprite.getHeight());
            this.bar[0][2] = new StaticImage(sprite, n8, 5);
            this.bar[1][0] = new StaticImage(sprite, n3, 5);
            this.bar[1][1] = new StaticImage(sprite, n4, 5, this.width, n9);
            this.bar[1][2] = new StaticImage(sprite, n5, 5);
            this.clipper = new ColorBackground(this.x, this.y, this.width, this.height, -1, -1);
            for (int i = 0; i < 3; ++i) {
                this.bar[1][i].setPosition(n, n2);
                n2 += this.bar[1][i].getHeight();
                this.bar[1][i].setClipLayer(this.clipper);
                this.bar[0][i].setPosition(this.bar[1][i].getX(), this.bar[1][i].getY());
            }
        }
    }

    void positionElements() {
        int n = this.x;
        int n2 = this.y;
        if (this.layout == 0) {
            this.clipper.setPosition(n, n2);
            for (int i = 0; i < 3; ++i) {
                this.bar[1][i].setPosition(n, n2);
                n += this.bar[1][i].getWidth();
                this.bar[0][i].setPosition(this.bar[1][i].getX(), this.bar[1][i].getY());
            }
        } else {
            this.clipper.setPosition(n, n2);
            for (int i = 0; i < 3; ++i) {
                this.bar[1][i].setPosition(n, n2);
                n2 += this.bar[1][i].getHeight();
                this.bar[0][i].setPosition(this.bar[1][i].getX(), this.bar[1][i].getY());
            }
        }
    }

    void drawLabel() {
        this.label = new Label(String.valueOf(this.value).concat("/").concat(String.valueOf(this.max)));
    }

    void addNotify() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.bar[i][j] == null) continue;
                Game.layerManager.add(this.bar[i][j]);
            }
        }
        if (this.label != null) {
            Game.layerManager.add(this.label);
        }
        this.update();
    }

    void removeNotify() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.bar[i][j] == null) continue;
                Game.layerManager.remove(this.bar[i][j]);
            }
        }
        if (this.label != null) {
            Game.layerManager.remove(this.label);
        }
    }

    void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.repaint();
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.bar[i][j] == null) continue;
                    this.bar[i][j].setVisible(this.visible);
                }
            }
            if (this.label != null) {
                this.label.setVisible(this.visible);
            }
        }
    }

    void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.positionElements();
        this.update();
    }

    void setWidth(int n) {
        if (this.layout == 0) {
            this.repaint();
            this.width = n;
            this.bar[0][1].setWidth(n -= this.bar[0][0].getWidth() * 2);
            this.bar[1][1].setWidth(n);
            this.positionElements();
            this.update();
            this.repaint();
        }
    }

    void setHeight(int n) {
        if (this.layout == 1) {
            this.repaint();
            this.height = n;
            this.bar[0][1].setHeight(n -= this.bar[0][0].getHeight() * 2);
            this.bar[1][1].setHeight(n);
            this.positionElements();
            this.update();
            this.repaint();
        }
    }

    void setLayout(byte by) {
        if (this.layout == by) {
            return;
        }
        this.repaint();
        if (this.layout == 0) {
            int n = this.height;
            this.height = this.width;
            this.width = n;
            for (int i = 0; i < 3; ++i) {
                this.bar[0][i].setTransform(5, true);
                this.bar[1][i].setTransform(5, true);
            }
            this.dir = (byte)3;
        } else {
            int n = this.height;
            this.height = this.width;
            this.width = n;
            for (int i = 0; i < 3; ++i) {
                this.bar[0][i].setTransform(0, true);
                this.bar[1][i].setTransform(0, true);
            }
            this.dir = 0;
        }
        this.clipper.setWidth(this.width);
        this.clipper.setHeight(this.height);
        this.positionElements();
        this.layout = by;
        this.repaint();
    }

    void setMax(int n) {
        if (this.max != n) {
            this.max = n;
            this.update();
        }
    }

    void addValue(int n) {
        this.setValue(this.value + n);
    }

    void setValue(int n) {
        if (n > this.max) {
            n = this.max;
        } else if (n < 0) {
            n = 0;
        }
        if (this.value != n) {
            this.value = n;
            this.update();
        }
    }

    void addPercent(int n, boolean bl, boolean bl2) {
        int n2 = this.max / (100 / n);
        if (bl2) {
            this.max += n2;
            if (this.max < 1) {
                this.max = 1;
            }
        }
        if (bl) {
            this.value += n2;
            if (this.value > this.max) {
                this.value = this.max;
            } else if (this.value < 0) {
                this.value = 0;
            }
        }
        this.update();
    }

    void update() {
        if (this.layout == 0) {
            int n = Game.fixDiv(this.value << 16, this.max << 16);
            int n2 = Game.fixMul(n, this.width << 16) >> 16;
            this.clipper.setWidth(n2);
            if (this.dir == 1) {
                this.clipper.setPosition(this.x + this.width - this.clipper.getWidth(), this.y);
            }
            if (this.label != null) {
                this.label.setText(String.valueOf(this.value).concat("/").concat(String.valueOf(this.max)));
                this.label.setPosition(this.bar[1][1].getX() + this.bar[1][1].getWidth() / 2 - this.label.getWidth() / 2, this.bar[1][1].getY());
            }
        } else {
            int n = Game.fixDiv(this.value << 16, this.max << 16);
            int n3 = Game.fixMul(n, this.height << 16) >> 16;
            this.clipper.setHeight(n3);
            if (this.dir == 3) {
                this.clipper.setPosition(this.x, this.y + this.height - this.clipper.getHeight());
            }
        }
    }
}

