/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.BitmapFont;
import de.softgames.pl.mylittlefarm.Border;
import de.softgames.pl.mylittlefarm.Button;
import de.softgames.pl.mylittlefarm.Event;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Label;
import de.softgames.pl.mylittlefarm.Rect;
import de.softgames.pl.mylittlefarm.Text;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Scroll
extends GameLayer {
    int align;
    int textHeight;
    int scroll;
    Vector lines;
    int bgColor = 0;
    int visibleLines;
    int page = 0;
    int numPages;
    Button left;
    Button right;
    Border border;
    Label header;
    Rect clip;
    short headerTextId = (short)-1;
    String text;

    public Scroll(String string, int n, int n2) {
        this.text = string;
        this.align = n;
        this.clip = new Rect();
        this.border = new Border();
        this.left = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0);
        this.right = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0, 2);
        this.left.setAnimation((byte)1);
        this.right.setAnimation((byte)2);
        if (n2 >= 0) {
            this.headerTextId = (short)n2;
            this.header = new Label(Text.get(this.headerTextId) + " " + (this.page + 1) + "/" + this.numPages);
            this.header.createBackground();
        }
        this.left.setPointerPressedEvent(new Event(5));
        this.right.setPointerPressedEvent(new Event(6));
        this.left.setPointerReleasedEvent(new Event(12));
        this.right.setPointerReleasedEvent(new Event(13));
        this.doLayout();
    }

    int getTextHeight() {
        return this.textHeight;
    }

    void keyLeft() {
        if (this.page > 0) {
            --this.page;
        }
        this.repaint();
        this.setButtonsVisibility();
        this.updateHeader();
    }

    void keyRight() {
        if (this.page < this.numPages - 1) {
            ++this.page;
        }
        this.repaint();
        this.setButtonsVisibility();
        this.updateHeader();
    }

    void updateHeader() {
        if (this.header != null) {
            this.header.setText(Text.get(this.headerTextId) + " " + (this.page + 1) + "/" + this.numPages, this.width);
            this.header.setPosition(this.x + this.width / 2 - this.header.getWidth() / 2, this.y - this.border.getSpriteWidth() - this.header.getHeight() - 2);
        }
    }

    int getHeaderHeight() {
        return this.header != null ? this.header.getHeight() : 0;
    }

    void addNotify() {
        Game.layerManager.addBefore(this, this.border);
        Game.layerManager.add(this.left);
        Game.layerManager.add(this.right);
        if (this.header != null) {
            Game.layerManager.add(this.header);
        }
    }

    void removeNotify() {
        Game.layerManager.remove(this.border);
        Game.layerManager.remove(this.left);
        Game.layerManager.remove(this.right);
        if (this.header != null) {
            Game.layerManager.remove(this.header);
        }
    }

    void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.border.setPosition(this.x, this.y);
        this.left.setPosition(this.x - this.left.getWidth() - 1, this.y + this.height / 2 - this.left.getHeight() / 2);
        this.right.setPosition(this.x + this.width + 1, this.y + this.height / 2 - this.right.getHeight() / 2);
        if (this.header != null) {
            this.header.setPosition(this.x + this.width / 2 - this.header.getWidth() / 2, this.y - this.border.getSpriteWidth() - this.header.getHeight() - 2);
        }
    }

    void doLayout() {
        this.x = this.left.getWidth() + this.border.getSpriteWidth() / 2;
        this.width = Game.canvasWidth - this.left.getWidth() * 2 - this.border.getSpriteWidth();
        this.updateHeader();
        int n = this.header != null ? this.header.getHeight() : 0;
        this.height = Game.canvasHeight - this.left.getWidth() * 2 - this.border.getSpriteWidth() * 3 - n;
        this.y = this.left.getHeight() + this.border.getSpriteWidth() + n;
        BitmapFont bitmapFont = Game.getFont(Game.FONT_DEFAULT);
        this.lines = bitmapFont.stringToLines(this.text, this.width);
        this.textHeight = this.lines.size() * bitmapFont.getHeight();
        if (this.textHeight < this.height) {
            this.height = this.textHeight;
            this.visibleLines = this.lines.size();
            this.numPages = 1;
            this.y = Game.canvasCenterY - this.height / 2;
        } else {
            this.visibleLines = this.height / bitmapFont.getHeight();
            this.numPages = this.lines.size() / this.visibleLines;
            if (this.lines.size() % this.visibleLines != 0) {
                ++this.numPages;
            }
        }
        this.page = 0;
        this.left.setPosition(this.x - this.left.getWidth() - 1, this.y + this.height / 2 - this.left.getHeight() / 2);
        this.right.setPosition(this.x + this.width + 1, this.y + this.height / 2 - this.right.getHeight() / 2);
        if (this.left.getX() - 3 < 0) {
            this.left.move(3, 0);
        }
        if (this.right.getX() + this.right.getWidth() + 3 > Game.canvasWidth) {
            this.right.move(-3, 0);
        }
        this.border.setPosition(this.x, this.y);
        this.border.setWidth(this.width);
        this.border.setHeight(this.height);
        this.updateHeader();
        this.setButtonsVisibility();
    }

    private void setButtonsVisibility() {
        this.left.setVisible(this.page > 0);
        this.right.setVisible(this.page < this.numPages - 1);
    }

    void paint(Graphics graphics) {
        BitmapFont bitmapFont = Game.getFont(Game.FONT_DEFAULT);
        int n = this.page * this.visibleLines;
        int n2 = n + this.visibleLines;
        if (n2 > this.lines.size()) {
            n2 = this.lines.size();
        }
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = this.x;
        int n8 = this.y;
        int n9 = 0;
        int n10 = bitmapFont.getHeight();
        if (this.align == 4) {
            n7 = this.x;
            n9 = 20;
        } else if (this.align == 1) {
            n7 = this.x + this.width / 2;
            n9 = 17;
        } else if (this.align == 8) {
            n7 = this.x + this.width;
            n9 = 24;
        }
        this.clip.x = this.x;
        this.clip.w = this.width;
        this.clip.h = n10;
        for (int i = n; i < n2; ++i) {
            this.clip.y = n8;
            if (this.clip.collidesWith(n3, n4, n5, n6)) {
                graphics.clipRect(this.clip.x, this.clip.y, this.clip.w, this.clip.h);
                String string = (String)this.lines.elementAt(i);
                bitmapFont.drawText(string, n7, n8, n9, graphics);
                graphics.setClip(n3, n4, n5, n6);
            }
            n8 += n10;
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    void release() {
        this.lines = null;
        this.left = null;
        this.right = null;
        this.border = null;
    }
}

