/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Button;
import de.softgames.pl.mylittlefarm.ColorBackground;
import de.softgames.pl.mylittlefarm.Event;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Label;
import de.softgames.pl.mylittlefarm.Menu;
import de.softgames.pl.mylittlefarm.Rect;
import de.softgames.pl.mylittlefarm.Scroll;
import de.softgames.pl.mylittlefarm.StaticImage;
import de.softgames.pl.mylittlefarm.Text;

public class City
extends GameLayer {
    ColorBackground bg;
    StaticImage town;
    StaticImage bg2;
    Button leftSoft;
    Button rightSoft;
    Scroll scroll;
    StaticImage[] neons;
    Label label;
    Menu menu;
    int selected;
    boolean[] neonBlink = new boolean[]{true, true, true, false, false, false};
    int blinkIndex;
    Button left;
    Button right;

    public City() {
        this.width = Game.canvasWidth;
        this.height = Game.canvasHeight;
        if (Game.cityTutorial) {
            this.scroll = new Scroll(Text.get(25), 1, 24);
        }
        this.menu = new Menu(4);
        this.menu.add(new Label(Text.get(4)), new Button(Game.getSprite(Game.SPRITE_MENU_ICONS), 1), new Event(8));
        this.menu.add(new Label(Text.get(50)), new Button(Game.getSprite(Game.SPRITE_MENU_ICONS), 9), new Event(38));
        this.menu.add(new Label(Text.get(51)), new Button(Game.getSprite(Game.SPRITE_MENU_ICONS), 8), new Event(22));
        this.bg = new ColorBackground(0, 0, Game.canvasWidth, Game.canvasHeight, 0);
        this.town = new StaticImage(Game.getSprite(Game.SPRITE_TOWN));
        this.leftSoft = new Button(Game.getSprite(Game.SPRITE_SOFT_KEYS), Game.cityTutorial ? 0 : 0);
        this.rightSoft = new Button(Game.getSprite(Game.SPRITE_SOFT_KEYS), 2);
        this.neons = new StaticImage[4];
        this.neons[0] = new StaticImage(Game.getSprite(Game.SPRITE_TOWN_SHOP_0));
        this.neons[1] = new StaticImage(Game.getSprite(Game.SPRITE_TOWN_SHOP_1));
        this.neons[2] = new StaticImage(Game.getSprite(Game.SPRITE_TOWN_SHOP_2));
        this.neons[3] = new StaticImage(Game.getSprite(Game.SPRITE_TOWN_SHOP_3));
        this.label = new Label("");
        this.label.createBackground();
        this.selected = Game.itemCategory;
        Game.currGameItem = null;
        this.left = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0);
        this.right = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0, 2);
        this.left.setAnimation((byte)1);
        this.right.setAnimation((byte)2);
        this.left.setPointerPressedEvent(new Event(5));
        this.right.setPointerPressedEvent(new Event(6));
        this.left.setPointerReleasedEvent(new Event(12));
        this.right.setPointerReleasedEvent(new Event(13));
        this.leftSoft.setPointerPressedEvent(new Event(7));
        this.rightSoft.setPointerPressedEvent(new Event(8));
    }

    void addNotify() {
        Game.layerManager.add(this.bg);
        Game.layerManager.add(this.town);
        for (int i = 0; i < 4; ++i) {
            Game.layerManager.add(this.neons[i]);
            this.neons[i].setVisible(false);
        }
        Game.layerManager.add(this.label);
        Game.layerManager.add(this.left);
        Game.layerManager.add(this.right);
        if (Game.cityTutorial) {
            Game.layerManager.add(this.scroll);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            this.left.setVisible(false);
            this.right.setVisible(false);
        } else {
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeySoft2Listener(this);
        }
        Game.layerManager.add(this.leftSoft);
        this.menu.setVisible(false);
        Game.layerManager.add(this.menu);
        Game.layerManager.setKeyFireListener(this);
        Game.layerManager.setKeySoft1Listener(this);
        this.setSelected(this.selected);
    }

    void setSelected(int n) {
        this.neons[this.selected].setVisible(false);
        this.neons[n].setVisible(true);
        this.label.setText(Text.get(31 + n), Game.canvasWidth - this.leftSoft.getWidth() - this.rightSoft.getWidth());
        this.label.setPosition(Game.canvasCenterX - this.label.getWidth() / 2, Game.canvasHeight - this.label.getHeight() - 2);
        this.blinkIndex = 0;
        this.selected = n;
    }

    void animate() {
        if (Game.cityTutorial || this.menu.isVisible()) {
            return;
        }
        this.neons[this.selected].setVisible(this.neonBlink[this.blinkIndex]);
        ++this.blinkIndex;
        if (this.blinkIndex == this.neonBlink.length) {
            this.blinkIndex = 0;
        }
    }

    void keyFire() {
        if (Game.cityTutorial) {
            Game.layerManager.remove(this.scroll);
            this.scroll.release();
            this.scroll = null;
            this.leftSoft.setFrame(0, 0);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeySoft2Listener(this);
            Game.cityTutorial = false;
            this.left.setVisible(true);
            this.right.setVisible(true);
            return;
        }
        Game.itemCategory = (byte)this.selected;
        Game.event(new Event(40));
    }

    void keySoft1() {
        this.keyFire();
    }

    void keySoft2() {
        if (this.menu.isVisible()) {
            this.menu.setVisible(false);
            this.label.setVisible(true);
            this.left.setVisible(true);
            this.right.setVisible(true);
            this.leftSoft.setFrame(0, 0);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
        } else {
            this.menu.setVisible(true);
            this.label.setVisible(false);
            this.left.setVisible(false);
            this.right.setVisible(false);
            this.leftSoft.setFrame(0, 0);
            Game.layerManager.setKeyFireListener(this.menu);
            Game.layerManager.setKeySoft1Listener(this.menu);
            Game.layerManager.setKeyUpListener(this.menu);
            Game.layerManager.setKeyDownListener(this.menu);
            Game.layerManager.setKeyLeftListener(null);
            Game.layerManager.setKeyRightListener(null);
        }
    }

    void keyRight() {
        this.keyDown();
    }

    void keyLeft() {
        this.keyUp();
    }

    void keyUp() {
        int n = this.selected - 1;
        if (n < 0) {
            n = this.neons.length - 1;
        }
        this.setSelected(n);
    }

    void keyDown() {
        int n = this.selected + 1;
        if (n > this.neons.length - 1) {
            n = 0;
        }
        this.setSelected(n);
    }

    boolean pointerPressed(int n, int n2) {
        for (int i = 0; i < this.neons.length; ++i) {
            if (!Rect.pointInside(this.neons[i].x, this.neons[i].y, this.neons[i].width, this.neons[i].height, n, n2)) continue;
            if (i != this.selected) {
                this.setSelected(i);
            } else {
                this.keyFire();
            }
            return true;
        }
        return false;
    }

    void doLayout() {
        int n;
        int n2;
        this.bg.setWidth(Game.canvasWidth);
        this.bg.setHeight(Game.canvasHeight);
        this.town.center();
        this.neons[0].setPosition(this.town.getX() + Game.getInteger(92), this.town.getY() + Game.getInteger(86));
        this.neons[1].setPosition(this.town.getX() + Game.getInteger(182), this.town.getY() + Game.getInteger(96));
        this.neons[2].setPosition(this.town.getX() + Game.getInteger(187), this.town.getY() + Game.getInteger(176));
        this.neons[3].setPosition(this.town.getX() + Game.getInteger(52), this.town.getY() + Game.getInteger(219));
        int n3 = this.neons[0].getX();
        int n4 = this.neons[0].getX() + this.neons[0].getWidth();
        for (n2 = 1; n2 < 4; ++n2) {
            n = this.neons[n2].getX();
            int n5 = this.neons[n2].getX() + this.neons[n2].getWidth();
            if (n < n3) {
                n3 = n;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        if (n3 < 0 || n4 > Game.canvasWidth) {
            n2 = Game.canvasCenterX - (n3 + (n4 - n3) / 2);
            this.town.move(n2, 0);
            for (n = 0; n < 4; ++n) {
                this.neons[n].move(n2, 0);
            }
        }
        if ((this.town.getWidth() < Game.canvasWidth || this.town.getHeight() < Game.canvasHeight) && this.bg2 == null) {
            this.bg2 = new StaticImage(Game.getSprite(Game.SPRITE_BG_TILE), 0, 0, Game.canvasWidth, Game.canvasHeight);
            Game.layerManager.addBefore(this.town, this.bg2);
        }
        if (this.bg2 != null) {
            this.bg2.setWidth(Game.canvasWidth);
            this.bg2.setHeight(Game.canvasHeight);
        }
        this.label.setWidth(Game.canvasWidth - this.leftSoft.getWidth() - this.rightSoft.getWidth());
        this.label.setPosition(Game.canvasCenterX - this.label.getWidth() / 2, Game.canvasHeight - this.label.getHeight() - 2);
        this.menu.setPosition(this.menu.border.getSpriteWidth() * 2, this.menu.up.getHeight() * 2);
        this.menu.setWidth(Game.canvasWidth - this.menu.border.getSpriteWidth() * 4);
        this.menu.setHeight(Game.canvasHeight - this.menu.up.getHeight() * 4);
        this.menu.shrink();
        this.left.setPosition(4, Game.canvasCenterY - this.left.getHeight() / 2);
        this.right.setPosition(Game.canvasWidth - this.right.getWidth() - 4, this.left.getY());
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
    }

    void release() {
        super.release();
        this.bg = null;
        this.town = null;
        this.leftSoft = null;
        this.rightSoft = null;
        this.scroll = null;
        this.neons = null;
        this.label = null;
        this.menu = null;
        this.neonBlink = null;
        this.left = null;
        this.right = null;
    }
}

