/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Rect;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameLayerManager {
    Vector layers = new Vector(50);
    Vector dirtyRegions = new Vector(50);
    int viewX;
    int viewY;
    int viewW;
    int viewH;
    boolean flush;
    GameLayer keyFireListener;
    GameLayer keySoft1Listener;
    GameLayer keySoft2Listener;
    GameLayer keyUpListener;
    GameLayer keyDownListener;
    GameLayer keyLeftListener;
    GameLayer keyRightListener;
    GameLayer pointedLayer;
    Vector rectPool = new Vector(50, 10);

    void setViewWindow(int n, int n2, int n3, int n4) {
        this.viewX = n;
        this.viewY = n2;
        this.viewW = n3;
        this.viewH = n4;
    }

    void add(GameLayer gameLayer) {
        if (gameLayer != null && !this.layers.contains(gameLayer)) {
            this.layers.addElement(gameLayer);
            gameLayer.addNotify();
            this.redrawRegion(gameLayer.getX(), gameLayer.getY(), gameLayer.getWidth(), gameLayer.getHeight());
        }
    }

    void remove(GameLayer gameLayer) {
        if (gameLayer != null && this.layers.contains(gameLayer)) {
            this.redrawRegion(gameLayer.getX(), gameLayer.getY(), gameLayer.getWidth(), gameLayer.getHeight());
            this.layers.removeElement(gameLayer);
            gameLayer.removeNotify();
        }
    }

    void addBefore(GameLayer gameLayer, GameLayer gameLayer2) {
        int n = this.layers.indexOf(gameLayer);
        if (n != -1) {
            this.layers.insertElementAt(gameLayer2, n);
            gameLayer2.addNotify();
            this.redrawRegion(gameLayer2.getX(), gameLayer2.getY(), gameLayer2.getWidth(), gameLayer2.getHeight());
        }
    }

    void moveToTop(GameLayer gameLayer) {
        this.remove(gameLayer);
        this.add(gameLayer);
    }

    boolean containsLayer(GameLayer gameLayer) {
        return this.layers.contains(gameLayer);
    }

    void clear() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.release();
        }
        this.layers.removeAllElements();
        this.dirtyRegions.removeAllElements();
        this.rectPool.removeAllElements();
        this.keyFireListener = null;
        this.keySoft1Listener = null;
        this.keySoft2Listener = null;
        this.keyUpListener = null;
        this.keyDownListener = null;
        this.keyLeftListener = null;
        this.keyRightListener = null;
        this.pointedLayer = null;
        this.redrawRegion(this.viewX, this.viewY, this.viewW, this.viewH);
    }

    void doLayout() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.doLayout();
        }
    }

    void gamePaused() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.gamePaused();
        }
    }

    void gameResumed() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.gameResumed();
        }
    }

    void setKeyFireListener(GameLayer gameLayer) {
        this.keyFireListener = gameLayer;
    }

    void setKeySoft1Listener(GameLayer gameLayer) {
        this.keySoft1Listener = gameLayer;
    }

    void setKeySoft2Listener(GameLayer gameLayer) {
        this.keySoft2Listener = gameLayer;
    }

    void setKeyUpListener(GameLayer gameLayer) {
        this.keyUpListener = gameLayer;
    }

    void setKeyDownListener(GameLayer gameLayer) {
        this.keyDownListener = gameLayer;
    }

    void setKeyLeftListener(GameLayer gameLayer) {
        this.keyLeftListener = gameLayer;
    }

    void setKeyRightListener(GameLayer gameLayer) {
        this.keyRightListener = gameLayer;
    }

    GameLayer getKeyFireListener() {
        return this.keyFireListener;
    }

    GameLayer getKeySoft1Listener() {
        return this.keySoft1Listener;
    }

    GameLayer getKeySoft2Listener() {
        return this.keySoft2Listener;
    }

    GameLayer getKeyUpListener() {
        return this.keyUpListener;
    }

    GameLayer getKeyDownListener() {
        return this.keyDownListener;
    }

    GameLayer getKeyLeftListener() {
        return this.keyLeftListener;
    }

    GameLayer getKeyRightListener() {
        return this.keyRightListener;
    }

    void redrawRegion(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Rect rect = this.nextRect();
        rect.set(n, n2, n3, n4);
        rect.clipTo(this.viewX, this.viewY, this.viewW, this.viewH);
        for (int i = this.dirtyRegions.size() - 1; i >= 0; --i) {
            Rect rect2 = (Rect)this.dirtyRegions.elementAt(i);
            if (!rect2.collidesWith(rect)) continue;
            rect2.join(rect);
            this.recycleRect(rect);
            return;
        }
        this.dirtyRegions.addElement(rect);
    }

    void animate() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.animate();
        }
    }

    boolean needsFlush() {
        return this.flush;
    }

    void paint(Graphics graphics) {
        int n;
        int n2;
        boolean bl = false;
        block0: while (!bl) {
            bl = true;
            n2 = this.dirtyRegions.size();
            for (n = 0; n < n2; ++n) {
                Rect rect = (Rect)this.dirtyRegions.elementAt(n);
                for (int i = n + 1; i < n2; ++i) {
                    Rect rect2 = (Rect)this.dirtyRegions.elementAt(i);
                    if (!rect.collidesWith(rect2)) continue;
                    rect.join(rect2);
                    this.dirtyRegions.removeElement(rect2);
                    this.recycleRect(rect2);
                    bl = false;
                    break;
                }
                if (!bl) continue block0;
            }
        }
        n2 = this.dirtyRegions.size();
        this.flush = n2 != 0;
        for (n = 0; n < n2; ++n) {
            Rect rect = (Rect)this.dirtyRegions.elementAt(n);
            int n3 = this.layers.size();
            for (int i = 0; i < n3; ++i) {
                GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
                if (!gameLayer.isVisible()) continue;
                GameLayer.clipRegion.set(rect.x, rect.y, rect.w, rect.h);
                gameLayer.clipRect(GameLayer.clipRegion);
                if (!rect.collidesWith(GameLayer.clipRegion)) continue;
                graphics.setClip(GameLayer.clipRegion.x, GameLayer.clipRegion.y, GameLayer.clipRegion.w, GameLayer.clipRegion.h);
                gameLayer.paint(graphics);
            }
            this.recycleRect(rect);
        }
        this.dirtyRegions.removeAllElements();
    }

    public void pointerPressed(int n, int n2) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            if (gameLayer.clipLayer == null) {
                if (!gameLayer.isVisible() || !Rect.pointInside(gameLayer.x, gameLayer.y, gameLayer.width, gameLayer.height, n, n2) || !gameLayer.pointerPressed(n, n2)) continue;
                this.pointedLayer = gameLayer;
                return;
            }
            if (!gameLayer.isVisible() || !gameLayer.clipLayer.isVisible() || !Rect.pointInside(gameLayer.clipLayer.x, gameLayer.clipLayer.y, gameLayer.clipLayer.width, gameLayer.clipLayer.height, n, n2) || !Rect.pointInside(gameLayer.x, gameLayer.y, gameLayer.width, gameLayer.height, n, n2) || !gameLayer.pointerPressed(n, n2)) continue;
            this.pointedLayer = gameLayer;
            return;
        }
    }

    public void pointerReleased(int n, int n2) {
        if (this.pointedLayer != null) {
            this.pointedLayer.pointerReleased(n, n2);
            this.pointedLayer = null;
        }
    }

    public void pointerDragged(int n, int n2) {
        if (this.pointedLayer != null) {
            this.pointedLayer.pointerDragged(n, n2);
        }
    }

    Rect nextRect() {
        Rect rect = null;
        if (this.rectPool.isEmpty()) {
            rect = new Rect();
        } else {
            int n = this.rectPool.size() - 1;
            rect = (Rect)this.rectPool.elementAt(n);
            this.rectPool.removeElementAt(n);
        }
        return rect;
    }

    void recycleRect(Rect rect) {
        this.rectPool.addElement(rect);
    }
}

