/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.BitmapFont;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.StaticImage;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Label
extends GameLayer {
    Vector lines;
    boolean blink;
    int blinkTimer = 5;
    int fontId = Game.FONT_DEFAULT;
    int anchor = 17;
    StaticImage bg;
    String text;

    public Label(String string) {
        this(string, Game.canvasWidth);
    }

    public Label(String string, int n) {
        this.setText(string, n);
    }

    void setFont(int n) {
        this.fontId = n;
        this.repaint();
    }

    void createBackground() {
        this.bg = new StaticImage(Game.getSprite(Game.SPRITE_HUD_BG_TILE));
        this.positionBackground();
    }

    void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.positionBackground();
    }

    void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.bg != null) {
            this.bg.setVisible(bl);
        }
    }

    void positionBackground() {
        if (this.bg != null) {
            this.bg.setPosition(this.x - 3, this.y - 1);
            this.bg.setWidth(this.width + 5);
            this.bg.setHeight(this.height + 2);
        }
    }

    void addNotify() {
        if (this.bg != null) {
            Game.layerManager.addBefore(this, this.bg);
        }
    }

    void removeNotify() {
        if (this.bg != null) {
            Game.layerManager.remove(this.bg);
        }
    }

    void setBlink(boolean bl) {
        this.blink = bl;
    }

    void setAnchor(int n) {
        this.anchor = n;
    }

    void setText(String string) {
        this.setText(string, Game.canvasWidth);
    }

    void setWidth(int n) {
        this.setText(this.text, n);
        this.positionBackground();
    }

    void setText(String string, int n) {
        this.text = string;
        this.repaint();
        BitmapFont bitmapFont = Game.getFont(this.fontId);
        this.lines = bitmapFont.stringToLines(string, n);
        if (this.lines.size() == 1) {
            this.width = bitmapFont.stringWidth(string);
            this.height = bitmapFont.getHeight();
        } else {
            this.width = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                int n2 = bitmapFont.stringWidth((String)this.lines.elementAt(i));
                if (n2 <= this.width) continue;
                this.width = n2;
            }
            this.height = bitmapFont.getHeight() * this.lines.size();
        }
        this.repaint();
    }

    public void animate() {
        if (this.blink) {
            --this.blinkTimer;
            if (this.blinkTimer <= 0) {
                this.blinkTimer = 5;
                this.setVisible(!this.visible);
            }
        }
    }

    public void paint(Graphics graphics) {
        BitmapFont bitmapFont = Game.getFont(this.fontId);
        int n = bitmapFont.getHeight();
        int n2 = this.x + this.width / 2;
        int n3 = this.y;
        if ((this.anchor & 4) != 0) {
            n2 = this.x;
        } else if ((this.anchor & 1) != 0) {
            n2 = this.x + this.width / 2;
        } else if ((this.anchor & 8) != 0) {
            n2 = this.x + this.width;
        }
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.clipRect(this.x, this.y, this.width, this.height);
        for (int i = 0; i < this.lines.size(); ++i) {
            String string = (String)this.lines.elementAt(i);
            bitmapFont.drawText(string, n2, n3, this.anchor, graphics);
            n3 += n;
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    void release() {
        super.release();
        this.lines = null;
        this.text = null;
    }
}

