/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Border;
import de.softgames.pl.mylittlefarm.Button;
import de.softgames.pl.mylittlefarm.Event;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameItem;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Label;
import de.softgames.pl.mylittlefarm.Scroll;
import de.softgames.pl.mylittlefarm.StaticImage;
import de.softgames.pl.mylittlefarm.Text;

public class Shop
extends GameLayer {
    StaticImage bg;
    StaticImage itemImage;
    StaticImage padlock;
    StaticImage sold;
    Button leftSoft;
    Button rightSoft;
    Button left;
    Button right;
    Scroll scroll;
    Label itemNameLabel;
    long scrollTimer;
    int selected;
    GameItem item;
    Border border;

    public Shop() {
        this.x = 0;
        this.y = 0;
        this.width = Game.canvasWidth;
        this.height = Game.canvasHeight;
        if (Game.shopTutorial[Game.itemCategory]) {
            this.scroll = new Scroll(Text.get(27 + Game.itemCategory), 1, 31 + Game.itemCategory);
        }
        this.itemNameLabel = new Label("");
        this.itemNameLabel.createBackground();
        this.bg = new StaticImage(Game.getSprite(Game.SPRITE_BG_TILE), 0, 0, Game.canvasWidth, Game.canvasHeight);
        this.leftSoft = new Button(Game.getSprite(Game.SPRITE_SOFT_KEYS), Game.shopTutorial[Game.itemCategory] ? 0 : 0);
        this.rightSoft = new Button(Game.getSprite(Game.SPRITE_SOFT_KEYS), 1);
        this.left = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0);
        this.right = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0, 2);
        this.left.setAnimation((byte)1);
        this.right.setAnimation((byte)2);
        this.padlock = new StaticImage(Game.getSprite(Game.SPRITE_PADLOCK));
        this.sold = new StaticImage(Game.getSprite(Game.SPRITE_SOLD));
        this.border = new Border();
        this.leftSoft.setPointerPressedEvent(new Event(7));
        this.rightSoft.setPointerPressedEvent(new Event(8));
        this.left.setPointerPressedEvent(new Event(5));
        this.right.setPointerPressedEvent(new Event(6));
        this.left.setPointerReleasedEvent(new Event(12));
        this.right.setPointerReleasedEvent(new Event(13));
        this.item = Game.gameItems[Game.itemCategory][this.selected];
    }

    void addNotify() {
        Game.layerManager.addBefore(this, this.bg);
        if (Game.shopTutorial[Game.itemCategory]) {
            Game.layerManager.add(this.scroll);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            Game.layerManager.add(this.leftSoft);
        } else {
            Game.layerManager.addBefore(this, this.border);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.add(this.left);
            Game.layerManager.add(this.right);
            Game.layerManager.add(this.itemNameLabel);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeySoft2Listener(this);
            this.showItem(this.selected);
        }
        Game.layerManager.setKeyFireListener(this);
        Game.layerManager.setKeySoft1Listener(this);
    }

    void showItem(int n) {
        this.item = Game.gameItems[Game.itemCategory][this.selected];
        if (this.itemImage != null) {
            Game.layerManager.remove(this.itemImage);
            Game.releaseImage(this.item.shopImageId);
        }
        Game.layerManager.remove(this.padlock);
        Game.layerManager.remove(this.sold);
        Game.layerManager.remove(this.leftSoft);
        this.item = Game.gameItems[Game.itemCategory][n];
        this.itemImage = new StaticImage(Game.getImage(this.item.shopImageId));
        this.itemImage.setClipLayer(this);
        if (this.item.shopAlign == 2) {
            this.itemImage.setPosition(this.x + this.width / 2 - this.itemImage.getWidth() / 2, this.y + this.height / 2 - this.itemImage.getHeight() / 2);
        } else {
            this.itemImage.setPosition(this.x + this.width / 2 - this.itemImage.getWidth() / 2, this.y + this.height - this.itemImage.getHeight());
        }
        Game.layerManager.add(this.itemImage);
        this.itemNameLabel.setText(Text.get(this.item.textNameId), Game.canvasWidth - this.leftSoft.getWidth() - this.rightSoft.getWidth());
        this.itemNameLabel.setPosition(Game.canvasCenterX - this.itemNameLabel.getWidth() / 2, Game.canvasHeight - this.itemNameLabel.getHeight() - 2);
        if (this.item.state == 0) {
            Game.layerManager.add(this.padlock);
        } else if (this.item.state == 1) {
            Game.layerManager.add(this.leftSoft);
            this.itemImage.setPointerPressedEvent(new Event(2));
        } else if (this.item.state == 2) {
            Game.layerManager.add(this.sold);
        }
        this.selected = n;
    }

    void animate() {
    }

    void keyFire() {
        if (Game.shopTutorial[Game.itemCategory]) {
            Game.layerManager.remove(this.scroll);
            this.scroll.release();
            this.scroll = null;
            Game.layerManager.addBefore(this, this.border);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.add(this.left);
            Game.layerManager.add(this.right);
            Game.layerManager.add(this.itemNameLabel);
            this.leftSoft.setFrame(0, 0);
            this.showItem(this.selected);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeySoft2Listener(this);
            Game.shopTutorial[Game.itemCategory] = false;
            return;
        }
        if (this.item.state == 1) {
            Game.currGameItem = this.item;
            Game.event(new Event(41));
        }
    }

    void keySoft1() {
        this.keyFire();
    }

    void keySoft2() {
        Game.event(new Event(39));
    }

    void keyLeft() {
        int n = this.selected - 1;
        if (n < 0) {
            n = Game.gameItems[Game.itemCategory].length - 1;
        }
        this.showItem(n);
    }

    void keyRight() {
        int n = this.selected + 1;
        if (n > Game.gameItems[Game.itemCategory].length - 1) {
            n = 0;
        }
        this.showItem(n);
    }

    void doLayout() {
        this.bg.setWidth(Game.canvasWidth);
        this.bg.setHeight(Game.canvasHeight);
        this.setWidth(Game.canvasWidth - this.left.getWidth() * 2 - this.left.getWidth() / 2);
        this.setHeight(Game.canvasHeight - this.left.getWidth() * 4);
        this.center();
        this.left.setPosition(this.x - this.left.getWidth(), this.y + this.height / 2 - this.left.getHeight() / 2);
        this.right.setPosition(this.x + this.width, this.left.getY());
        if (this.left.getX() - 3 < 0) {
            this.left.move(3, 0);
        }
        if (this.right.getX() + this.right.getWidth() + 3 > Game.canvasWidth) {
            this.right.move(-3, 0);
        }
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
        this.border.setWidth(this.width);
        this.border.setHeight(this.height);
        this.border.setPosition(this.x, this.y);
        this.padlock.center(this);
        this.sold.center(this);
        if (this.item != null && this.itemImage != null) {
            if (this.item.shopAlign == 2) {
                this.itemImage.setPosition(this.x + this.width / 2 - this.itemImage.getWidth() / 2, this.y + this.height / 2 - this.itemImage.getHeight() / 2);
            } else {
                this.itemImage.setPosition(this.x + this.width / 2 - this.itemImage.getWidth() / 2, this.y + this.height - this.itemImage.getHeight());
            }
        }
        this.itemNameLabel.setWidth(Game.canvasWidth - this.leftSoft.getWidth() - this.rightSoft.getWidth());
        this.itemNameLabel.setPosition(Game.canvasCenterX - this.itemNameLabel.getWidth() / 2, Game.canvasHeight - this.itemNameLabel.getHeight() - 2);
    }

    void release() {
        super.release();
    }
}

