/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Gr2D {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int COORD_LEN = 2;
    public static final int ANCHOR_IMG_HCENTER = 1;
    public static final int ANCHOR_IMG_VCENTER = 2;
    public static final int ANCHOR_IMG_LEFT = 4;
    public static final int ANCHOR_IMG_RIGHT = 8;
    public static final int ANCHOR_IMG_TOP = 16;
    public static final int ANCHOR_IMG_BOTTOM = 32;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT_90 = 5;
    public static final int TRANS_ROT_180 = 3;
    public static final int TRANS_ROT_270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT_90 = 7;
    public static final int TRANS_MIRROR_ROT_180 = 1;
    public static final int TRANS_MIRROR_ROT_270 = 4;
    public static Graphics graphics;
    private static int[] iArrClipCur;
    private static int[] iArrClipSave;

    public static final void init() {
        Gr2D.iArrClipCur[0] = 0;
        Gr2D.iArrClipCur[1] = 0;
        Gr2D.iArrClipCur[2] = GUtillScreen.w;
        Gr2D.iArrClipCur[3] = GUtillScreen.h;
    }

    public static final void renderBind(Graphics g) {
        graphics = g;
    }

    public static final void renderRelease() {
        graphics = null;
    }

    public static final void renderImage(Image image, int x, int y, int anchor) {
        graphics.drawImage(image, x, y, anchor);
    }

    public static final void renderImage(Graphics g, Image image, int x, int y, int anchor) {
        g.drawImage(image, x, y, anchor);
    }

    public static final void renderRegion(Image image, int x_src, int y_src, int w, int h, int transform, int x_dest, int y_dest, int anchor) {
        graphics.drawRegion(image, x_src, y_src, w, h, transform, x_dest, y_dest, anchor);
    }

    public static final void saveClip() {
        GUtillArray.copy(iArrClipSave, iArrClipCur);
    }

    public static final void restoreClip() {
        Gr2D.setClip(iArrClipSave);
        Gr2D.init();
    }

    public static final void setClip(int[] rc) {
        Gr2D.setClip(rc[0], rc[1], rc[2], rc[3]);
    }

    public static final void setClip(int x, int y, int width, int height) {
        Gr2D.setClip2(x, y, width, height);
        Gr2D.iArrClipCur[0] = x;
        Gr2D.iArrClipCur[1] = y;
        Gr2D.iArrClipCur[2] = width;
        Gr2D.iArrClipCur[3] = height;
    }

    public static final void setClip(Graphics g, int x, int y, int width, int height) {
        int _x = x;
        int _y = y;
        int _w = width;
        int _h = height;
        if (_x < 0) {
            _x = 0;
        }
        if (_x + _w > GUtillScreen.w) {
            _w = GUtillScreen.w - _x;
        }
        if (_y < 0) {
            _y = 0;
        }
        if (_y < 0) {
            _y = 0;
        }
        if (_y + _h > GUtillScreen.h) {
            _h = GUtillScreen.h - _y;
        }
        g.setClip(_x, _y, _w, _h);
    }

    private static final void setClip2(int x, int y, int width, int height) {
        int bottom;
        int right;
        int _x = x;
        int _y = y;
        int _w = width;
        int _h = height;
        if (iArrClipSave[0] != 0 && _x < iArrClipSave[0]) {
            _x = iArrClipSave[0];
        }
        if (_x + _w > (right = iArrClipSave[0] + iArrClipSave[2])) {
            _w = right - _x;
        }
        if (_y < 0) {
            _y = 0;
        }
        if (iArrClipSave[1] != 0 && _y < iArrClipSave[1]) {
            _y = iArrClipSave[1];
        }
        if (_y + _h > (bottom = iArrClipSave[1] + iArrClipSave[3])) {
            _h = bottom - _y;
        }
        graphics.setClip(_x, _y, _w, _h);
    }

    public static final void renderRect(int x, int y, int width, int height, int color) {
        Gr2D.saveClip();
        Gr2D.setClip(x, y, width, height);
        graphics.setColor(color);
        graphics.fillRect(x, y, width, height);
        Gr2D.restoreClip();
    }

    public static final void renderRectGradient(Graphics g, int x, int y, int width, int height, int[] colorTop, int[] colorBottom) {
        int count = height - y;
        int[] step = new int[]{colorBottom[0] - colorTop[0], colorBottom[1] - colorTop[1], colorBottom[2] - colorTop[2]};
        int right = x + width;
        for (int i = 0; i < count; ++i) {
            g.setColor((colorTop[0] * count + i * step[0]) / count, (colorTop[1] * count + i * step[1]) / count, (colorTop[2] * count + i * step[2]) / count);
            int top = y + i;
            g.drawLine(x, top, right, top);
        }
    }

    public static final void renderLine(int x1, int y1, int x2, int y2, int color) {
        graphics.setColor(color);
        graphics.drawLine(x1, y1, x2, y2);
    }

    public static final Image loadImage(String fileName) throws DebugException {
        try {
            return Image.createImage((String)fileName);
        }
        catch (IOException e) {
            throw new DebugException("Gr2D", "Unable to load image: " + fileName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Image createImage(int w, int h) {
        return Image.createImage((int)w, (int)h);
    }

    private static final byte[] getImageCoded(String fileName) throws Exception {
        GUtillIo.initRead(fileName);
        GUtillIo.initWrite();
        GUtillIo.writeInt(-1991225785);
        GUtillIo.writeInt(218765834);
        System.out.println(fileName + " " + GUtillIo.getInputSize());
        byte[] data = new byte[GUtillIo.getInputSize()];
        GUtillIo.read(data);
        GUtillIo.writeArray(data);
        GUtillIo.writeInt(0);
        GUtillIo.writeInt(1229278788);
        GUtillIo.writeInt(-1371381630);
        GUtillIo.closeRead();
        GUtillIo.closeWrite();
        return GUtillIo.toByteArray();
    }

    public static final Image createImage(String fileName) {
        if (GUtillIo.fileExist(fileName)) {
            try {
                byte[] imageData = Gr2D.getImageCoded(fileName);
                return Gr2D.createImage(imageData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new DebugException("Gr2D", "Missing image: " + fileName).show();
        }
        return null;
    }

    public static final Image createImage(byte[] imageData) {
        return Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
    }

    static {
        iArrClipCur = new int[4];
        iArrClipSave = new int[4];
    }
}

