/*
 * Decompiled with CFR 0.152.
 */
public class GameField {
    public static final byte TEXT_EMPTY = 0;
    public static final byte TEXT_FULL = 1;
    public static boolean USE_MATRIX_FILLING = true;
    public static long RAIN_RENDER_DELAY = 100L;
    public static final byte BORDER_NONE = -1;
    public static final byte BORDER_TOP = 0;
    public static final byte BORDER_LEFT = 1;
    public static final byte BORDER_RIGHT = 2;
    public static final byte BORDER_BOTTOM = 3;
    public static final int size = 200;
    public static final byte width = 10;
    public static final byte height = 20;
    public static final byte STEP_LEFT = 0;
    public static final byte STEP_RIGHT = 1;
    public static final byte STEP_UP = 2;
    public static final byte STEP_DOWN = 3;
    public static final short[] step = new short[]{-1, 1, -10, 10};
    private static final GameFieldItem[] fieldItems = new GameFieldItem[200];
    private static int _fullBrickData;
    private static GameFieldItem _fullBrickItem;
    private static final byte[] bLastRenderedStates;
    public static final short[] sFillingList;
    public static final int last = 199;
    public static final int last_row = 190;
    public static final int last_in_line = 9;
    private static long rain_lastTimeRendered;
    private static final int RAIN_APPEAR_INTERVAL = 100;
    private static final int RAIN_MIN_LENGTH = 4;
    private static final int RAIN_MAX_LENGTH = 8;
    private static final int RAIN_MIN_TRAIN_DURATION = 5;
    private static final int RAIN_MAX_TRAIN_DURATION = 30;
    private static final int RAIN_MAX_POINTS_COUNT = 8;
    private static int rain_headCreatingTryCount;
    private static final int[] rain_Heads;
    private static final boolean[] rain_Slots;
    private static final byte[] rain_Durations;
    private static final int[] matrixRain;
    public static final int lastRenderedState_clear = 0;
    private static boolean matriksFillingPaintingInProgress;
    private static boolean matriksFillingCleaningInProgress;
    private static int[] matrixFillingHeads;
    private static long filling_lastTimeRendered;
    public static boolean fieldIsInvalid;
    private static final int MIN_FIELD_BLINK_INTERVAL = 800;
    private static final int MAX_FIELD_BLINK_INTERVAL = 1000;
    private static final int BLINK_LIFE_TIME = 4;
    private static long lLastBlinkTime;
    private static int currentfieldBlinkInterval;

    private static GameFieldItem fullBrick() {
        if (_fullBrickItem == null) {
            _fullBrickItem = new GameFieldItem();
            _fullBrickItem.setBrickType(1);
            _fullBrickData = _fullBrickItem.data();
        }
        _fullBrickItem.setData(_fullBrickData);
        return _fullBrickItem;
    }

    public static GameFieldItem getItem(int pos) {
        if (pos < 0 || pos >= 200) {
            return GameField.fullBrick();
        }
        return fieldItems[pos];
    }

    public static GameFieldItem getItem(short[] pos) {
        return GameField.getItem(pos[0] + pos[1] * 10);
    }

    public static GameFieldItem getItem(int x, int y) {
        return GameField.getItem(x + y * 10);
    }

    public static int getBrickType(int pos) {
        if (pos < 0 || pos >= 200) {
            return 1;
        }
        return fieldItems[pos].brickType();
    }

    public static void setBrickType(int pos, int brickType) {
        if (pos >= 0 && pos < 200) {
            fieldItems[pos].setBrickType(brickType);
        }
    }

    public static int getBrickType(short[] pos) {
        return GameField.getItem(pos).brickType();
    }

    public static void setBrickType(short[] pos, int brickType) {
        GameField.getItem(pos).setBrickType(brickType);
    }

    public static int getBrickType(int x, int y) {
        return GameField.getItem(x, y).brickType();
    }

    public static void setBrickType(int x, int y, int brickType) {
        GameField.getItem(x, y).setBrickType(brickType);
    }

    private static int getRainPointLifeCounter(int rainPoint) {
        return rainPoint >> 1 & 0x7F;
    }

    private static int setRainPointLifeCounter(int rainPoint, int value) {
        return rainPoint & 0xFFFFFF01 | value << 1;
    }

    private static int getRainPointMatrixBrickIndex(int rainPoint) {
        return rainPoint >> 12 & 0x1F;
    }

    private static int setRainPointMatrixBrickIndex(int rainPoint, int value) {
        return rainPoint & 0xFFFE0FFF | value << 12;
    }

    public static void clearRainArray() {
        int i;
        for (i = 0; i < 8; ++i) {
            GameField.rain_Heads[i] = -1;
            GameField.rain_Slots[i] = false;
        }
        for (i = 0; i < 200; ++i) {
            GameField.matrixRain[i] = 0;
        }
        rain_headCreatingTryCount = 0;
    }

    private static boolean createRainHead(boolean force) {
        if (force || rain_headCreatingTryCount > 100) {
            for (int i = 0; i < 8; ++i) {
                if (rain_Slots[i]) continue;
                GameField.rain_Slots[i] = true;
                GameField.rain_Durations[i] = (byte)(GUtillMath.rnd(25) + 5);
                byte trainLength = (byte)(GUtillMath.rnd(4) + 4);
                int item = 0 | (trainLength & 0x7F) << 1 | (i & 0xF) << 8 | 1;
                int pos = GUtillMath.rnd(160);
                GameField.matrixRain[pos] = item;
                GameField.rain_Heads[i] = pos;
                break;
            }
            rain_headCreatingTryCount = 0;
            return true;
        }
        ++rain_headCreatingTryCount;
        return false;
    }

    private static void renderMatrixRain() {
        int i;
        if (System.currentTimeMillis() <= rain_lastTimeRendered + RAIN_RENDER_DELAY) {
            return;
        }
        rain_lastTimeRendered = System.currentTimeMillis();
        int activeHeadsCounter = 0;
        for (i = 0; i < 8; ++i) {
            if (rain_Heads[i] == 0) continue;
            ++activeHeadsCounter;
        }
        for (i = 0; i < 5 - activeHeadsCounter; ++i) {
            GameField.createRainHead(true);
        }
        GameField.createRainHead(true);
        for (i = 0; i < 8; ++i) {
            int pos = rain_Heads[i];
            if (pos == -1) continue;
            int matrixBrickIndex = GameField.getRainPointMatrixBrickIndex(pos);
            int bricksLeft = GameField.getRainPointLifeCounter(matrixRain[pos]);
            if (bricksLeft != 0 && pos + 10 < 200 && matrixRain[pos + 10] == 0) {
                matrixBrickIndex = GUtillMath.rnd(30);
                GameField.matrixRain[pos + 10] = 0 | bricksLeft - 1 << 1 | i << 8 | 1 | matrixBrickIndex << 12;
                GameField.rain_Heads[i] = pos + 10;
            } else {
                GameField.rain_Heads[i] = -1;
            }
            GameField.matrixRain[pos] = 0 | (rain_Durations[i] & 0x7F) << 1 | (i & 0xF) << 8 | matrixBrickIndex << 12;
        }
        for (i = 0; i < 8; ++i) {
            GameField.rain_Slots[i] = false;
        }
        for (i = 0; i < 200; ++i) {
            int currentPoint;
            if (matrixRain[i] == 0) {
                GameField.getItem(i).setIsRainPoint(false);
                continue;
            }
            GameField.getItem(i).setIsRainPoint(true);
            int headIndex = matrixRain[i] >> 8 & 0xF;
            if (headIndex < 8) {
                GameField.rain_Slots[headIndex] = true;
            }
            if (((currentPoint = matrixRain[i]) & 1) != 0) continue;
            int lifeCounter = GameField.getRainPointLifeCounter(currentPoint);
            GameField.matrixRain[i] = lifeCounter == 0 ? 0 : GameField.setRainPointLifeCounter(currentPoint, lifeCounter - 1);
        }
    }

    public static final void initFildItems() {
        for (int i = 0; i < 200; ++i) {
            GameField.fieldItems[i] = new GameFieldItem();
        }
    }

    public static final void init() {
        GameField.initFillWay();
        GameField.clearRainArray();
    }

    public static byte setLastRenderedState(boolean isFull, int row, int index) {
        return (byte)((isFull ? 128 : 0) | (row & 3) << 5 | index & 0x1F);
    }

    public static final void clear() {
        for (int i = 0; i < 200; ++i) {
            fieldItems[i].clear();
            GameField.bLastRenderedStates[i] = 0;
        }
    }

    public static final void save() throws Exception {
        GUtillIo.writeBoolean(GameFieldItem.TAIN_HIGHLIGHT_1_TARIN);
        for (int i = 0; i < 200; ++i) {
            GUtillIo.writeInt(fieldItems[i].data());
        }
    }

    public static final void load() throws Exception {
        GameFieldItem.TAIN_HIGHLIGHT_1_TARIN = GUtillIo.readBoolean();
        for (int i = 0; i < 200; ++i) {
            fieldItems[i].setData(GUtillIo.readInt());
            GameField.bLastRenderedStates[i] = 0;
        }
    }

    public static final byte[] border(short[] pos) {
        int index = pos[1] * 10 + pos[0];
        return GameField.border(index);
    }

    public static final byte[] border(int index) {
        byte[] result = new byte[]{};
        if ((index + 1) % 10 == 0) {
            result = GUtillArray.add(result, (byte)2);
        } else if (index % 10 == 0) {
            result = GUtillArray.add(result, (byte)1);
        }
        if (index < 10) {
            result = GUtillArray.add(result, (byte)0);
        } else if (index + 10 >= 200) {
            result = GUtillArray.add(result, (byte)3);
        }
        return result;
    }

    private static final void initFillWay() {
        int wCount = 0;
        int wMax = 9;
        int hCount = 0;
        int hMax = 18;
        int x = 0;
        int y = 0;
        boolean horizontal = true;
        boolean increase = true;
        int index = 0;
        do {
            GameField.sFillingList[index++] = (short)(x + y * 10);
            if (horizontal) {
                if (wCount == wMax) {
                    horizontal = false;
                    wMax = (byte)(wMax - 1);
                    wCount = 0;
                } else {
                    wCount = (byte)(wCount + 1);
                }
            } else if (hCount == hMax) {
                horizontal = true;
                hMax = (byte)(hMax - 1);
                hCount = 0;
                increase = !increase;
            } else {
                hCount = (byte)(hCount + 1);
            }
            if (horizontal) {
                x += increase ? 1 : -1;
                continue;
            }
            y += increase ? 1 : -1;
        } while (index != 200);
    }

    public static final void composeGameFieldAndFigure(GameLogic model) {
        if (matriksFillingPaintingInProgress || matriksFillingCleaningInProgress) {
            return;
        }
        for (int i = 0; i < 200; ++i) {
            if (GameField.getBrickType(i) != 2) continue;
            GameField.setBrickType(i, 0);
        }
        int[] figure_pos = model.figure_pos;
        int[] figure_elem = model.figure_elem;
        int len = model.figure_pos.length;
        for (int i = 0; i < len; ++i) {
            if (figure_pos[i] < 0 || figure_pos[i] >= 200) continue;
            figure_elem[i] = new GameFieldItem(figure_elem[i]).data();
            GameField.getItem(figure_pos[i]).composeData(figure_elem[i]);
        }
    }

    public static final void composeFillingArray(int fillingIndex) {
        if (fillingIndex != -1) {
            for (int i = 0; i < 200; ++i) {
                GameField.getItem(sFillingList[i]).setIsFillingFull(i < fillingIndex);
            }
        }
    }

    public static void stopMatrixFilling() {
        matriksFillingPaintingInProgress = false;
        matriksFillingCleaningInProgress = false;
        for (int i = 0; i < 200; ++i) {
            GameField.getItem(i).setIsFillingFull(false);
            GameField.getItem(i).setIsFillingHed(false);
        }
    }

    public static boolean FillMatrixStyle(boolean isPainting) {
        if (System.currentTimeMillis() <= filling_lastTimeRendered) {
            return true;
        }
        filling_lastTimeRendered = System.currentTimeMillis();
        if (isPainting) {
            int i;
            matriksFillingCleaningInProgress = false;
            if (!matriksFillingPaintingInProgress) {
                matriksFillingPaintingInProgress = true;
                for (int i2 = 0; i2 < 10; ++i2) {
                    GameField.matrixFillingHeads[i2] = -1;
                }
            }
            int counter = 0;
            for (i = 0; i < 10; ++i) {
                if (matrixFillingHeads[i] != -1) continue;
                ++counter;
            }
            if (counter != 0) {
                counter = GUtillMath.rnd(counter);
                for (i = 0; i < 10; ++i) {
                    if (matrixFillingHeads[i] != -1) continue;
                    if (counter == 0) {
                        GameField.matrixFillingHeads[i] = 0;
                        break;
                    }
                    --counter;
                }
            }
            for (i = 0; i < 10; ++i) {
                int headFieldPos = matrixFillingHeads[i] * 10 + i;
                if (matrixFillingHeads[i] == -1 || headFieldPos >= 200) continue;
                if (GameField.getItem(headFieldPos).isFillingHead()) {
                    GameField.getItem(headFieldPos).setIsFillingHed(false);
                    GameField.matrixFillingHeads[i] = matrixFillingHeads[i] + 1;
                    headFieldPos = matrixFillingHeads[i] * 10 + i;
                    if (headFieldPos >= 200) continue;
                    GameField.getItem(headFieldPos).setIsFillingHed(true);
                    GameField.getItem(headFieldPos).setIsFillingFull(true);
                    continue;
                }
                GameField.getItem(headFieldPos).setIsFillingHed(true);
                GameField.getItem(headFieldPos).setIsFillingFull(true);
            }
            boolean fillingNotFinished = false;
            for (int i3 = 0; i3 < 10; ++i3) {
                if (matrixFillingHeads[i3] >= 20) continue;
                fillingNotFinished = true;
                break;
            }
            matriksFillingPaintingInProgress = fillingNotFinished;
        } else {
            int i;
            matriksFillingPaintingInProgress = false;
            if (!matriksFillingCleaningInProgress) {
                int i4;
                matriksFillingCleaningInProgress = true;
                for (i4 = 0; i4 < 10; ++i4) {
                    GameField.matrixFillingHeads[i4] = -1;
                }
                for (i4 = 0; i4 < 200; ++i4) {
                    GameField.getItem(i4).setIsFillingFull(true);
                }
            }
            int counter = 0;
            for (i = 0; i < 10; ++i) {
                if (matrixFillingHeads[i] != -1) continue;
                ++counter;
            }
            if (counter != 0) {
                counter = GUtillMath.rnd(counter);
                for (i = 0; i < 10; ++i) {
                    if (matrixFillingHeads[i] != -1) continue;
                    if (counter == 0) {
                        GameField.matrixFillingHeads[i] = 0;
                        break;
                    }
                    --counter;
                }
            }
            for (i = 0; i < 10; ++i) {
                int headFieldPos = matrixFillingHeads[i] * 10 + i;
                if (matrixFillingHeads[i] == -1 || headFieldPos >= 200) continue;
                GameField.matrixFillingHeads[i] = matrixFillingHeads[i] + 1;
                if (GameField.getItem(headFieldPos).isFillingHead()) {
                    GameField.getItem(headFieldPos).setIsFillingHed(false);
                    GameField.matrixFillingHeads[i] = matrixFillingHeads[i] + 1;
                    headFieldPos = matrixFillingHeads[i] * 10 + i;
                    if (headFieldPos >= 200) continue;
                    GameField.getItem(headFieldPos).setIsFillingHed(true);
                    GameField.getItem(headFieldPos).setIsFillingFull(false);
                    continue;
                }
                GameField.getItem(headFieldPos).setIsFillingHed(true);
                GameField.getItem(headFieldPos).setIsFillingFull(false);
            }
            boolean fillingNotFinished = false;
            for (int i5 = 0; i5 < 10; ++i5) {
                if (matrixFillingHeads[i5] >= 20) continue;
                fillingNotFinished = true;
                break;
            }
            matriksFillingCleaningInProgress = fillingNotFinished;
        }
        return isPainting ? matriksFillingPaintingInProgress : matriksFillingCleaningInProgress;
    }

    public static final void updateBricksStates() {
        for (int i = 0; i < 200; ++i) {
            fieldItems[i].updateState();
            if (GameField.getItem(i).matrixBrickType() != 3) continue;
            GameField.getItem(i).setMatrixBrickIndex(GameField.getRainPointMatrixBrickIndex(matrixRain[i]));
        }
    }

    public static final void updateRenderStates() {
        for (int i = 0; i < 200; ++i) {
            if (fieldIsInvalid) {
                fieldItems[i].setIsRendred(false);
                GameField.bLastRenderedStates[i] = 0;
                continue;
            }
            GameField.getItem(i).setIsRendred((bLastRenderedStates[i] & 0xFFFFFF7F) != 0 == GameField.getItem(i).isVisible());
            if (!GameField.getItem(i).isRendered() || !GameField.getItem(i).isVisible() || !E.MATRIX_SKIN_RENDERING_ON) continue;
            GameField.getItem(i).setIsRendred(bLastRenderedStates[i] == GameField.setLastRenderedState(GameField.getItem(i).isVisible(), GameField.getItem(i).matrixBrickType(), GameField.getItem(i).matrixBrickIdex() + 1));
        }
        fieldIsInvalid = false;
    }

    private static final void blinkRandomField() {
        if (System.currentTimeMillis() > (long)currentfieldBlinkInterval + lLastBlinkTime) {
            lLastBlinkTime = System.currentTimeMillis();
            currentfieldBlinkInterval = GUtillMath.rnd(200) + 800;
            int pos = GUtillMath.rnd(200);
            if (GameField.getBrickType(pos) == 1) {
                GameField.getItem(pos).setIsHotOnceBrick(true);
                GameField.getItem(pos).setLifeCounter(4);
            }
        }
    }

    public static final void render(int yOrigin, int xOrigin, GameLogic model, int fillingIndex) {
        GameField.composeGameFieldAndFigure(model);
        if (E.MATRIX_SKIN_RENDERING_ON) {
            GameField.renderMatrixRain();
        }
        if (!E.MATRIX_SKIN_RENDERING_ON) {
            GameField.composeFillingArray(fillingIndex);
        }
        GameField.updateBricksStates();
        if (E.MATRIX_SKIN_RENDERING_ON) {
            GameField.blinkRandomField();
        }
        GameField.updateRenderStates();
        int renderedCounter = 0;
        for (int i = 0; i < 200; ++i) {
            int brickType;
            GameFieldItem currentValue = fieldItems[i];
            if (currentValue.isRendered()) continue;
            ++renderedCounter;
            boolean shouldRenderSimpleBrick = true;
            if (currentValue.isVisible()) {
                if (E.MATRIX_SKIN_RENDERING_ON && currentValue.matrixBrickIdex() != -1 && Gr2DFrame.renderMatrixBrick(currentValue.matrixBrickType(), currentValue.matrixBrickIdex(), xOrigin + i % 10 * EGameView.iBrickW, yOrigin + i / 10 * EGameView.iBrickH, 20)) {
                    shouldRenderSimpleBrick = false;
                    GameField.bLastRenderedStates[i] = GameField.setLastRenderedState(true, currentValue.matrixBrickType(), currentValue.matrixBrickIdex() + 1);
                }
                brickType = 1;
            } else {
                brickType = 0;
            }
            if (!shouldRenderSimpleBrick) continue;
            Gr2DFrame.renderSubImage(brickType, xOrigin + i % 10 * EGameView.iBrickW, yOrigin + i / 10 * EGameView.iBrickH, 20);
            GameField.bLastRenderedStates[i] = GameField.setLastRenderedState(brickType == 1, 0, 0);
        }
    }

    static {
        bLastRenderedStates = new byte[200];
        sFillingList = new short[200];
        rain_lastTimeRendered = 0L;
        rain_headCreatingTryCount = 0;
        rain_Heads = new int[8];
        rain_Slots = new boolean[8];
        rain_Durations = new byte[8];
        matrixRain = new int[200];
        matriksFillingPaintingInProgress = false;
        matriksFillingCleaningInProgress = false;
        matrixFillingHeads = new int[10];
        filling_lastTimeRendered = 0L;
        fieldIsInvalid = false;
        lLastBlinkTime = 0L;
        currentfieldBlinkInterval = 100;
    }
}

