/*
 * Decompiled with CFR 0.152.
 */
package OTPGen;

import OTPGen.Account;
import OTPGen.DisplayPassword;
import OTPGen.MD4;
import OTPGen.MD5;
import OTPGen.SHA1;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;

public class Computer
extends Form
implements Runnable,
CommandListener {
    Display display;
    Gauge gauge;
    DisplayPassword fmPassword;
    CommandListener owner;
    volatile boolean isRunning;
    Account account;
    String pass;
    Command cmStop;
    byte[] resultPassword = null;

    public Computer(Display d, CommandListener l, DisplayPassword displayPassword) {
        super("");
        this.display = d;
        this.owner = l;
        this.fmPassword = displayPassword;
        this.gauge = new Gauge("\u0416\u0434\u0438\u0442\u0435...", false, 1, 0);
        this.cmStop = new Command("\u0420\u0430\u0431\u043e\u0442\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430", 6, 0);
        this.append((Item)this.gauge);
        this.addCommand(this.cmStop);
        this.setCommandListener(this);
    }

    public void initialise(Account account, String passphrase) {
        this.account = account;
        this.pass = passphrase;
        this.setTitle(account.getLabel());
        this.gauge.setMaxValue(this.account.getSeq());
    }

    public void run() {
        this.isRunning = true;
        try {
            this.fmPassword.setResult(this.account.getLabel(), this.compute(this.account, this.pass));
            this.display.setCurrent((Displayable)this.fmPassword);
        }
        catch (AbortException abortException) {
            // empty catch block
        }
        this.gauge.setMaxValue(1);
    }

    public void commandAction(Command cm, Displayable d) {
        if (d == this && cm.getCommandType() == 6) {
            this.isRunning = false;
        } else if (d == this.fmPassword) {
            this.fmPassword.doCommand(cm);
        }
        this.owner.commandAction(cm, (Displayable)this);
    }

    public Account getAccount() {
        return this.account;
    }

    private byte[] compute(Account a, String pass) throws AbortException {
        int i;
        MD4 hash;
        byte[] init = (a.getSeed() + pass).getBytes();
        byte[] result = new byte[8];
        if (a.getHash() == 0) {
            hash = new MD4();
        } else if (a.getHash() == 1) {
            hash = new MD5();
        } else if (a.getHash() == 2) {
            hash = new SHA1();
        } else {
            return new byte[0];
        }
        for (i = 0; i <= init.length; i += 64) {
            hash.transformBlock(init, i);
        }
        result = hash.foldTo64();
        for (i = 0; i < a.getSeq(); ++i) {
            hash.reset();
            hash.transformBlock(result, 0);
            result = hash.foldTo64();
            if (i % 10 == 0) {
                this.gauge.setValue(i);
            }
            if (this.isRunning) continue;
            throw new AbortException();
        }
        return result;
    }

    private class AbortException
    extends Exception {
        public AbortException() {
            super("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043e");
        }
    }
}

