/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.megaconverter;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import ru.untaba.utils.BufferedInputStream;
import ru.untaba.utils.Utils;

public class BookIndexesData {
    private int[] a;
    private boolean b;

    public void load(String string) {
        this.b = false;
        FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)1);
        if (!fileConnection.exists()) {
            fileConnection.close();
            throw new IOException("BookIndexesData.load(): Index file not found:" + string);
        }
        int n = (int)fileConnection.fileSize();
        if (n % 4 != 0) {
            throw new IOException("BookIndexesData.load(): Incorrect index file format: size % 4 != 0: " + string);
        }
        int n2 = n / 4;
        this.a = new int[n2];
        int[] nArray = this.a;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileConnection.openInputStream()));
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        Utils.closeInputStream(dataInputStream);
        Utils.closeFileConnection(fileConnection);
        this.b = true;
    }

    public int getIndexsCount() {
        if (this.b) {
            return this.a.length >> 1;
        }
        throw new RuntimeException("BookIndexesData.getBlockOffset(): indexes data is not initialized");
    }

    public int getBlockOffset(int n) {
        if (this.b) {
            return this.a[n << 1];
        }
        throw new RuntimeException("BookIndexesData.getBlockOffset(): indexes data is not initialized");
    }

    public int getBlockAttributeFlags(int n) {
        if (this.b) {
            return this.a[(n << 1) + 1];
        }
        throw new RuntimeException("BookIndexesData.getBlockAttributeFlags(): indexes data is not initialized");
    }

    public boolean isLoaded() {
        return this.b;
    }

    public boolean isBlockIdValid(int n) {
        if (this.b) {
            boolean bl = false;
            if (n >= 0 && n < this.getIndexsCount()) {
                bl = true;
            }
            return bl;
        }
        throw new RuntimeException("BookIndexesData.isBlockIdValid(): indexes data is not initialized");
    }

    int getLasValidBlockId() {
        if (this.b) {
            return this.getIndexsCount() - 1;
        }
        throw new RuntimeException("BookIndexesData.getLasValidBlockId(): indexes data is not initialized");
    }
}

