/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import ru.untaba.utils.zip.core.CRC32;
import ru.untaba.utils.zip.core.Inflater;
import ru.untaba.utils.zip.core.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    static final int FTEXT = 1;
    static final int FHCRC = 2;
    static final int FEXTRA = 4;
    static final int FNAME = 8;
    static final int FCOMMENT = 16;
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean a;

    public GZIPInputStream(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public GZIPInputStream(InputStream inputStream, int n) {
        super(inputStream, new Inflater(true), n);
        this.a();
    }

    public void close() {
        super.close();
    }

    public int read(byte[] byArray, int n, int n2) {
        if (!this.a) {
            this.a();
        }
        if (this.eos) {
            return -1;
        }
        if ((n2 = super.read(byArray, n, n2)) > 0) {
            this.crc.update(byArray, n, n2);
        }
        if (this.inf.finished()) {
            int n3;
            byArray = new byte[8];
            n = this.inf.getRemaining();
            if (n > 8) {
                n = 8;
            }
            System.arraycopy(this.buf, this.len - this.inf.getRemaining(), byArray, 0, n);
            for (n = 8 - n; n > 0; n -= n3) {
                n3 = this.in.read(byArray, 8 - n, n);
                if (n3 > 0) continue;
                throw new EOFException("Early EOF in GZIP footer");
            }
            n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
            if (n3 != (int)this.crc.getValue()) {
                throw new IOException("GZIP crc sum mismatch, theirs \"" + Integer.toHexString(n3) + "\" and ours \"" + Integer.toHexString((int)this.crc.getValue()));
            }
            int n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
            if (n4 != this.inf.getTotalOut()) {
                throw new IOException("Number of bytes mismatch");
            }
            this.eos = true;
        }
        return n2;
    }

    private void a() {
        int n;
        CRC32 cRC32 = new CRC32();
        int n2 = this.in.read();
        if (n2 < 0) {
            this.eos = true;
            return;
        }
        int n3 = this.in.read();
        if (n2 + (n3 << 8) != 35615) {
            throw new IOException("Error in GZIP header, bad magic code");
        }
        cRC32.update(n2);
        cRC32.update(n3);
        n2 = this.in.read();
        if (n2 != 8) {
            throw new IOException("Error in GZIP header, data not in deflate format");
        }
        cRC32.update(n2);
        n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException("Early EOF in GZIP header");
        }
        cRC32.update(n2);
        if ((n2 & 0xD0) != 0) {
            throw new IOException("Reserved flag bits in GZIP header != 0");
        }
        for (n3 = 0; n3 < 6; ++n3) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            cRC32.update(n);
        }
        if ((n2 & 4) != 0) {
            for (n3 = 0; n3 < 2; ++n3) {
                n = this.in.read();
                if (n < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                cRC32.update(n);
            }
            if (this.in.read() < 0 || this.in.read() < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            n3 = this.in.read();
            n = this.in.read();
            if (n3 < 0 || n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            cRC32.update(n3);
            cRC32.update(n);
            n3 = n3 << 8 | n;
            for (n = 0; n < n3; ++n) {
                int n4 = this.in.read();
                if (n4 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                cRC32.update(n4);
            }
        }
        if ((n2 & 8) != 0) {
            while ((n3 = this.in.read()) > 0) {
                cRC32.update(n3);
            }
            if (n3 < 0) {
                throw new EOFException("Early EOF in GZIP file name");
            }
            cRC32.update(n3);
        }
        if ((n2 & 0x10) != 0) {
            while ((n3 = this.in.read()) > 0) {
                cRC32.update(n3);
            }
            if (n3 < 0) {
                throw new EOFException("Early EOF in GZIP comment");
            }
            cRC32.update(n3);
        }
        if ((n2 & 2) != 0) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            n3 = this.in.read();
            if (n3 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            if ((n = n << 8 | n3) != ((int)cRC32.getValue() & 0xFFFF)) {
                throw new IOException("Header CRC value mismatch");
            }
        }
        this.a = true;
    }
}

