/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import java.io.IOException;
import java.io.InputStream;
import ru.untaba.utils.zip.core.DataFormatException;
import ru.untaba.utils.zip.core.Inflater;
import ru.untaba.utils.zip.core.ZipException;
import ru.untaba.utils.zip.utils.io.FilterInputStream;
import ru.untaba.utils.zip.utils.io.InternalError;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private byte[] a = new byte[1];

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 4096);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("in may not be null");
        }
        if (inflater == null) {
            throw new NullPointerException("inf may not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("size may not be negative");
        }
        this.inf = inflater;
        this.buf = new byte[n];
    }

    public int available() {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (this.inf.finished()) {
            return 0;
        }
        return 1;
    }

    public synchronized void close() {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    protected void fill() {
        if (this.in == null) {
            throw new ZipException("InflaterInputStream is closed");
        }
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len < 0) {
            throw new ZipException("Deflated stream ends early.");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int read() {
        int n = this.read(this.a, 0, 1);
        if (n > 0) {
            return this.a[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (true) {
            try {
                n3 = this.inf.inflate(byArray, n, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw new ZipException(dataFormatException.getMessage());
            }
            if (n3 > 0) {
                return n3;
            }
            if (this.inf.needsDictionary() | this.inf.finished()) {
                return -1;
            }
            if (!this.inf.needsInput()) break;
            this.fill();
        }
        throw new InternalError("Don't know what to do");
    }

    public long skip(long l) {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L) {
            return 0L;
        }
        int n = (int)Math.min(l, 2048L);
        byte[] byArray = new byte[n];
        long l2 = 0L;
        while (l > 0L && (n = this.read(byArray, 0, n)) > 0) {
            l -= (long)n;
            l2 += (long)n;
            n = (int)Math.min(l, 2048L);
        }
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() {
        throw new IOException("reset not supported");
    }
}

