/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.localcatalog;

import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import ru.untaba.main.AppGlobalSettings;

public class LocalCatalog {
    public static void createLocalCatalog() {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + LocalCatalog.getSDCardName() + "/untaba/"), (int)3);
            if (!fileConnection.exists()) {
                fileConnection.mkdir();
            }
            fileConnection.close();
            fileConnection = (FileConnection)Connector.open((String)("file:///" + LocalCatalog.getSDCardName() + "/untaba/books/"), (int)3);
            if (!fileConnection.exists()) {
                fileConnection.mkdir();
            }
            fileConnection.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static boolean deleteBookDirIfExists(String string) {
        try {
            string = (FileConnection)Connector.open((String)string);
            if (string.exists()) {
                LocalCatalog.deleteBookDir((FileConnection)string);
            }
            string.close();
        }
        catch (IOException iOException) {}
        return false;
    }

    public static final boolean deleteBookDirIfExists(int n, boolean bl) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)LocalCatalog.getBookDirSystemPath(n, bl));
            if (fileConnection.exists()) {
                LocalCatalog.deleteBookDir(fileConnection);
            }
            fileConnection.close();
        }
        catch (IOException iOException) {}
        return false;
    }

    public static void deleteBookDir(FileConnection fileConnection) {
        Enumeration enumeration = fileConnection.list();
        while (enumeration.hasMoreElements()) {
            FileConnection fileConnection2 = (FileConnection)Connector.open((String)(fileConnection.getURL() + enumeration.nextElement()));
            fileConnection2.delete();
            fileConnection2.close();
        }
        fileConnection.delete();
    }

    public static final String getSDCardName() {
        return AppGlobalSettings.getSdCardName();
    }

    public static final String getBookFileSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/" + n;
        return string;
    }

    public static final String getBookZipFileSystemPath(int n) {
        String string = "file:///" + LocalCatalog.getSDCardName() + "/untaba/books/";
        String string2 = string + n + "/" + n + ".zip";
        return string2;
    }

    public static final String getBookDataFileSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/" + n + ".data";
        return string;
    }

    public static final String getBookIndexFileSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/" + n + ".index";
        return string;
    }

    public static final String getBookDescriptionFileSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/" + n + ".des";
        return string;
    }

    public static final String getBookmarksFileSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/" + n + ".bm";
        return string;
    }

    public static final String getTOCFileSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/" + n + ".toc";
        return string;
    }

    public static final String getBookDirSystemPath(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("file:///").append(LocalCatalog.getSDCardName()).append("/untaba/books/");
        if (bl) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString() + n + "/";
        return string;
    }

    public static final String getCatalogPath() {
        String string = "file:///" + LocalCatalog.getSDCardName() + "/untaba/books/";
        return string;
    }

    public static final boolean doesBookDirExist(int n, boolean bl) {
        boolean bl2 = false;
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)LocalCatalog.getBookDirSystemPath(n, bl), (int)1);
            if (fileConnection.exists()) {
                bl2 = true;
            }
            fileConnection.close();
        }
        catch (IOException iOException) {}
        return bl2;
    }

    public static final boolean doesLocalCatalogExist() {
        boolean bl = false;
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + LocalCatalog.getSDCardName() + "/untaba/books/"), (int)1);
            if (fileConnection.exists()) {
                bl = true;
            }
            fileConnection.close();
        }
        catch (IOException iOException) {}
        return bl;
    }

    public static final boolean isAnoughSpace() {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file:///" + LocalCatalog.getSDCardName() + "/untaba/books/"), (int)1);
            fileConnection.availableSize();
            fileConnection.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    public static int getBooksCount() {
        int n = 0;
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)LocalCatalog.getCatalogPath(), (int)1);
            if (fileConnection.exists()) {
                Enumeration enumeration = fileConnection.list();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                    ++n;
                }
            }
            fileConnection.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    public static String getBookImportedUniquePath() {
        String string = null;
        boolean bl = false;
        int n = (int)System.currentTimeMillis();
        if (n < 0) {
            n = -n;
        }
        do {
            try {
                string = "file:///" + LocalCatalog.getSDCardName() + "/untaba/books/" + '0' + n + '/';
                FileConnection fileConnection = (FileConnection)Connector.open((String)string);
                bl = fileConnection.exists();
                fileConnection.close();
            }
            catch (IOException iOException) {}
        } while (bl);
        string = string + n;
        return string;
    }
}

