/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.megaconverter.renderer;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import ru.untaba.megaconverter.BookBlockData;
import ru.untaba.megaconverter.renderer.RenderingElement;
import ru.untaba.megaconverter.renderer.RenderingElementParagraph;
import ru.untaba.megaconverter.renderer.RenderingElementTitle;
import ru.untaba.megaconverter.renderer.RenderingLayoutSettings;

public class RenderingLayout {
    private Vector a;
    private int b;
    private RenderingLayoutSettings c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;

    public RenderingLayout(RenderingLayoutSettings renderingLayoutSettings) {
        this.c = renderingLayoutSettings;
    }

    public void addBookBlockDataToRenderingLayout(BookBlockData bookBlockData) {
        int n = bookBlockData.getId();
        int n2 = (bookBlockData.getAttributeFlags() & 2) != 0 ? 1 : 0;
        String string = bookBlockData.getTextData();
        int n3 = (bookBlockData.getAttributeFlags() & 4) != 0 ? 2 : 1;
        RenderingElement renderingElement = null;
        if (n3 == 1) {
            renderingElement = new RenderingElementParagraph(this.c);
        } else if (n3 == 2) {
            renderingElement = new RenderingElementTitle(this.c);
        }
        renderingElement.setBookBlockIdCreatedFrom(n);
        renderingElement.setBookBlockNewLineAttributeFlag(n2 != 0);
        renderingElement.setText(string);
        Vector<RenderingElement> vector = this.a;
        if (vector == null) {
            vector = this.a = new Vector<RenderingElement>();
            this.d = -renderingElement.getTopVisibleAreaYbyDescriptor(this.h);
        }
        n2 = 0;
        if (!vector.contains(renderingElement)) {
            int n4;
            if (vector.size() == 0) {
                n4 = 0;
            } else if (((RenderingElement)vector.elementAt(vector.size() - 1)).getBookBlockIdCreatedFrom() < n) {
                n4 = vector.size();
            } else {
                int n5 = 0;
                n2 = vector.size();
                while (n5 + 1 < n2) {
                    int n6 = n5 + (n2 - n5) / 2;
                    if (((RenderingElement)vector.elementAt(n6)).getBookBlockIdCreatedFrom() >= n) {
                        n2 = n6;
                        continue;
                    }
                    n5 = n6;
                }
                n4 = ((RenderingElement)vector.elementAt(n5)).getBookBlockIdCreatedFrom() >= n ? n5 : n2;
            }
            n2 = n4;
            vector.insertElementAt(renderingElement, n2);
            int n7 = renderingElement.getHeight() + renderingElement.getElementTopMargin();
            this.b += n7;
            if (vector.size() > 1 && n2 == 0) {
                this.d -= n7;
            }
        }
    }

    public void removeTopBookBlockData(int n) {
        System.err.println("!!! UNLOAD TOP BLOCKS: COUNT: " + n);
        Vector vector = this.a;
        if (vector != null) {
            int n2 = vector.size();
            for (int i = 0; i < n && i < n2; --n2, ++i) {
                RenderingElement renderingElement = (RenderingElement)vector.elementAt(0);
                this.d += renderingElement.getHeight() + renderingElement.getElementTopMargin();
                this.b -= renderingElement.getHeight() + renderingElement.getElementTopMargin();
                vector.removeElementAt(0);
            }
            if (vector.size() == 0) {
                this.d = 0;
                this.b = 0;
            }
        }
    }

    public void removeBottomBlockData(int n) {
        System.err.println("!!! UNLOAD BOTTOM BLOCKS: COUNT: " + n);
        Vector vector = this.a;
        if (vector != null) {
            int n2 = vector.size();
            for (int i = 0; i < n && n2 - 1 >= 0; ++i) {
                RenderingElement renderingElement = (RenderingElement)vector.elementAt(n2 - 1);
                this.b -= renderingElement.getHeight() + renderingElement.getElementTopMargin();
                vector.removeElementAt(n2 - 1);
                --n2;
            }
        }
    }

    public void renderElements(Graphics graphics) {
        System.err.println("!!! RENDERING ELEMENTS");
        int n = graphics.getClipHeight();
        int n2 = graphics.getClipWidth();
        this.j = n;
        graphics.setColor(this.c.getBackgroundColor());
        graphics.fillRect(0, 0, n2, n);
        Vector vector = this.a;
        int n3 = 0;
        int n4 = 0;
        if (vector != null && vector.size() > 0) {
            int n5 = vector.size();
            int n6 = this.d;
            int n7 = this.c.getLayoutElementsMargin();
            for (int i = 0; i < n5; ++i) {
                RenderingElement renderingElement = (RenderingElement)vector.elementAt(i);
                int n8 = renderingElement.getElementTopMargin();
                int n9 = renderingElement.getHeight();
                int n10 = n6 + n8;
                n6 = n6 + n8 + n9;
                if (!(n10 >= 0 && n10 <= n || n6 >= 0 && n6 <= n) && (n10 >= 0 || n6 <= n)) continue;
                renderingElement.render(graphics, n7, n10);
                n8 = renderingElement.getVisibleTopY();
                n9 = renderingElement.getVisibleBottomY();
                if (n4 == 0 && n8 >= 0) {
                    n4 = n - n8 - n7;
                    this.e = renderingElement.getBookBlockIdCreatedFrom();
                    this.h = renderingElement.getDescriptorOfTopVisibleAreaY();
                }
                if (n9 >= 0) {
                    n3 = n9 - n7;
                }
                this.k = renderingElement.getBookBlockIdCreatedFrom();
            }
        }
        this.f = n3;
        this.g = n4;
    }

    public void pageDown() {
        this.d -= this.f;
        Object object = this.a;
        if (object != null && ((Vector)object).size() > 0 && ((RenderingElement)(object = (RenderingElement)((Vector)object).elementAt(((Vector)object).size() - 1))).getBookBlockIdCreatedFrom() == this.i && this.d + this.b < this.j) {
            this.d = this.j - this.b - ((RenderingElement)object).getElementTopMargin();
        }
    }

    public void pageUp() {
        this.d += this.g;
        Vector vector = this.a;
        if (vector != null && vector.size() > 0 && ((RenderingElement)vector.elementAt(0)).getBookBlockIdCreatedFrom() == 0 && this.d > 0) {
            this.d = 0;
        }
    }

    public void scrollUp(int n) {
        this.d -= n;
    }

    public void scrollDown(int n) {
        this.d += n;
    }

    public int getRequiredDataBlockId(Graphics graphics) {
        int n = -1;
        int n2 = graphics.getClipHeight();
        int n3 = this.d;
        int n4 = this.d + this.b;
        Vector vector = this.a;
        if (vector == null || vector.size() == 0) {
            n = this.e;
        } else if (n3 > 0) {
            n = ((RenderingElement)vector.elementAt(0)).getBookBlockIdCreatedFrom() - 1;
        } else if (n4 < n2 * 4) {
            n = ((RenderingElement)vector.elementAt(vector.size() - 1)).getBookBlockIdCreatedFrom() + 1;
        }
        return n;
    }

    public void unloadUnusedBlocks(Graphics graphics) {
        int n = graphics.getClipHeight();
        Vector vector = this.a;
        if (vector != null && vector.size() > 0) {
            int n2;
            RenderingLayout renderingLayout = this;
            int n3 = -1;
            Vector vector2 = renderingLayout.a;
            int n4 = vector2.size();
            int n5 = renderingLayout.d;
            for (n2 = 0; n2 < n4; ++n2) {
                RenderingElement renderingElement = (RenderingElement)vector2.elementAt(n2);
                int n6 = n5 + renderingElement.getElementTopMargin() + renderingElement.getHeight();
                if (n5 > 0 || n6 > 0) {
                    n3 = n2;
                    break;
                }
                n5 = n6;
            }
            if ((n2 = n3) >= 0 && n2 > 4) {
                this.removeTopBookBlockData(n2 - 4);
            }
            n3 = n;
            RenderingLayout renderingLayout2 = this;
            int n7 = -1;
            Vector vector3 = renderingLayout2.a;
            n5 = vector3.size();
            int n8 = renderingLayout2.d;
            for (int i = 0; i < n5; ++i) {
                RenderingElement renderingElement = (RenderingElement)vector3.elementAt(i);
                n = n8 + renderingElement.getElementTopMargin() + renderingElement.getHeight();
                if (n8 > n3 * 4) {
                    n7 = i;
                    break;
                }
                n8 = n;
            }
            if ((n8 = n7) >= 0 && (n = vector.size() - n8) > 4) {
                this.removeBottomBlockData(n - 4);
            }
        }
    }

    public int getCurrentTopBlockId() {
        return this.e;
    }

    public int getCurrentBottomBlockId() {
        return this.k;
    }

    public int getCurrentDescriptorOfTopElement() {
        return this.h;
    }

    public void setCurrentBookPosition(int n, int n2) {
        this.e = n;
        this.h = n2;
    }

    public void setLastValideBlockId(int n) {
        this.i = n;
    }
}

